/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.activities;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.rest.api.impl.activities.AbstractActivitySummaryProcessor;
import org.alfresco.rest.api.impl.activities.ActivitySummaryProcessor;
import org.alfresco.service.cmr.repository.NodeRef;

public class BaseActivitySummaryProcessor
extends AbstractActivitySummaryProcessor {
    @Override
    protected ActivitySummaryProcessor.Change processEntry(String key, Object value) {
        ActivitySummaryProcessor.Change change = null;
        if (key.equals("page")) {
            change = new ChangePageValue(key);
        }
        if (key.equals("tenantDomain")) {
            change = new AbstractActivitySummaryProcessor.RemoveKey(key);
        }
        if (key.equals("nodeRef")) {
            change = new AbstractActivitySummaryProcessor.ChangeKey(key, "objectId");
        }
        if (key.equals("parentNodeRef")) {
            change = new AbstractActivitySummaryProcessor.ChangeKey(key, "parentObjectId");
        }
        if (value == null || value.equals("")) {
            change = new AbstractActivitySummaryProcessor.RemoveKey(key);
        }
        return change;
    }

    public static class ChangePageValue
    implements ActivitySummaryProcessor.Change {
        private String key;
        private static final String regex = Pattern.quote("document-details?nodeRef=") + "(.*)";
        private static final Pattern pattern = Pattern.compile(regex);

        public ChangePageValue(String key) {
            this.key = key;
        }

        @Override
        public void process(Map<String, Object> entries) {
            String value = (String)entries.remove(this.key);
            try {
                value = URLDecoder.decode(value, "UTF-8");
                Matcher matcher = pattern.matcher(value);
                if (matcher.matches()) {
                    String nodeRefStr = matcher.group(1);
                    boolean isNodeRef = NodeRef.isNodeRef((String)nodeRefStr);
                    if (isNodeRef) {
                        NodeRef nodeRef = new NodeRef(nodeRefStr);
                        entries.put("objectId", nodeRef.getId());
                    } else {
                        AbstractActivitySummaryProcessor.logger.warn((Object)("Activity page url contains an invalid NodeRef " + value));
                    }
                } else {
                    AbstractActivitySummaryProcessor.logger.warn((Object)("Failed to match activity page url for objectId extraction " + value));
                }
            }
            catch (UnsupportedEncodingException e) {
                AbstractActivitySummaryProcessor.logger.warn((Object)("Unable to decode activity page url " + value));
            }
        }
    }
}

