/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.io.IOException;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.ServiceRegistry;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SearchInReadOnlyModeTest
extends AbstractSingleNetworkSiteTest {
    @Test
    public void testReadOnlyServerCanPerformSearch() throws IOException {
        TransactionServiceImpl transactionService = (TransactionServiceImpl)this.applicationContext.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        try {
            transactionService.setAllowWrite(false);
            this.setRequestContext(user1);
            this.verifySystemIsInReadOnlyMode();
            HttpResponse response = this.postSearch();
            Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        }
        finally {
            transactionService.setAllowWrite(true);
        }
    }

    private void verifySystemIsInReadOnlyMode() throws IOException {
        Node n = new Node();
        n.setName("test-folder-any-name-" + this.RUNID);
        n.setNodeType("cm:folder");
        HttpResponse response = this.publicApiClient.post(this.getScope(), this.getNodeChildrenUrl(this.getNodeId()), null, null, null, RestApiUtil.toJsonAsStringNonNull(n));
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(403);
        Assertions.assertThat((String)response.getResponse()).contains(new CharSequence[]{"The system is currently in read-only mode."});
    }

    private String getNodeId() {
        try {
            return this.getMyNodeId();
        }
        catch (Exception e) {
            Assertions.fail((String)"Test setup failure: unable to get My Node ID", (Throwable)e);
            return null;
        }
    }

    private HttpResponse postSearch() throws IOException {
        String json = "{ \"query\": {\"query\": \"cm:name:king\",\"userQuery\": \"great\",\"language\": \"afts\"}, \"fields\" : [\"id\",\"name\", \"search\"]}";
        PublicApiHttpClient.RequestBuilder requestBuilder = new PublicApiHttpClient.PostRequestBuilder(this.httpClient).setBodyAsString("{ \"query\": {\"query\": \"cm:name:king\",\"userQuery\": \"great\",\"language\": \"afts\"}, \"fields\" : [\"id\",\"name\", \"search\"]}").setRequestContext(this.publicApiClient.getRequestContext()).setScope(this.getScope()).setApiName("search").setEntityCollectionName("search");
        return this.publicApiClient.execute(requestBuilder);
    }
}

