/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tests;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.UserDataService;
import org.alfresco.rest.workflow.api.model.Deployment;
import org.alfresco.rest.workflow.api.model.ProcessDefinition;
import org.alfresco.rest.workflow.api.model.ProcessInfo;
import org.alfresco.rest.workflow.api.tests.DeploymentParser;
import org.alfresco.rest.workflow.api.tests.ProcessDefinitionParser;
import org.alfresco.rest.workflow.api.tests.ProcessesParser;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class WorkflowApiClient
extends PublicApiClient {
    public static final DateFormat DATE_FORMAT_ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private DeploymentsClient deploymentsClient;
    private ProcessDefinitionsClient processDefinitionsClient;
    private ProcessesClient processesClient;
    private TasksClient tasksClient;

    public WorkflowApiClient(PublicApiHttpClient client, UserDataService userDataService) {
        super(client, userDataService);
        this.initWorkflowClients();
    }

    public void initWorkflowClients() {
        this.deploymentsClient = new DeploymentsClient(this);
        this.processDefinitionsClient = new ProcessDefinitionsClient(this);
        this.processesClient = new ProcessesClient(this);
        this.tasksClient = new TasksClient(this);
    }

    public DeploymentsClient deploymentsClient() {
        return this.deploymentsClient;
    }

    public ProcessDefinitionsClient processDefinitionsClient() {
        return this.processDefinitionsClient;
    }

    public ProcessesClient processesClient() {
        return this.processesClient;
    }

    public TasksClient tasksClient() {
        return this.tasksClient;
    }

    public static Date parseDate(JSONObject entry, String fieldName) {
        String dateText = (String)entry.get((Object)fieldName);
        if (dateText != null) {
            try {
                return DATE_FORMAT_ISO8601.parse(dateText);
            }
            catch (Exception e) {
                throw new RuntimeException("couldn't parse date " + dateText + ": " + e.getMessage(), e);
            }
        }
        return null;
    }

    public class DeploymentsClient
    extends PublicApiClient.AbstractProxy {
        public DeploymentsClient(WorkflowApiClient this$0) {
            super(this$0);
        }

        public PublicApiClient.ListResponse<Deployment> getDeployments(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("deployments", null, null, null, params, "Failed to get deploymentsClient");
            return DeploymentParser.INSTANCE.parseList(response.getJsonResponse());
        }

        public JSONObject getDeploymentsWithRawResponse(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("deployments", null, null, null, params, "Failed to get deploymentsClient");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public PublicApiClient.ListResponse<Deployment> getDeployments() throws PublicApiException {
            return this.getDeployments(null);
        }

        public Deployment findDeploymentById(String deploymentId) throws PublicApiException {
            HttpResponse response = this.getSingle("deployments", deploymentId, null, null, "Failed to get deployment");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return DeploymentParser.INSTANCE.parseEntry(entry);
        }

        public void deleteDeployment(String deploymentId) throws PublicApiException {
            this.remove("deployments", deploymentId, null, null, "Failed to delete deployment");
        }
    }

    public class ProcessDefinitionsClient
    extends PublicApiClient.AbstractProxy {
        public ProcessDefinitionsClient(WorkflowApiClient this$0) {
            super(this$0);
        }

        public PublicApiClient.ListResponse<ProcessDefinition> getProcessDefinitions(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("process-definitions", null, null, null, params, "Failed to get process definitions");
            return ProcessDefinitionParser.INSTANCE.parseList(response.getJsonResponse());
        }

        public JSONObject getProcessDefinitionsWithRawResponse(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("process-definitions", null, null, null, params, "Failed to get process definitions");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public ProcessDefinition findProcessDefinitionById(String processDefinitionId) throws PublicApiException {
            HttpResponse response = this.getSingle("process-definitions", processDefinitionId, null, null, "Failed to get process definition");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return ProcessDefinitionParser.INSTANCE.parseEntry(entry);
        }

        public HttpResponse findImageById(String processDefinitionId) throws PublicApiException {
            return this.getSingle("process-definitions", processDefinitionId, "image", null, "Failed to get process definition");
        }

        public JSONObject findStartFormModel(String processDefinitionId) throws PublicApiException {
            HttpResponse response = this.getAll("process-definitions", processDefinitionId, "start-form-model", null, null, "Failed to get the start form model of the process definition");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }
    }

    public class ProcessesClient
    extends PublicApiClient.AbstractProxy {
        public ProcessesClient(WorkflowApiClient this$0) {
            super(this$0);
        }

        public ProcessInfo createProcess(String body) throws PublicApiException {
            HttpResponse response = this.create("processes", null, null, null, body, "Failed to start new process instance");
            return ProcessesParser.INSTANCE.parseEntry((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public PublicApiClient.ListResponse<ProcessInfo> getProcesses(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("processes", null, null, null, params, "Failed to get process instances");
            return ProcessesParser.INSTANCE.parseList(response.getJsonResponse());
        }

        public JSONObject getProcessesJSON(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("processes", null, null, null, params, "Failed to get process instances");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public ProcessInfo findProcessById(String processInstanceId) throws PublicApiException {
            HttpResponse response = this.getSingle("processes", processInstanceId, null, null, "Failed to find process instance by id");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return ProcessesParser.INSTANCE.parseEntry(entry);
        }

        public JSONObject getTasks(String processInstanceId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("processes", processInstanceId, "tasks", null, params, "Failed to get task instances of processInstanceId " + processInstanceId);
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public JSONObject getActivities(String processInstanceId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("processes", processInstanceId, "activities", null, params, "Failed to get activity instances of processInstanceId " + processInstanceId);
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public HttpResponse getImage(String processInstanceId) throws PublicApiException {
            HttpResponse response = this.getSingle("processes", processInstanceId, "image", null, "Failed to get image of processInstanceId " + processInstanceId);
            return response;
        }

        public JSONObject findProcessItems(String processInstanceId) throws PublicApiException {
            HttpResponse response = this.getAll("processes", processInstanceId, "items", null, null, "Failed to get the items of the process instance");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public JSONObject getProcessvariables(String processInstanceId) throws PublicApiException {
            HttpResponse response = this.getAll("processes", processInstanceId, "variables", null, null, "Failed to get the variables of the process instance");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public JSONObject createVariables(String processId, JSONArray variables) throws PublicApiException {
            HttpResponse response = this.create("processes", processId, "variables", null, variables.toJSONString(), "Failed to create variables");
            return response.getJsonResponse();
        }

        public JSONObject updateVariable(String processId, String variableName, JSONObject variable) throws PublicApiException {
            HttpResponse response = this.update("processes", processId, "variables", variableName, variable.toJSONString(), "Failed to update variable");
            return response.getJsonResponse();
        }

        public void deleteVariable(String processId, String variableName) throws PublicApiException {
            this.remove("processes", processId, "variables", variableName, "Failed to delete variable");
        }

        public void addProcessItem(String processId, String body) throws PublicApiException {
            this.create("processes", processId, "items", null, body, "Failed to add item");
        }

        public void deleteProcessItem(String processId, String itemId) throws PublicApiException {
            this.remove("processes", processId, "items", itemId, "Failed to delete item");
        }

        public JSONObject findProcessItem(String processInstanceId, String itemId) throws PublicApiException {
            HttpResponse response = this.getAll("processes", processInstanceId, "items", itemId, null, "Failed to get the item of the process instance");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return entry;
        }

        public void deleteProcessById(String processId) throws PublicApiException {
            this.remove("processes", processId, null, null, "Failed to delete process");
        }
    }

    public class TasksClient
    extends PublicApiClient.AbstractProxy {
        public TasksClient(WorkflowApiClient this$0) {
            super(this$0);
        }

        public JSONObject findTaskById(String taskId) throws PublicApiException {
            HttpResponse response = this.getSingle("tasks", taskId, null, null, "Failed to get task");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return entry;
        }

        public JSONObject updateTask(String taskId, JSONObject task, List<String> selectedFields) throws PublicApiException {
            String selectedFieldsValue = StringUtils.join(selectedFields, (String)",");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("select", selectedFieldsValue);
            HttpResponse response = this.update("tasks", taskId, null, null, task.toJSONString(), params, "Failed to update task", 200);
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return entry;
        }

        public JSONObject findTasks(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("tasks", null, null, null, params, "Failed to get all tasks");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public JSONObject findTaskCandidates(String taskId) throws PublicApiException {
            HttpResponse response = this.getAll("tasks", taskId, "candidates", null, null, "Failed to get task candidates");
            return response.getJsonResponse();
        }

        public JSONObject findTaskVariables(String taskId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("tasks", taskId, "variables", null, params, "Failed to get task variables");
            return response.getJsonResponse();
        }

        public JSONObject findTaskVariables(String taskId) throws PublicApiException {
            return this.findTaskVariables(taskId, null);
        }

        public JSONObject createTaskVariables(String taskId, JSONArray variables) throws PublicApiException {
            HttpResponse response = this.create("tasks", taskId, "variables", null, variables.toJSONString(), "Failed to create task variables");
            return response.getJsonResponse();
        }

        public JSONObject updateTaskVariable(String taskId, String variableName, JSONObject variable) throws PublicApiException {
            HttpResponse response = this.update("tasks", taskId, "variables", variableName, variable.toJSONString(), "Failed to update task variable");
            return response.getJsonResponse();
        }

        public void deleteTaskVariable(String taskId, String variableName) throws PublicApiException {
            this.remove("tasks", taskId, "variables", variableName, "Failed to delete task variable");
        }

        public JSONObject findTaskFormModel(String taskId) throws PublicApiException {
            HttpResponse response = this.getAll("tasks", taskId, "task-form-model", null, null, "Failed to get task form model");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public JSONObject findTaskItems(String taskId) throws PublicApiException {
            HttpResponse response = this.getAll("tasks", taskId, "items", null, null, "Failed to get the items of the task");
            JSONObject list = (JSONObject)response.getJsonResponse().get((Object)"list");
            return list;
        }

        public JSONObject addTaskItem(String taskId, String body) throws PublicApiException {
            HttpResponse response = this.create("tasks", taskId, "items", null, body, "Failed to add item");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return entry;
        }

        public void deleteTaskItem(String taskId, String itemId) throws PublicApiException {
            this.remove("tasks", taskId, "items", itemId, "Failed to delete item");
        }

        public JSONObject findTaskItem(String taskId, String itemId) throws PublicApiException {
            HttpResponse response = this.getAll("tasks", taskId, "items", itemId, null, "Failed to get the item of the task");
            JSONObject entry = (JSONObject)response.getJsonResponse().get((Object)"entry");
            return entry;
        }
    }
}

