/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class DictionaryRestApiTest
extends BaseWebScriptTest {
    private static final String URL_SITES = "/api/classes";
    private static final String URL_PROPERTIES = "/api/properties";

    protected void setUp() throws Exception {
        super.setUp();
        this.getServer();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void validatePropertyDef(JSONObject result) throws Exception {
        DictionaryRestApiTest.assertEquals((Object)"cm:created", (Object)result.get("name"));
        DictionaryRestApiTest.assertEquals((Object)"Created Date", (Object)result.get("title"));
        DictionaryRestApiTest.assertEquals((Object)"Created Date", (Object)result.get("description"));
        DictionaryRestApiTest.assertEquals((Object)"d:datetime", (Object)result.get("dataType"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("multiValued"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("enforced"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("protected"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("indexed"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("indexedAtomically"));
        DictionaryRestApiTest.assertEquals((Object)"/api/property/cm_created", (Object)result.get("url"));
    }

    private void validateChildAssociation(JSONObject result) throws Exception {
        DictionaryRestApiTest.assertEquals((Object)"cm:member", (Object)result.get("name"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("isChildAssociation"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("protected"));
        DictionaryRestApiTest.assertEquals((Object)"cm:authorityContainer", (Object)result.getJSONObject("source").get("class"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("source").get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.getJSONObject("source").get("many"));
        DictionaryRestApiTest.assertEquals((Object)"cm:authority", (Object)result.getJSONObject("target").get("class"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("target").get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.getJSONObject("target").get("many"));
        DictionaryRestApiTest.assertTrue((boolean)result.get("url").toString().startsWith("/api/classes/"));
        DictionaryRestApiTest.assertTrue((result.get("url").toString().indexOf("/association/cm_member") > 0 ? 1 : 0) != 0);
    }

    private void validateAssociation(JSONObject result) throws Exception {
        DictionaryRestApiTest.assertEquals((Object)"cm:workingcopylink", (Object)result.get("name"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("isChildAssociation"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("protected"));
        DictionaryRestApiTest.assertEquals((Object)"cm:checkedOut", (Object)result.getJSONObject("source").get("class"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.getJSONObject("source").get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("source").get("many"));
        DictionaryRestApiTest.assertEquals((Object)"cm:workingcopy", (Object)result.getJSONObject("target").get("class"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.getJSONObject("target").get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("target").get("many"));
        DictionaryRestApiTest.assertEquals((Object)"/api/classes/cm_checkedOut/association/cm_workingcopylink", (Object)result.get("url"));
    }

    private void validateAssociationDef(JSONObject result) throws Exception {
        DictionaryRestApiTest.assertEquals((Object)"cm:avatar", (Object)result.get("name"));
        DictionaryRestApiTest.assertEquals((Object)"Avatar", (Object)result.get("title"));
        DictionaryRestApiTest.assertEquals((Object)"The person's avatar image", (Object)result.get("description"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("isChildAssociation"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("protected"));
        DictionaryRestApiTest.assertEquals((Object)"cm:person", (Object)result.getJSONObject("source").get("class"));
        DictionaryRestApiTest.assertEquals((Object)"cm:avatarOf", (Object)result.getJSONObject("source").get("role"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("source").get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("source").get("many"));
        DictionaryRestApiTest.assertEquals((Object)"cm:content", (Object)result.getJSONObject("target").get("class"));
        DictionaryRestApiTest.assertEquals((Object)"cm:hasAvatar", (Object)result.getJSONObject("target").get("role"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("target").get("mandatory"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.getJSONObject("target").get("many"));
        DictionaryRestApiTest.assertEquals((Object)"/api/classes/cm_person/association/cm_avatar", (Object)result.get("url"));
    }

    private void validateTypeClass(JSONObject result) throws Exception {
        DictionaryRestApiTest.assertEquals((Object)"cm:cmobject", (Object)result.get("name"));
        DictionaryRestApiTest.assertEquals((Object)false, (Object)result.get("isAspect"));
        DictionaryRestApiTest.assertEquals((Object)"Object", (Object)result.get("title"));
        DictionaryRestApiTest.assertEquals((Object)"", (Object)result.get("description"));
        DictionaryRestApiTest.assertEquals((Object)"sys:base", (Object)result.getJSONObject("parent").get("name"));
        DictionaryRestApiTest.assertEquals((Object)"base", (Object)result.getJSONObject("parent").get("title"));
        DictionaryRestApiTest.assertEquals((Object)"/api/classes/sys_base", (Object)result.getJSONObject("parent").get("url"));
        DictionaryRestApiTest.assertEquals((Object)"sys:referenceable", (Object)result.getJSONObject("defaultAspects").getJSONObject("sys:referenceable").get("name"));
        DictionaryRestApiTest.assertEquals((Object)"Referenceable", (Object)result.getJSONObject("defaultAspects").getJSONObject("sys:referenceable").get("title"));
        DictionaryRestApiTest.assertEquals((Object)"/api/classes/cm_cmobject/property/sys_referenceable", (Object)result.getJSONObject("defaultAspects").getJSONObject("sys:referenceable").get("url"));
        DictionaryRestApiTest.assertEquals((Object)"cm:auditable", (Object)result.getJSONObject("defaultAspects").getJSONObject("cm:auditable").get("name"));
        DictionaryRestApiTest.assertEquals((Object)"Auditable", (Object)result.getJSONObject("defaultAspects").getJSONObject("cm:auditable").get("title"));
        DictionaryRestApiTest.assertEquals((Object)"/api/classes/cm_cmobject/property/cm_auditable", (Object)result.getJSONObject("defaultAspects").getJSONObject("cm:auditable").get("url"));
        DictionaryRestApiTest.assertEquals((Object)"/api/classes/cm_cmobject", (Object)result.get("url"));
    }

    private void validateAspectClass(JSONObject result) throws Exception {
        DictionaryRestApiTest.assertEquals((Object)"cm:thumbnailed", (Object)result.get("name"));
        DictionaryRestApiTest.assertEquals((Object)true, (Object)result.get("isAspect"));
        DictionaryRestApiTest.assertEquals((Object)"Thumbnailed", (Object)result.get("title"));
        DictionaryRestApiTest.assertEquals((Object)"", (Object)result.get("description"));
        DictionaryRestApiTest.assertEquals((int)0, (int)result.getJSONObject("defaultAspects").length());
        if (result.getJSONObject("properties").has("cm:automaticUpdate")) {
            DictionaryRestApiTest.assertEquals((Object)"cm:automaticUpdate", (Object)result.getJSONObject("properties").getJSONObject("cm:automaticUpdate").get("name"));
            DictionaryRestApiTest.assertEquals((Object)"Automatic Update", (Object)result.getJSONObject("properties").getJSONObject("cm:automaticUpdate").get("title"));
            DictionaryRestApiTest.assertEquals((Object)"/api/classes/cm_thumbnailed/property/cm_automaticUpdate", (Object)result.getJSONObject("properties").getJSONObject("cm:automaticUpdate").get("url"));
        }
    }

    private void validatePropertiesConformity(JSONArray classDefs) throws Exception {
        int itemsToTest = 10;
        for (int i = 0; i < 10 && i < classDefs.length(); ++i) {
            JSONObject classDef1 = classDefs.getJSONObject(i);
            JSONArray propertyNames1 = classDef1.getJSONObject("properties").names();
            List<String> propertyValues1 = Collections.emptyList();
            if (propertyNames1 != null) {
                propertyValues1 = new ArrayList(propertyNames1.length());
                for (int j = 0; j < propertyNames1.length(); ++j) {
                    propertyValues1.add(propertyNames1.getString(j));
                }
            }
            String classUrl = classDef1.getString("url");
            DictionaryRestApiTest.assertTrue((boolean)classUrl.contains(URL_SITES));
            TestWebScriptServer.Response responseFromGetClassDef = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(classUrl), 200);
            JSONObject classDef2 = new JSONObject(responseFromGetClassDef.getContentAsString());
            DictionaryRestApiTest.assertTrue((classDef2.length() > 0 ? 1 : 0) != 0);
            DictionaryRestApiTest.assertEquals((int)200, (int)responseFromGetClassDef.getStatus());
            DictionaryRestApiTest.assertEquals((String)classDef1.getString("name"), (String)classDef2.getString("name"));
            JSONArray propertyNames2 = classDef2.getJSONObject("properties").names();
            List<String> propertyValues2 = Collections.emptyList();
            if (propertyNames2 != null) {
                propertyValues2 = new ArrayList(propertyNames2.length());
                for (int j = 0; j < propertyNames2.length(); ++j) {
                    propertyValues2.add(propertyNames2.getString(j));
                }
            }
            TestWebScriptServer.Response responseFromGetPropertiesDef = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(classUrl + "/properties"), 200);
            JSONArray propertiesDefs = new JSONArray(responseFromGetPropertiesDef.getContentAsString());
            DictionaryRestApiTest.assertEquals((int)200, (int)responseFromGetClassDef.getStatus());
            ArrayList<String> propertyValues3 = new ArrayList<String>(propertiesDefs.length());
            for (int j = 0; j < propertiesDefs.length(); ++j) {
                propertyValues3.add(propertiesDefs.getJSONObject(j).getString("name"));
            }
            this.assertEquivalenceProperties(propertyValues1, propertyValues2);
            this.assertEquivalenceProperties(propertyValues2, propertyValues3);
        }
    }

    private void assertEquivalenceProperties(List<String> propertyValues1, List<String> propertyValues2) {
        if (propertyValues1.size() != propertyValues2.size() || !propertyValues1.containsAll(propertyValues2)) {
            DictionaryRestApiTest.fail((String)"Wrong properties in classes");
        }
    }

    public void testGetPropertyDef() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cm_auditable/property/cm_created"), 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        JSONObject result = new JSONObject(response.getContentAsString());
        this.validatePropertyDef(result);
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cm_hi/property/cm_welcome"), 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cm_auditable/property/cm_welcome"), 200);
        result = new JSONObject(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)0, (int)result.length());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetPropertyDefs() throws Exception {
        int i;
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest("/api/classes/cm_auditable/properties");
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        JSONArray result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        DictionaryRestApiTest.assertEquals((int)5, (int)result.length());
        arguments.clear();
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:created")) continue;
            this.validatePropertyDef(result.getJSONObject(i));
        }
        req = new TestWebScriptServer.GetRequest(URL_PROPERTIES);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (result.getJSONObject(i).get("name").equals("cm:created")) {
                this.validatePropertyDef(result.getJSONObject(i));
            }
            String title = "";
            if (!result.getJSONObject(i).has("title")) continue;
            title = result.getJSONObject(i).getString("title");
        }
        req = new TestWebScriptServer.GetRequest("/api/properties?name=cm:name&name=cm:title&name=cm:description");
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)3, (int)result.length());
    }

    public void testGetClassDetail() throws Exception {
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest("/api/classes/cm_thumbnailed");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        this.validateAspectClass(result);
        req = new TestWebScriptServer.GetRequest("/api/classes/cm_cmobject");
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONObject(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        this.validateTypeClass(result);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cm_hi"), 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetClassDetails() throws Exception {
        int i;
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(URL_SITES);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("cf", "aspect");
        arguments.put("nsp", "cm");
        arguments.put("n", "thumbnailed");
        req.setArgs(arguments);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "type");
        arguments.put("nsp", "cm");
        arguments.put("n", "cmobject");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "all");
        arguments.put("nsp", "cm");
        arguments.put("n", "cmobject");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "type");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "aspect");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        arguments.clear();
        arguments.put("cf", "all");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "type");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            System.out.println(result.getJSONObject(i).toString());
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "aspect");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        arguments.put("n", "cmobject");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        arguments.put("n", "thumbnailed");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:thumbnailed")) continue;
            this.validateAspectClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("n", "cmobject");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "type");
        arguments.put("n", "cmobject");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "aspects");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "types");
        arguments.put("nsp", "cmd");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "a\ufffd&llsara");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "aspectb");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("cf", "typesa");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testSubClassDetails() throws Exception {
        int i;
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest("/api/classes/sys_base/subclasses");
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("r", "true");
        req.setArgs(arguments);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("r", "false");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("r", "false");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("r", "true");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:cmobject")) continue;
            this.validateTypeClass(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("r", "true");
        arguments.put("n", "cmobject");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("r", "true");
        arguments.put("n", "dublincore");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("r", "true");
        arguments.put("n", "dublincoresara");
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetAssociationDef() throws Exception {
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest("/api/classes/cm_person/association/cm_avatar");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        this.validateAssociationDef(result);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cm_personalbe/association/cms_avatarsara"), 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cm_person/association/cm_atari"), 200);
        result = new JSONObject(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)0, (int)result.length());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetAssociationDefs() throws Exception {
        int i;
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest("/api/classes/cm_authorityContainer/associations");
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("af", "all");
        req.setArgs(arguments);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:member")) continue;
            this.validateChildAssociation(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("af", "child");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:member")) continue;
            this.validateChildAssociation(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("af", "child");
        arguments.put("nsp", "cm");
        arguments.put("n", "member");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:workingcopylink")) continue;
            this.validateChildAssociation(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("af", "general");
        arguments.put("nsp", "cm");
        arguments.put("n", "member");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)0, (int)result.length());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        req = new TestWebScriptServer.GetRequest("/api/classes/cm_checkedOut/associations");
        arguments.clear();
        arguments.put("af", "general");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:workingcopylink")) continue;
            this.validateAssociation(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("af", "general");
        arguments.put("nsp", "cm");
        arguments.put("n", "workingcopylink");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:workingcopylink")) continue;
            this.validateAssociation(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        arguments.put("n", "workingcopylink");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((result.length() > 0 ? 1 : 0) != 0, (boolean)true);
        for (i = 0; i < result.length(); ++i) {
            if (!result.getJSONObject(i).get("name").equals("cm:workingcopylink")) continue;
            this.validateAssociation(result.getJSONObject(i));
        }
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        arguments.clear();
        arguments.put("af", "child");
        arguments.put("nsp", "cm");
        arguments.put("n", "workingcopylink");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertEquals((int)0, (int)result.length());
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/classes/cmsa_personalbe/associations"), 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
        arguments.clear();
        arguments.put("nsp", "cm");
        arguments.put("n", "hiwelcome");
        req.setArgs(arguments);
        response = this.sendRequest((TestWebScriptServer.Request)req, 404);
        DictionaryRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetClasses() throws Exception {
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(URL_SITES);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        DictionaryRestApiTest.assertTrue((result.length() > 0 ? 1 : 0) != 0);
        DictionaryRestApiTest.assertEquals((int)200, (int)response.getStatus());
        this.validatePropertiesConformity(result);
    }
}

