/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.web.scripts.solr.PropertyValue;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.webscripts.json.JSONUtils;

class SOLRSerializer {
    protected static final Log logger = LogFactory.getLog(SOLRSerializer.class);
    private JSONUtils jsonUtils = new JSONUtils();
    private Set<QName> NUMBER_TYPES;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private SOLRTypeConverter typeConverter;

    SOLRSerializer() {
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        this.NUMBER_TYPES = new HashSet<QName>(4);
        this.NUMBER_TYPES.add(DataTypeDefinition.DOUBLE);
        this.NUMBER_TYPES.add(DataTypeDefinition.FLOAT);
        this.NUMBER_TYPES.add(DataTypeDefinition.INT);
        this.NUMBER_TYPES.add(DataTypeDefinition.LONG);
        this.typeConverter = new SOLRTypeConverter(this.namespaceService);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public String serializeToJSONString(Serializable value) {
        if (value != null && this.typeConverter.INSTANCE.getConverter(value.getClass(), String.class) == null) {
            return value.toString();
        }
        return (String)this.typeConverter.INSTANCE.convert(String.class, (Object)value);
    }

    public <T> T serializeValue(Class<T> targetClass, Object value) throws JSONException {
        return (T)this.typeConverter.INSTANCE.convert(targetClass, value);
    }

    public PropertyValue serialize(QName propName, Serializable value) throws IOException, JSONException {
        if (value == null) {
            return new PropertyValue(false, "null");
        }
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propName);
        if (propertyDef == null) {
            return new PropertyValue(true, this.serializeToJSONString(value));
        }
        DataTypeDefinition dataType = propertyDef.getDataType();
        QName dataTypeName = dataType.getName();
        if (propertyDef.isMultiValued()) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Multi value: expected a collection, got " + value.getClass().getName());
            }
            Collection c = (Collection)((Object)value);
            JSONArray body = new JSONArray();
            for (Serializable o : c) {
                if (dataTypeName.equals((Object)DataTypeDefinition.MLTEXT)) {
                    MLText source = (MLText)o;
                    JSONArray array = new JSONArray();
                    for (Locale locale : source.getLocales()) {
                        org.json.JSONObject json = new org.json.JSONObject();
                        json.put("locale", DefaultTypeConverter.INSTANCE.convert(String.class, (Object)locale));
                        json.put("value", (Object)source.getValue(locale));
                        array.put((Object)json);
                    }
                    body.put((Object)array);
                    continue;
                }
                if (dataTypeName.equals((Object)DataTypeDefinition.CONTENT)) {
                    throw new RuntimeException("Multi-valued content properties are not supported");
                }
                body.put((Object)this.serializeToJSONString(o));
            }
            return new PropertyValue(false, body.toString());
        }
        boolean encodeString = true;
        encodeString = dataTypeName.equals((Object)DataTypeDefinition.MLTEXT) ? false : !dataTypeName.equals((Object)DataTypeDefinition.CONTENT);
        String sValue = null;
        sValue = value instanceof String && encodeString ? (String)this.jsonUtils.encodeJSONString((Object)value) : this.serializeToJSONString(value);
        return new PropertyValue(encodeString, sValue);
    }

    static class SOLRTypeConverter {
        private NamespaceService namespaceService;
        TypeConverter INSTANCE = new TypeConverter();

        SOLRTypeConverter(NamespaceService namespaceService) {
            this.namespaceService = namespaceService;
            Map converters = DefaultTypeConverter.INSTANCE.getConverters();
            for (Class source : converters.keySet()) {
                Map converters1 = (Map)converters.get(source);
                for (Class dest : converters1.keySet()) {
                    TypeConverter.Converter converter = (TypeConverter.Converter)converters1.get(dest);
                    this.INSTANCE.addConverter(source, dest, converter);
                }
            }
            this.INSTANCE.addConverter(MLText.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<MLText, String>(this){

                public String convert(MLText source) {
                    try {
                        JSONArray array = new JSONArray();
                        for (Locale locale : source.getLocales()) {
                            org.json.JSONObject json = new org.json.JSONObject();
                            json.put("locale", DefaultTypeConverter.INSTANCE.convert(String.class, (Object)locale));
                            json.put("value", (Object)source.getValue(locale));
                            array.put((Object)json);
                        }
                        return array.toString(3);
                    }
                    catch (JSONException e) {
                        throw new AlfrescoRuntimeException("Unable to serialize content data to JSON", (Throwable)e);
                    }
                }
            });
            this.INSTANCE.addConverter(QName.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<QName, String>(this){

                public String convert(QName source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(ContentDataWithId.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<ContentDataWithId, String>(){

                public String convert(ContentDataWithId source) {
                    org.json.JSONObject json = new org.json.JSONObject();
                    try {
                        json.put("contentId", (Object)String.valueOf(source.getId()));
                        String locale = (String)INSTANCE.convert(String.class, (Object)source.getLocale());
                        json.put("locale", locale == null ? org.json.JSONObject.NULL : locale);
                        String encoding = source.getEncoding();
                        json.put("encoding", encoding == null ? org.json.JSONObject.NULL : encoding);
                        String mimetype = source.getMimetype();
                        json.put("mimetype", mimetype == null ? org.json.JSONObject.NULL : mimetype);
                        json.put("size", (Object)String.valueOf(source.getSize()));
                        return json.toString(3);
                    }
                    catch (JSONException e) {
                        throw new AlfrescoRuntimeException("Unable to serialize content data to JSON", (Throwable)e);
                    }
                }
            });
            this.INSTANCE.addConverter(ContentData.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<ContentData, String>(){

                public String convert(ContentData source) {
                    org.json.JSONObject json = new org.json.JSONObject();
                    try {
                        String locale = (String)INSTANCE.convert(String.class, (Object)source.getLocale());
                        json.put("locale", locale == null ? org.json.JSONObject.NULL : locale);
                        String encoding = source.getEncoding();
                        json.put("encoding", encoding == null ? org.json.JSONObject.NULL : encoding);
                        String mimetype = source.getMimetype();
                        json.put("mimetype", mimetype == null ? org.json.JSONObject.NULL : mimetype);
                        json.put("size", (Object)String.valueOf(source.getSize()));
                        return json.toString(3);
                    }
                    catch (JSONException e) {
                        throw new AlfrescoRuntimeException("Unable to serialize content data to JSON", (Throwable)e);
                    }
                }
            });
            this.INSTANCE.addConverter(NodeRef.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<NodeRef, String>(this){

                public String convert(NodeRef source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(String.class, NodeRef.class, (TypeConverter.Converter)new TypeConverter.Converter<String, NodeRef>(this){

                public NodeRef convert(String source) {
                    return new NodeRef(source);
                }
            });
            this.INSTANCE.addConverter(Path.AttributeElement.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path.AttributeElement, String>(this){

                public String convert(Path.AttributeElement source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(Path.ChildAssocElement.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path.ChildAssocElement, String>(this){

                public String convert(Path.ChildAssocElement source) {
                    return source.getRef().toString();
                }
            });
            this.INSTANCE.addConverter(Path.DescendentOrSelfElement.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path.DescendentOrSelfElement, String>(this){

                public String convert(Path.DescendentOrSelfElement source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(Path.ParentElement.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path.ParentElement, String>(this){

                public String convert(Path.ParentElement source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(Path.SelfElement.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path.SelfElement, String>(this){

                public String convert(Path.SelfElement source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(String.class, Path.AttributeElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.AttributeElement>(this){

                public Path.AttributeElement convert(String source) {
                    return new Path.AttributeElement(source);
                }
            });
            this.INSTANCE.addConverter(String.class, Path.ChildAssocElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.ChildAssocElement>(){

                public Path.ChildAssocElement convert(String source) {
                    return new Path.ChildAssocElement((ChildAssociationRef)INSTANCE.convert(ChildAssociationRef.class, (Object)source));
                }
            });
            this.INSTANCE.addConverter(String.class, Path.DescendentOrSelfElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.DescendentOrSelfElement>(this){

                public Path.DescendentOrSelfElement convert(String source) {
                    return new Path.DescendentOrSelfElement();
                }
            });
            this.INSTANCE.addConverter(String.class, Path.ParentElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.ParentElement>(this){

                public Path.ParentElement convert(String source) {
                    return new Path.ParentElement();
                }
            });
            this.INSTANCE.addConverter(String.class, Path.SelfElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.SelfElement>(this){

                public Path.SelfElement convert(String source) {
                    return new Path.SelfElement();
                }
            });
            this.INSTANCE.addConverter(Path.class, List.class, (TypeConverter.Converter)new TypeConverter.Converter<Path, List>(){

                public List convert(Path source) {
                    ArrayList<String> pathArray = new ArrayList<String>(source.size());
                    for (Path.Element element : source) {
                        pathArray.add((String)INSTANCE.convert(String.class, (Object)element));
                    }
                    return pathArray;
                }
            });
            this.INSTANCE.addConverter(Path.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path, String>(this){

                public String convert(Path source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(ChildAssociationRef.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<ChildAssociationRef, String>(this){

                public String convert(ChildAssociationRef source) {
                    return JSONObject.escape((String)source.toString());
                }
            });
            this.INSTANCE.addConverter(String.class, ChildAssociationRef.class, (TypeConverter.Converter)new TypeConverter.Converter<String, ChildAssociationRef>(this){

                public ChildAssociationRef convert(String source) {
                    return new ChildAssociationRef(source);
                }
            });
            this.INSTANCE.addConverter(AssociationRef.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<AssociationRef, String>(this){

                public String convert(AssociationRef source) {
                    return JSONObject.escape((String)source.toString());
                }
            });
            this.INSTANCE.addConverter(String.class, AssociationRef.class, (TypeConverter.Converter)new TypeConverter.Converter<String, AssociationRef>(this){

                public AssociationRef convert(String source) {
                    return new AssociationRef(source);
                }
            });
            this.INSTANCE.addConverter(Number.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Number, String>(this){

                public String convert(Number source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(Boolean.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Boolean, String>(this){

                public String convert(Boolean source) {
                    return source.toString();
                }
            });
            this.INSTANCE.addConverter(Date.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Date, String>(this){

                public String convert(Date source) {
                    try {
                        DateTime dt = new DateTime((Object)source, DateTimeZone.UTC);
                        return dt.toString();
                    }
                    catch (PlatformRuntimeException e) {
                        throw new TypeConversionException("Failed to convert date " + String.valueOf(source) + " to string", (Throwable)e);
                    }
                }
            });
        }
    }
}

