/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.Comparator;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;

public interface DictionaryComparators {

    public static class PropertyDefinitionComparator
    implements Comparator<PropertyDefinition> {
        private final MessageLookup messageLookup;

        public PropertyDefinitionComparator(MessageLookup messageLookup) {
            this.messageLookup = messageLookup;
        }

        @Override
        public int compare(PropertyDefinition arg0, PropertyDefinition arg1) {
            String title1;
            int result = 0;
            String title0 = arg0.getTitle(this.messageLookup);
            if (title0 == null) {
                title0 = arg0.getName().toPrefixString();
            }
            if ((title1 = arg1.getTitle(this.messageLookup)) == null) {
                title1 = arg1.getName().getPrefixString();
            }
            if (title0 == null && title1 != null) {
                result = 1;
            } else if (title0 != null && title1 == null) {
                result = -1;
            } else if (title0 != null && title1 != null) {
                result = String.CASE_INSENSITIVE_ORDER.compare(title0, title1);
            }
            return result;
        }
    }

    public static class ClassDefinitionComparator
    implements Comparator<ClassDefinition> {
        private final MessageLookup messageLookup;

        public ClassDefinitionComparator(MessageLookup messageLookup) {
            this.messageLookup = messageLookup;
        }

        @Override
        public int compare(ClassDefinition arg0, ClassDefinition arg1) {
            String title1;
            int result = 0;
            String title0 = arg0.getTitle(this.messageLookup);
            if (title0 == null) {
                title0 = arg0.getName().toPrefixString();
            }
            if ((title1 = arg1.getTitle(this.messageLookup)) == null) {
                title1 = arg1.getName().getPrefixString();
            }
            if (title0 == null && title1 != null) {
                result = 1;
            } else if (title0 != null && title1 == null) {
                result = -1;
            } else if (title0 != null && title1 != null) {
                result = String.CASE_INSENSITIVE_ORDER.compare(title0, title1);
            }
            return result;
        }
    }
}

