/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.directurl;

import org.alfresco.repo.content.directurl.AbstractDirectUrlConfig;
import org.alfresco.repo.content.directurl.InvalidDirectAccessUrlConfigException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestApiDirectUrlConfig
extends AbstractDirectUrlConfig {
    private static final Log logger = LogFactory.getLog(RestApiDirectUrlConfig.class);

    public void init() {
        this.validate();
    }

    public void validate() {
        try {
            this.validateDirectAccessUrlConfig();
        }
        catch (InvalidDirectAccessUrlConfigException ex) {
            logger.error((Object)("Disabling REST API direct access URLs due to configuration error: " + ex.getMessage()));
            this.setEnabled(false);
        }
        logger.info((Object)("REST API direct access URLs are " + (this.isEnabled() != false ? "enabled" : "disabled")));
    }

    private void validateDirectAccessUrlConfig() throws InvalidDirectAccessUrlConfigException {
        if (this.isEnabled().booleanValue()) {
            if (this.getDefaultExpiryTimeInSec() == null) {
                logger.warn((Object)String.format("Default expiry time property is missing: setting to system-wide default [%s].", this.getSysWideDefaultExpiryTimeInSec()));
                this.setDefaultExpiryTimeInSec(this.getSysWideDefaultExpiryTimeInSec());
            }
            if (this.getDefaultExpiryTimeInSec() < 1L) {
                String errorMsg = String.format("REST API direct access URL default expiry time [%s] is invalid.", this.getDefaultExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
            if (this.getDefaultExpiryTimeInSec() > this.getSysWideMaxExpiryTimeInSec()) {
                String errorMsg = String.format("REST API direct access URL default expiry time [%s] exceeds system-wide maximum expiry time [%s].", this.getDefaultExpiryTimeInSec(), this.getSysWideMaxExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
        }
    }
}

