/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestRemovePermissions
extends EnterpriseTestApi {
    private static Log logger = LogFactory.getLog(TestRemovePermissions.class);
    public static final String ADMIN_USER = "admin";
    public static final String ADMIN_PASSWORD = "admin";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String ATOMPUB_URL_OC = "http://{0}:{1}/alfresco/cmisatom";
    public static final String ATOMPUB_URL_11 = "http://{0}:{1}/alfresco/api/-default-/public/cmis/versions/1.1/atom";
    public static final String REPOSITORYSERVICE_URL = "http://{0}:{1}/alfresco/cmis/RepositoryService?wsdl";
    public static final String NAVIGATIONSERVICE_URL = "http://{0}:{1}/alfresco/cmis/NavigationService?wsdl";
    public static final String OBJECTSERVICE_URL = "http://{0}:{1}/alfresco/cmis/ObjectService?wsdl";
    public static final String VERSIONINGSERVICE_URL = "http://{0}:{1}/alfresco/cmis/VersioningService?wsdl";
    public static final String DISCOVERYSERVICE_URL = "http://{0}:{1}/alfresco/cmis/DiscoveryService?wsdl";
    public static final String MULTIFILINGSERVICE_URL = "http://{0}:{1}/alfresco/cmis/MultiFilingService?wsdl";
    public static final String RELATIONSHIPSERVICE_URL = "http://{0}:{1}/alfresco/cmis/RelationshipService?wsdl";
    public static final String ACLSERVICE_URL = "http://{0}:{1}/alfresco/cmis/ACLService?wsdl";
    public static final String POLICYSERVICE_URL = "http://{0}:{1}/alfresco/cmis/PolicyService?wsdl";
    public static final String REPOSITORYSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/cmis?wsdl";
    public static final String NAVIGATIONSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/NavigationService?wsdl";
    public static final String OBJECTSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/ObjectService?wsdl";
    public static final String VERSIONINGSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/VersioningService?wsdl";
    public static final String DISCOVERYSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/DiscoveryService?wsdl";
    public static final String MULTIFILINGSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/MultiFilingService?wsdl";
    public static final String RELATIONSHIPSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/RelationshipService?wsdl";
    public static final String ACLSERVICE_OC_URL = "http://{0}:{1}//alfresco/cmisws/ACLService?wsdl";
    public static final String POLICYSERVICE_OC_URL = "http://{0}:{1}/alfresco/cmisws/PolicyService?wsdl";
    public static final String BROWSE_URL_11 = "http://{0}:{1}/alfresco/api/-default-/public/cmis/versions/1.1/browser";

    protected Session getATOMPUB_10_Session() {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            int port = this.getTestFixture().getJettyComponent().getPort();
            parameters.put("org.apache.chemistry.opencmis.user", "admin");
            parameters.put("org.apache.chemistry.opencmis.password", "admin");
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", MessageFormat.format(ATOMPUB_URL_OC, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", ((Repository)sessionFactory.getRepositories(parameters).get(0)).getId());
            return sessionFactory.createSession(parameters);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    protected Session getATOMPUB_11_Session() {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            int port = this.getTestFixture().getJettyComponent().getPort();
            parameters.put("org.apache.chemistry.opencmis.user", "admin");
            parameters.put("org.apache.chemistry.opencmis.password", "admin");
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", MessageFormat.format(ATOMPUB_URL_11, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", ((Repository)sessionFactory.getRepositories(parameters).get(0)).getId());
            return sessionFactory.createSession(parameters);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    protected Session getBROWSER_11_Session() {
        try {
            HashMap<String, String> parameter = new HashMap<String, String>();
            int port = this.getTestFixture().getJettyComponent().getPort();
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.BROWSER.value());
            parameter.put("org.apache.chemistry.opencmis.binding.browser.url", MessageFormat.format(BROWSE_URL_11, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameter.put("org.apache.chemistry.opencmis.binding.cookies", "true");
            parameter.put("org.apache.chemistry.opencmis.user", "admin");
            parameter.put("org.apache.chemistry.opencmis.password", "admin");
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            parameter.put("org.apache.chemistry.opencmis.session.repository.id", ((Repository)sessionFactory.getRepositories(parameter).get(0)).getId());
            return sessionFactory.createSession(parameter);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    protected Session getWEBSERVICE_10_Session() {
        try {
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            int port = 8080;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.apache.chemistry.opencmis.user", "admin");
            parameters.put("org.apache.chemistry.opencmis.password", "admin");
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", MessageFormat.format(ACLSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", MessageFormat.format(DISCOVERYSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", MessageFormat.format(MULTIFILINGSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", MessageFormat.format(NAVIGATIONSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", MessageFormat.format(OBJECTSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", MessageFormat.format(POLICYSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", MessageFormat.format(RELATIONSHIPSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", MessageFormat.format(REPOSITORYSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", MessageFormat.format(REPOSITORYSERVICE_OC_URL, DEFAULT_HOSTNAME, String.valueOf(port)));
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", ((Repository)sessionFactory.getRepositories(parameters).get(0)).getId());
            return sessionFactory.createSession(parameters);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAllPermissions_WEBSERVICE_10() {
        Folder testFolder = null;
        try {
            Session session = this.getWEBSERVICE_10_Session();
            if (session == null) {
                Assert.fail((String)"WEBSERVICE 1.0 session cannot be null");
            }
            testFolder = this.createFolder(session, "testRemoveAllPermissions_WEBSERVICE_10");
            List<Ace> acl = this.create2TestACLs(session);
            testFolder.addAcl(acl, AclPropagation.PROPAGATE);
            Acl allacl = session.getAcl(session.createObjectId(testFolder.getId()), false);
            int oldSize = allacl.getAces().size();
            Acl newAcl = testFolder.removeAcl(allacl.getAces(), AclPropagation.PROPAGATE);
            int newsize = newAcl.getAces().size();
            System.out.println("Old ace size -->" + oldSize);
            System.out.println("New ace size --> " + newsize);
            Assert.assertTrue((newsize == oldSize - acl.size() ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        finally {
            if (testFolder != null) {
                testFolder.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveAllPermissions_ATOMPUB_10() {
        Folder testFolder = null;
        try {
            Session session = this.getATOMPUB_10_Session();
            if (session == null) {
                Assert.fail((String)"ATOMPUB 1.0 session cannot be null");
            }
            testFolder = this.createFolder(session, "testRemoveAllPermissions_ATOMPUB_10");
            List<Ace> acl = this.create2TestACLs(session);
            testFolder.addAcl(acl, AclPropagation.PROPAGATE);
            Acl allacl = session.getAcl(session.createObjectId(testFolder.getId()), false);
            int oldSize = allacl.getAces().size();
            Acl newAcl = testFolder.removeAcl(allacl.getAces(), AclPropagation.PROPAGATE);
            int newsize = newAcl.getAces().size();
            System.out.println("Old ace size -->" + oldSize);
            System.out.println("New ace size --> " + newsize);
            Assert.assertTrue((newsize == oldSize - acl.size() ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        finally {
            if (testFolder != null) {
                testFolder.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveAllPermissions_ATOMPUB_11() {
        Folder testFolder = null;
        try {
            Session session = this.getATOMPUB_11_Session();
            if (session == null) {
                Assert.fail((String)"ATOMPUB 1.1 session cannot be null");
            }
            testFolder = this.createFolder(session, "testRemoveAllPermissions_ATOMPUB_11");
            List<Ace> acl = this.create2TestACLs(session);
            testFolder.addAcl(acl, AclPropagation.PROPAGATE);
            Acl allacl = session.getAcl(session.createObjectId(testFolder.getId()), false);
            int oldSize = allacl.getAces().size();
            Acl newAcl = testFolder.removeAcl(allacl.getAces(), AclPropagation.PROPAGATE);
            int newsize = newAcl.getAces().size();
            System.out.println("Old ace size -->" + oldSize);
            System.out.println("New ace size --> " + newsize);
            Assert.assertTrue((newsize == oldSize - acl.size() ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        finally {
            if (testFolder != null) {
                testFolder.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveAllPermissions_BROWSER_11() {
        Folder testFolder = null;
        try {
            Session session = this.getBROWSER_11_Session();
            if (session == null) {
                Assert.fail((String)"ATOMPUB 1.1 session cannot be null");
            }
            testFolder = this.createFolder(session, "testRemoveAllPermissions_BROWSER_11");
            List<Ace> acl = this.create2TestACLs(session);
            testFolder.addAcl(acl, AclPropagation.PROPAGATE);
            Acl allacl = session.getAcl(session.createObjectId(testFolder.getId()), false);
            int oldSize = allacl.getAces().size();
            Acl newAcl = testFolder.removeAcl(allacl.getAces(), AclPropagation.PROPAGATE);
            int newsize = newAcl.getAces().size();
            System.out.println("Old ace size -->" + oldSize);
            System.out.println("New ace size --> " + newsize);
            Assert.assertTrue((newsize == oldSize - acl.size() ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        finally {
            if (testFolder != null) {
                testFolder.delete();
            }
        }
    }

    private Folder createFolder(Session session, String name) {
        Folder folder = session.getRootFolder();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", name);
        Folder testFolder = folder.createFolder(properties);
        return testFolder;
    }

    private List<Ace> create2TestACLs(Session session) {
        ArrayList<Ace> newACE = new ArrayList<Ace>();
        LinkedList<String> permissions1 = new LinkedList<String>();
        permissions1.add("{http://www.alfresco.org/model/system/1.0}base.ReadPermissions");
        LinkedList<String> permissions2 = new LinkedList<String>();
        permissions2.add("{http://www.alfresco.org/model/system/1.0}base.Unlock");
        Ace ace1 = session.getObjectFactory().createAce("testUser1", permissions1);
        Ace ace2 = session.getObjectFactory().createAce("testUser2", permissions2);
        newACE.add(ace1);
        newACE.add(ace2);
        return newACE;
    }
}

