/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.model.VersionOptions;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.junit.Assert;
import org.junit.Test;

public class NodeVersionsApiTest
extends AbstractSingleNetworkSiteTest {
    private static final String URL_DELETED_NODES = "deleted-nodes";

    protected String getNodeVersionRevertUrl(String nodeId, String versionId) {
        return this.getNodeVersionsUrl(nodeId) + "/" + versionId + "/revert";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileVersionCreateWithOverwrite() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            int verCnt = 1;
            String versionLabel = "1.0";
            String textContentSuffix = "The quick brown fox jumps over the lazy dog ";
            String contentName = "content-1-" + System.currentTimeMillis();
            String content = textContentSuffix + verCnt;
            Document documentResp = this.createTextFile(f1Id, contentName, content, "UTF-8", null);
            String docId = documentResp.getId();
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)versionLabel, (Object)documentResp.getProperties().get("cm:versionLabel"));
            HashMap<String, String> params = null;
            int cnt = 3;
            versionLabel = (String)this.uploadTextFileVersions(user1, f1Id, contentName, cnt, textContentSuffix, verCnt, null, versionLabel).getFirst();
            verCnt += cnt;
            cnt = 2;
            versionLabel = (String)this.uploadTextFileVersions(user1, f1Id, contentName, cnt, textContentSuffix, verCnt, true, versionLabel).getFirst();
            verCnt += cnt;
            cnt = 3;
            versionLabel = (String)this.uploadTextFileVersions(user1, f1Id, contentName, cnt, textContentSuffix, verCnt, false, versionLabel).getFirst();
            Assert.assertEquals((Object)"3.3", (Object)versionLabel);
            Assert.assertEquals((long)9L, (long)(verCnt += cnt));
            params = new HashMap<String, String>();
            params.put("overwrite", "true");
            params.put("autoRename", "true");
            this.createTextFile(myFolderNodeId, contentName, content, "UTF-8", params, 400);
            List<String> aspectNames = documentResp.getAspectNames();
            aspectNames.remove("cm:versionable");
            Document dUpdate = new Document();
            dUpdate.setAspectNames(aspectNames);
            HttpResponse response = this.put("nodes", docId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
            documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
            Assert.assertFalse((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNull(documentResp.getProperties());
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            content = textContentSuffix + ++cnt;
            params = new HashMap();
            params.put("overwrite", "true");
            this.createTextFile(f1Id, contentName, content, "UTF-8", params, 409);
            textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            for (int i = 1; i <= 4; ++i) {
                content = textContentSuffix + i;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
                File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
                PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
                this.putBinary(this.getNodeContentUrl(docId), payload, null, null, 200);
            }
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileVersionAsMinor() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            int verCnt = 1;
            int cnt = 1;
            String versionLabel = "0.1";
            String textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            String contentName = "content-2-" + System.currentTimeMillis();
            String content = textContentSuffix + cnt;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("majorVersion", "false");
            Document documentResp = this.createTextFile(f1Id, contentName, content, "UTF-8", params);
            String docId = documentResp.getId();
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)versionLabel, (Object)documentResp.getProperties().get("cm:versionLabel"));
            cnt = 2;
            versionLabel = this.updateFileVersions(user1, docId, cnt, textContentSuffix, verCnt, null, versionLabel);
            verCnt += cnt;
            cnt = 3;
            versionLabel = this.updateFileVersions(user1, docId, cnt, textContentSuffix, verCnt, true, versionLabel);
            Assert.assertEquals((Object)"3.0", (Object)versionLabel);
            Assert.assertEquals((long)6L, (long)(verCnt += cnt));
            HttpResponse response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)verCnt, (long)nodes.size());
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteVersion() throws Exception {
        this.setRequestContext(user1);
        String sharedFolderNodeId = this.getSharedNodeId();
        String f1Id = null;
        try {
            f1Id = this.createFolder(sharedFolderNodeId, "testDeleteVersion-f1").getId();
            String textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            String contentName = "content-1";
            int cnt = 4;
            Pair<String, String> pair = this.uploadTextFileVersions(user1, f1Id, contentName, cnt, textContentSuffix, 0, null, null);
            String versionLabel = (String)pair.getFirst();
            String docId = (String)pair.getSecond();
            Assert.assertEquals((Object)"1.3", (Object)versionLabel);
            HttpResponse response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)cnt, (long)nodes.size());
            this.setRequestContext(null);
            this.delete(this.getNodeVersionsUrl(docId), "1.0", null, 401);
            this.setRequestContext(user1);
            this.delete(this.getNodeVersionsUrl("dummy"), "1.0", null, 404);
            this.delete(this.getNodeVersionsUrl(docId), "15.0", null, 404);
            this.setRequestContext(user2);
            this.delete(this.getNodeVersionsUrl(docId), "1.0", null, 403);
            this.delete(this.getNodeVersionsUrl(docId), "1.3", null, 403);
            this.setRequestContext(user1);
            this.delete(this.getNodeVersionsUrl(docId), "1.0", null, 204);
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)(cnt - 1), (long)nodes.size());
            response = this.getSingle("nodes", docId, 200);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)"1.3", (Object)nodeResp.getProperties().get("cm:versionLabel"));
            response = this.getSingle(this.getNodeContentUrl(docId), null, 200);
            Assert.assertEquals((Object)(textContentSuffix + "4"), (Object)response.getResponse());
            this.delete(this.getNodeVersionsUrl(docId), "1.3", null, 204);
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)(cnt - 2), (long)nodes.size());
            response = this.getSingle("nodes", docId, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)"1.2", (Object)nodeResp.getProperties().get("cm:versionLabel"));
            response = this.getSingle(this.getNodeContentUrl(docId), null, 200);
            Assert.assertEquals((Object)(textContentSuffix + "3"), (Object)response.getResponse());
            this.delete(this.getNodeVersionsUrl(docId), "1.1", null, 204);
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)(cnt - 3), (long)nodes.size());
            response = this.getSingle("nodes", docId, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)"1.2", (Object)nodeResp.getProperties().get("cm:versionLabel"));
            response = this.getSingle(this.getNodeContentUrl(docId), null, 200);
            Assert.assertEquals((Object)(textContentSuffix + "3"), (Object)response.getResponse());
            this.delete(this.getNodeVersionsUrl(docId), "1.2", null, 422);
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)"1.2", (Object)nodes.get(0).getId());
            String textContent = "more changes 0";
            ByteArrayInputStream inputStream = new ByteArrayInputStream(textContent.getBytes());
            File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
            PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
            response = this.putBinary(this.getNodeContentUrl(docId), payload, null, null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertTrue((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            Assert.assertEquals((Object)"1.3", (Object)nodeResp.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)"MINOR", (Object)nodeResp.getProperties().get("cm:versionType"));
            response = this.getSingle("nodes", docId, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            ArrayList<String> aspectNamesToKeep = new ArrayList<String>();
            aspectNamesToKeep.addAll(nodeResp.getAspectNames());
            aspectNamesToKeep.remove("cm:versionable");
            Node nUpdate = new Node();
            nUpdate.setAspectNames(aspectNamesToKeep);
            response = this.put("nodes", docId, RestApiUtil.toJsonAsStringNonNull(nUpdate), null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertFalse((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            Map<String, Object> props = nodeResp.getProperties();
            if (props != null) {
                Assert.assertNull((Object)props.get("cm:versionLabel"));
                Assert.assertNull((Object)props.get("cm:versionType"));
            }
            response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            textContent = "more changes 1";
            inputStream = new ByteArrayInputStream(textContent.getBytes());
            txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
            payload = new PublicApiHttpClient.BinaryPayload(txtFile);
            response = this.putBinary(this.getNodeContentUrl(docId), payload, null, null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertFalse((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            response = this.getSingle("nodes", docId, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            aspectNamesToKeep = new ArrayList();
            aspectNamesToKeep.addAll(nodeResp.getAspectNames());
            aspectNamesToKeep.add("cm:versionable");
            nUpdate = new Node();
            nUpdate.setAspectNames(aspectNamesToKeep);
            response = this.put("nodes", docId, RestApiUtil.toJsonAsStringNonNull(nUpdate), null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertTrue((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            props = nodeResp.getProperties();
            Assert.assertEquals((Object)"1.0", (Object)props.get("cm:versionLabel"));
            Assert.assertEquals((Object)"MAJOR", (Object)props.get("cm:versionType"));
            response = this.getSingle(this.getNodeVersionsUrl(docId), "1.0/content", null, 200);
            Assert.assertEquals((Object)textContent, (Object)response.getResponse());
            textContent = "more changes 2";
            inputStream = new ByteArrayInputStream(textContent.getBytes());
            txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
            payload = new PublicApiHttpClient.BinaryPayload(txtFile);
            response = this.putBinary(this.getNodeContentUrl(docId), payload, null, null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertTrue((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            props = nodeResp.getProperties();
            Assert.assertEquals((Object)"1.1", (Object)props.get("cm:versionLabel"));
            Assert.assertEquals((Object)"MINOR", (Object)props.get("cm:versionType"));
            response = this.getSingle(this.getNodeVersionsUrl(docId), "1.1/content", null, 200);
            Assert.assertEquals((Object)textContent, (Object)response.getResponse());
        }
        finally {
            if (f1Id != null) {
                this.setRequestContext(user1);
                this.deleteNode(f1Id, true, 204);
            }
        }
    }

    private Pair<String, String> uploadTextFileVersions(String userId, String parentFolderNodeId, String fileName, int cnt, String textContentPrefix, int currentVersionCounter, Boolean majorVersionIn, String currentVersionLabel) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("overwrite", "true");
        if (majorVersionIn != null) {
            params.put("majorVersion", majorVersionIn.toString());
        }
        String docId = null;
        for (int i = 1; i <= cnt; ++i) {
            boolean expectedMajorVersion;
            boolean bl = expectedMajorVersion = majorVersionIn != null ? majorVersionIn : false;
            if (currentVersionLabel == null) {
                currentVersionLabel = "0.0";
                if (majorVersionIn == null) {
                    expectedMajorVersion = true;
                }
            }
            String[] parts = ((String)currentVersionLabel).split("\\.");
            int majorVer = Integer.valueOf(parts[0]);
            int minorVer = Integer.valueOf(parts[1]);
            if (expectedMajorVersion) {
                ++majorVer;
                minorVer = 0;
            } else {
                ++minorVer;
            }
            currentVersionLabel = majorVer + "." + minorVer;
            params.put("comment", "my version " + ++currentVersionCounter);
            String textContent = textContentPrefix + currentVersionCounter;
            Document documentResp = this.createTextFile(parentFolderNodeId, fileName, textContent, "UTF-8", params);
            docId = documentResp.getId();
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)currentVersionLabel, (Object)documentResp.getProperties().get("cm:versionLabel"));
            HttpResponse response = this.getSingle(this.getNodeVersionsUrl(docId), (String)currentVersionLabel, null, 200);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)currentVersionLabel, (Object)nodeResp.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)(expectedMajorVersion ? "MAJOR" : "MINOR"), (Object)nodeResp.getProperties().get("cm:versionType"));
        }
        return new Pair(currentVersionLabel, docId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileVersionUpdate() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            int majorVersion = 1;
            int minorVersion = 0;
            int verCnt = 1;
            String textContentSuffix = "The quick brown fox jumps over the lazy dog ";
            String contentName = "content " + System.currentTimeMillis();
            String content = textContentSuffix + verCnt;
            Document documentResp = this.createTextFile(myFolderNodeId, contentName, content, "UTF-8", null);
            String d1Id = documentResp.getId();
            String versionId = majorVersion + "." + minorVersion;
            HttpResponse response = this.getSingle("nodes", d1Id, 200);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertTrue((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            Assert.assertEquals((Object)versionId, (Object)nodeResp.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)"MAJOR", (Object)nodeResp.getProperties().get("cm:versionType"));
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("include", "properties");
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, params, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)verCnt, (long)nodes.size());
            Assert.assertEquals((Object)versionId, (Object)nodes.get(0).getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)"MAJOR", (Object)nodes.get(0).getProperties().get("cm:versionType"));
            response = this.getSingle(this.getNodeVersionsUrl(d1Id), versionId, null, 200);
            Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)versionId, (Object)node.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)"MAJOR", (Object)node.getProperties().get("cm:versionType"));
            int updateCnt = 3;
            for (int i = 1; i <= updateCnt; ++i) {
                ++minorVersion;
                content = textContentSuffix + ++verCnt;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
                File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
                PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
                this.putBinary(this.getNodeContentUrl(d1Id), payload, null, null, 200);
                versionId = majorVersion + "." + minorVersion;
                response = this.getSingle("nodes", d1Id, 200);
                nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
                Assert.assertTrue((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
                Assert.assertEquals((Object)versionId, (Object)nodeResp.getProperties().get("cm:versionLabel"));
                Assert.assertEquals((Object)"MINOR", (Object)nodeResp.getProperties().get("cm:versionType"));
                response = this.getSingle(this.getNodeVersionsUrl(d1Id), versionId, null, 200);
                node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
                Assert.assertEquals((Object)versionId, (Object)node.getProperties().get("cm:versionLabel"));
                Assert.assertEquals((Object)"MINOR", (Object)node.getProperties().get("cm:versionType"));
                response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 200);
                nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
                Assert.assertEquals((long)verCnt, (long)nodes.size());
            }
            int totalVerCnt = verCnt;
            params = new HashMap();
            params.put("include", "properties");
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)totalVerCnt, (long)nodes.size());
            this.checkVersionHistoryAndContent(d1Id, nodes, verCnt, textContentSuffix, null, majorVersion, minorVersion, false);
            this.deleteNode(d1Id);
            this.getSingle(NodesEntityResource.class, d1Id, null, 404);
            this.getAll(this.getNodeVersionsUrl(d1Id), null, null, 404);
            this.post("deleted-nodes/" + d1Id + "/restore", null, null, 200);
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)totalVerCnt, (long)nodes.size());
            this.setRequestContext(null);
            this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 401);
            this.setRequestContext(user1);
            this.getAll(this.getNodeVersionsUrl("dummy"), paging, null, 404);
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRevert() throws Exception {
        this.setRequestContext(user1);
        String sharedFolderNodeId = this.getSharedNodeId();
        String f1Id = null;
        try {
            f1Id = this.createFolder(sharedFolderNodeId, "testRevert-f1-" + System.currentTimeMillis()).getId();
            int majorVersion = 1;
            int minorVersion = 0;
            int verCnt = 1;
            String textContentSuffix = "The quick brown fox jumps over the lazy dog ";
            String contentName = "content " + System.currentTimeMillis();
            String content = textContentSuffix + verCnt;
            String updateVerCommentSuffix = "Update comment ";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("comment", updateVerCommentSuffix + verCnt);
            Document documentResp = this.createTextFile(f1Id, contentName, content, "UTF-8", params);
            String d1Id = documentResp.getId();
            int updateCnt = 3;
            for (int i = 1; i <= updateCnt; ++i) {
                ++minorVersion;
                content = textContentSuffix + ++verCnt;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
                File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
                PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
                params = new HashMap();
                params.put("comment", updateVerCommentSuffix + verCnt);
                this.putBinary(this.getNodeContentUrl(d1Id), payload, null, params, 200);
            }
            params = new HashMap();
            params.put("include", "properties");
            HttpResponse response = this.getAll(this.getNodeVersionsUrl(d1Id), null, params, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)verCnt, (long)nodes.size());
            this.checkVersionHistoryAndContent(d1Id, nodes, verCnt, textContentSuffix, updateVerCommentSuffix, majorVersion, minorVersion, false);
            int revertMajorVersion = 1;
            int revertMinorVersion = 0;
            String revertVerCommentSuffix = "Revert comment ";
            int revertCnt = 3;
            for (int i = 1; i <= revertCnt; ++i) {
                String revertVersionId = revertMajorVersion + "." + revertMinorVersion;
                VersionOptions versionOptions = new VersionOptions();
                versionOptions.setMajorVersion(Boolean.valueOf(true));
                versionOptions.setComment(revertVerCommentSuffix + i);
                this.post(this.getNodeVersionRevertUrl(d1Id, revertVersionId), RestApiUtil.toJsonAsStringNonNull(versionOptions), null, 200);
                ++verCnt;
                ++revertMinorVersion;
                ++majorVersion;
            }
            params = new HashMap();
            params.put("include", "properties");
            response = this.getAll(this.getNodeVersionsUrl(d1Id), null, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)verCnt, (long)nodes.size());
            List<Node> revertedNodes = nodes.subList(0, revertCnt);
            this.checkVersionHistoryAndContent(d1Id, revertedNodes, updateCnt, textContentSuffix, revertVerCommentSuffix, majorVersion, 0, true);
            minorVersion = 3;
            List<Node> originalUpdatedNodes = nodes.subList(revertCnt, nodes.size());
            this.checkVersionHistoryAndContent(d1Id, originalUpdatedNodes, updateCnt + 1, textContentSuffix, updateVerCommentSuffix, 1, minorVersion, false);
            this.post(this.getNodeVersionRevertUrl(d1Id, majorVersion + ".0"), "{}", null, 200);
            this.setRequestContext(null);
            this.post(this.getNodeVersionRevertUrl(d1Id, "1.0"), "{}", null, 401);
            this.setRequestContext(user1);
            this.post(this.getNodeVersionRevertUrl("dummy", "1.0"), "{}", null, 404);
            this.post(this.getNodeVersionRevertUrl(d1Id, "15.0"), "{}", null, 404);
            this.setRequestContext(user2);
            this.post(this.getNodeVersionRevertUrl(d1Id, "1.0"), "{}", null, 403);
        }
        finally {
            if (f1Id != null) {
                this.setRequestContext(user1);
                this.deleteNode(f1Id, true, 204);
            }
        }
    }

    private void checkVersionHistoryAndContent(String docId, List<Node> nodesWithProps, int verCnt, String textContentSuffix, String verCommentSuffix, int majorVersion, int minorVersion, boolean majorVersions) throws Exception {
        String versionId = null;
        for (Node versionNode : nodesWithProps) {
            versionId = majorVersion + "." + minorVersion;
            Assert.assertEquals((Object)versionId, (Object)versionNode.getId());
            Assert.assertEquals((Object)versionId, (Object)versionNode.getProperties().get("cm:versionLabel"));
            if (versionId.endsWith(".0")) {
                Assert.assertEquals((Object)"MAJOR", (Object)versionNode.getProperties().get("cm:versionType"));
            } else {
                Assert.assertEquals((Object)"MINOR", (Object)versionNode.getProperties().get("cm:versionType"));
            }
            Assert.assertNull((Object)versionNode.getParentId());
            Assert.assertNull((Object)versionNode.getCreatedByUser());
            Assert.assertNull((Object)versionNode.getCreatedAt());
            Assert.assertEquals((Object)(verCommentSuffix != null ? verCommentSuffix + verCnt : null), (Object)versionNode.getVersionComment());
            HttpResponse response = this.getSingle(this.getNodeVersionsUrl(docId), versionId + "/content", null, 200);
            String textContent = response.getResponse();
            Assert.assertEquals((Object)(textContentSuffix + verCnt), (Object)textContent);
            if (majorVersions) {
                --majorVersion;
            } else {
                --minorVersion;
            }
            --verCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEmptyFileVersionUpdate() throws Exception {
        this.setRequestContext(user1);
        String myFolderNodeId = this.getMyNodeId();
        String f1Id = this.createFolder(myFolderNodeId, "f1").getId();
        try {
            Node n = new Node();
            n.setName("d1");
            n.setNodeType("cm:content");
            HttpResponse response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
            String d1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
            response = this.getSingle("nodes", d1Id, 200);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertFalse((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            PublicApiClient.Paging paging = this.getPaging(0, 100);
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            response = this.getAll(this.getNodeVersionsUrl(f1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
            int cntBefore = 2;
            int verCnt = 1;
            String textContentSuffix = "The quick brown fox jumps over the lazy dog ";
            for (int i = 1; i <= cntBefore; ++i) {
                String content = textContentSuffix + verCnt;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
                File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
                PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
                this.putBinary(this.getNodeContentUrl(d1Id), payload, null, null, 200);
                ++verCnt;
                response = this.getSingle("nodes", d1Id, 200);
                nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
                Assert.assertFalse((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
                response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 200);
                nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
                Assert.assertEquals((long)0L, (long)nodes.size());
            }
            Node nodeUpdate = new Node();
            nodeUpdate.setAspectNames(Collections.singletonList("cm:versionable"));
            this.put("nodes", d1Id, RestApiUtil.toJsonAsStringNonNull(nodeUpdate), null, 200);
            Object versionId = "1.0";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("include", "properties");
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)1L, (long)nodes.size());
            Assert.assertEquals((Object)versionId, (Object)nodes.get(0).getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)"MAJOR", (Object)nodes.get(0).getProperties().get("cm:versionType"));
            response = this.getSingle(this.getNodeVersionsUrl(d1Id), (String)versionId, null, 200);
            Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)versionId, (Object)node.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)"MAJOR", (Object)node.getProperties().get("cm:versionType"));
            int cntAfter = 3;
            for (int i = 1; i <= cntAfter; ++i) {
                String content = textContentSuffix + verCnt;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
                File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
                PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
                this.putBinary(this.getNodeContentUrl(d1Id), payload, null, null, 200);
                ++verCnt;
                versionId = "1." + i;
                response = this.getSingle(this.getNodeVersionsUrl(d1Id), (String)versionId, null, 200);
                node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
                Assert.assertEquals((Object)versionId, (Object)node.getProperties().get("cm:versionLabel"));
                Assert.assertEquals((Object)"MINOR", (Object)node.getProperties().get("cm:versionType"));
                response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 200);
                nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
                Assert.assertEquals((long)(i + 1), (long)nodes.size());
            }
            int totalVerCnt = cntAfter + 1;
            int minorVersion = totalVerCnt - 1;
            verCnt = cntBefore + cntAfter;
            params = new HashMap();
            params.put("include", "properties");
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, params, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)totalVerCnt, (long)nodes.size());
            this.checkVersionHistoryAndContent(d1Id, nodes, verCnt, textContentSuffix, null, 1, minorVersion, false);
            this.deleteNode(d1Id);
            this.getSingle(NodesEntityResource.class, d1Id, null, 404);
            this.getAll(this.getNodeVersionsUrl(d1Id), null, null, 404);
            this.post("deleted-nodes/" + d1Id + "/restore", null, null, 200);
            response = this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)(cntAfter + 1), (long)nodes.size());
            this.setRequestContext(null);
            this.getAll(this.getNodeVersionsUrl(d1Id), paging, null, 401);
            this.setRequestContext(user1);
            this.getAll(this.getNodeVersionsUrl("dummy"), paging, null, 404);
            String f99Id = this.createFolder(f1Id, "f99").getId();
            this.getSingle(this.getNodeVersionsUrl(f99Id), "1.0", null, 404);
            this.getSingle(this.getNodeVersionsUrl(f99Id), "1.0/content", null, 404);
            n = new Node();
            n.setName("z1");
            n.setNodeType("cm:content");
            response = this.post(this.getNodeChildrenUrl(f1Id), RestApiUtil.toJsonAsStringNonNull(n), 201);
            String z1Id = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class).getId();
            this.getSingle(this.getNodeVersionsUrl(z1Id), "1.0", null, 404);
            this.getSingle(this.getNodeVersionsUrl(z1Id), "1.0/content", null, 404);
        }
        finally {
            this.setRequestContext(user1);
            this.deleteNode(f1Id, true, 204);
        }
    }

    @Test
    public void testRequestVersionsContentDirectUrl() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String docId = documentResp.getId();
        Assert.assertFalse((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNull(documentResp.getProperties());
        int majorVersion = 1;
        int minorVersion = 0;
        String content = "The quick brown fox jumps over the lazy dog ";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "my version ");
        documentResp = this.updateTextFile(docId, content, params);
        Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNotNull(documentResp.getProperties());
        Assert.assertEquals((Object)(majorVersion + "." + minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        String contentNodeId = documentResp.getId();
        Assert.assertNotNull(documentResp.getProperties());
        Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        ContentInfo contentInfo = documentResp.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        HttpResponse dauResponse = this.post(this.getRequestVersionDirectAccessUrl(contentNodeId, majorVersion + "." + minorVersion), null, null, null, null, 501);
    }

    @Test
    public void testUpdateFileVersionCreate() throws Exception {
        int i;
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String docId = documentResp.getId();
        Assert.assertFalse((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNull(documentResp.getProperties());
        int cnt = 0;
        for (int i2 = 1; i2 <= 3; ++i2) {
            String content = "The quick brown fox jumps over the lazy dog " + ++cnt;
            documentResp = this.updateTextFile(docId, content, null);
            Assert.assertFalse((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNull(documentResp.getProperties());
        }
        int majorVersion = 1;
        int minorVersion = 0;
        String content = "The quick brown fox jumps over the lazy dog " + ++cnt;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "my version " + cnt);
        documentResp = this.updateTextFile(docId, content, params);
        Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNotNull(documentResp.getProperties());
        Assert.assertEquals((Object)(majorVersion + "." + minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        ++minorVersion;
        content = "The quick brown fox jumps over the lazy dog " + ++cnt;
        params = new HashMap();
        params.put("comment", "my version " + cnt);
        documentResp = this.updateTextFile(docId, content, params);
        Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNotNull(documentResp.getProperties());
        Assert.assertEquals((Object)(majorVersion + "." + minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        minorVersion = 0;
        for (i = 1; i <= 3; ++i) {
            ++majorVersion;
            content = "The quick brown fox jumps over the lazy dog " + ++cnt;
            params = new HashMap();
            params.put("comment", "my version " + cnt);
            params.put("majorVersion", "true");
            documentResp = this.updateTextFile(docId, content, params);
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)(majorVersion + "." + minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        }
        for (i = 1; i <= 3; ++i) {
            ++minorVersion;
            content = "The quick brown fox jumps over the lazy dog " + ++cnt;
            params = new HashMap();
            params.put("comment", "my version " + cnt);
            params.put("majorVersion", "false");
            documentResp = this.updateTextFile(docId, content, params);
            Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(documentResp.getProperties());
            Assert.assertEquals((Object)(majorVersion + "." + minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        }
        ++majorVersion;
        minorVersion = 0;
        content = "The quick brown fox jumps over the lazy dog " + ++cnt;
        params = new HashMap();
        params.put("comment", "my version " + cnt);
        params.put("majorVersion", "true");
        documentResp = this.updateTextFile(docId, content, params);
        Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNotNull(documentResp.getProperties());
        Assert.assertEquals((Object)(majorVersion + "." + minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        content = "The quick brown fox jumps over the lazy dog " + ++cnt;
        documentResp = this.updateTextFile(docId, content, null);
        Assert.assertTrue((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNotNull(documentResp.getProperties());
        Assert.assertEquals((Object)(majorVersion + "." + ++minorVersion), (Object)documentResp.getProperties().get("cm:versionLabel"));
        List<String> aspectNames = documentResp.getAspectNames();
        aspectNames.remove("cm:versionable");
        Document dUpdate = new Document();
        dUpdate.setAspectNames(aspectNames);
        response = this.put("nodes", docId, RestApiUtil.toJsonAsStringNonNull(dUpdate), null, 200);
        documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertFalse((boolean)documentResp.getAspectNames().contains("cm:versionable"));
        Assert.assertNull(documentResp.getProperties());
        for (int i3 = 1; i3 <= 3; ++i3) {
            content = "The quick brown fox jumps over the lazy dog " + ++cnt;
            documentResp = this.updateTextFile(docId, content, null);
            Assert.assertFalse((boolean)documentResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNull(documentResp.getProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVersionHistoryPaging() throws Exception {
        this.setRequestContext(user1);
        String f1Id = null;
        try {
            f1Id = this.createFolder("-my-", "testVersionHistoryPaging-f1").getId();
            String textContentSuffix = "Amazingly few discotheques provide jukeboxes ";
            String contentName = "content-1";
            int cnt = 6;
            Pair<String, String> pair = this.uploadTextFileVersions(user1, f1Id, contentName, cnt, textContentSuffix, 0, null, null);
            String versionLabel = (String)pair.getFirst();
            String docId = (String)pair.getSecond();
            Assert.assertEquals((Object)"1.5", (Object)versionLabel);
            HttpResponse response = this.getAll(this.getNodeVersionsUrl(docId), null, null, 200);
            List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)cnt, (long)nodes.size());
            PublicApiClient.Paging paging = this.getPaging(0, 2);
            response = this.getAll(this.getNodeVersionsUrl(docId), paging, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)2L, (long)nodes.size());
            PublicApiClient.ExpectedPaging expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
            Assert.assertEquals((long)0L, (long)expectedPaging.getSkipCount().intValue());
            Assert.assertEquals((long)2L, (long)expectedPaging.getMaxItems().intValue());
            Assert.assertTrue((expectedPaging.getTotalItems() >= cnt ? 1 : 0) != 0);
            Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
            paging = this.getPaging(2, 3);
            response = this.getAll(this.getNodeVersionsUrl(docId), paging, 200);
            nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
            Assert.assertEquals((long)3L, (long)nodes.size());
            expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
            Assert.assertEquals((long)3L, (long)expectedPaging.getCount().intValue());
            Assert.assertEquals((long)2L, (long)expectedPaging.getSkipCount().intValue());
            Assert.assertEquals((long)3L, (long)expectedPaging.getMaxItems().intValue());
            Assert.assertTrue((expectedPaging.getTotalItems() >= cnt ? 1 : 0) != 0);
        }
        finally {
            if (f1Id != null) {
                this.setRequestContext(user1);
                this.deleteNode(f1Id, true, 204);
            }
        }
    }

    @Override
    public String getScope() {
        return "public";
    }
}

