/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities.feed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.util.JSONtoFmModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class UserFeedRetrieverWebScript
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(UserFeedRetrieverWebScript.class);
    public static final String PARAM_SITE_ID = "s";
    public static final String PARAM_EXCLUDE_THIS_USER = "exclUser";
    public static final String PARAM_EXCLUDE_OTHER_USERS = "exclOthers";
    public static final String PARAM_ONLY_FOLLOWING = "following";
    public static final String PARAM_ACTIVITY_FILTER = "activityFilter";
    private ActivityService activityService;
    private SubscriptionService subscriptionService;
    private boolean userNamesAreCaseSensitive = false;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setSubscriptionService(SubscriptionService subscriptionService) {
        this.subscriptionService = subscriptionService;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        HashMap<String, Object> model;
        block20: {
            String extensionPath;
            String format = req.getFormat();
            if (format == null || format.length() == 0) {
                format = this.getDescription().getDefaultFormat();
            }
            String[] extParts = (extensionPath = req.getExtensionPath()) == null ? new String[1] : extensionPath.split("/");
            String feedUserId = null;
            if (extParts.length == 1) {
                feedUserId = extParts[0];
            } else if (extParts.length > 1) {
                throw new AlfrescoRuntimeException("Unexpected extension: " + extensionPath);
            }
            String siteId = req.getParameter(PARAM_SITE_ID);
            String exclThisUserStr = req.getParameter(PARAM_EXCLUDE_THIS_USER);
            String exclOtherUsersStr = req.getParameter(PARAM_EXCLUDE_OTHER_USERS);
            String onlyFollowingStr = req.getParameter(PARAM_ONLY_FOLLOWING);
            String activityFilterStr = req.getParameter(PARAM_ACTIVITY_FILTER);
            boolean exclThisUser = false;
            if (exclThisUserStr != null && (exclThisUserStr.equalsIgnoreCase("true") || exclThisUserStr.equalsIgnoreCase("t"))) {
                exclThisUser = true;
            }
            boolean exclOtherUsers = false;
            if (exclOtherUsersStr != null && (exclOtherUsersStr.equalsIgnoreCase("true") || exclOtherUsersStr.equalsIgnoreCase("t"))) {
                exclOtherUsers = true;
            }
            HashSet<Object> userFilter = null;
            if (onlyFollowingStr != null && (onlyFollowingStr.equalsIgnoreCase("true") || onlyFollowingStr.equalsIgnoreCase("t"))) {
                PagingFollowingResults following;
                userFilter = new HashSet<Object>();
                if (this.subscriptionService.isActive() && (following = this.subscriptionService.getFollowing(AuthenticationUtil.getRunAsUser(), new PagingRequest(-1, null))).getPage() != null) {
                    for (Object userName : following.getPage()) {
                        userFilter.add(this.userNamesAreCaseSensitive ? userName : ((String)userName).toLowerCase());
                    }
                }
            }
            HashSet<String> activityFilter = null;
            if (activityFilterStr != null) {
                activityFilter = new HashSet<String>();
                String[] activities = activityFilterStr.split(",");
                for (String s : activities) {
                    if (s.trim().length() <= 0) continue;
                    activityFilter.add(s.trim());
                }
                if (activityFilter.size() == 0) {
                    activityFilter = null;
                }
            }
            if (feedUserId == null || feedUserId.length() == 0) {
                feedUserId = AuthenticationUtil.getFullyAuthenticatedUser();
            }
            if (format.equals("atomfeed") || format.equals("atom")) {
                format = "atomentry";
            }
            model = new HashMap<String, Object>();
            try {
                List feedEntries = this.activityService.getUserFeedEntries(feedUserId, siteId, exclThisUser, exclOtherUsers, userFilter, activityFilter);
                if (format.equals("json")) {
                    model.put("feedEntries", feedEntries);
                    model.put("siteId", siteId);
                    break block20;
                }
                ArrayList<Map> activityFeedModels = new ArrayList<Map>();
                try {
                    for (String feedEntry : feedEntries) {
                        activityFeedModels.add(JSONtoFmModel.convertJSONObjectToMap((String)feedEntry));
                    }
                }
                catch (JSONException je) {
                    throw new AlfrescoRuntimeException("Unable to get user feed entries: " + je.getMessage());
                }
                model.put("feedEntries", activityFeedModels);
                model.put("feedUserId", feedUserId);
            }
            catch (AccessDeniedException ade) {
                status.setCode(401);
                logger.warn((Object)("Unable to get user feed entries for '" + feedUserId + "' - currently logged in as '" + AuthenticationUtil.getFullyAuthenticatedUser() + "'"));
                return null;
            }
        }
        return model;
    }
}

