/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.custommodel;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.M2Association;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.XMLUtil;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CustomModelImportTest
extends BaseWebScriptTest {
    private static final String NON_ADMIN_USER = "nonAdminUserName";
    private static final String CUSTOM_MODEL_ADMIN = "customModelAdmin";
    private static final String RESOURCE_PREFIX = "custommodel/";
    private static final String UPLOAD_URL = "/api/cmm/upload";
    private static final int BUFFER_SIZE = 20480;
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;
    private PersonService personService;
    private RetryingTransactionHelper transactionHelper;
    private CustomModelService customModelService;
    private List<String> importedModels = new ArrayList<String>();
    private List<File> tempFiles = new ArrayList<File>();

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService", MutableAuthenticationService.class);
        this.authorityService = (AuthorityService)this.getServer().getApplicationContext().getBean("AuthorityService", AuthorityService.class);
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService", PersonService.class);
        this.transactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        this.customModelService = (CustomModelService)this.getServer().getApplicationContext().getBean("customModelService", CustomModelService.class);
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                CustomModelImportTest.this.createUser(CustomModelImportTest.NON_ADMIN_USER);
                CustomModelImportTest.this.createUser(CustomModelImportTest.CUSTOM_MODEL_ADMIN);
                if (!CustomModelImportTest.this.authorityService.getContainingAuthorities(AuthorityType.GROUP, CustomModelImportTest.CUSTOM_MODEL_ADMIN, true).contains("GROUP_ALFRESCO_MODEL_ADMINISTRATORS")) {
                    CustomModelImportTest.this.authorityService.addAuthority("GROUP_ALFRESCO_MODEL_ADMINISTRATORS", CustomModelImportTest.CUSTOM_MODEL_ADMIN);
                }
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)CUSTOM_MODEL_ADMIN);
    }

    public void tearDown() throws Exception {
        for (File file : this.tempFiles) {
            file.delete();
        }
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (String modelName : CustomModelImportTest.this.importedModels) {
                    CustomModelImportTest.this.customModelService.deleteCustomModel(modelName);
                }
                return null;
            }
        });
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                CustomModelImportTest.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        CustomModelImportTest.this.deleteUser(CustomModelImportTest.NON_ADMIN_USER);
                        CustomModelImportTest.this.deleteUser(CustomModelImportTest.CUSTOM_MODEL_ADMIN);
                        return null;
                    }
                });
                return null;
            }
        });
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testValidUpload_ModelAndExtModule() throws Exception {
        File zipFile = this.getResourceFile("validModelAndExtModule.zip");
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)postRequest, 403);
        AuthenticationUtil.setFullyAuthenticatedUser((String)CUSTOM_MODEL_ADMIN);
        response = this.sendRequest((TestWebScriptServer.Request)postRequest, 200);
        JSONObject json = new JSONObject(new JSONTokener(response.getContentAsString()));
        String importedModelName = json.getString("modelName");
        this.importedModels.add(importedModelName);
        String extModule = json.getString("shareExtModule");
        Document document = XMLUtil.parse((String)extModule);
        NodeList nodes = document.getElementsByTagName("id");
        CustomModelImportTest.assertEquals((int)1, (int)nodes.getLength());
        CustomModelImportTest.assertNotNull((Object)nodes.item(0).getTextContent());
    }

    public void testValidUpload_ModelOnly() throws Exception {
        File zipFile = this.getResourceFile("validModel.zip");
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)postRequest, 403);
        AuthenticationUtil.setFullyAuthenticatedUser((String)CUSTOM_MODEL_ADMIN);
        response = this.sendRequest((TestWebScriptServer.Request)postRequest, 200);
        JSONObject json = new JSONObject(new JSONTokener(response.getContentAsString()));
        String importedModelName = json.getString("modelName");
        this.importedModels.add(importedModelName);
        CustomModelImportTest.assertFalse((boolean)json.has("shareExtModule"));
        this.sendRequest((TestWebScriptServer.Request)postRequest, 409);
    }

    public void testValidUpload_ExtModuleOnly() throws Exception {
        File zipFile = this.getResourceFile("validExtModule.zip");
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)postRequest, 403);
        AuthenticationUtil.setFullyAuthenticatedUser((String)CUSTOM_MODEL_ADMIN);
        response = this.sendRequest((TestWebScriptServer.Request)postRequest, 200);
        JSONObject json = new JSONObject(new JSONTokener(response.getContentAsString()));
        CustomModelImportTest.assertFalse((boolean)json.has("modelName"));
        String extModule = json.getString("shareExtModule");
        Document document = XMLUtil.parse((String)extModule);
        NodeList nodes = document.getElementsByTagName("id");
        CustomModelImportTest.assertEquals((int)1, (int)nodes.getLength());
        CustomModelImportTest.assertNotNull((Object)nodes.item(0).getTextContent());
    }

    public void testNotZipFileUpload() throws Exception {
        File file = this.getResourceFile("validModel.zip");
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.entries().nextElement();
        File unzippedModelFile = TempFileProvider.createTempFile((InputStream)zipFile.getInputStream(zipEntry), (String)"validModel", (String)".xml");
        this.tempFiles.add(unzippedModelFile);
        zipFile.close();
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(unzippedModelFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 400);
    }

    public void testInvalidZipUpload() throws Exception {
        String content = "<note><from>Jane</from><to>John</to><heading>Upload test</heading><body>This is an invalid model or a Share extension module</body></note>";
        ZipEntryContext context = new ZipEntryContext("invalidFormat.xml", content.getBytes());
        File zipFile = this.createZip(context);
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 400);
    }

    public void testUploadModel_Invalid() throws Exception {
        long timestamp = System.currentTimeMillis();
        String modelName = ((Object)((Object)this)).getClass().getSimpleName() + timestamp;
        String prefix = "prefix" + timestamp;
        String uri = "uriNamespace" + timestamp;
        M2Model model = M2Model.createModel((String)(prefix + ":" + modelName));
        model.setAuthor("Admin");
        model.setDescription("Desc");
        ByteArrayOutputStream xml = new ByteArrayOutputStream();
        model.toXML((OutputStream)xml);
        ZipEntryContext context = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        File zipFile = this.createZip(context);
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 409);
        model.createNamespace(uri, prefix);
        model.createNamespace(uri + "anotherUri", prefix + "anotherPrefix");
        xml = new ByteArrayOutputStream();
        model.toXML((OutputStream)xml);
        context = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        zipFile = this.createZip(context);
        postRequest = this.buildMultipartPostRequest(zipFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 409);
    }

    public void testUploadModel_UnsupportedModelElements() throws Exception {
        long timestamp = System.currentTimeMillis();
        String modelName = ((Object)((Object)this)).getClass().getSimpleName() + timestamp;
        String prefix = "prefix" + timestamp;
        String uri = "uriNamespace" + timestamp;
        String aspectName = prefix + ":testAspec";
        String typeName = prefix + ":testType";
        String associationName = prefix + ":testAssociation";
        M2Model model = M2Model.createModel((String)(prefix + ":" + modelName));
        model.createNamespace(uri, prefix);
        model.setAuthor("John Doe");
        model.createAspect(aspectName);
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Type type = model.createType(typeName);
        M2Association association = type.createAssociation(associationName);
        association.setSourceMandatory(false);
        association.setSourceMany(false);
        association.setTargetMandatory(false);
        association.setTargetClassName("cm:content");
        ByteArrayOutputStream xml = new ByteArrayOutputStream();
        model.toXML((OutputStream)xml);
        ZipEntryContext context = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        File zipFile = this.createZip(context);
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 409);
        type.removeAssociation(associationName);
        type.addMandatoryAspect(aspectName);
        xml = new ByteArrayOutputStream();
        model.toXML((OutputStream)xml);
        context = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        zipFile = this.createZip(context);
        postRequest = this.buildMultipartPostRequest(zipFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 409);
    }

    public void testInvalidNumberOfZipEntries() throws Exception {
        long timestamp = System.currentTimeMillis();
        String modelName = ((Object)((Object)this)).getClass().getSimpleName() + timestamp;
        String prefix = "prefix" + timestamp;
        String uri = "uriNamespace" + timestamp;
        M2Model modelOne = M2Model.createModel((String)(prefix + ":" + modelName));
        modelOne.createNamespace(uri, prefix);
        modelOne.setDescription("Model 1");
        ByteArrayOutputStream xml = new ByteArrayOutputStream();
        modelOne.toXML((OutputStream)xml);
        ZipEntryContext contextOne = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        modelName = modelName + "two";
        prefix = prefix + "two";
        uri = uri + "two";
        M2Model modelTwo = M2Model.createModel((String)(prefix + ":" + modelName));
        modelTwo.createNamespace(uri, prefix);
        modelTwo.setDescription("Model 2");
        xml = new ByteArrayOutputStream();
        modelTwo.toXML((OutputStream)xml);
        ZipEntryContext contextTwo = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        modelName = modelName + "three";
        prefix = prefix + "three";
        uri = uri + "three";
        M2Model modelThree = M2Model.createModel((String)(prefix + ":" + modelName));
        modelThree.createNamespace(uri, prefix);
        modelThree.setDescription("Model 3");
        xml = new ByteArrayOutputStream();
        modelThree.toXML((OutputStream)xml);
        ZipEntryContext contextThree = new ZipEntryContext(modelName + ".xml", xml.toByteArray());
        File zipFile = this.createZip(contextOne, contextTwo, contextThree);
        TestWebScriptServer.PostRequest postRequest = this.buildMultipartPostRequest(zipFile);
        this.sendRequest((TestWebScriptServer.Request)postRequest, 400);
    }

    public TestWebScriptServer.PostRequest buildMultipartPostRequest(File file) throws IOException {
        Part[] parts = new Part[]{new FilePart("filedata", file.getName(), file, "application/zip", null)};
        MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(parts, new HttpMethodParams());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        multipartRequestEntity.writeRequest((OutputStream)os);
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(UPLOAD_URL, os.toByteArray(), multipartRequestEntity.getContentType());
        return postReq;
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private void deleteUser(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    private File getResourceFile(String xmlFileName) throws FileNotFoundException {
        URL url = CustomModelImportTest.class.getClassLoader().getResource(RESOURCE_PREFIX + xmlFileName);
        if (url == null) {
            CustomModelImportTest.fail((String)("Cannot get the resource: " + xmlFileName));
        }
        return ResourceUtils.getFile((URL)url);
    }

    private File createZip(ZipEntryContext ... zipEntryContexts) {
        File zipFile = TempFileProvider.createTempFile((String)((Object)((Object)this)).getClass().getSimpleName(), (String)".zip");
        this.tempFiles.add(zipFile);
        byte[] buffer = new byte[20480];
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile), 20480);
            ZipOutputStream zos = new ZipOutputStream(out);
            for (ZipEntryContext context : zipEntryContexts) {
                int len;
                ZipEntry zipEntry = new ZipEntry(context.getZipEntryName());
                zos.putNextEntry(zipEntry);
                InputStream input = context.getEntryContent();
                while ((len = input.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                input.close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            CustomModelImportTest.fail((String)"couldn't create zip file.");
        }
        return zipFile;
    }

    private static class ZipEntryContext {
        private final String zipEntryName;
        private final InputStream entryContent;

        public ZipEntryContext(String zipEntryName, byte[] zipEntryContent) {
            this.zipEntryName = zipEntryName;
            this.entryContent = new ByteArrayInputStream(zipEntryContent);
        }

        public String getZipEntryName() {
            return this.zipEntryName;
        }

        public InputStream getEntryContent() {
            return this.entryContent;
        }
    }
}

