/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.service.cmr.lock.LockType;

@JsonIgnoreProperties(value={"mappedType"})
public class LockInfo {
    private Integer timeToExpire;
    private LockType2 type;
    private Lifetime lifetime;

    public void setTimeToExpire(Integer timeToExpire) {
        this.timeToExpire = timeToExpire;
    }

    public Integer getTimeToExpire() {
        return this.timeToExpire;
    }

    public LockType getMappedType() {
        return this.type != null ? this.type.getType() : null;
    }

    public LockType2 getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = LockType2.valueOf(type);
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetimeStr) {
        this.lifetime = Lifetime.valueOf((String)lifetimeStr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LockInfo{");
        sb.append(", timeToExpire='").append(this.timeToExpire).append('\'');
        sb.append(", type='").append((Object)this.type).append('\'');
        sb.append(", lifetime='").append(this.lifetime).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static enum LockType2 {
        FULL(LockType.READ_ONLY_LOCK),
        ALLOW_OWNER_CHANGES(LockType.WRITE_LOCK);

        private LockType type;

        private LockType2(LockType type) {
            this.type = type;
        }

        public LockType getType() {
            return this.type;
        }
    }
}

