/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.PropertyMap;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class AbstractSiteServiceTest
extends BaseWebScriptTest {
    protected MutableAuthenticationService authenticationService;
    protected AuthenticationComponent authenticationComponent;
    protected PersonService personService;
    private static final String URL_SITES = "/api/sites";
    private static final String URL_MEMBERSHIPS = "/memberships";
    protected List<String> createdSites = Lists.newArrayList();

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void deleteSites() throws Exception {
        for (String shortName : this.createdSites) {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 0);
        }
        this.createdSites.clear();
    }

    protected void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            this.createPerson(userName);
        }
    }

    protected void createPerson(String userName) {
        PropertyMap ppOne = new PropertyMap(4);
        ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
        ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
        ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
        ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
        this.personService.createPerson((Map)ppOne);
    }

    protected void deleteUser(String username) {
        this.personService.deletePerson(username);
        if (this.authenticationService.authenticationExists(username)) {
            this.authenticationService.deleteAuthentication(username);
        }
    }

    protected JSONObject createSite(String sitePreset, String shortName, String title, String description, SiteVisibility visibility, int expectedStatus) throws Exception {
        JSONObject site = new JSONObject();
        site.put("sitePreset", (Object)sitePreset);
        site.put("shortName", (Object)shortName);
        site.put("title", (Object)title);
        site.put("description", (Object)description);
        site.put("visibility", (Object)visibility.toString());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_SITES, site.toString(), "application/json"), expectedStatus);
        this.createdSites.add(shortName);
        return new JSONObject(response.getContentAsString());
    }

    protected void addSiteMember(String userName, String site) throws Exception {
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)userName);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + site + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
    }
}

