/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={OwnJVMTestsCategory.class})
public class RuleServiceIntegrationTest {
    private static final String STANDARD_TEXT_CONTENT = "standardTextContent";
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserOne");
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserTwo");
    public static TemporaryNodes STATIC_TEST_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1).around((TestRule)TEST_USER2).around((TestRule)STATIC_TEST_NODES);
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    @Rule
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(TEST_USER1);
    private static ServiceRegistry SERVICE_REGISTRY;
    private static NodeService NODE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static ActionService ACTION_SERVICE;
    private static RuleService RULE_SERVICE;
    private static ContentService CONTENT_SERVICE;
    protected static MailActionExecuter MAIL_ACTION_EXECUTER;
    private static NodeRef COMPANY_HOME;
    private static NodeRef TEST_FOLDER;
    private NodeRef parentFolder;
    private NodeRef childFolder;
    private NodeRef childContent;
    protected static boolean WAS_IN_TEST_MODE;

    @BeforeClass
    public static void setupTest() throws Exception {
        SERVICE_REGISTRY = (ServiceRegistry)APP_CONTEXT_INIT.getApplicationContext().getBean("ServiceRegistry");
        NODE_SERVICE = SERVICE_REGISTRY.getNodeService();
        TRANSACTION_HELPER = SERVICE_REGISTRY.getTransactionService().getRetryingTransactionHelper();
        ACTION_SERVICE = SERVICE_REGISTRY.getActionService();
        RULE_SERVICE = SERVICE_REGISTRY.getRuleService();
        CONTENT_SERVICE = SERVICE_REGISTRY.getContentService();
        MAIL_ACTION_EXECUTER = (MailActionExecuter)((ApplicationContextFactory)APP_CONTEXT_INIT.getApplicationContext().getBean("OutboundSMTP", ApplicationContextFactory.class)).getApplicationContext().getBean("mail", MailActionExecuter.class);
        WAS_IN_TEST_MODE = MAIL_ACTION_EXECUTER.isTestMode();
        MAIL_ACTION_EXECUTER.setTestMode(true);
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        COMPANY_HOME = repositoryHelper.getCompanyHome();
        TEST_FOLDER = STATIC_TEST_NODES.createNode(COMPANY_HOME, "testFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
    }

    @AfterClass
    public static void tearDownTests() {
        MAIL_ACTION_EXECUTER.setTestMode(WAS_IN_TEST_MODE);
    }

    @Before
    public void createTestContent() {
        this.parentFolder = this.testNodes.createNode(TEST_FOLDER, "testFolderInFolder", ContentModel.TYPE_FOLDER, TEST_USER2.getUsername());
        this.childFolder = this.testNodes.createNode(this.parentFolder, "testDocInFolder", ContentModel.TYPE_FOLDER, TEST_USER2.getUsername());
        this.childContent = this.testNodes.createNode(this.childFolder, "theTestContent", ContentModel.TYPE_CONTENT, TEST_USER2.getUsername());
    }

    @Test
    public void testInheritedInvertedRule() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                org.alfresco.service.cmr.rule.Rule parentRule = new org.alfresco.service.cmr.rule.Rule();
                parentRule.setRuleTypes(Collections.singletonList("inbound"));
                parentRule.setTitle("RuleServiceTest" + GUID.generate());
                parentRule.setDescription("Add Versionable");
                Action action = ACTION_SERVICE.createAction("add-features");
                action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
                parentRule.setAction(action);
                parentRule.applyToChildren(true);
                org.alfresco.service.cmr.rule.Rule childRule = new org.alfresco.service.cmr.rule.Rule();
                childRule.setRuleTypes(Collections.singletonList("inbound"));
                childRule.setTitle("RuleServiceTest" + GUID.generate());
                childRule.setDescription("RemoveVersonable");
                Action action2 = ACTION_SERVICE.createAction("remove-features");
                action2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
                childRule.setAction(action2);
                childRule.applyToChildren(false);
                RULE_SERVICE.saveRule(RuleServiceIntegrationTest.this.parentFolder, parentRule);
                RULE_SERVICE.saveRule(RuleServiceIntegrationTest.this.childFolder, childRule);
                return null;
            }
        });
        this.addContentToNode(this.childContent);
        Assert.assertTrue((String)"Versionable Aspect was not removed", (!NODE_SERVICE.hasAspect(this.childContent, ContentModel.ASPECT_VERSIONABLE) ? 1 : 0) != 0);
    }

    @Test
    public void testEmailExecutorOnOutboundTriggerDelete() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
                rule.setRuleTypes(Collections.singletonList("outbound"));
                rule.setTitle("RuleServiceTest" + GUID.generate());
                rule.setDescription("Send email on delete");
                Action mailAction = ACTION_SERVICE.createAction("mail");
                mailAction.setParameterValue("from", (Serializable)((Object)"some.body@example.com"));
                mailAction.setParameterValue("to", (Serializable)((Object)"some.bodyelse@example.com"));
                mailAction.setParameterValue("subject", (Serializable)((Object)"Testing"));
                mailAction.setParameterValue("template", (Serializable)((Object)"alfresco/templates/mail/test.txt.ftl"));
                mailAction.setParameterValue("template_model", RuleServiceIntegrationTest.this.getModel());
                rule.setAction(mailAction);
                RULE_SERVICE.saveRule(RuleServiceIntegrationTest.this.childFolder, rule);
                return null;
            }
        });
        NODE_SERVICE.deleteNode(this.childContent);
        MimeMessage message = MAIL_ACTION_EXECUTER.retrieveLastTestMessage();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Hello Jan 1, 1970", (Object)((String)message.getContent()));
    }

    private void addContentToNode(NodeRef nodeRef) {
        ContentWriter contentWriter = CONTENT_SERVICE.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        Assert.assertNotNull((Object)contentWriter);
        contentWriter.putContent(STANDARD_TEXT_CONTENT + System.currentTimeMillis());
    }

    private Serializable getModel() {
        HashMap<String, Date> model = new HashMap<String, Date>();
        model.put("epoch", new Date(0L));
        return model;
    }
}

