/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import org.alfresco.repo.search.impl.solr.SpellCheckDecisionManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.ResourceUtils;

public class SpellCheckDecisionManagerTest {
    private static final String RESOURCE_PREFIX = "org/alfresco/repo/search/impl/spellcheck/";
    private static final String SEARCH_REQUEST_URL = "/solr4/alfresco/afts?wt=json&fl=DBID%2Cscore&rows=251&df=keywords&start=0&locale=en&alternativeDic=DEFAULT_DICTIONARY&fq=%7B%21afts%7DAUTHORITY_FILTER_FROM_JSON&fq=%7B%21afts%7DTENANT_FILTER_FROM_JSON";

    @Test
    public void testCollation() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("searchInsteadFor.json");
        JSONObject requestBody = this.createJsonSearchRequest("alfrezco");
        String spellCheckParam = this.getSpellCheckParam("alfrezco");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertTrue((boolean)manager.isCollate());
        Assert.assertEquals((Object)SEARCH_REQUEST_URL, (Object)manager.getUrl());
        JSONObject searchedForJsonObject = manager.getSpellCheckJsonValue();
        Assert.assertEquals((Object)"alfresco", (Object)searchedForJsonObject.getString("searchInsteadFor"));
        Assert.assertEquals((Object)this.createJsonSearchRequest("alfresco").getString("query"), (Object)requestBody.getString("query"));
        long numberFound = this.getOrigQueryHit(resultJson);
        Assert.assertEquals((long)0L, (long)numberFound);
        long collationHit = this.getCollationHit(resultJson);
        Assert.assertTrue((collationHit > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCollation2() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("searchInsteadFor2.json");
        JSONObject requestBody = this.createJsonSearchRequest("alfrezco");
        String spellCheckParam = this.getSpellCheckParam("alfrezco");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertTrue((boolean)manager.isCollate());
        Assert.assertEquals((Object)SEARCH_REQUEST_URL, (Object)manager.getUrl());
        JSONObject searchedForJsonObject = manager.getSpellCheckJsonValue();
        Assert.assertEquals((Object)"alfresco", (Object)searchedForJsonObject.getString("searchInsteadFor"));
        Assert.assertEquals((Object)this.createJsonSearchRequest("alfresco").getString("query"), (Object)requestBody.getString("query"));
        long numberFound = this.getOrigQueryHit(resultJson);
        Assert.assertEquals((long)0L, (long)numberFound);
        long collationHit = this.getCollationHit2(resultJson);
        Assert.assertTrue((collationHit > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testDidYouMean() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("didYouMean.json");
        JSONObject requestBody = this.createJsonSearchRequest("londn");
        String spellCheckParam = this.getSpellCheckParam("londn");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertFalse((boolean)manager.isCollate());
        Assert.assertEquals((Object)(SEARCH_REQUEST_URL + spellCheckParam), (Object)manager.getUrl());
        JSONObject didYouMeanJsonObject = manager.getSpellCheckJsonValue();
        JSONArray jsonArray = didYouMeanJsonObject.getJSONArray("didYouMean");
        Assert.assertEquals((long)2L, (long)jsonArray.length());
        Object[] suggestedTerms = new String[]{jsonArray.getString(0), jsonArray.getString(1)};
        Arrays.sort(suggestedTerms);
        Assert.assertEquals((Object)"login", (Object)suggestedTerms[0]);
        Assert.assertEquals((Object)"london", (Object)suggestedTerms[1]);
        Assert.assertEquals((Object)this.createJsonSearchRequest("londn").getString("query"), (Object)requestBody.getString("query"));
        long numberFound = this.getOrigQueryHit(resultJson);
        long collationHit = this.getCollationHit(resultJson);
        Assert.assertTrue((collationHit > numberFound ? 1 : 0) != 0);
    }

    @Test
    public void testDidYouMean2() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("didYouMean2.json");
        JSONObject requestBody = this.createJsonSearchRequest("londn");
        String spellCheckParam = this.getSpellCheckParam("londn");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertFalse((boolean)manager.isCollate());
        Assert.assertEquals((Object)(SEARCH_REQUEST_URL + spellCheckParam), (Object)manager.getUrl());
        JSONObject didYouMeanJsonObject = manager.getSpellCheckJsonValue();
        JSONArray jsonArray = didYouMeanJsonObject.getJSONArray("didYouMean");
        Assert.assertEquals((long)2L, (long)jsonArray.length());
        Object[] suggestedTerms = new String[]{jsonArray.getString(0), jsonArray.getString(1)};
        Arrays.sort(suggestedTerms);
        Assert.assertEquals((Object)"login", (Object)suggestedTerms[0]);
        Assert.assertEquals((Object)"london", (Object)suggestedTerms[1]);
        Assert.assertEquals((Object)this.createJsonSearchRequest("londn").getString("query"), (Object)requestBody.getString("query"));
        System.out.println("###jsonResult:" + resultJson);
        long numberFound = this.getOrigQueryHit(resultJson);
        long collationHit = this.getCollationHit2(resultJson);
        Assert.assertTrue((collationHit > numberFound ? 1 : 0) != 0);
    }

    @Test
    public void testNoSuggestions() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("noSuggestions.json");
        JSONObject requestBody = this.createJsonSearchRequest("gibberishtextttttttttt");
        String spellCheckParam = this.getSpellCheckParam("gibberishtextttttttttt");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertFalse((boolean)manager.isCollate());
        Assert.assertEquals((Object)(SEARCH_REQUEST_URL + spellCheckParam), (Object)manager.getUrl());
        JSONObject noSuggestionsJsonObject = manager.getSpellCheckJsonValue();
        Assert.assertEquals((long)0L, (long)noSuggestionsJsonObject.length());
        Assert.assertEquals((Object)this.createJsonSearchRequest("gibberishtextttttttttt").getString("query"), (Object)requestBody.getString("query"));
        long numberFound = this.getOrigQueryHit(resultJson);
        Assert.assertEquals((long)0L, (long)numberFound);
        long collationHit = this.getCollationHit(resultJson);
        Assert.assertEquals((long)0L, (long)collationHit);
    }

    @Test
    public void testCorrectlySpelledTerm() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("correctlySpelledTermQuery.json");
        JSONObject requestBody = this.createJsonSearchRequest("london");
        String spellCheckParam = this.getSpellCheckParam("london");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertFalse((boolean)manager.isCollate());
        Assert.assertEquals((Object)(SEARCH_REQUEST_URL + spellCheckParam), (Object)manager.getUrl());
        JSONObject noSuggestionsJsonObject = manager.getSpellCheckJsonValue();
        Assert.assertEquals((long)0L, (long)noSuggestionsJsonObject.length());
        Assert.assertEquals((Object)this.createJsonSearchRequest("london").getString("query"), (Object)requestBody.getString("query"));
        long numberFound = this.getOrigQueryHit(resultJson);
        long collationHit = this.getCollationHit(resultJson);
        Assert.assertTrue((numberFound >= collationHit ? 1 : 0) != 0);
    }

    @Test
    public void testCorrectlySpelledTerm2() throws Exception {
        JSONObject resultJson = this.getSearchResponseAsJson("correctlySpelledTermQuery2.json");
        JSONObject requestBody = this.createJsonSearchRequest("london");
        String spellCheckParam = this.getSpellCheckParam("london");
        SpellCheckDecisionManager manager = new SpellCheckDecisionManager(resultJson, SEARCH_REQUEST_URL + spellCheckParam, requestBody, spellCheckParam);
        Assert.assertFalse((boolean)manager.isCollate());
        Assert.assertEquals((Object)(SEARCH_REQUEST_URL + spellCheckParam), (Object)manager.getUrl());
        JSONObject noSuggestionsJsonObject = manager.getSpellCheckJsonValue();
        Assert.assertEquals((long)0L, (long)noSuggestionsJsonObject.length());
        Assert.assertEquals((Object)this.createJsonSearchRequest("london").getString("query"), (Object)requestBody.getString("query"));
        long numberFound = this.getOrigQueryHit(resultJson);
        long collationHit = this.getCollationHit2(resultJson);
        Assert.assertTrue((collationHit == 1L ? 1 : 0) != 0);
        Assert.assertTrue((numberFound >= collationHit ? 1 : 0) != 0);
    }

    public JSONObject getSearchResponseAsJson(String jsonResponse) throws FileNotFoundException, JSONException {
        URL url = SpellCheckDecisionManagerTest.class.getClassLoader().getResource(RESOURCE_PREFIX + jsonResponse);
        if (url == null) {
            Assert.fail((String)("Cannot get the resource: " + jsonResponse));
        }
        FileReader reader = new FileReader(ResourceUtils.getFile((URL)url));
        JSONObject resultJson = new JSONObject(new JSONTokener((Reader)reader));
        return resultJson;
    }

    public JSONObject createJsonSearchRequest(String searchTerm) throws JSONException {
        String requestStr = "{\"queryConsistency\" : \"DEFAULT\",\"textAttributes\" : [],\"allAttributes\" : [],\"templates\" : [{\"template\" : \"%(cm:name cm:title cm:description ia:whatEvent ia:descriptionEvent lnk:title lnk:description TEXT TAG)\",\"name\" : \"keywords\"}],\"authorities\" : [\"GROUP_EVERYONE\", \"ROLE_ADMINISTRATOR\", \"ROLE_AUTHENTICATED\", \"admin\"],\"tenants\" : [\"\"],\"query\" : \"(" + searchTerm + "  AND (+TYPE:\\\"cm:content\\\" OR +TYPE:\\\"cm:folder\\\")) AND -TYPE:\\\"cm:thumbnail\\\" AND -TYPE:\\\"cm:failedThumbnail\\\" AND -TYPE:\\\"cm:rating\\\" AND -TYPE:\\\"st:site\\\" AND -ASPECT:\\\"st:siteContainer\\\" AND -ASPECT:\\\"sys:hidden\\\" AND -cm:creator:system AND -QNAME:comment\\\\-*\"," + "\"locales\" : [\"en\"]," + "\"defaultNamespace\" : \"http://www.alfresco.org/model/content/1.0\"," + "\"defaultFTSFieldOperator\" : \"AND\"," + "\"defaultFTSOperator\" : \"AND\"" + "}";
        ByteArrayInputStream is = new ByteArrayInputStream(requestStr.getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        JSONObject json = new JSONObject(new JSONTokener((Reader)reader));
        return json;
    }

    private String getSpellCheckParam(String searchTerm) {
        return "&spellcheck.q=" + searchTerm + "&spellcheck=true";
    }

    private long getOrigQueryHit(JSONObject resultJson) throws JSONException {
        JSONObject response = resultJson.getJSONObject("response");
        long numberFound = response.getLong("numFound");
        return numberFound;
    }

    private long getCollationHit(JSONObject resultJson) throws JSONException {
        JSONObject spellcheck = resultJson.getJSONObject("spellcheck");
        JSONArray suggestions = spellcheck.getJSONArray("suggestions");
        int key = 0;
        int value = 1;
        int length = suggestions.length();
        while (value < length) {
            String jsonName = suggestions.getString(key);
            if ("collation".equals(jsonName)) {
                JSONObject valueJsonObject = suggestions.getJSONObject(value);
                long collationHit = valueJsonObject.getLong("hits");
                return collationHit;
            }
            key += 2;
            value += 2;
        }
        return 0L;
    }

    private long getCollationHit2(JSONObject resultJson) throws JSONException {
        JSONObject spellcheck = resultJson.getJSONObject("spellcheck");
        JSONArray collations = spellcheck.getJSONArray("collations");
        int key = 0;
        int value = 1;
        int length = collations.length();
        while (value < length) {
            String jsonName = collations.getString(key);
            if ("collation".equals(jsonName)) {
                JSONObject valueJsonObject = collations.getJSONObject(value);
                long collationHit = valueJsonObject.getLong("hits");
                return collationHit;
            }
            key += 2;
            value += 2;
        }
        return 0L;
    }
}

