/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.io.ByteArrayInputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.management.subsystems.AbstractChainedSubsystemTest;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.rotation.HardcodedPublicKeyLocator;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.representations.AccessToken;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class IdentityServiceRemoteUserMapperTest
extends AbstractChainedSubsystemTest {
    private static final String REMOTE_USER_MAPPER_BEAN_NAME = "remoteUserMapper";
    private static final String DEPLOYMENT_BEAN_NAME = "identityServiceDeployment";
    private static final String CONFIG_BEAN_NAME = "identityServiceConfig";
    private static final String TEST_USER_USERNAME = "testuser";
    private static final String TEST_USER_EMAIL = "testuser@mail.com";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String BASIC_PREFIX = "Basic ";
    private static final String CONFIG_SILENT_ERRORS = "identity-service.authentication.validation.failure.silent";
    private static final String PASSWORD_GRANT_RESPONSE = "{\"access_token\": \"%s\",\"expires_in\": 300,\"refresh_expires_in\": 1800,\"refresh_token\": \"%s\",\"token_type\": \"bearer\",\"not-before-policy\": 0,\"session_state\": \"71c2c5ba-9c98-49fc-882f-dedcf80ee1b5\"}";
    ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    DefaultChildApplicationContextManager childApplicationContextManager;
    ChildApplicationContextFactory childApplicationContextFactory;
    private KeyPair keyPair;
    private IdentityServiceConfig identityServiceConfig;

    protected void setUp() throws Exception {
        this.childApplicationContextManager = (DefaultChildApplicationContextManager)this.ctx.getBean("Authentication");
        this.childApplicationContextManager.stop();
        this.childApplicationContextManager.setProperty("chain", "identity-service1:identity-service");
        this.childApplicationContextFactory = this.getChildApplicationContextFactory(this.childApplicationContextManager, "identity-service1");
        this.keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        this.applyHardcodedPublicKey(this.keyPair.getPublic());
        this.identityServiceConfig = (IdentityServiceConfig)this.childApplicationContextFactory.getApplicationContext().getBean(CONFIG_BEAN_NAME);
    }

    protected void tearDown() throws Exception {
        this.childApplicationContextManager.destroy();
        this.childApplicationContextManager = null;
        this.childApplicationContextFactory = null;
    }

    public void testKeycloakConfig() throws Exception {
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.auth-server-url", (String)"http://localhost:8999/auth", (String)this.identityServiceConfig.getAuthServerUrl());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.realm", (String)"alfresco", (String)this.identityServiceConfig.getRealm());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.realm-public-key", (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvWLQxipXNe6cLnVPGy7lBgyR51bDiK7Jso8Rmh2TB+bmO4fNaMY1ETsxECSM0f6NTV0QHks9+gBe+pB6JNeMuPmaE/M/MsE9KUif9L2ChFq3zor6s2foFv2DTiTkij+1aQF9fuIjDNH4FC6L252WydZzh+f73Xuy5evdPj+wrPYqWyP7sKd+4Q9EIILWAuTDvKEjwyZmIyfM/nUn6ltDP6W8xMP0PoEJNAAp79anz2jk2HP2PvC2qdjVsphdTk3JG5qQMB0WJUh4Kjgabd4jQJ77U8gTRswKgNHRRPWhruiIcmmkP+zI0ozNW6rxH3PF4L7M9rXmfcmUcBcKf+YxjwIDAQAB", (String)this.identityServiceConfig.getRealmKey());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.ssl-required", (String)"external", (String)this.identityServiceConfig.getSslRequired());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.resource", (String)"test", (String)this.identityServiceConfig.getResource());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.cors-allowed-headers", (String)AUTHORIZATION_HEADER, (String)this.identityServiceConfig.getCorsAllowedHeaders());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.cors-allowed-methods", (String)"POST, PUT, DELETE, GET", (String)this.identityServiceConfig.getCorsAllowedMethods());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.cors-exposed-headers", (String)"WWW-Authenticate, My-custom-exposed-Header", (String)this.identityServiceConfig.getCorsExposedHeaders());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.truststore", (String)"classpath:/alfresco/subsystems/identityServiceAuthentication/keystore.jks", (String)this.identityServiceConfig.getTruststore());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.truststore-password", (String)"password", (String)this.identityServiceConfig.getTruststorePassword());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.client-keystore", (String)"classpath:/alfresco/subsystems/identityServiceAuthentication/keystore.jks", (String)this.identityServiceConfig.getClientKeystore());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.client-keystore-password", (String)"password", (String)this.identityServiceConfig.getClientKeystorePassword());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.client-key-password", (String)"password", (String)this.identityServiceConfig.getClientKeyPassword());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.token-store", (String)"SESSION", (String)this.identityServiceConfig.getTokenStore());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.principal-attribute", (String)"preferred_username", (String)this.identityServiceConfig.getPrincipalAttribute());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.confidential-port", (int)100, (int)this.identityServiceConfig.getConfidentialPort());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.cors-max-age", (int)1000, (int)this.identityServiceConfig.getCorsMaxAge());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.connection-pool-size", (int)5, (int)this.identityServiceConfig.getConnectionPoolSize());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.register-node-period", (int)50, (int)this.identityServiceConfig.getRegisterNodePeriod());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.token-minimum-time-to-live", (int)10, (int)this.identityServiceConfig.getTokenMinimumTimeToLive());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.min-time-between-jwks-requests", (int)60, (int)this.identityServiceConfig.getMinTimeBetweenJwksRequests());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.public-key-cache-ttl", (int)3600, (int)this.identityServiceConfig.getPublicKeyCacheTtl());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.client-connection-timeout", (int)3000, (int)this.identityServiceConfig.getClientConnectionTimeout());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.client-socket-timeout", (int)1000, (int)this.identityServiceConfig.getClientSocketTimeout());
        IdentityServiceRemoteUserMapperTest.assertFalse((String)"identity-service.public-client", (boolean)this.identityServiceConfig.isPublicClient());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.use-resource-role-mappings", (boolean)this.identityServiceConfig.isUseResourceRoleMappings());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.enable-cors", (boolean)this.identityServiceConfig.isCors());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.expose-token", (boolean)this.identityServiceConfig.isExposeToken());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.bearer-only", (boolean)this.identityServiceConfig.isBearerOnly());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.autodetect-bearer-only", (boolean)this.identityServiceConfig.isAutodetectBearerOnly());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.enable-basic-auth", (boolean)this.identityServiceConfig.isEnableBasicAuth());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.allow-any-hostname", (boolean)this.identityServiceConfig.isAllowAnyHostname());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.disable-trust-manager", (boolean)this.identityServiceConfig.isDisableTrustManager());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.always-refresh-token", (boolean)this.identityServiceConfig.isAlwaysRefreshToken());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.register-node-at-startup", (boolean)this.identityServiceConfig.isRegisterNodeAtStartup());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.enable-pkce", (boolean)this.identityServiceConfig.isPkce());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.ignore-oauth-query-parameter", (boolean)this.identityServiceConfig.isIgnoreOAuthQueryParameter());
        IdentityServiceRemoteUserMapperTest.assertTrue((String)"identity-service.turn-off-change-session-id-on-login", (boolean)this.identityServiceConfig.getTurnOffChangeSessionIdOnLogin());
        Map credentials = this.identityServiceConfig.getCredentials();
        IdentityServiceRemoteUserMapperTest.assertNotNull((String)"Expected a credentials map", (Object)credentials);
        IdentityServiceRemoteUserMapperTest.assertFalse((String)"Expected to retrieve a populated credentials map", (boolean)credentials.isEmpty());
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.credentials.secret", (Object)"11111", credentials.get("secret"));
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"identity-service.credentials.provider", (Object)"secret", credentials.get("provider"));
    }

    public void testValidToken() throws Exception {
        String jwt = this.generateToken(false);
        HttpServletRequest mockRequest = this.createMockTokenRequest(jwt);
        IdentityServiceRemoteUserMapperTest.assertEquals((String)TEST_USER_USERNAME, (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest));
    }

    public void testWrongPublicKey() throws Exception {
        this.childApplicationContextFactory.stop();
        this.applyHardcodedPublicKey(KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic());
        String jwt = this.generateToken(false);
        HttpServletRequest mockRequest = this.createMockTokenRequest(jwt);
        IdentityServiceRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest));
    }

    public void testWrongPublicKeyWithError() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty(CONFIG_SILENT_ERRORS, "false");
        this.applyHardcodedPublicKey(KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic());
        String jwt = this.generateToken(false);
        HttpServletRequest mockRequest = this.createMockTokenRequest(jwt);
        String user = ((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest);
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"Returned user should be null when wrong public key is used.", null, (String)user);
    }

    public void testInvalidJwt() throws Exception {
        HttpServletRequest mockRequest = this.createMockTokenRequest("thisisnotaJWT");
        IdentityServiceRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest));
    }

    public void testMissingToken() throws Exception {
        HttpServletRequest mockRequest = this.createMockTokenRequest("");
        IdentityServiceRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest));
    }

    public void testExpiredToken() throws Exception {
        String jwt = this.generateToken(true);
        HttpServletRequest mockRequest = this.createMockTokenRequest(jwt);
        IdentityServiceRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest));
    }

    public void testExpiredTokenWithError() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty(CONFIG_SILENT_ERRORS, "false");
        this.applyHardcodedPublicKey(this.keyPair.getPublic());
        String jwt = this.generateToken(true);
        HttpServletRequest mockRequest = this.createMockTokenRequest(jwt);
        String user = ((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest);
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"Returned user should be null when the token is expired.", null, (String)user);
    }

    public void testMissingHeader() throws Exception {
        HttpServletRequest mockRequest = this.createMockTokenRequest(null);
        IdentityServiceRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean(REMOTE_USER_MAPPER_BEAN_NAME)).getRemoteUser(mockRequest));
    }

    private HttpServletRequest createMockTokenRequest(String token) {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Vector<String> authHeaderValues = new Vector<String>(1);
        if (token != null) {
            authHeaderValues.add(BEARER_PREFIX + token);
        }
        Mockito.when((Object)mockRequest.getHeaders(AUTHORIZATION_HEADER)).thenReturn(authHeaderValues.elements());
        return mockRequest;
    }

    private HttpServletRequest createMockBasicRequest() {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Vector<String> authHeaderValues = new Vector<String>(1);
        String userPwd = "testuser:testuser";
        authHeaderValues.add(BASIC_PREFIX + Base64.encodeBytes((byte[])userPwd.getBytes()));
        Mockito.when((Object)mockRequest.getHeaders(AUTHORIZATION_HEADER)).thenReturn(authHeaderValues.elements(), (Object[])new Enumeration[]{authHeaderValues.elements()});
        return mockRequest;
    }

    private HttpClient createMockHttpClient() throws Exception {
        HttpClient mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpResponse mockHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine mockStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity mockHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        String token = this.generateToken(false);
        String jsonResponse = String.format(PASSWORD_GRANT_RESPONSE, token, token);
        ByteArrayInputStream jsonResponseStream = new ByteArrayInputStream(jsonResponse.getBytes());
        Mockito.when((Object)mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)mockHttpResponse);
        Mockito.when((Object)mockHttpResponse.getStatusLine()).thenReturn((Object)mockStatusLine);
        Mockito.when((Object)mockHttpResponse.getEntity()).thenReturn((Object)mockHttpEntity);
        Mockito.when((Object)mockStatusLine.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)mockHttpEntity.getContent()).thenReturn((Object)jsonResponseStream);
        return mockHttpClient;
    }

    private String generateToken(boolean expired) throws Exception {
        String issuerUrl = String.valueOf(this.identityServiceConfig.getAuthServerUrl()) + "/realms/" + this.identityServiceConfig.getRealm();
        AccessToken token = new AccessToken();
        token.type("Bearer");
        token.id("1234");
        token.subject("abc123");
        token.issuer(issuerUrl);
        token.setPreferredUsername(TEST_USER_USERNAME);
        token.setEmail(TEST_USER_EMAIL);
        token.setGivenName("Joe");
        token.setFamilyName("Bloggs");
        if (expired) {
            token.expiration(Time.currentTime() - 60);
        }
        String jwt = new JWSBuilder().jsonContent((Object)token).rsa256(this.keyPair.getPrivate());
        return jwt;
    }

    private void applyHardcodedPublicKey(PublicKey publicKey) {
        KeycloakDeployment deployment = (KeycloakDeployment)this.childApplicationContextFactory.getApplicationContext().getBean(DEPLOYMENT_BEAN_NAME);
        HardcodedPublicKeyLocator publicKeyLocator = new HardcodedPublicKeyLocator(publicKey);
        deployment.setPublicKeyLocator((PublicKeyLocator)publicKeyLocator);
    }
}

