/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SystemUsageDataCollector
extends HBBaseDataCollector
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(SystemUsageDataCollector.class);
    private DescriptorDAO currentRepoDescriptorDAO;
    private DataSource dataSource;

    public SystemUsageDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"currentRepoDescriptorDAO", (Object)this.currentRepoDescriptorDAO);
        PropertyCheck.mandatory((Object)this, (String)"dataSource", (Object)this.dataSource);
    }

    @Override
    public List<HBData> collectData() {
        logger.debug((Object)"Preparing repository usage (system) data...");
        Runtime runtime = Runtime.getRuntime();
        HashMap<String, Serializable> systemUsageValues = new HashMap<String, Serializable>();
        HashMap<String, Number> cpu = new HashMap<String, Number>();
        OperatingSystemMXBean osMBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        if (osMBean != null) {
            if (osMBean instanceof UnixOperatingSystemMXBean) {
                long openFileDescriptorCount = ((UnixOperatingSystemMXBean)osMBean).getOpenFileDescriptorCount();
                systemUsageValues.put("openFileDescriptorCount", new Long(openFileDescriptorCount));
            }
            double processCpuLoad = osMBean.getProcessCpuLoad() * 100.0;
            double systemCpuLoad = osMBean.getSystemCpuLoad() * 100.0;
            int intProcessCpuLoad = (int)Math.round(processCpuLoad);
            int intSystemCpuLoad = (int)Math.round(systemCpuLoad);
            cpu.put("percentageProcessLoad", new Integer(intProcessCpuLoad));
            cpu.put("percentageSystemLoad", new Integer(intSystemCpuLoad));
            cpu.put("systemLoadAverage", new Double(osMBean.getSystemLoadAverage()));
        }
        cpu.put("availableProcessors", new Integer(runtime.availableProcessors()));
        systemUsageValues.put("cpu", cpu);
        if (this.dataSource instanceof BasicDataSource) {
            HashMap<String, Integer> db = new HashMap<String, Integer>();
            int idleConnections = ((BasicDataSource)this.dataSource).getNumIdle();
            int activeConnections = ((BasicDataSource)this.dataSource).getNumActive();
            db.put("idleConnections", new Integer(idleConnections));
            db.put("activeConnections", new Integer(activeConnections));
            systemUsageValues.put("db", db);
        }
        HashMap<String, Long> mem = new HashMap<String, Long>();
        mem.put("free", runtime.freeMemory());
        mem.put("max", runtime.maxMemory());
        mem.put("total", runtime.totalMemory());
        systemUsageValues.put("mem", mem);
        HBData systemUsageData = new HBData(this.currentRepoDescriptorDAO.getDescriptor().getId(), this.getCollectorId(), this.getCollectorVersion(), new Date(), systemUsageValues);
        return Arrays.asList(systemUsageData);
    }
}

