/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={NeverRunsTests.class})
public class NodePropertyHelperTest
extends TestCase {
    private static final QName QN_BOOLEAN = NodePropertyHelperTest.createQName("boolean");
    private static final QName QN_INTEGER = NodePropertyHelperTest.createQName("integer");
    private static final QName QN_LONG = NodePropertyHelperTest.createQName("long");
    private static final QName QN_FLOAT = NodePropertyHelperTest.createQName("float");
    private static final QName QN_TEXT = NodePropertyHelperTest.createQName("text");
    private static final QName QN_MLTEXT = NodePropertyHelperTest.createQName("mltext");
    private static final QName QN_REF = NodePropertyHelperTest.createQName("ref");
    private static final QName QN_ANY = NodePropertyHelperTest.createQName("any");
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodePropertyHelper helper;
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;

    private static QName createQName(String localName) {
        return QName.createQName((String)"test", (String)("local-" + localName));
    }

    public void setUp() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        QNameDAO qnameDAO = (QNameDAO)this.ctx.getBean("qnameDAO");
        LocaleDAO localeDAO = (LocaleDAO)this.ctx.getBean("localeDAO");
        ContentDataDAO contentDataDAO = (ContentDataDAO)this.ctx.getBean("contentDataDAO");
        this.helper = new NodePropertyHelper(dictionaryService, qnameDAO, localeDAO, contentDataDAO);
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMinRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(10);
        this.txnHelper.setMaxRetryWaitMs(50);
    }

    private void marshallAndUnmarshall(final Map<QName, Serializable> in, final boolean exact) throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> txnCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String diffReport;
                Map rawProps1 = NodePropertyHelperTest.this.helper.convertToPersistentProperties(in);
                Map props1 = NodePropertyHelperTest.this.helper.convertToPublicProperties(rawProps1);
                if (exact) {
                    diffReport = EqualsHelper.getMapDifferenceReport((Map)props1, (Map)in);
                    NodePropertyHelperTest.assertNull((String)diffReport, (Object)diffReport);
                }
                Map rawProps2 = NodePropertyHelperTest.this.helper.convertToPersistentProperties(in);
                diffReport = EqualsHelper.getMapDifferenceReport((Map)rawProps2, (Map)rawProps1);
                NodePropertyHelperTest.assertNull((String)diffReport, (Object)diffReport);
                Map props2 = NodePropertyHelperTest.this.helper.convertToPublicProperties(rawProps2);
                diffReport = EqualsHelper.getMapDifferenceReport((Map)props2, (Map)props1);
                NodePropertyHelperTest.assertNull((String)diffReport, (Object)diffReport);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)txnCallback);
    }

    public void testNullKnownValues() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(ContentModel.PROP_AUTO_VERSION, null);
        in.put(ContentModel.PROP_HITS, null);
        in.put(ContentModel.PROP_SIZE_CURRENT, null);
        in.put(ContentModel.PROP_RATING_SCORE, null);
        in.put(ContentModel.PROP_NAME, null);
        in.put(ContentModel.PROP_TITLE, null);
        in.put(ContentModel.PROP_REFERENCE, null);
        in.put(VersionModel.PROP_QNAME_VALUE, null);
        this.marshallAndUnmarshall(in, true);
    }

    public void testSimpleKnownValues() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(ContentModel.PROP_AUTO_VERSION, Boolean.TRUE);
        in.put(ContentModel.PROP_HITS, new Integer(1));
        in.put(ContentModel.PROP_SIZE_CURRENT, new Long(2L));
        in.put(ContentModel.PROP_RATING_SCORE, new Float(3.0));
        in.put(ContentModel.PROP_NAME, (Serializable)((Object)"four"));
        in.put(ContentModel.PROP_TITLE, (Serializable)new MLText("five"));
        in.put(ContentModel.PROP_REFERENCE, (Serializable)new NodeRef("protocol://identifier/six"));
        in.put(VersionModel.PROP_QNAME_VALUE, Locale.CANADA);
        this.marshallAndUnmarshall(in, true);
    }

    public void testConvertableKnownValues() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(ContentModel.PROP_AUTO_VERSION, (Serializable)((Object)"TRUE"));
        in.put(ContentModel.PROP_HITS, (Serializable)((Object)"1"));
        in.put(ContentModel.PROP_SIZE_CURRENT, (Serializable)((Object)"2"));
        in.put(ContentModel.PROP_RATING_SCORE, (Serializable)((Object)"3.0"));
        in.put(ContentModel.PROP_NAME, (Serializable)new MLText("four"));
        in.put(ContentModel.PROP_TITLE, (Serializable)((Object)"five"));
        in.put(ContentModel.PROP_REFERENCE, (Serializable)((Object)"protocol://identifier/six"));
        in.put(VersionModel.PROP_QNAME_VALUE, (Serializable)((Object)"en_CA_"));
        this.marshallAndUnmarshall(in, false);
    }

    public void testNullResidualValues() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(QN_TEXT, null);
        this.marshallAndUnmarshall(in, true);
    }

    public void testSimpleResidualValues() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(QN_BOOLEAN, Boolean.TRUE);
        in.put(QN_INTEGER, new Integer(1));
        in.put(QN_LONG, new Long(2L));
        in.put(QN_FLOAT, new Float(3.0));
        in.put(QN_TEXT, (Serializable)((Object)"four"));
        in.put(QN_MLTEXT, (Serializable)new MLText("five"));
        in.put(QN_REF, (Serializable)new NodeRef("protocol://identifier/six"));
        in.put(QN_ANY, Locale.CANADA);
        this.marshallAndUnmarshall(in, true);
    }

    public void testSimpleMultiValue() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(ContentModel.PROP_ADDRESSEES, null);
        this.marshallAndUnmarshall(in, true);
        in.put(ContentModel.PROP_ADDRESSEES, (Serializable)((Object)Arrays.asList(new String[0])));
        this.marshallAndUnmarshall(in, true);
        in.put(ContentModel.PROP_ADDRESSEES, (Serializable)((Object)Arrays.asList("A")));
        this.marshallAndUnmarshall(in, true);
        in.put(ContentModel.PROP_ADDRESSEES, (Serializable)((Object)Arrays.asList("A", "B")));
        this.marshallAndUnmarshall(in, true);
    }

    public void testAnyMultiValue() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(VersionModel.PROP_QNAME_VALUE, null);
        this.marshallAndUnmarshall(in, true);
        in.put(VersionModel.PROP_QNAME_VALUE, (Serializable)((Object)Arrays.asList(new String[0])));
        this.marshallAndUnmarshall(in, true);
        in.put(VersionModel.PROP_QNAME_VALUE, (Serializable)((Object)Arrays.asList("A")));
        this.marshallAndUnmarshall(in, true);
        in.put(VersionModel.PROP_QNAME_VALUE, (Serializable)((Object)Arrays.asList("A", "B")));
        this.marshallAndUnmarshall(in, true);
    }

    public void testResidualMultiValue() throws Throwable {
        HashMap<QName, Serializable> in = new HashMap<QName, Serializable>(17);
        in.put(QN_ANY, null);
        this.marshallAndUnmarshall(in, true);
        in.put(QN_ANY, (Serializable)((Object)Arrays.asList(new String[0])));
        this.marshallAndUnmarshall(in, true);
        in.put(QN_ANY, (Serializable)((Object)Arrays.asList("A")));
        this.marshallAndUnmarshall(in, true);
        in.put(QN_ANY, (Serializable)((Object)Arrays.asList("A", "B")));
        this.marshallAndUnmarshall(in, true);
        ArrayList arrayListVal = new ArrayList(2);
        HashSet hashSetVal = new HashSet(2);
        in.put(QN_ANY, (Serializable)((Object)Arrays.asList(arrayListVal, hashSetVal)));
        this.marshallAndUnmarshall(in, true);
    }
}

