/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.InvitationServiceImpl;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.processor.TemplateServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionUserError;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.email.ExtendedMailActionExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.annotation.Commit;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Transactional
public abstract class AbstractInvitationServiceImplTest
extends BaseAlfrescoSpringTest {
    private static final String TEST_REJECT_URL = "testRejectUrl";
    private static final String TEST_ACCEPT_URL = "testAcceptUrl";
    private static final String TEST_SERVER_PATH = "testServerPath";
    private static final Log logger = LogFactory.getLog(AbstractInvitationServiceImplTest.class);
    private SiteService siteService;
    private PersonService personService;
    protected InvitationService invitationService;
    private MailActionExecuter mailService;
    private boolean startSendEmails;
    protected InvitationServiceImpl invitationServiceImpl;
    protected WorkflowAdminServiceImpl workflowAdminService;
    private TemplateService templateService;
    protected static final String SITE_SHORT_NAME_INVITE = "InvitationTest";
    protected static final String SITE_SHORT_NAME_RED = "InvitationTestRed";
    protected static final String SITE_SHORT_NAME_BLUE = "InvitationTestBlue";
    public static final String PERSON_FIRSTNAME = "InvitationFirstName123";
    public static final String PERSON_FIRSTNAME_SPACES = "Invitation First\tName\n1\r2\r\n3";
    public static final String PERSON_LASTNAME = "InvitationLastName123";
    public static final String PERSON_LASTNAME_SPACES = "Invitation Last\tName\n1\r2\r\n3";
    public static final String PERSON_JOBTITLE = "JobTitle123";
    public static final String PERSON_ORG = "Organisation123";
    public static final String USER_MANAGER = "InvitationServiceManagerOne";
    public static final String USER_ONE = "InvitationServiceAlice";
    public static final String USER_TWO = "InvitationServiceBob";
    public static final String USER_EVE = "InvitationServiceEve";
    public static final String USER_NOEMAIL = "InvitationServiceNoEmail";
    public static final String USER_ONE_FIRSTNAME = "One";
    public static final String USER_ONE_LASTNAME = "Test";
    public static final String USER_ONE_EMAIL = "InvitationServiceAlice@alfrescotesting.com";
    public static final String USER_TWO_EMAIL = "InvitationServiceBob@alfrescotesting.com";
    private Collection<String> enabledEngines;
    private Collection<String> visibleEngines;

    @Override
    @Before
    public void before() throws Exception {
        SiteInfo siteInfoBlue;
        SiteInfo siteInfoRed;
        super.before();
        this.invitationService = (InvitationService)this.applicationContext.getBean("InvitationService");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.invitationServiceImpl = (InvitationServiceImpl)this.applicationContext.getBean("invitationService");
        this.workflowAdminService = (WorkflowAdminServiceImpl)this.applicationContext.getBean("workflowAdminService");
        this.templateService = (TemplateServiceImpl)this.applicationContext.getBean("templateService");
        this.startSendEmails = this.invitationServiceImpl.isSendEmails();
        this.enabledEngines = this.workflowAdminService.getEnabledEngines();
        this.visibleEngines = this.workflowAdminService.getVisibleEngines();
        this.invitationServiceImpl.setSendEmails(true);
        this.mailService = (MailActionExecuter)((ApplicationContextFactory)this.applicationContext.getBean("OutboundSMTP")).getApplicationContext().getBean("mail");
        this.mailService.setTestMode(true);
        this.createPerson(USER_MANAGER, "InvitationServiceManagerOne@alfrescotesting.com", PERSON_FIRSTNAME, PERSON_LASTNAME);
        this.createPerson(USER_ONE, USER_ONE_EMAIL, USER_ONE_FIRSTNAME, USER_ONE_LASTNAME);
        this.createPerson(USER_TWO, USER_TWO_EMAIL, PERSON_FIRSTNAME, PERSON_LASTNAME);
        this.createPerson(USER_EVE, "InvitationServiceEve@alfrescotesting.com", PERSON_FIRSTNAME, PERSON_LASTNAME);
        this.createPerson(USER_NOEMAIL, null, USER_NOEMAIL, USER_NOEMAIL);
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_INVITE);
        if (siteInfo == null) {
            siteInfo = this.siteService.createSite("InviteSitePreset", SITE_SHORT_NAME_INVITE, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
            this.siteService.setMembership(SITE_SHORT_NAME_INVITE, USER_NOEMAIL, "SiteManager");
        }
        if ((siteInfoRed = this.siteService.getSite(SITE_SHORT_NAME_RED)) == null) {
            this.siteService.createSite("InviteSiteRed", SITE_SHORT_NAME_RED, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
        }
        if ((siteInfoBlue = this.siteService.getSite(SITE_SHORT_NAME_BLUE)) == null) {
            this.siteService.createSite("InviteSiteBlue", SITE_SHORT_NAME_BLUE, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
        }
    }

    @Override
    @After
    public void after() throws Exception {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.workflowAdminService.setEnabledEngines(this.enabledEngines);
        this.workflowAdminService.setVisibleEngines(this.visibleEngines);
        super.after();
    }

    @Test
    public void testConfiguration() {
        AbstractInvitationServiceImplTest.assertNotNull((String)"Invitation service is null", (Object)this.invitationService);
    }

    @Test
    public void testInternalUserNotDeletedAfterInviteCancelled() throws Exception {
        boolean enabled = this.authenticationService.getAuthenticationEnabled(USER_ONE);
        AbstractInvitationServiceImplTest.assertTrue((String)"User One authentication disabled", (boolean)enabled);
        this.authenticationService.setAuthenticationEnabled(USER_ONE, false);
        enabled = this.authenticationService.getAuthenticationEnabled(USER_ONE);
        AbstractInvitationServiceImplTest.assertTrue((String)"User One authentication enabled", (!enabled ? 1 : 0) != 0);
        String inviteeUserName = USER_ONE;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        try {
            this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, acceptUrl, rejectUrl);
            AbstractInvitationServiceImplTest.fail((String)("An exception of type " + InvitationExceptionUserError.class.getName() + " should be thrown"));
        }
        catch (Exception ex) {
            AbstractInvitationServiceImplTest.assertTrue((String)"Incorrect exception was thrown", (boolean)(ex instanceof InvitationExceptionUserError));
        }
        AbstractInvitationServiceImplTest.assertNotNull((String)"User Exists", (Object)this.personService.getPersonOrNull(USER_ONE));
        AbstractInvitationServiceImplTest.assertTrue((String)"Authentication Exists", (boolean)this.authenticationService.authenticationExists(USER_ONE));
    }

    @Test
    public void testExternalUserDeletedAfterInviteCancelled() throws Exception {
        String inviteeFirstName = PERSON_FIRSTNAME;
        String inviteeLastName = PERSON_LASTNAME;
        String inviteeEmail = "123@alfrescotesting.com";
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        String inviteeUsername = nominatedInvitation.getInviteeUserName();
        this.invitationService.cancel(nominatedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertNull((String)"Person deleted", (Object)this.personService.getPersonOrNull(inviteeUsername));
        AbstractInvitationServiceImplTest.assertFalse((String)"Authentication deleted", (boolean)this.authenticationService.authenticationExists(inviteeUsername));
    }

    @Test
    public void testNominatedInvitationNewUser() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1);
        Date startDate = calendar.getTime();
        String inviteeFirstName = PERSON_FIRSTNAME;
        String inviteeLastName = PERSON_LASTNAME;
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeUserName = null;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        String inviteId = nominatedInvitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitation.getInviteeEmail());
        inviteeUserName = nominatedInvitation.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeUserName);
        Date sentDate = nominatedInvitation.getSentInviteDate();
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too early. Start Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.after(startDate));
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too lateStart Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.before(new Date(new Date().getTime() + 1L)));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)nominatedInvitation.getResourceType());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)nominatedInvitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)nominatedInvitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)nominatedInvitation.getServerPath());
        AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)nominatedInvitation.getAcceptUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)nominatedInvitation.getRejectUrl());
        NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertNotNull((String)"invitation is null", (Object)invitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)invitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)invitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)invitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)invitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)invitation.getResourceType());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)invitation.getServerPath());
        AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)invitation.getAcceptUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)invitation.getRejectUrl());
        Date sentDate2 = invitation.getSentInviteDate();
        AbstractInvitationServiceImplTest.assertTrue((String)"sentDate wrong too early", (boolean)sentDate2.after(startDate));
        AbstractInvitationServiceImplTest.assertTrue((String)"sentDate wrong - too late", (boolean)sentDate2.before(new Date(new Date().getTime() + 1L)));
        MimeMessage msg = this.mailService.retrieveLastTestMessage();
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg.getAllRecipients().length);
        AbstractInvitationServiceImplTest.assertEquals((String)inviteeEmail, (String)msg.getAllRecipients()[0].toString());
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg.getFrom().length);
        AbstractInvitationServiceImplTest.assertEquals((String)"InvitationServiceManagerOne@alfrescotesting.com", (String)msg.getFrom()[0].toString());
        AbstractInvitationServiceImplTest.assertNull((String)"Not been sent yet", (Object)msg.getSentDate());
        AbstractInvitationServiceImplTest.assertNull((String)"Not been sent yet", (Object)msg.getReceivedDate());
        AbstractInvitationServiceImplTest.assertTrue((msg.getSubject().indexOf("You have been invited to join the") != -1 ? 1 : 0) != 0);
        List invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
        NominatedInvitation firstInvite = (NominatedInvitation)invitations.get(0);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)firstInvite.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)firstInvite.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)firstInvite.getInviteeUserName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)inviteeUserName);
        NominatedInvitation acceptedInvitation = (NominatedInvitation)this.invitationService.accept(firstInvite.getInviteId(), firstInvite.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)firstInvite.getInviteId(), (String)acceptedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)acceptedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)acceptedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)acceptedInvitation.getInviteeUserName());
        List it4 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it4.isEmpty());
        NominatedInvitation acceptedInvitation2 = (NominatedInvitation)this.invitationService.getInvitation(firstInvite.getInviteId());
        AbstractInvitationServiceImplTest.assertNotNull((String)"get after accept does not return", (Object)acceptedInvitation2);
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleName, (String)inviteeRole);
        this.siteService.removeMembership(resourceName, inviteeUserName);
        Field faf = this.mailService instanceof ExtendedMailActionExecutor ? this.mailService.getClass().getSuperclass().getDeclaredField("fromDefaultAddress") : this.mailService.getClass().getDeclaredField("fromDefaultAddress");
        faf.setAccessible(true);
        String defaultFromAddress = (String)ReflectionUtils.getField((Field)faf, (Object)this.mailService);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NOEMAIL);
        NominatedInvitation nominatedInvitation2 = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, USER_TWO_EMAIL, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation2);
        inviteId = nominatedInvitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation2.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation2.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)USER_TWO_EMAIL, (String)nominatedInvitation2.getInviteeEmail());
        MimeMessage msg2 = this.mailService.retrieveLastTestMessage();
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg2.getAllRecipients().length);
        AbstractInvitationServiceImplTest.assertEquals((String)USER_TWO_EMAIL, (String)msg2.getAllRecipients()[0].toString());
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg2.getFrom().length);
        AbstractInvitationServiceImplTest.assertEquals((String)defaultFromAddress, (String)msg2.getFrom()[0].toString());
    }

    @Test
    public void testNominatedInvitationNewUserReject() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1);
        Date startDate = calendar.getTime();
        String inviteeFirstName = PERSON_FIRSTNAME;
        String inviteeLastName = PERSON_LASTNAME;
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeUserName = null;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitation.getInviteeEmail());
        inviteeUserName = nominatedInvitation.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeUserName);
        Date sentDate = nominatedInvitation.getSentInviteDate();
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too earlyStart Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.after(startDate));
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too lateStart Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.before(new Date(new Date().getTime() + 1L)));
        NominatedInvitation rejectedInvitation = (NominatedInvitation)this.invitationService.reject(nominatedInvitation.getInviteId(), "dont want it");
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)nominatedInvitation.getInviteId(), (String)rejectedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)rejectedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)rejectedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)rejectedInvitation.getInviteeUserName());
        List it4 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it4.isEmpty());
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        if (roleName != null) {
            AbstractInvitationServiceImplTest.fail((String)"role has been set for a rejected user");
        }
        if (this.personService.personExists(inviteeUserName)) {
            AbstractInvitationServiceImplTest.fail((String)"generated user has not been cleaned up");
        }
    }

    @Test
    public void testNominatedInvitationNewUserSameEmails() throws Exception {
        String inviteeAFirstName = "John";
        String inviteeALastName = "Smith";
        String inviteeBFirstName = "Jane";
        String inviteeBLastName = "Smith";
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeAUserName = null;
        String inviteeBUserName = null;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitationA = this.invitationService.inviteNominated(inviteeAFirstName, inviteeALastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitationA);
        String inviteAId = nominatedInvitationA.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeAFirstName, (String)nominatedInvitationA.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeALastName, (String)nominatedInvitationA.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitationA.getInviteeEmail());
        inviteeAUserName = nominatedInvitationA.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeAUserName);
        NominatedInvitation nominatedInvitationB = this.invitationService.inviteNominated(inviteeBFirstName, inviteeBLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitationB);
        String inviteBId = nominatedInvitationB.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeBFirstName, (String)nominatedInvitationB.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeBLastName, (String)nominatedInvitationB.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitationB.getInviteeEmail());
        inviteeBUserName = nominatedInvitationB.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeBUserName);
        AbstractInvitationServiceImplTest.assertFalse((String)"generated user names are the same", (boolean)inviteeAUserName.equals(inviteeBUserName));
        AuthenticationUtil.setFullyAuthenticatedUser((String)nominatedInvitationA.getInviteeUserName());
        NominatedInvitation acceptedInvitationA = (NominatedInvitation)this.invitationService.accept(inviteAId, nominatedInvitationA.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteAId, (String)acceptedInvitationA.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeAFirstName, (String)acceptedInvitationA.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeALastName, (String)acceptedInvitationA.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeAUserName, (String)acceptedInvitationA.getInviteeUserName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)nominatedInvitationB.getInviteeUserName());
        NominatedInvitation acceptedInvitationB = (NominatedInvitation)this.invitationService.accept(inviteBId, nominatedInvitationB.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteBId, (String)acceptedInvitationB.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeBFirstName, (String)acceptedInvitationB.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeBLastName, (String)acceptedInvitationB.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeBUserName, (String)acceptedInvitationB.getInviteeUserName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_MANAGER);
        String roleNameA = this.siteService.getMembersRole(resourceName, inviteeAUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleNameA, (String)inviteeRole);
        String roleNameB = this.siteService.getMembersRole(resourceName, inviteeBUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleNameB, (String)inviteeRole);
        this.siteService.removeMembership(resourceName, inviteeAUserName);
        this.siteService.removeMembership(resourceName, inviteeBUserName);
    }

    @Test
    public void testMNT11775() throws Exception {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String invitationId = invitation.getInviteId();
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.reject(invitationId, "Go away!");
        try {
            this.invitationService.approve(invitationId, "Have I not rejected this?");
            AbstractInvitationServiceImplTest.fail((String)"rejected invitation not working");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        try {
            HashMap<String, String> model = new HashMap<String, String>(8, 1.0f);
            model.put("resourceName", resourceName);
            model.put("resourceType", (String)resourceType);
            model.put("inviteeRole", inviteeRole);
            model.put("reviewComments", "Go away!");
            model.put("inviteeUserName", inviteeUserName);
            String emailMsg = this.templateService.processTemplate("freemarker", "/alfresco/bootstrap/invite/moderated-reject-email.ftl", model);
            AbstractInvitationServiceImplTest.assertNotNull((String)"Email message is null", (Object)emailMsg);
            AbstractInvitationServiceImplTest.assertTrue((String)"Email message doesn't contain review comment", (boolean)emailMsg.contains("Go away!"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.toString());
            AbstractInvitationServiceImplTest.fail((String)"Process email message template exception");
        }
    }

    @Test
    public void test_MNT15614() throws Exception {
        String[] siteNames = new String[]{"it", "site", "GROUP"};
        String inviteeUserName = USER_ONE;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String inviteeRole = "SiteCollaborator";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String[] stringArray = siteNames;
        int n = siteNames.length;
        int n2 = 0;
        while (n2 < n) {
            String siteName = stringArray[n2];
            SiteInfo siteInfoRed = this.siteService.getSite(siteName);
            if (siteInfoRed == null) {
                this.siteService.createSite("InviteSitePreset", siteName, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
            }
            AbstractInvitationServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(siteName, AuthenticationUtil.getAdminUserName()));
            NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeUserName, resourceType, siteName, inviteeRole, acceptUrl, rejectUrl);
            AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
            ++n2;
        }
    }

    @Test
    public void testNominatedInvitationNewUserWhitespace() throws Exception {
        String inviteeFirstName = PERSON_FIRSTNAME_SPACES;
        String inviteeLastName = PERSON_LASTNAME_SPACES;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeEmail = "123@alfrescotesting.com";
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        String expectedUserName = (String.valueOf(inviteeFirstName) + "_" + inviteeLastName).toLowerCase();
        expectedUserName = expectedUserName.replaceAll("\\s+", "_");
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"Wrong username!", (String)expectedUserName, (String)nominatedInvitation.getInviteeUserName());
        String inviteId = nominatedInvitation.getInviteId();
        NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertNotNull((String)"invitation is null", (Object)invitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)invitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)invitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)expectedUserName, (String)invitation.getInviteeUserName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)invitation.getInviteeUserName());
        NominatedInvitation acceptedInvitation = (NominatedInvitation)this.invitationService.accept(invitation.getInviteId(), invitation.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)acceptedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)acceptedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)expectedUserName, (String)acceptedInvitation.getInviteeUserName());
        String roleName = this.siteService.getMembersRole(resourceName, expectedUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleName, (String)inviteeRole);
        this.siteService.removeMembership(resourceName, expectedUserName);
    }

    protected void testNominatedInvitationExistingUser(boolean requireAcceptance) throws Exception {
        String inviteeUserName = USER_ONE;
        String inviteeEmail = USER_ONE_EMAIL;
        String inviteeFirstName = USER_ONE_FIRSTNAME;
        String inviteeLastName = USER_ONE_LASTNAME;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        if (requireAcceptance) {
            NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
            AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
            String inviteId = nominatedInvitation.getInviteId();
            AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)nominatedInvitation.getInviteeUserName());
            AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)nominatedInvitation.getResourceType());
            AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)nominatedInvitation.getResourceName());
            AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)nominatedInvitation.getRoleName());
            AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)nominatedInvitation.getServerPath());
            AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)nominatedInvitation.getAcceptUrl());
            AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)nominatedInvitation.getRejectUrl());
            AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation.getInviteeFirstName());
            AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation.getInviteeLastName());
            AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitation.getInviteeEmail());
            NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
            AbstractInvitationServiceImplTest.assertNotNull((String)"invitation is null", (Object)invitation);
            AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)invitation.getInviteId());
            AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)nominatedInvitation.getInviteeUserName());
            AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)invitation.getResourceType());
            AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
            AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
            AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)invitation.getServerPath());
            AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)invitation.getAcceptUrl());
            AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)invitation.getRejectUrl());
            AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)invitation.getInviteeFirstName());
            AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)invitation.getInviteeLastName());
            AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)invitation.getInviteeEmail());
            List invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
            AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
            NominatedInvitation firstInvite = (NominatedInvitation)invitations.get(0);
            AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
            AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)firstInvite.getInviteeFirstName());
            AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)firstInvite.getInviteeLastName());
            AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)firstInvite.getInviteeUserName());
            NominatedInvitation canceledInvitation = (NominatedInvitation)this.invitationService.cancel(inviteId);
            AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)canceledInvitation.getInviteId());
            AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)canceledInvitation.getInviteeFirstName());
            AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)canceledInvitation.getInviteeLastName());
            AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)canceledInvitation.getInviteeUserName());
            List it2 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
            AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it2.isEmpty());
            NominatedInvitation secondInvite = this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
            NominatedInvitation rejectedInvitation = (NominatedInvitation)this.invitationService.cancel(secondInvite.getInviteId());
            AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)secondInvite.getInviteId(), (String)rejectedInvitation.getInviteId());
            AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)rejectedInvitation.getInviteeUserName());
            List it3 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
            AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it3.isEmpty());
        }
        NominatedInvitation thirdInvite = this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        if (requireAcceptance) {
            NominatedInvitation acceptedInvitation = (NominatedInvitation)this.invitationService.accept(thirdInvite.getInviteId(), thirdInvite.getTicket());
            AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)thirdInvite.getInviteId(), (String)acceptedInvitation.getInviteId());
            AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)acceptedInvitation.getInviteeFirstName());
            AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)acceptedInvitation.getInviteeLastName());
            AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)acceptedInvitation.getInviteeUserName());
        }
        List it4 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it4.isEmpty());
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    @Test
    public void testNominatedInvitationExistingUser() throws Exception {
        this.invitationServiceImpl.setNominatedInvitationWorkflowId("activiti$activitiInvitationNominated");
        this.testNominatedInvitationExistingUser(true);
    }

    @Test
    public void testModeratedInvitation() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        AbstractInvitationServiceImplTest.assertNotNull((String)"moderated invitation is null", (Object)invitation);
        String inviteId = invitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)invitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments", (String)comments, (String)invitation.getInviteeComments());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)invitation.getResourceType());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
        ModeratedInvitation mi2 = (ModeratedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id", (String)inviteId, (String)mi2.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)mi2.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)mi2.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments", (String)comments, (String)mi2.getInviteeComments());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)mi2.getResourceType());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)mi2.getResourceName());
        List invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
        ModeratedInvitation firstInvite = (ModeratedInvitation)invitations.get(0);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
        ModeratedInvitation canceledInvitation = (ModeratedInvitation)this.invitationService.cancel(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)canceledInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments wrong", (String)comments, (String)canceledInvitation.getInviteeComments());
        List inv2 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"After cancel invitations is not empty", (boolean)inv2.isEmpty());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invite2 = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String secondInvite = invite2.getInviteId();
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.reject(secondInvite, "This is a test reject");
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invite3 = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String thirdInvite = invite3.getInviteId();
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.approve(thirdInvite, "Welcome in");
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    @Test
    public void testWorkspaceModeratedInvitation() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole, "workspace");
        AbstractInvitationServiceImplTest.assertNotNull((String)"moderated invitation is null", (Object)invitation);
        String inviteId = invitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)invitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments", (String)comments, (String)invitation.getInviteeComments());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)invitation.getResourceType());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"client name wrong", (String)"workspace", (String)invitation.getClientName());
        ModeratedInvitation mi2 = (ModeratedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id", (String)inviteId, (String)mi2.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)mi2.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)mi2.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments", (String)comments, (String)mi2.getInviteeComments());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)resourceType, (Object)mi2.getResourceType());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)mi2.getResourceName());
        List invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
        ModeratedInvitation firstInvite = (ModeratedInvitation)invitations.get(0);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
        ModeratedInvitation canceledInvitation = (ModeratedInvitation)this.invitationService.cancel(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)canceledInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments wrong", (String)comments, (String)canceledInvitation.getInviteeComments());
        List inv2 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"After cancel invitations is not empty", (boolean)inv2.isEmpty());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invite3 = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        AbstractInvitationServiceImplTest.assertEquals((String)"client name wrong", null, (String)invite3.getClientName());
        String thirdInvite = invite3.getInviteId();
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.approve(thirdInvite, "Welcome in");
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    @Test
    public void testModeratedApprove() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String invitationId = invitation.getInviteId();
        try {
            this.invitationService.approve(invitationId, "No Way Hosea!");
            AbstractInvitationServiceImplTest.fail((String)"excetion not thrown");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.approve(invitationId, "Come on in");
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        try {
            this.invitationService.approve(invitationId, "Have I not already done this?");
            AbstractInvitationServiceImplTest.fail((String)"duplicate approve excetion not thrown");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    @Test
    public void testModeratedReject() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String invitationId = invitation.getInviteId();
        try {
            this.invitationService.reject(invitationId, "No Way Hosea!");
            AbstractInvitationServiceImplTest.fail((String)"excetion not thrown");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.reject(invitationId, "Go away!");
        try {
            this.invitationService.approve(invitationId, "Have I not rejected this?");
            AbstractInvitationServiceImplTest.fail((String)"rejected invitation not working");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
    }

    @Test
    public void testSearchInvitation() {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.inviteModerated(comments, USER_ONE, resourceType, SITE_SHORT_NAME_RED, inviteeRole);
        this.invitationService.inviteNominated(USER_ONE, resourceType, SITE_SHORT_NAME_RED, inviteeRole, serverPath, acceptUrl, rejectUrl);
        NominatedInvitation invitationThree = this.invitationService.inviteNominated(USER_ONE, resourceType, SITE_SHORT_NAME_BLUE, inviteeRole, serverPath, acceptUrl, rejectUrl);
        invitationThree.getInviteId();
        this.invitationService.inviteModerated(comments, USER_TWO, resourceType, SITE_SHORT_NAME_RED, inviteeRole);
        List resOne = this.invitationService.listPendingInvitationsForResource(Invitation.ResourceType.WEB_SITE, SITE_SHORT_NAME_BLUE);
        AbstractInvitationServiceImplTest.assertEquals((String)"blue invites not 0", (int)0, (int)resOne.size());
        List resTwo = this.invitationService.listPendingInvitationsForResource(Invitation.ResourceType.WEB_SITE, SITE_SHORT_NAME_RED);
        AbstractInvitationServiceImplTest.assertEquals((String)"red invites not 2", (int)2, (int)resTwo.size());
        List resThree = this.invitationService.listPendingInvitationsForInvitee(USER_ONE);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one does not have 1 invitations", (int)1, (int)resThree.size());
        List resFour = this.invitationService.listPendingInvitationsForInvitee(USER_TWO);
        AbstractInvitationServiceImplTest.assertEquals((String)"user two does not have 1 invitations", (int)1, (int)resFour.size());
        InvitationSearchCriteriaImpl crit1 = new InvitationSearchCriteriaImpl();
        crit1.setInvitee(USER_ONE);
        crit1.setInvitationType(InvitationSearchCriteria.InvitationType.NOMINATED);
        List resFive = this.invitationService.searchInvitation((InvitationSearchCriteria)crit1);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one should not have any nominated invites", (int)0, (int)resFive.size());
        List limitRes = this.invitationService.searchInvitation((InvitationSearchCriteria)crit1, 1);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one should not have any nominated invites", (int)0, (int)limitRes.size());
        InvitationSearchCriteriaImpl crit2 = new InvitationSearchCriteriaImpl();
        List searchInvitation = this.invitationService.searchInvitation((InvitationSearchCriteria)crit2);
        AbstractInvitationServiceImplTest.assertTrue((String)"2 moderated invitations should be found", (searchInvitation.size() == 2 ? 1 : 0) != 0);
        searchInvitation = this.invitationService.searchInvitation((InvitationSearchCriteria)crit2, 2);
        AbstractInvitationServiceImplTest.assertTrue((String)"search everything returned 0 or more than 2 elements", (searchInvitation.size() > 0 && searchInvitation.size() <= 2 ? 1 : 0) != 0);
        InvitationSearchCriteriaImpl crit3 = new InvitationSearchCriteriaImpl();
        crit3.setInviter(USER_MANAGER);
        crit3.setInvitationType(InvitationSearchCriteria.InvitationType.NOMINATED);
        List res3 = this.invitationService.searchInvitation((InvitationSearchCriteria)crit3);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one should not have any nominated invites", (int)0, (int)res3.size());
        res3 = this.invitationService.searchInvitation((InvitationSearchCriteria)crit3, 1);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one should not have any nominated invites", (int)0, (int)res3.size());
    }

    @Test
    public void testSearchInvitationWithLimit() throws Exception {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        int i = 0;
        while (i < 10) {
            this.invitationService.inviteNominated(USER_ONE, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
            ++i;
        }
        NominatedInvitation inviteForUserTwo = this.invitationService.inviteNominated(USER_TWO, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        InvitationSearchCriteriaImpl query = new InvitationSearchCriteriaImpl();
        query.setInvitee(USER_TWO);
        List results = this.invitationService.searchInvitation((InvitationSearchCriteria)query, 0);
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)results.size());
        AbstractInvitationServiceImplTest.assertEquals((String)inviteForUserTwo.getInviteId(), (String)((Invitation)results.get(0)).getInviteId());
        query = new InvitationSearchCriteriaImpl();
        query.setInvitee(USER_ONE);
        results = this.invitationService.searchInvitation((InvitationSearchCriteria)query, 3);
        AbstractInvitationServiceImplTest.assertEquals((int)3, (int)results.size());
    }

    @Test
    public void testExternalUserManagerInvitingAnotherExternalUser() throws Exception {
        String inviteeFirstName = PERSON_FIRSTNAME;
        String inviteeLastName = PERSON_LASTNAME;
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeFirstName2 = "user2name";
        String inviteeLastName2 = "user2lastname";
        String inviteeEmail2 = "1234@alfrescotesting.com";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, Invitation.ResourceType.WEB_SITE, SITE_SHORT_NAME_INVITE, "SiteManager", TEST_SERVER_PATH, TEST_ACCEPT_URL, TEST_REJECT_URL);
        AuthenticationUtil.setFullyAuthenticatedUser((String)nominatedInvitation.getInviteeUserName());
        this.invitationService.accept(nominatedInvitation.getInviteId(), nominatedInvitation.getTicket());
        NominatedInvitation nominatedInvitation2 = this.invitationService.inviteNominated(inviteeFirstName2, inviteeLastName2, inviteeEmail2, Invitation.ResourceType.WEB_SITE, SITE_SHORT_NAME_INVITE, "SiteCollaborator", TEST_SERVER_PATH, TEST_ACCEPT_URL, TEST_REJECT_URL);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation2);
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName2, (String)nominatedInvitation2.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName2, (String)nominatedInvitation2.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail2, (String)nominatedInvitation2.getInviteeEmail());
        AuthenticationUtil.setFullyAuthenticatedUser((String)nominatedInvitation2.getInviteeUserName());
        NodeRef person = this.personService.getPersonOrNull(nominatedInvitation2.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertTrue((String)"user has not been created", (person != null ? 1 : 0) != 0);
        AbstractInvitationServiceImplTest.assertTrue((String)"user should have the ASPECT_ANULLABLE aspect since the invitation hasn't been accepted yet", (boolean)this.nodeService.hasAspect(person, ContentModel.ASPECT_ANULLABLE));
        Invitation acceptedNominatedInvitation2 = this.invitationService.accept(nominatedInvitation2.getInviteId(), nominatedInvitation2.getTicket());
        AbstractInvitationServiceImplTest.assertNotNull((String)"accepted nominated invitation is null", (Object)acceptedNominatedInvitation2);
        AbstractInvitationServiceImplTest.assertEquals((String)"role is wrong", (String)"SiteCollaborator", (String)acceptedNominatedInvitation2.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)(String.valueOf(inviteeFirstName2) + "_" + inviteeLastName2), (String)acceptedNominatedInvitation2.getInviteeUserName());
        person = this.personService.getPersonOrNull(acceptedNominatedInvitation2.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertTrue((String)"user has not been created", (person != null ? 1 : 0) != 0);
        AbstractInvitationServiceImplTest.assertTrue((String)"user should not have the ASPECT_ANULLABLE aspect anymore", (!this.nodeService.hasAspect(person, ContentModel.ASPECT_ANULLABLE) ? 1 : 0) != 0);
        Invitation invitation = this.invitationService.getInvitation(acceptedNominatedInvitation2.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"invited user name is wrong", (String)invitation.getInviteeUserName(), (String)acceptedNominatedInvitation2.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id is wrong", (String)invitation.getInviteId(), (String)acceptedNominatedInvitation2.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite resource name is wrong", (String)invitation.getResourceName(), (String)acceptedNominatedInvitation2.getResourceName());
    }

    @Ignore
    @Test
    @Commit
    public void disabled_test100Invites() throws Exception {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        int i = 0;
        while (i < 1000) {
            this.invitationService.inviteNominated(USER_ONE, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
            ++i;
        }
        NominatedInvitation invite = this.invitationService.inviteNominated(USER_TWO, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        InvitationSearchCriteriaImpl query = new InvitationSearchCriteriaImpl();
        query.setInvitee(USER_TWO);
        long start = System.currentTimeMillis();
        List results = this.invitationService.searchInvitation((InvitationSearchCriteria)query);
        long end = System.currentTimeMillis();
        System.out.println("Invitation Search took " + (end - start) + "ms.");
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)results.size());
        AbstractInvitationServiceImplTest.assertEquals((String)invite.getInviteId(), (String)((Invitation)results.get(0)).getInviteId());
    }

    @Test
    public void testGetInvitation() {
        try {
            this.invitationService.getInvitation("activiti$99999999");
            AbstractInvitationServiceImplTest.fail((String)"should have thrown an exception");
        }
        catch (Exception exception) {}
    }

    private void createPerson(String userName, String emailAddress, String firstName, String lastName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)firstName);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)lastName);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)emailAddress);
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)PERSON_JOBTITLE);
            personProps.put((Object)ContentModel.PROP_ORGANIZATION, (Object)PERSON_ORG);
            this.personService.createPerson((Map)personProps);
        }
    }

    private void deletePersonByUserName(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }
}

