/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFileProps {
    private static final String CONTENT_URL = "contentUrl";
    private static final String DELETE_WATCH_COUNT = "deleteWatchCount";
    private static final Log log = LogFactory.getLog(CacheFileProps.class);
    private final Properties properties = new Properties();
    private final File cacheFile;
    private final File propsFile;

    public CacheFileProps(File cacheFile) {
        this.cacheFile = cacheFile;
        this.propsFile = this.fileForCacheFile();
    }

    public void load() {
        this.properties.clear();
        if (this.propsFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.propsFile));
                this.properties.load(reader);
                reader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error((Object)("File disappeared after exists() check: " + this.cacheFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read properties file " + this.cacheFile, e);
            }
        }
    }

    public void store() {
        block13: {
            FilterOutputStream out = null;
            try {
                try {
                    out = new BufferedOutputStream(new FileOutputStream(this.propsFile));
                    this.properties.store(out, "Properties for " + this.cacheFile);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Couldn't create output stream for file: " + this.propsFile, e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't write file: " + this.propsFile, e);
                }
            }
            catch (Throwable throwable) {
                block12: {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!log.isErrorEnabled()) break block12;
                        log.error((Object)("Couldn't close file: " + this.propsFile));
                    }
                }
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                if (!log.isErrorEnabled()) break block13;
                log.error((Object)("Couldn't close file: " + this.propsFile));
            }
        }
    }

    public void delete() {
        this.propsFile.delete();
    }

    public boolean exists() {
        return this.propsFile.exists();
    }

    public long fileSize() {
        return this.propsFile.length();
    }

    public void setContentUrl(String url) {
        this.properties.setProperty(CONTENT_URL, url);
    }

    public String getContentUrl() {
        return this.properties.getProperty(CONTENT_URL);
    }

    public void setDeleteWatchCount(Integer watchCount) {
        this.properties.setProperty(DELETE_WATCH_COUNT, watchCount.toString());
    }

    public Integer getDeleteWatchCount() {
        String watchCountStr = this.properties.getProperty(DELETE_WATCH_COUNT, "0");
        return Integer.parseInt(watchCountStr);
    }

    private File fileForCacheFile() {
        return new File(String.valueOf(this.cacheFile.getAbsolutePath()) + ".properties");
    }
}

