/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.transform.AbstractLocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.transform.client.model.config.SupportedSourceAndTarget;
import org.alfresco.transform.client.model.config.TransformOption;
import org.alfresco.transform.client.model.config.Transformer;

public class LocalPassThroughTransform
extends AbstractLocalTransform {
    public static final String NAME = "PassThrough";

    public LocalPassThroughTransform(String name, TransformerDebug transformerDebug, MimetypeService mimetypeService, boolean strictMimeTypeCheck, Map<String, Set<String>> strictMimetypeExceptions, boolean retryTransformOnDifferentMimeType, Set<TransformOption> transformsTransformOptions, LocalTransformServiceRegistry localTransformServiceRegistry) {
        super(name, transformerDebug, mimetypeService, strictMimeTypeCheck, strictMimetypeExceptions, retryTransformOnDifferentMimeType, transformsTransformOptions, localTransformServiceRegistry);
    }

    public static Transformer getConfig(List<String> mimetypes) {
        HashSet<SupportedSourceAndTarget> supportedSourceAndTargetList = new HashSet<SupportedSourceAndTarget>();
        for (String mimetype : mimetypes) {
            supportedSourceAndTargetList.add((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(mimetype)).withTargetMediaType(mimetype)).withPriority(Integer.valueOf(20)).build());
            if (!LocalPassThroughTransform.isToText(mimetype, mimetype)) continue;
            supportedSourceAndTargetList.add((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(mimetype)).withTargetMediaType("text/plain")).withPriority(Integer.valueOf(20)).build());
        }
        return Transformer.builder().withTransformerName(NAME).withSupportedSourceAndTargetList(supportedSourceAndTargetList).build();
    }

    private static boolean isToText(String sourceMimetype, String targetMimetype) {
        return targetMimetype.equals("text/plain") && sourceMimetype.startsWith("text/") || sourceMimetype.equals("application/x-javascript") || sourceMimetype.equals("application/dita+xml");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected void transformImpl(ContentReader reader, ContentWriter writer, Map<String, String> transformOptions, String sourceMimetype, String targetMimetype, String sourceExtension, String targetExtension, String renditionName, NodeRef sourceNodeRef) throws UnsupportedTransformationException, ContentIOException {
        if (LocalPassThroughTransform.isToText(sourceMimetype, targetMimetype)) {
            String sourceEncoding = reader.getEncoding();
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (InputStreamReader charReader = sourceEncoding == null ? new InputStreamReader(reader.getContentInputStream()) : new InputStreamReader(reader.getContentInputStream(), sourceEncoding);){
                    String targetEncoding = writer.getEncoding();
                    Throwable throwable2 = null;
                    Object var16_20 = null;
                    try (OutputStreamWriter charWriter = targetEncoding == null ? new OutputStreamWriter(writer.getContentOutputStream()) : new OutputStreamWriter(writer.getContentOutputStream(), targetEncoding);){
                        char[] buffer = new char[8192];
                        int readCount = 0;
                        while (readCount > -1) {
                            ((Writer)charWriter).write(buffer, 0, readCount);
                            readCount = charReader.read(buffer);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                AbstractLocalTransform.log.error((Object)e);
            }
        } else {
            writer.putContent(reader.getContentInputStream());
        }
    }
}

