/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TypeNames {
    private HashMap weighted = new HashMap();
    private HashMap defaults = new HashMap();

    public String get(int typecode) throws IllegalArgumentException {
        String result = (String)this.defaults.get(new Integer(typecode));
        if (result == null) {
            throw new IllegalArgumentException("No Dialect mapping for JDBC type: " + typecode);
        }
        return result;
    }

    public String get(int typecode, int size, int precision, int scale) throws IllegalArgumentException {
        Map map = (Map)this.weighted.get(new Integer(typecode));
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                if (size > (Integer)entry.getKey()) continue;
                return TypeNames.replace((String)entry.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(typecode), size, precision, scale);
    }

    private static String replace(String type, int size, int precision, int scale) {
        type = TypeNames.replaceOnce(type, "$s", Integer.toString(scale));
        type = TypeNames.replaceOnce(type, "$l", Integer.toString(size));
        return TypeNames.replaceOnce(type, "$p", Integer.toString(precision));
    }

    public void put(int typecode, int capacity, String value) {
        TreeMap<Integer, String> map = (TreeMap<Integer, String>)this.weighted.get(new Integer(typecode));
        if (map == null) {
            map = new TreeMap<Integer, String>();
            this.weighted.put(new Integer(typecode), map);
        }
        map.put(new Integer(capacity), value);
    }

    public void put(int typecode, String value) {
        this.defaults.put(new Integer(typecode), value);
    }

    private static String replaceOnce(String template, String placeholder, String replacement) {
        int loc;
        int n = loc = template == null ? -1 : template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return new StringBuffer(template.substring(0, loc)).append(replacement).append(template.substring(loc + placeholder.length())).toString();
    }
}

