/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node.ibatis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.AbstractNodeDAOImpl;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.ChildPropertyEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeAspectsEntity;
import org.alfresco.repo.domain.node.NodeAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeExistsException;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.node.NodeRangeEntity;
import org.alfresco.repo.domain.node.NodeUpdateEntity;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.node.PrimaryChildrenAclUpdateEntity;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.repo.domain.node.TransactionQueryEntity;
import org.alfresco.repo.domain.node.ibatis.NodeBatchLoadEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.Assert;

public class NodeDAOImpl
extends AbstractNodeDAOImpl {
    private static final String INSERT_TRANSACTION = "alfresco.node.insert.insert_Transaction";
    private static final String UPDATE_TRANSACTION_COMMIT_TIME = "alfresco.node.update_TransactionCommitTime";
    private static final String DELETE_TRANSACTION_BY_ID = "alfresco.node.delete_TransactionById";
    private static final String INSERT_STORE = "alfresco.node.insert.insert_Store";
    private static final String UPDATE_STORE_ROOT = "alfresco.node.update_StoreRoot";
    private static final String UPDATE_STORE = "alfresco.node.update_Store";
    private static final String UPDATE_NODES_IN_STORE = "alfresco.node.update_NodesInStore";
    private static final String SELECT_STORE_ALL = "alfresco.node.select_StoreAll";
    private static final String SELECT_STORE_BY_REF = "alfresco.node.select_StoreByRef";
    private static final String SELECT_STORE_ROOT_NODE_BY_REF = "alfresco.node.select_StoreRootNodeByRef";
    private static final String INSERT_NODE = "alfresco.node.insert.insert_Node";
    private static final String UPDATE_NODE = "alfresco.node.update_Node";
    private static final String UPDATE_NODE_BULK_TOUCH = "alfresco.node.update_NodeBulkTouch";
    private static final String DELETE_NODE_BY_ID = "alfresco.node.delete_NodeById";
    private static final String DELETE_NODES_BY_TXN_COMMIT_TIME = "alfresco.node.delete.delete_NodesByTxnCommitTime";
    private static final String DELETE_NODE_PROPS_BY_TXN_COMMIT_TIME = "alfresco.node.delete.delete_NodePropsByTxnCommitTime";
    private static final String SELECT_NODE_BY_ID = "alfresco.node.select_NodeById";
    private static final String SELECT_NODE_BY_NODEREF = "alfresco.node.select_NodeByNodeRef";
    private static final String SELECT_NODES_BY_UUIDS = "alfresco.node.select_NodesByUuids";
    private static final String SELECT_NODES_BY_IDS = "alfresco.node.select_NodesByIds";
    private static final String SELECT_NODE_PROPERTIES = "alfresco.node.select_NodeProperties";
    private static final String SELECT_PROPERTIES_BY_TYPES = "alfresco.node.select_PropertiesByTypes";
    private static final String SELECT_PROPERTIES_BY_ACTUAL_TYPE = "alfresco.node.select_PropertiesByActualType";
    private static final String SELECT_NODE_ASPECTS = "alfresco.node.select_NodeAspects";
    private static final String INSERT_NODE_PROPERTY = "alfresco.node.insert_NodeProperty";
    private static final String UPDATE_PRIMARY_CHILDREN_SHARED_ACL = "alfresco.node.update.update_PrimaryChildrenSharedAcl";
    private static final String INSERT_NODE_ASPECT = "alfresco.node.insert_NodeAspect";
    private static final String DELETE_NODE_ASPECTS = "alfresco.node.delete_NodeAspects";
    private static final String DELETE_NODE_PROPERTIES = "alfresco.node.delete_NodeProperties";
    private static final String SELECT_NODE_MIN_ID = "alfresco.node.select_NodeMinId";
    private static final String SELECT_NODE_MAX_ID = "alfresco.node.select_NodeMaxId";
    private static final String SELECT_NODE_INTERVAL_BY_TYPE = "alfresco.node.select_MinMaxNodeIdForNodeType";
    private static final String SELECT_NODES_WITH_ASPECT_IDS = "alfresco.node.select_NodesWithAspectIds";
    private static final String SELECT_NODES_WITH_ASPECT_IDS_LIMITED = "alfresco.node.select_NodesWithAspectIds_Limited";
    private static final String INSERT_NODE_ASSOC = "alfresco.node.insert.insert_NodeAssoc";
    private static final String UPDATE_NODE_ASSOC = "alfresco.node.update_NodeAssoc";
    private static final String DELETE_NODE_ASSOC = "alfresco.node.delete_NodeAssoc";
    private static final String DELETE_NODE_ASSOCS = "alfresco.node.delete_NodeAssocs";
    private static final String SELECT_NODE_ASSOCS = "alfresco.node.select_NodeAssocs";
    private static final String SELECT_NODE_ASSOCS_BY_SOURCE_AND_PROPERTY_VALUE = "alfresco.node.select_NodeAssocsBySourceAndPropertyValue";
    private static final String SELECT_NODE_ASSOCS_BY_TARGET = "alfresco.node.select_NodeAssocsByTarget";
    private static final String SELECT_NODE_ASSOC_BY_ID = "alfresco.node.select_NodeAssocById";
    private static final String SELECT_NODE_ASSOCS_MAX_INDEX = "alfresco.node.select_NodeAssocsMaxId";
    private static final String SELECT_CHILD_NODE_IDS = "alfresco.node.select.children.select_ChildNodeIds_Limited";
    private static final String SELECT_NODE_PRIMARY_CHILD_ACLS = "alfresco.node.select_NodePrimaryChildAcls";
    private static final String INSERT_CHILD_ASSOC = "alfresco.node.insert.insert_ChildAssoc";
    private static final String DELETE_CHILD_ASSOCS = "alfresco.node.delete_ChildAssocs";
    private static final String UPDATE_CHILD_ASSOCS_INDEX = "alfresco.node.update_ChildAssocsIndex";
    private static final String UPDATE_CHILD_ASSOC_UNIQUE_NAME = "alfresco.node.update_ChildAssocUniqueName";
    private static final String SELECT_CHILD_ASSOC_BY_ID = "alfresco.node.select_ChildAssocById";
    private static final String COUNT_CHILD_ASSOC_BY_PARENT_ID = "alfresco.node.count_ChildAssocByParentId";
    private static final String SELECT_CHILD_ASSOCS_BY_PROPERTY_VALUE = "alfresco.node.select_ChildAssocsByPropertyValue";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT = "alfresco.node.select_ChildAssocsOfParent";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT_LIMITED = "alfresco.node.select.children.select_ChildAssocsOfParent_Limited";
    private static final String SELECT_CHILD_ASSOC_OF_PARENT_BY_NAME = "alfresco.node.select_ChildAssocOfParentByName";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT_WITHOUT_PARENT_ASSOCS_OF_TYPE = "alfresco.node.select_ChildAssocsOfParentWithoutParentAssocsOfType";
    private static final String SELECT_ASSOCS_NOT_LINKED_BY_TWO_OTHER_ASSOCS = "alfresco.node.select_AssocsNotLinkedByTwoOtherAssocs";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT_WITHOUT_NODE_ASSOCS_OF_TYPE = "alfresco.node.select_ChildAssocsOfParentWithoutNodeAssocsOfType";
    private static final String SELECT_PARENT_ASSOCS_OF_CHILD = "alfresco.node.select_ParentAssocsOfChild";
    private static final String SELECT_PARENT_ASSOCS_OF_CHILDREN = "alfresco.node.select.children.select_ParentAssocsOfChildren";
    private static final String UPDATE_PARENT_ASSOCS_OF_CHILD = "alfresco.node.update_ParentAssocsOfChild";
    private static final String DELETE_SUBSCRIPTIONS = "alfresco.node.delete_NodeSubscriptions";
    private static final String UPDATE_MOVE_PARENT_ASSOCS = "alfresco.node.update_MoveParentAssocs";
    private static final String UPDATE_MOVE_CHILD_ASSOCS = "alfresco.node.update_MoveChildAssocs";
    private static final String UPDATE_MOVE_SOURCE_ASSOCS = "alfresco.node.update_MoveSourceAssocs";
    private static final String UPDATE_MOVE_TARGET_ASSOCS = "alfresco.node.update_MoveTargetAssocs";
    private static final String UPDATE_MOVE_PROPERTIES = "alfresco.node.update_MoveProperties";
    private static final String UPDATE_MOVE_ASPECTS = "alfresco.node.update_MoveAspects";
    private static final String SELECT_TXN_LAST = "alfresco.node.select_TxnLast";
    private static final String SELECT_TXN_NODES = "alfresco.node.select_TxnNodes";
    private static final String SELECT_TXNS = "alfresco.node.select_Txns";
    private static final String SELECT_TXN_COUNT = "alfresco.node.select_TxnCount";
    private static final String SELECT_TXNS_UNUSED = "alfresco.node.select_TxnsUnused";
    private static final String DELETE_TXNS_UNUSED = "alfresco.node.delete_Txns_Unused";
    private static final String SELECT_TXN_MIN_COMMIT_TIME = "alfresco.node.select_TxnMinCommitTime";
    private static final String SELECT_TXN_MAX_COMMIT_TIME = "alfresco.node.select_TxnMaxCommitTime";
    private static final String SELECT_TXN_MIN_COMMIT_TIME_FOR_NODE_TYPE = "alfresco.node.select_TxnMinCommitTimeForNodeType";
    private static final String SELECT_TXN_MIN_ID = "alfresco.node.select_TxnMinId";
    private static final String SELECT_TXN_MAX_ID = "alfresco.node.select_TxnMaxId";
    private static final String SELECT_TXN_UNUSED_MIN_COMMIT_TIME = "alfresco.node.select_TxnMinUnusedCommitTime";
    private static final String SELECT_ONE_TXNS_BY_COMMIT_TIME_DESC = "alfresco.node.select_OneTxnsByCommitTimeDescending";
    private static final String SELECT_TXN_MIN_TX_ID_IN_NODE_IDRANGE = "alfresco.node.select_TxnMinTxIdInNodeIdRange";
    private static final String SELECT_TXN_MAX_TX_ID_IN_NODE_IDRANGE = "alfresco.node.select_TxnMaxTxIdInNodeIdRange";
    private static final String SELECT_TXN_NEXT_TXN_COMMIT_TIME = "select_TxnNextTxnCommitTime";
    private static final String SELECT_NODES_DELETED_BY_TXN_COMMIT_TIME = "alfresco.node.select.select_Deleted_NodesByTxnCommitTime";
    private static final String DELETE_NODES_BY_ID = "alfresco.node.delete_NodesById";
    private static final String DELETE_NODE_PROPS_BY_NODE_ID = "alfresco.node.delete_NodePropsByNodeId";
    private static final String SELECT_TXNS_UNUSED_BY_TXN_COMMIT_TIME = "alfresco.node.select.select_Txns_UnusedByTxnCommitTime";
    private static final String DELETE_TXNS_UNUSED_BY_ID = "alfresco.node.delete_Txns_UnusedById";
    protected QNameDAO qnameDAO;
    protected DictionaryService dictionaryService;
    private SqlSessionTemplate template;

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
        super.setQnameDAO(qnameDAO);
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
        super.setDictionaryService(dictionaryService);
    }

    @Override
    public void startBatch() {
    }

    @Override
    public void executeBatch() {
    }

    @Override
    protected Long insertTransaction(String changeTxnId, Long commitTimeMs) {
        TransactionEntity transaction = new TransactionEntity();
        transaction.setVersion(1L);
        transaction.setChangeTxnId(changeTxnId);
        transaction.setCommitTimeMs(commitTimeMs);
        this.template.insert(INSERT_TRANSACTION, (Object)transaction);
        return transaction.getId();
    }

    @Override
    protected int updateTransaction(Long txnId, Long commitTimeMs) {
        TransactionEntity transaction = new TransactionEntity();
        transaction.setId(txnId);
        transaction.setCommitTimeMs(commitTimeMs);
        return this.template.update(UPDATE_TRANSACTION_COMMIT_TIME, (Object)transaction);
    }

    @Override
    protected int deleteTransaction(Long txnId) {
        TransactionEntity transaction = new TransactionEntity();
        transaction.setId(txnId);
        return this.template.delete(DELETE_TRANSACTION_BY_ID, (Object)transaction);
    }

    @Override
    protected List<StoreEntity> selectAllStores() {
        return this.template.selectList(SELECT_STORE_ALL);
    }

    @Override
    protected StoreEntity selectStore(StoreRef storeRef) {
        StoreEntity store = new StoreEntity();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        return (StoreEntity)this.template.selectOne(SELECT_STORE_BY_REF, (Object)store);
    }

    @Override
    protected NodeEntity selectStoreRootNode(StoreRef storeRef) {
        StoreEntity store = new StoreEntity();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        return (NodeEntity)this.template.selectOne(SELECT_STORE_ROOT_NODE_BY_REF, (Object)store);
    }

    @Override
    protected Long insertStore(StoreEntity store) {
        store.setVersion(1L);
        this.template.insert(INSERT_STORE, (Object)store);
        return store.getId();
    }

    @Override
    protected int updateStoreRoot(StoreEntity store) {
        return this.template.update(UPDATE_STORE_ROOT, (Object)store);
    }

    @Override
    protected int updateStore(StoreEntity store) {
        return this.template.update(UPDATE_STORE, (Object)store);
    }

    @Override
    protected int updateNodesInStore(Long txnId, Long storeId) {
        IdsEntity ids = new IdsEntity();
        ids.setIdOne(txnId);
        ids.setIdTwo(storeId);
        return this.template.update(UPDATE_NODES_IN_STORE, (Object)ids);
    }

    @Override
    protected Long insertNode(NodeEntity node) {
        node.setVersion(1L);
        this.template.insert(INSERT_NODE, (Object)node);
        return node.getId();
    }

    @Override
    protected int updateNode(NodeUpdateEntity nodeUpdate) {
        nodeUpdate.incrementVersion();
        return this.template.update(UPDATE_NODE, (Object)nodeUpdate);
    }

    @Override
    protected int updateNodes(Long txnId, List<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return 0;
        }
        IdsEntity ids = new IdsEntity();
        ids.setIdOne(txnId);
        ids.setIds(nodeIds);
        return this.template.update(UPDATE_NODE_BULK_TOUCH, (Object)ids);
    }

    @Override
    public Long getMinNodeId() {
        return (Long)this.template.selectOne(SELECT_NODE_MIN_ID);
    }

    @Override
    public Long getMaxNodeId() {
        return (Long)this.template.selectOne(SELECT_NODE_MAX_ID);
    }

    @Override
    public Pair<Long, Long> getNodeIdsIntervalForType(QName type, Long startTxnTime, Long endTxnTime) {
        final Pair intervalPair = new Pair((Object)AbstractNodeDAOImpl.LONG_ZERO, (Object)AbstractNodeDAOImpl.LONG_ZERO);
        Pair<Long, QName> typePair = this.qnameDAO.getQName(type);
        if (typePair == null) {
            return intervalPair;
        }
        TransactionQueryEntity txnQuery = new TransactionQueryEntity();
        txnQuery.setTypeQNameId((Long)typePair.getFirst());
        txnQuery.setMinCommitTime(startTxnTime);
        txnQuery.setMaxCommitTime(endTxnTime);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                Map result = (Map)context.getResultObject();
                if (result != null) {
                    intervalPair.setFirst((Object)((Long)result.get("minId")));
                    intervalPair.setSecond((Object)((Long)result.get("maxId")));
                }
            }
        };
        this.template.select(SELECT_NODE_INTERVAL_BY_TYPE, (Object)txnQuery, resultHandler);
        return intervalPair;
    }

    @Override
    protected void updatePrimaryChildrenSharedAclId(Long txnId, Long primaryParentNodeId, Long optionalOldSharedAlcIdInAdditionToNull, Long newSharedAlcId) {
        PrimaryChildrenAclUpdateEntity primaryChildrenAclUpdateEntity = new PrimaryChildrenAclUpdateEntity();
        primaryChildrenAclUpdateEntity.setTxnId(txnId);
        primaryChildrenAclUpdateEntity.setPrimaryParentNodeId(primaryParentNodeId);
        primaryChildrenAclUpdateEntity.setOptionalOldSharedAclIdInAdditionToNull(optionalOldSharedAlcIdInAdditionToNull);
        primaryChildrenAclUpdateEntity.setNewSharedAclId(newSharedAlcId);
        this.template.update(UPDATE_PRIMARY_CHILDREN_SHARED_ACL, (Object)primaryChildrenAclUpdateEntity);
    }

    @Override
    protected int deleteNodeById(Long nodeId) {
        NodeEntity node = new NodeEntity();
        node.setId(nodeId);
        return this.template.delete(DELETE_NODE_BY_ID, (Object)node);
    }

    @Override
    protected int deleteNodesByCommitTime(long fromTxnCommitTimeMs, long toTxnCommitTimeMs) {
        Pair<Long, QName> deletedTypePair = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        if (deletedTypePair == null) {
            return 0;
        }
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setTypeQNameId((Long)deletedTypePair.getFirst());
        query.setMinCommitTime(fromTxnCommitTimeMs);
        query.setMaxCommitTime(toTxnCommitTimeMs);
        this.template.delete(DELETE_NODE_PROPS_BY_TXN_COMMIT_TIME, (Object)query);
        return this.template.delete(DELETE_NODES_BY_TXN_COMMIT_TIME, (Object)query);
    }

    @Override
    protected NodeEntity selectNodeById(Long id) {
        NodeEntity node = new NodeEntity();
        node.setId(id);
        return (NodeEntity)this.template.selectOne(SELECT_NODE_BY_ID, (Object)node);
    }

    @Override
    protected List<NodeEntity> selectNodesByIds(List<Long> ids) {
        ArrayList nodes = new ArrayList();
        ids.forEach(id -> {
            NodeEntity node = new NodeEntity();
            node.setId((Long)id);
            nodes.add(node);
        });
        return this.template.selectList(SELECT_NODES_BY_IDS, nodes);
    }

    @Override
    protected NodeEntity selectNodeByNodeRef(NodeRef nodeRef) {
        StoreEntity store = new StoreEntity();
        StoreRef storeRef = nodeRef.getStoreRef();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        NodeEntity node = new NodeEntity();
        node.setStore(store);
        String uuid = nodeRef.getId();
        if (uuid.length() > 36) {
            return null;
        }
        node.setUuid(uuid);
        return (NodeEntity)this.template.selectOne(SELECT_NODE_BY_NODEREF, (Object)node);
    }

    @Override
    protected List<Node> selectNodesByUuids(Long storeId, SortedSet<String> uuids) {
        NodeBatchLoadEntity nodeBatchLoadEntity = new NodeBatchLoadEntity();
        nodeBatchLoadEntity.setStoreId(storeId);
        nodeBatchLoadEntity.setUuids(new ArrayList<String>(uuids));
        return this.template.selectList(SELECT_NODES_BY_UUIDS, (Object)nodeBatchLoadEntity);
    }

    @Override
    protected List<Node> selectNodesByIds(SortedSet<Long> ids) {
        NodeBatchLoadEntity nodeBatchLoadEntity = new NodeBatchLoadEntity();
        nodeBatchLoadEntity.setIds(new ArrayList<Long>(ids));
        return this.template.selectList(SELECT_NODES_BY_IDS, (Object)nodeBatchLoadEntity);
    }

    private Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> makePersistentPropertiesMap(List<NodePropertyEntity> rows) {
        HashMap<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> results = new HashMap<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>>(3);
        for (NodePropertyEntity row : rows) {
            Long nodeId = row.getNodeId();
            Long nodeVersion = row.getNodeVersion();
            if (nodeId == null || nodeVersion == null) {
                throw new RuntimeException("Expect results with a Node and Version: " + row);
            }
            NodeVersionKey nodeTxnKey = new NodeVersionKey(nodeId, nodeVersion);
            HashMap<NodePropertyKey, NodePropertyValue> props = (HashMap<NodePropertyKey, NodePropertyValue>)results.get(nodeTxnKey);
            if (props == null) {
                props = new HashMap<NodePropertyKey, NodePropertyValue>(17);
                results.put(nodeTxnKey, props);
            }
            props.put(row.getKey(), row.getValue());
        }
        return results;
    }

    private List<NodePropertyEntity> makePersistentRows(Long nodeId, Map<NodePropertyKey, NodePropertyValue> map) {
        ArrayList<NodePropertyEntity> rows = new ArrayList<NodePropertyEntity>(map.size());
        for (Map.Entry<NodePropertyKey, NodePropertyValue> entry : map.entrySet()) {
            NodePropertyEntity row = new NodePropertyEntity();
            row.setNodeId(nodeId);
            row.setKey(entry.getKey());
            row.setValue(entry.getValue());
            rows.add(row);
        }
        return rows;
    }

    @Override
    protected Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Set<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return Collections.emptyMap();
        }
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeIds(new ArrayList<Long>(nodeIds));
        List rows = this.template.selectList(SELECT_NODE_PROPERTIES, (Object)prop);
        return this.makePersistentPropertiesMap(rows);
    }

    @Override
    protected Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long nodeId) {
        return this.selectNodeProperties(nodeId, Collections.emptySet());
    }

    @Override
    protected Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long nodeId, Set<Long> qnameIds) {
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeId(nodeId);
        switch (qnameIds.size()) {
            case 0: {
                break;
            }
            case 1: {
                prop.setKey(new NodePropertyKey());
                prop.getKey().setQnameId(qnameIds.iterator().next());
                break;
            }
            default: {
                prop.setQnameIds(new ArrayList<Long>(qnameIds));
            }
        }
        List rows = this.template.selectList(SELECT_NODE_PROPERTIES, (Object)prop);
        return this.makePersistentPropertiesMap(rows);
    }

    @Override
    public List<NodePropertyEntity> selectNodePropertiesByTypes(Set<QName> qnames) {
        final ArrayList<NodePropertyEntity> properties = new ArrayList<NodePropertyEntity>();
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(qnames, false);
        if (qnameIds.size() > 0) {
            IdsEntity param = new IdsEntity();
            param.setIds(new ArrayList<Long>(qnameIds));
            this.template.select(SELECT_PROPERTIES_BY_TYPES, (Object)param, new ResultHandler(){

                public void handleResult(ResultContext context) {
                    properties.add((NodePropertyEntity)context.getResultObject());
                }
            });
        }
        return properties;
    }

    @Override
    public List<NodePropertyEntity> selectNodePropertiesByDataType(QName dataType, long minNodeId, long maxNodeId) {
        int typeOrdinal = NodePropertyValue.convertToTypeOrdinal(dataType);
        IdsEntity ids = new IdsEntity();
        ids.setIdOne(Long.valueOf(typeOrdinal));
        ids.setIdTwo(minNodeId);
        ids.setIdThree(maxNodeId);
        final ArrayList<NodePropertyEntity> properties = new ArrayList<NodePropertyEntity>();
        this.template.select(SELECT_PROPERTIES_BY_ACTUAL_TYPE, (Object)ids, new ResultHandler(){

            public void handleResult(ResultContext context) {
                properties.add((NodePropertyEntity)context.getResultObject());
            }
        });
        return properties;
    }

    @Override
    protected int deleteNodeProperties(Long nodeId, Set<Long> qnameIds) {
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeId(nodeId);
        if (qnameIds != null) {
            if (qnameIds.isEmpty()) {
                return 0;
            }
            prop.setQnameIds(new ArrayList<Long>(qnameIds));
        }
        return this.template.delete(DELETE_NODE_PROPERTIES, (Object)prop);
    }

    @Override
    protected int deleteNodeProperties(Long nodeId, List<NodePropertyKey> propKeys) {
        Assert.notNull((Object)nodeId, (String)"Must have 'nodeId'");
        Assert.notNull((Object)nodeId, (String)"Must have 'propKeys'");
        if (propKeys.size() == 0) {
            return 0;
        }
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeId(nodeId);
        this.startBatch();
        int count = 0;
        try {
            for (NodePropertyKey propKey : propKeys) {
                prop.setKey(propKey);
                count += this.template.delete(DELETE_NODE_PROPERTIES, (Object)prop);
            }
        }
        finally {
            this.executeBatch();
        }
        return count;
    }

    @Override
    protected void insertNodeProperties(Long nodeId, Map<NodePropertyKey, NodePropertyValue> persistableProps) {
        if (persistableProps.isEmpty()) {
            return;
        }
        List<NodePropertyEntity> rows = this.makePersistentRows(nodeId, persistableProps);
        this.startBatch();
        try {
            for (NodePropertyEntity row : rows) {
                this.template.insert(INSERT_NODE_PROPERTY, (Object)row);
            }
        }
        finally {
            this.executeBatch();
        }
    }

    @Override
    protected Map<NodeVersionKey, Set<QName>> selectNodeAspects(Set<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return Collections.emptyMap();
        }
        NodeAspectsEntity aspects = new NodeAspectsEntity();
        aspects.setNodeIds(new ArrayList<Long>(nodeIds));
        List rows = this.template.selectList(SELECT_NODE_ASPECTS, (Object)aspects);
        HashMap<NodeVersionKey, Set<QName>> results = new HashMap<NodeVersionKey, Set<QName>>(rows.size() * 2);
        for (NodeAspectsEntity nodeAspectsEntity : rows) {
            Long nodeVersion;
            Long nodeId = nodeAspectsEntity.getNodeId();
            NodeVersionKey nodeVersionKey = new NodeVersionKey(nodeId, nodeVersion = nodeAspectsEntity.getNodeVersion());
            if (results.containsKey(nodeVersionKey)) {
                throw new IllegalStateException("Found existing key while querying for node aspects: " + nodeIds);
            }
            HashSet<Long> aspectIds = new HashSet<Long>(nodeAspectsEntity.getAspectQNameIds());
            Set<QName> aspectQNames = this.qnameDAO.convertIdsToQNames(aspectIds);
            results.put(nodeVersionKey, aspectQNames);
        }
        return results;
    }

    @Override
    protected void insertNodeAspect(Long nodeId, Long qnameId) {
        HashMap<String, Long> aspectParameters = new HashMap<String, Long>(5);
        aspectParameters.put("nodeId", nodeId);
        aspectParameters.put("qnameId", qnameId);
        this.template.insert(INSERT_NODE_ASPECT, aspectParameters);
    }

    @Override
    protected int deleteNodeAspects(Long nodeId, Set<Long> qnameIds) {
        NodeAspectsEntity nodeAspects = new NodeAspectsEntity();
        nodeAspects.setNodeId(nodeId);
        if (qnameIds != null && !qnameIds.isEmpty()) {
            nodeAspects.setAspectQNameIds(new ArrayList<Long>(qnameIds));
        }
        return this.template.delete(DELETE_NODE_ASPECTS, (Object)nodeAspects);
    }

    @Override
    protected void selectNodesWithAspects(List<Long> qnameIds, Long minNodeId, Long maxNodeId, final NodeDAO.NodeRefQueryCallback resultsCallback) {
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                NodeEntity entity = (NodeEntity)context.getResultObject();
                Pair nodePair = new Pair((Object)entity.getId(), (Object)entity.getNodeRef());
                resultsCallback.handle((Pair<Long, NodeRef>)nodePair);
            }
        };
        IdsEntity parameters = new IdsEntity();
        parameters.setIdOne(minNodeId);
        parameters.setIdTwo(maxNodeId);
        parameters.setIds(qnameIds);
        this.template.select(SELECT_NODES_WITH_ASPECT_IDS, (Object)parameters, resultHandler);
    }

    @Override
    protected void selectNodesWithAspects(List<Long> qnameIds, Long minNodeId, Long maxNodeId, boolean ordered, final NodeDAO.NodeRefQueryCallback resultsCallback) {
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                NodeEntity entity = (NodeEntity)context.getResultObject();
                Pair nodePair = new Pair((Object)entity.getId(), (Object)entity.getNodeRef());
                resultsCallback.handle((Pair<Long, NodeRef>)nodePair);
            }
        };
        IdsEntity parameters = new IdsEntity();
        parameters.setIdOne(minNodeId);
        parameters.setIdTwo(maxNodeId);
        parameters.setIds(qnameIds);
        parameters.setOrdered(ordered);
        this.template.select(SELECT_NODES_WITH_ASPECT_IDS, (Object)parameters, resultHandler);
    }

    @Override
    protected void selectNodesWithAspects(List<Long> qnameIds, Long minNodeId, Long maxNodeId, boolean ordered, int maxResults, final NodeDAO.NodeRefQueryCallback resultsCallback) {
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                NodeEntity entity = (NodeEntity)context.getResultObject();
                Pair nodePair = new Pair((Object)entity.getId(), (Object)entity.getNodeRef());
                resultsCallback.handle((Pair<Long, NodeRef>)nodePair);
            }
        };
        IdsEntity parameters = new IdsEntity();
        parameters.setIdOne(minNodeId);
        parameters.setIdTwo(maxNodeId);
        parameters.setIds(qnameIds);
        parameters.setOrdered(ordered);
        parameters.setMaxResults(maxResults);
        this.template.select(SELECT_NODES_WITH_ASPECT_IDS_LIMITED, (Object)parameters, resultHandler);
    }

    @Override
    protected Long insertNodeAssoc(Long sourceNodeId, Long targetNodeId, Long assocTypeQNameId, int assocIndex) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setVersion(1L);
        assoc.setTypeQNameId(assocTypeQNameId);
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(targetNodeId);
        assoc.setTargetNode(targetNode);
        assoc.setAssocIndex(assocIndex);
        this.template.insert(INSERT_NODE_ASSOC, (Object)assoc);
        return assoc.getId();
    }

    @Override
    protected int updateNodeAssoc(Long id, int assocIndex) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setId(id);
        assoc.setAssocIndex(assocIndex);
        return this.template.update(UPDATE_NODE_ASSOC, (Object)assoc);
    }

    @Override
    protected int deleteNodeAssoc(Long sourceNodeId, Long targetNodeId, Long assocTypeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setTypeQNameId(assocTypeQNameId);
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(targetNodeId);
        assoc.setTargetNode(targetNode);
        return this.template.delete(DELETE_NODE_ASSOC, (Object)assoc);
    }

    @Override
    protected int deleteNodeAssocs(List<Long> ids) {
        IdsEntity param = new IdsEntity();
        param.setIds(ids);
        return this.template.delete(DELETE_NODE_ASSOCS, (Object)param);
    }

    @Override
    protected List<NodeAssocEntity> selectNodeAssocs(Long nodeId) {
        NodeEntity node = new NodeEntity();
        node.setId(nodeId);
        return this.template.selectList(SELECT_NODE_ASSOCS, (Object)node);
    }

    @Override
    protected List<NodeAssocEntity> selectNodeAssocsBySource(Long sourceNodeId, Long typeQNameId) {
        return this.selectNodeAssocsBySourceAndPropertyValue(sourceNodeId, typeQNameId, null, null);
    }

    @Override
    protected List<NodeAssocEntity> selectNodeAssocsBySourceAndPropertyValue(Long sourceNodeId, Long typeQNameId, Long propertyQNameId, NodePropertyValue nodeValue) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        assoc.setTypeQNameId(typeQNameId);
        assoc.setPropertyQNameId(propertyQNameId);
        assoc.setPropertyValue(nodeValue);
        return this.template.selectList(SELECT_NODE_ASSOCS_BY_SOURCE_AND_PROPERTY_VALUE, (Object)assoc);
    }

    @Override
    protected List<NodeAssocEntity> selectNodeAssocsByTarget(Long targetNodeId, Long typeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(targetNodeId);
        assoc.setTargetNode(targetNode);
        assoc.setTypeQNameId(typeQNameId);
        return this.template.selectList(SELECT_NODE_ASSOCS_BY_TARGET, (Object)assoc);
    }

    @Override
    protected NodeAssocEntity selectNodeAssocById(Long assocId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setId(assocId);
        return (NodeAssocEntity)this.template.selectOne(SELECT_NODE_ASSOC_BY_ID, (Object)assoc);
    }

    @Override
    protected int selectNodeAssocMaxIndex(Long sourceNodeId, Long assocTypeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        assoc.setTypeQNameId(assocTypeQNameId);
        Integer maxIndex = (Integer)this.template.selectOne(SELECT_NODE_ASSOCS_MAX_INDEX, (Object)assoc);
        return maxIndex == null ? 0 : maxIndex;
    }

    @Override
    protected Long insertChildAssoc(ChildAssocEntity assoc) {
        assoc.setVersion(1L);
        this.template.insert(INSERT_CHILD_ASSOC, (Object)assoc);
        return assoc.getId();
    }

    @Override
    protected int deleteChildAssocs(List<Long> ids) {
        IdsEntity idsEntity = new IdsEntity();
        idsEntity.setIds(ids);
        return this.template.delete(DELETE_CHILD_ASSOCS, (Object)idsEntity);
    }

    @Override
    protected int updateChildAssocIndex(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, int index) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
        assoc.setQNameAll(this.qnameDAO, assocQName, true);
        assoc.setAssocIndex(index);
        return this.template.update(UPDATE_CHILD_ASSOCS_INDEX, (Object)assoc);
    }

    @Override
    protected int updateChildAssocUniqueName(Long assocId, String name) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setId(assocId);
        assoc.setChildNodeNameAll(null, null, name);
        return this.template.update(UPDATE_CHILD_ASSOC_UNIQUE_NAME, (Object)assoc);
    }

    @Override
    protected ChildAssocEntity selectChildAssoc(Long assocId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setId(assocId);
        return (ChildAssocEntity)this.template.selectOne(SELECT_CHILD_ASSOC_BY_ID, (Object)assoc);
    }

    @Override
    protected List<ChildAssocEntity> selectChildNodeIds(Long nodeId, Boolean isPrimary, Long minChildNodeIdInclusive, int maxResults) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(nodeId);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(minChildNodeIdInclusive);
        assoc.setParentNode(parentNode);
        assoc.setPrimary(isPrimary);
        assoc.setChildNode(childNode);
        RowBounds rowBounds = new RowBounds(0, maxResults);
        return this.template.selectList(SELECT_CHILD_NODE_IDS, (Object)assoc, rowBounds);
    }

    @Override
    public List<NodeIdAndAclId> selectPrimaryChildAcls(Long nodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(nodeId);
        assoc.setParentNode(parentNode);
        assoc.setPrimary(true);
        return this.template.selectList(SELECT_NODE_PRIMARY_CHILD_ACLS, (Object)assoc);
    }

    @Override
    protected List<ChildAssocEntity> selectChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        if (!assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            return Collections.emptyList();
        }
        if (!assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            return Collections.emptyList();
        }
        assoc.setOrdered(false);
        return this.template.selectList(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc);
    }

    @Override
    protected void selectChildAssocs(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, Boolean sameStore, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (childNodeId != null) {
            NodeEntity childNode = new NodeEntity();
            childNode.setId(childNodeId);
            assoc.setChildNode(childNode);
        }
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        if (assocQName != null && !assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            resultsCallback.done();
            return;
        }
        if (isPrimary != null) {
            assoc.setPrimary(isPrimary);
        }
        if (sameStore != null) {
            assoc.setSameStore(sameStore);
        }
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    public void selectChildAssocs(Long parentNodeId, QName assocTypeQName, QName assocQName, int maxResults, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        if (assocQName != null && !assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            resultsCallback.done();
            return;
        }
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        RowBounds rowBounds = new RowBounds(0, maxResults);
        List entities = this.template.selectList(SELECT_CHILD_ASSOCS_OF_PARENT_LIMITED, (Object)assoc, rowBounds);
        DefaultResultContext resultContext = new DefaultResultContext();
        for (Object entity : entities) {
            resultContext.nextResultObject(entity);
            resultHandler.handleResult((ResultContext)resultContext);
        }
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocs(Long parentNodeId, Set<QName> assocTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        Set<Long> assocTypeQNameIds = this.qnameDAO.convertQNamesToIds(assocTypeQNames, false);
        if (assocTypeQNameIds.size() == 0) {
            resultsCallback.done();
            return;
        }
        assoc.setTypeQNameIds(new ArrayList<Long>(assocTypeQNameIds));
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected ChildAssocEntity selectChildAssoc(Long parentNodeId, QName assocTypeQName, String childName) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (!assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            return null;
        }
        assoc.setChildNodeNameAll(null, assocTypeQName, childName);
        assoc.setOrdered(false);
        return (ChildAssocEntity)this.template.selectOne(SELECT_CHILD_ASSOC_OF_PARENT_BY_NAME, (Object)assoc);
    }

    @Override
    protected void selectChildAssocs(Long parentNodeId, QName assocTypeQName, Collection<String> childNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        if (childNames.size() == 0) {
            resultsCallback.done();
            return;
        }
        if (childNames.size() > 1000) {
            throw new IllegalArgumentException("Unable to process more than 1000 child names in getChildAssocs");
        }
        final HashSet<String> childNamesShort = new HashSet<String>(childNames.size());
        ArrayList<Long> childNamesCrc = new ArrayList<Long>(childNames.size());
        for (String childName : childNames) {
            String childNameLower = childName.toLowerCase();
            String childNameShort = ChildAssocEntity.getChildNodeNameShort(childNameLower);
            Long childNameCrc = ChildAssocEntity.getChildNodeNameCrc(childNameLower);
            childNamesShort.add(childNameShort);
            childNamesCrc.add(childNameCrc);
        }
        ChildAssocResultHandlerFilter filter = new ChildAssocResultHandlerFilter(){

            @Override
            public boolean isResult(ChildAssocEntity assoc) {
                return childNamesShort.contains(assoc.getChildNodeName());
            }
        };
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        assoc.setChildNodeNameCrcs(childNamesCrc);
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(filter, resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocsByPropertyValue(Long parentNodeId, QName propertyQName, NodePropertyValue nodeValue, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildPropertyEntity assocProp = new ChildPropertyEntity();
        assocProp.setParentNodeId(parentNodeId);
        Pair<Long, QName> propName = this.qnameDAO.getQName(propertyQName);
        if (propName == null) {
            resultsCallback.done();
            return;
        }
        assocProp.setValue(nodeValue);
        assocProp.setPropertyQNameId((Long)propName.getFirst());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_BY_PROPERTY_VALUE, (Object)assocProp, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocsByChildTypes(Long parentNodeId, Set<QName> childNodeTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        Set<Long> childNodeTypeQNameIds = this.qnameDAO.convertQNamesToIds(childNodeTypeQNames, false);
        if (childNodeTypeQNameIds.size() == 0) {
            resultsCallback.done();
            return;
        }
        assoc.setChildNodeTypeQNameIds(new ArrayList<Long>(childNodeTypeQNameIds));
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocsWithoutParentAssocsOfType(Long parentNodeId, QName assocTypeQName, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (!assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT_WITHOUT_PARENT_ASSOCS_OF_TYPE, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    public List<String> selectAssocsNotLinkedByTwoOtherAssocs(Long parentNodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        return this.template.selectList(SELECT_ASSOCS_NOT_LINKED_BY_TWO_OTHER_ASSOCS, (Object)assoc);
    }

    @Override
    public List<Node> selectChildAssocsWithoutNodeAssocsOfTypes(Long parentNodeId, Long minNodeId, Long maxNodeId, Set<QName> assocTypeQNames) {
        Set<Long> childNodeTypeQNameIds;
        IdsEntity idsEntity = new IdsEntity();
        Assert.notNull((Object)parentNodeId, (String)"The parent node id must not be null.");
        idsEntity.setIdOne(parentNodeId);
        idsEntity.setIdTwo(minNodeId);
        idsEntity.setIdThree(maxNodeId);
        if (assocTypeQNames != null && (childNodeTypeQNameIds = this.qnameDAO.convertQNamesToIds(assocTypeQNames, false)).size() > 0) {
            idsEntity.setIds(new ArrayList<Long>(childNodeTypeQNameIds));
        }
        return this.template.selectList(SELECT_CHILD_ASSOCS_OF_PARENT_WITHOUT_NODE_ASSOCS_OF_TYPE, (Object)idsEntity);
    }

    @Override
    protected List<ChildAssocEntity> selectPrimaryParentAssocs(Long childNodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        assoc.setPrimary(Boolean.TRUE);
        return this.template.selectList(SELECT_PARENT_ASSOCS_OF_CHILD, (Object)assoc);
    }

    @Override
    protected void selectParentAssocs(Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        if (assocQName != null && !assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            resultsCallback.done();
            return;
        }
        if (isPrimary != null) {
            assoc.setPrimary(isPrimary);
        }
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_PARENT_ASSOCS_OF_CHILD, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected List<ChildAssocEntity> selectParentAssocs(Long childNodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        return this.template.selectList(SELECT_PARENT_ASSOCS_OF_CHILD, (Object)assoc);
    }

    @Override
    protected List<ChildAssocEntity> selectParentAssocsOfChildren(Set<Long> childrenNodeIds) {
        if (childrenNodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        IdsEntity idsEntity = new IdsEntity();
        idsEntity.setIds(new ArrayList<Long>(childrenNodeIds));
        return this.template.selectList(SELECT_PARENT_ASSOCS_OF_CHILDREN, (Object)idsEntity);
    }

    @Override
    protected int updatePrimaryParentAssocs(Long childNodeId, Long parentNodeId, QName assocTypeQName, QName assocQName, String childNodeName) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        if (assocTypeQName != null) {
            assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
            assoc.setChildNodeNameAll(this.dictionaryService, assocTypeQName, childNodeName);
        }
        if (assocQName != null) {
            assoc.setQNameAll(this.qnameDAO, assocQName, true);
        }
        assoc.setPrimary(Boolean.TRUE);
        return this.template.update(UPDATE_PARENT_ASSOCS_OF_CHILD, (Object)assoc);
    }

    @Override
    protected void moveNodeData(Long fromNodeId, Long toNodeId) {
        IdsEntity params = new IdsEntity();
        params.setIdOne(fromNodeId);
        params.setIdTwo(toNodeId);
        int countPA = this.template.update(UPDATE_MOVE_PARENT_ASSOCS, (Object)params);
        int countCA = this.template.update(UPDATE_MOVE_CHILD_ASSOCS, (Object)params);
        int countSA = this.template.update(UPDATE_MOVE_SOURCE_ASSOCS, (Object)params);
        int countTA = this.template.update(UPDATE_MOVE_TARGET_ASSOCS, (Object)params);
        int countP = this.template.update(UPDATE_MOVE_PROPERTIES, (Object)params);
        int countA = this.template.update(UPDATE_MOVE_ASPECTS, (Object)params);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Moved node data: \n   From: " + fromNodeId + "\n" + "   To:   " + toNodeId + "\n" + "   PA:   " + countPA + "\n" + "   CA:   " + countCA + "\n" + "   SA:   " + countSA + "\n" + "   TA:   " + countTA + "\n" + "   P:    " + countP + "\n" + "   A:    " + countA));
        }
    }

    @Override
    protected void deleteSubscriptions(Long nodeId) {
    }

    @Override
    protected Transaction selectLastTxnBeforeCommitTime(Long maxCommitTime) {
        Assert.notNull((Object)maxCommitTime, (String)"maxCommitTime");
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setMaxCommitTime(maxCommitTime);
        List txns = this.template.selectList(SELECT_TXN_LAST, (Object)query, new RowBounds(0, 1));
        if (txns.size() > 0) {
            return (Transaction)txns.get(0);
        }
        return null;
    }

    @Override
    protected int selectTransactionCount() {
        return (Integer)this.template.selectOne(SELECT_TXN_COUNT);
    }

    @Override
    protected Transaction selectTxnById(Long txnId) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setId(txnId);
        return (Transaction)this.template.selectOne(SELECT_TXNS, (Object)query);
    }

    @Override
    protected List<NodeEntity> selectTxnChanges(Long txnId, Long storeId) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setId(txnId);
        if (storeId != null) {
            query.setStoreId(storeId);
        }
        return this.template.selectList(SELECT_TXN_NODES, (Object)query);
    }

    @Override
    public List<Transaction> selectTxns(Long fromTimeInclusive, Long toTimeExclusive, Integer count, List<Long> includeTxnIds, List<Long> excludeTxnIds, Boolean ascending) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setMinCommitTime(fromTimeInclusive);
        query.setMaxCommitTime(toTimeExclusive);
        if (includeTxnIds != null && includeTxnIds.size() > 0) {
            query.setIncludeTxnIds(includeTxnIds);
        }
        if (excludeTxnIds != null && excludeTxnIds.size() > 0) {
            query.setExcludeTxnIds(excludeTxnIds);
        }
        query.setAscending(ascending);
        if (count == null) {
            return this.template.selectList(SELECT_TXNS, (Object)query);
        }
        return this.template.selectList(SELECT_TXNS, (Object)query, new RowBounds(0, count.intValue()));
    }

    @Override
    protected List<Long> selectTxnsUnused(Long minTxnId, Long maxCommitTime, Integer count) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setMinId(minTxnId);
        query.setMaxCommitTime(maxCommitTime);
        if (count == null) {
            return this.template.selectList(SELECT_TXNS_UNUSED, (Object)query);
        }
        return this.template.selectList(SELECT_TXNS_UNUSED, (Object)query, new RowBounds(0, count.intValue()));
    }

    @Override
    public int deleteTxnsUnused(long fromCommitTime, long toCommitTime) {
        TransactionQueryEntity txnQuery = new TransactionQueryEntity();
        txnQuery.setMinCommitTime(fromCommitTime);
        txnQuery.setMaxCommitTime(toCommitTime);
        int numDeleted = this.template.delete(DELETE_TXNS_UNUSED, (Object)txnQuery);
        return numDeleted;
    }

    @Override
    protected Long selectMinTxnCommitTime() {
        return (Long)this.template.selectOne(SELECT_TXN_MIN_COMMIT_TIME);
    }

    @Override
    protected Long selectMaxTxnCommitTime() {
        return (Long)this.template.selectOne(SELECT_TXN_MAX_COMMIT_TIME);
    }

    @Override
    protected Long selectMinTxnCommitTimeForDeletedNodes() {
        Pair<Long, QName> deletedTypePair = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        if (deletedTypePair == null) {
            return AbstractNodeDAOImpl.LONG_ZERO;
        }
        TransactionQueryEntity txnQuery = new TransactionQueryEntity();
        txnQuery.setTypeQNameId((Long)deletedTypePair.getFirst());
        return (Long)this.template.selectOne(SELECT_TXN_MIN_COMMIT_TIME_FOR_NODE_TYPE, (Object)txnQuery);
    }

    @Override
    protected Long selectMinTxnId() {
        return (Long)this.template.selectOne(SELECT_TXN_MIN_ID);
    }

    @Override
    protected Long selectMinUnusedTxnCommitTime() {
        return (Long)this.template.selectOne(SELECT_TXN_UNUSED_MIN_COMMIT_TIME);
    }

    @Override
    protected Long selectMaxTxnId() {
        return (Long)this.template.selectOne(SELECT_TXN_MAX_ID);
    }

    @Override
    public int countChildAssocsByParent(Long parentNodeId, boolean isPrimary) {
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        ChildAssocEntity childAssoc = new ChildAssocEntity();
        childAssoc.setParentNode(parentNode);
        childAssoc.setPrimary(isPrimary);
        return (Integer)this.template.selectOne(COUNT_CHILD_ASSOC_BY_PARENT_ID, (Object)childAssoc);
    }

    @Override
    protected Long selectMinTxInNodeIdRange(Long fromNodeId, Long toNodeId) {
        NodeRangeEntity nodeRangeEntity = new NodeRangeEntity();
        nodeRangeEntity.setFromNodeId(fromNodeId);
        nodeRangeEntity.setToNodeId(toNodeId);
        return (Long)this.template.selectOne(SELECT_TXN_MIN_TX_ID_IN_NODE_IDRANGE, (Object)nodeRangeEntity);
    }

    @Override
    protected Long selectMaxTxInNodeIdRange(Long fromNodeId, Long toNodeId) {
        NodeRangeEntity nodeRangeEntity = new NodeRangeEntity();
        nodeRangeEntity.setFromNodeId(fromNodeId);
        nodeRangeEntity.setToNodeId(toNodeId);
        return (Long)this.template.selectOne(SELECT_TXN_MAX_TX_ID_IN_NODE_IDRANGE, (Object)nodeRangeEntity);
    }

    @Override
    public Long selectNextTxCommitTime(Long fromCommitTime) {
        TransactionQueryEntity fromCommitTimeEntity = new TransactionQueryEntity();
        fromCommitTimeEntity.setMinCommitTime(fromCommitTime);
        return (Long)this.template.selectOne(SELECT_TXN_NEXT_TXN_COMMIT_TIME, (Object)fromCommitTimeEntity);
    }

    @Override
    public Iterator<Long> selectDeletedNodesByCommitTime(long maxCommitTime) {
        Pair<Long, QName> deletedTypePair = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        if (deletedTypePair == null) {
            return null;
        }
        TransactionQueryEntity transactionQueryEntity = new TransactionQueryEntity();
        transactionQueryEntity.setMaxCommitTime(maxCommitTime);
        transactionQueryEntity.setTypeQNameId((Long)deletedTypePair.getFirst());
        Cursor cursor = this.template.selectCursor(SELECT_NODES_DELETED_BY_TXN_COMMIT_TIME, (Object)transactionQueryEntity);
        return cursor.iterator();
    }

    @Override
    public Iterator<Long> selectUnusedTransactionsByCommitTime(long maxCommitTime) {
        TransactionQueryEntity maxCommitTimeEntity = new TransactionQueryEntity();
        maxCommitTimeEntity.setMaxCommitTime(maxCommitTime);
        Cursor cursor = this.template.selectCursor(SELECT_TXNS_UNUSED_BY_TXN_COMMIT_TIME, (Object)maxCommitTimeEntity);
        return cursor.iterator();
    }

    @Override
    public List<String> purgeDeletedNodes(long minAge, int deleteBatchSize) {
        int count;
        long maxCommitTime = System.currentTimeMillis() - minAge;
        Iterator<Long> nodeIdIterator = this.selectDeletedNodesByCommitTime(maxCommitTime);
        ArrayList<Long> nodeIdList = new ArrayList<Long>();
        ArrayList<String> deleteResult = new ArrayList<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("nodes selected for deletion, deleteBatchSize:" + deleteBatchSize));
        }
        while (nodeIdIterator != null && nodeIdIterator.hasNext()) {
            if (deleteBatchSize == nodeIdList.size()) {
                count = this.deleteSelectedNodesAndProperties(nodeIdList);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("nodes deleted:" + count));
                }
                deleteResult.add("Purged old nodes: " + count);
                nodeIdList.clear();
                continue;
            }
            nodeIdList.add(nodeIdIterator.next());
        }
        if (nodeIdList.size() > 0) {
            count = this.deleteSelectedNodesAndProperties(nodeIdList);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("remaining nodes deleted:" + count));
            }
            deleteResult.add("Purged old nodes: " + count);
            nodeIdList.clear();
        }
        return deleteResult;
    }

    @Override
    public List<String> purgeEmptyTransactions(long minAge, int deleteBatchSize) {
        int count;
        long maxCommitTime = System.currentTimeMillis() - minAge;
        Iterator<Long> transactionIdIterator = this.selectUnusedTransactionsByCommitTime(maxCommitTime);
        ArrayList<Long> transactionIdList = new ArrayList<Long>();
        ArrayList<String> deleteResult = new ArrayList<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("transactions selected for deletion, deleteBatchSize:" + deleteBatchSize));
        }
        while (transactionIdIterator.hasNext()) {
            if (deleteBatchSize == transactionIdList.size()) {
                count = this.deleteSelectedTransactions(transactionIdList);
                deleteResult.add("Purged old transactions: " + count);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("transactions deleted:" + count));
                }
                transactionIdList.clear();
                continue;
            }
            transactionIdList.add(transactionIdIterator.next());
        }
        if (transactionIdList.size() > 0) {
            count = this.deleteSelectedTransactions(transactionIdList);
            deleteResult.add("Purged old transactions: " + count);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("final batch of transactions deleted:" + count));
            }
            transactionIdList.clear();
        }
        return deleteResult;
    }

    private int deleteSelectedNodesAndProperties(List<Long> nodeIdList) {
        int cnt = this.template.delete(DELETE_NODE_PROPS_BY_NODE_ID, nodeIdList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("nodes props deleted:" + cnt));
        }
        cnt = this.template.delete(DELETE_NODES_BY_ID, nodeIdList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("nodes  deleted:" + cnt));
        }
        return cnt;
    }

    private int deleteSelectedTransactions(List<Long> transactionIdList) {
        return this.template.delete(DELETE_TXNS_UNUSED_BY_ID, transactionIdList);
    }

    private class ChildAssocResultHandler
    implements ResultHandler {
        private final ChildAssocResultHandlerFilter filter;
        private final NodeDAO.ChildAssocRefQueryCallback resultsCallback;
        private boolean more = true;

        private ChildAssocResultHandler(NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
            this(null, resultsCallback);
        }

        private ChildAssocResultHandler(ChildAssocResultHandlerFilter filter, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
            this.filter = filter;
            this.resultsCallback = resultsCallback;
        }

        public void handleResult(ResultContext context) {
            Pair<Long, NodeRef> childNodePair;
            Pair<Long, NodeRef> parentNodePair;
            if (!this.more) {
                return;
            }
            ChildAssocEntity assoc = (ChildAssocEntity)context.getResultObject();
            if (this.filter != null && !this.filter.isResult(assoc)) {
                return;
            }
            Pair<Long, ChildAssociationRef> childAssocPair = assoc.getPair(NodeDAOImpl.this.qnameDAO);
            boolean more = this.resultsCallback.handle(childAssocPair, parentNodePair = assoc.getParentNode().getNodePair(), childNodePair = assoc.getChildNode().getNodePair());
            if (!more) {
                this.more = false;
            }
        }
    }

    private static interface ChildAssocResultHandlerFilter {
        public boolean isResult(ChildAssocEntity var1);
    }

    public static class MSSQL
    extends NodeDAOImpl {
        private SqlSessionTemplate template;

        @Override
        public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
            super.setSqlSessionTemplate(sqlSessionTemplate);
            this.template = sqlSessionTemplate;
        }

        @Override
        protected void deleteSubscriptions(Long nodeId) {
            this.template.delete(NodeDAOImpl.DELETE_SUBSCRIPTIONS, (Object)nodeId);
        }
    }

    public static class MySQL
    extends NodeDAOImpl {
        private static final String DELETE_TXNS_UNUSED_MYSQL = "alfresco.node.delete_Txns_Unused_MySQL";
        private SqlSessionTemplate template;

        @Override
        public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
            super.setSqlSessionTemplate(sqlSessionTemplate);
            this.template = sqlSessionTemplate;
        }

        @Override
        public int deleteTxnsUnused(long fromCommitTime, long toCommitTime) {
            TransactionQueryEntity txnQuery = new TransactionQueryEntity();
            txnQuery.setMinCommitTime(fromCommitTime);
            txnQuery.setMaxCommitTime(toCommitTime);
            int numDeleted = this.template.delete(DELETE_TXNS_UNUSED_MYSQL, (Object)txnQuery);
            return numDeleted;
        }
    }

    public static class MySQLClusterNDB
    extends MySQL {
        @Override
        protected Long newNodeImplInsert(NodeEntity node) {
            Long id = null;
            try {
                NodeRef targetNodeRef = node.getNodeRef();
                NodeEntity dbTargetNode = this.selectNodeByNodeRef(targetNodeRef);
                if (dbTargetNode != null) {
                    if (dbTargetNode.getDeleted(this.qnameDAO)) {
                        Long dbTargetNodeId = dbTargetNode.getId();
                        this.deleteNodeProperties(dbTargetNodeId, (Set<Long>)null);
                        this.deleteNodeById(dbTargetNodeId);
                    } else {
                        throw new NodeExistsException(dbTargetNode.getNodePair(), null);
                    }
                }
                id = this.insertNode(node);
            }
            catch (Throwable e) {
                if (e instanceof NodeExistsException) {
                    throw e;
                }
                throw new AlfrescoRuntimeException("Failed to insert new node: " + node, e);
            }
            return id;
        }

        @Override
        protected Long newChildAssocInsert(ChildAssocEntity assoc, QName assocTypeQName, String childNodeName) {
            return this.newChildAssocInsertImpl(assoc, assocTypeQName, childNodeName);
        }

        @Override
        protected int setChildAssocsUniqueNameImpl(Long childNodeId, String childName) {
            return this.updateChildAssocUniqueNameImpl(childNodeId, childName);
        }

        @Override
        protected void updatePrimaryParentAssocs(ChildAssocEntity primaryParentAssoc, Node newParentNode, Node childNode, Long newChildNodeId, String childNodeName, Long oldParentNodeId, QName assocTypeQName, QName assocQName) {
            this.updatePrimaryParentAssocsImpl(primaryParentAssoc, newParentNode, childNode, newChildNodeId, childNodeName, oldParentNodeId, assocTypeQName, assocQName);
        }
    }
}

