/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.Event2MessageProducer;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class EventGeneratorQueue
implements InitializingBean {
    protected static final Log LOGGER = LogFactory.getLog(EventGeneratorQueue.class);
    protected Executor enqueueThreadPoolExecutor;
    protected Executor dequeueThreadPoolExecutor;
    protected Event2MessageProducer event2MessageProducer;
    protected BlockingQueue<EventInMaking> queue = new LinkedBlockingQueue<EventInMaking>();
    protected Runnable listener = this.createListener();

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"enqueueThreadPoolExecutor", (Object)this.enqueueThreadPoolExecutor);
        PropertyCheck.mandatory((Object)this, (String)"dequeueThreadPoolExecutor", (Object)this.dequeueThreadPoolExecutor);
        PropertyCheck.mandatory((Object)this, (String)"event2MessageProducer", (Object)this.event2MessageProducer);
    }

    public void setEvent2MessageProducer(Event2MessageProducer event2MessageProducer) {
        this.event2MessageProducer = event2MessageProducer;
    }

    public void setEnqueueThreadPoolExecutor(Executor enqueueThreadPoolExecutor) {
        this.enqueueThreadPoolExecutor = enqueueThreadPoolExecutor;
    }

    public void setDequeueThreadPoolExecutor(Executor dequeueThreadPoolExecutor) {
        this.dequeueThreadPoolExecutor = dequeueThreadPoolExecutor;
        dequeueThreadPoolExecutor.execute(this.listener);
    }

    public void accept(Callable<RepoEvent<?>> maker) {
        EventInMaking eventInMaking = new EventInMaking(maker);
        this.queue.offer(eventInMaking);
        this.enqueueThreadPoolExecutor.execute(() -> {
            try {
                eventInMaking.make();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unexpected error while enqueuing maker function for repository event" + e));
            }
        });
    }

    private Runnable createListener() {
        return new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    private static class EventInMaking {
        private Callable<RepoEvent<?>> maker;
        private volatile RepoEvent<?> event;
        private CountDownLatch latch;

        public EventInMaking(Callable<RepoEvent<?>> maker) {
            this.maker = maker;
            this.latch = new CountDownLatch(1);
        }

        public void make() throws Exception {
            try {
                this.event = this.maker.call();
            }
            finally {
                this.latch.countDown();
            }
        }

        public RepoEvent<?> getEventWhenReady() throws InterruptedException {
            this.latch.await(30L, TimeUnit.SECONDS);
            return this.event;
        }

        public String toString() {
            return this.maker.toString();
        }
    }
}

