/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.impl.AbstractCategoryServiceImpl;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class SolrCategoryServiceImpl
extends AbstractCategoryServiceImpl {
    @Override
    public List<Pair<NodeRef, Integer>> getTopCategories(StoreRef storeRef, QName aspectName, int count) {
        AspectDefinition definition = this.dictionaryService.getAspect(aspectName);
        if (definition == null) {
            throw new IllegalStateException("Unknown aspect");
        }
        QName catProperty = null;
        Map properties = definition.getProperties();
        for (QName pName : properties.keySet()) {
            PropertyDefinition def;
            if (!pName.getNamespaceURI().equals(aspectName.getNamespaceURI()) || !pName.getLocalName().equalsIgnoreCase(aspectName.getLocalName()) || !(def = (PropertyDefinition)properties.get(pName)).getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) continue;
            catProperty = pName;
        }
        if (catProperty == null) {
            throw new IllegalStateException("Aspect does not have category property mirroring the aspect name");
        }
        String field = "@" + catProperty;
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("index-fts-alfresco");
        sp.addStore(storeRef);
        sp.setQuery(catProperty + ":*");
        SearchParameters.FieldFacet ff = new SearchParameters.FieldFacet(field);
        ff.setLimitOrNull(Integer.valueOf(count));
        sp.addFieldFacet(ff);
        try (ResultSet resultSet = null;){
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(sp);
            List facetCounts = resultSet.getFieldFacet(field);
            LinkedList<Pair<NodeRef, Integer>> answer = new LinkedList<Pair<NodeRef, Integer>>();
            for (Pair term : facetCounts) {
                NodeRef nodeRef = new NodeRef((String)term.getFirst());
                Pair toAdd = this.nodeService.exists(nodeRef) ? new Pair((Object)nodeRef, (Object)((Integer)term.getSecond())) : new Pair(null, (Object)((Integer)term.getSecond()));
                answer.add((Pair<NodeRef, Integer>)toAdd);
            }
            LinkedList<Pair<NodeRef, Integer>> linkedList = answer;
            return linkedList;
        }
    }
}

