/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.template.TemplateSource;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class ClassPathRepoTemplateLoader
implements TemplateLoader {
    private NodeService nodeService;
    private ContentService contentService;
    private String encoding;

    public ClassPathRepoTemplateLoader(NodeService nodeService, ContentService contentService, String encoding) {
        if (nodeService == null) {
            throw new IllegalArgumentException("NodeService is mandatory.");
        }
        if (contentService == null) {
            throw new IllegalArgumentException("ContentService is mandatory.");
        }
        this.nodeService = nodeService;
        this.contentService = contentService;
        this.encoding = encoding;
    }

    public Object findTemplateSource(String name) throws IOException {
        ClassLoader classLoader;
        URL url;
        if (name.indexOf("://") != -1) {
            NodeRef ref = new NodeRef(name);
            if (this.nodeService.exists(ref)) {
                return new RepoTemplateSource(ref);
            }
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return (url = (classLoader = this.getClass().getClassLoader()).getResource(name)) == null ? null : new ClassPathTemplateSource(classLoader, name, this.encoding);
    }

    public long getLastModified(Object templateSource) {
        return ((BaseTemplateSource)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (encoding != null) {
            return ((BaseTemplateSource)templateSource).getReader(encoding);
        }
        return ((BaseTemplateSource)templateSource).getReader(this.encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((BaseTemplateSource)templateSource).close();
    }

    abstract class BaseTemplateSource
    implements TemplateSource {
        BaseTemplateSource() {
        }

        @Override
        public abstract Reader getReader(String var1) throws IOException;

        @Override
        public abstract void close() throws IOException;

        @Override
        public abstract long lastModified();

        @Override
        public InputStream getResource(String name) {
            return this.getRelativeResource(name);
        }

        protected abstract InputStream getRelativeResource(String var1);
    }

    class ClassPathTemplateSource
    extends BaseTemplateSource {
        private final URL url;
        private URLConnection conn;
        private InputStream inputStream;
        private String encoding;
        private ClassLoader classLoader;
        private String resourceName;

        ClassPathTemplateSource(ClassLoader classLoader, String name, String encoding) throws IOException {
            this.classLoader = classLoader;
            this.resourceName = name;
            this.url = classLoader.getResource(name);
            this.conn = this.url.openConnection();
            this.encoding = encoding;
        }

        public String toString() {
            return this.url.toString();
        }

        @Override
        public long lastModified() {
            return this.conn.getLastModified();
        }

        @Override
        public Reader getReader(String encoding) throws IOException {
            this.inputStream = this.conn.getInputStream();
            if (encoding != null) {
                return new InputStreamReader(this.inputStream, encoding);
            }
            return new InputStreamReader(this.inputStream);
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            finally {
                this.inputStream = null;
                this.conn = null;
            }
        }

        @Override
        protected InputStream getRelativeResource(String name) {
            int lastSlash;
            String newResourceName = name;
            if (!name.startsWith("/") && (lastSlash = this.resourceName.lastIndexOf(47)) != -1) {
                newResourceName = String.valueOf(name.substring(0, lastSlash)) + "/" + name;
            }
            URL url = this.classLoader.getResource(newResourceName);
            try {
                return url == null ? null : url.openConnection().getInputStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    class RepoTemplateSource
    extends BaseTemplateSource {
        private final NodeRef nodeRef;
        private InputStream inputStream;
        private ContentReader conn;

        RepoTemplateSource(NodeRef ref) throws IOException {
            this.nodeRef = ref;
            this.conn = ClassPathRepoTemplateLoader.this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        }

        public boolean equals(Object o) {
            if (o instanceof RepoTemplateSource) {
                return this.nodeRef.equals((Object)((RepoTemplateSource)o).nodeRef);
            }
            return false;
        }

        public int hashCode() {
            return this.nodeRef.hashCode();
        }

        public String toString() {
            return this.nodeRef.toString();
        }

        @Override
        public long lastModified() {
            return this.conn.getLastModified();
        }

        @Override
        public Reader getReader(String encoding) throws IOException {
            this.inputStream = this.conn.getContentInputStream();
            return new InputStreamReader(this.inputStream, this.conn.getEncoding());
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            finally {
                this.inputStream = null;
                this.conn = null;
            }
        }

        @Override
        protected InputStream getRelativeResource(String name) {
            ContentReader contentReader;
            InputStream stream = null;
            NodeRef parentRef = ClassPathRepoTemplateLoader.this.nodeService.getPrimaryParent(this.nodeRef).getParentRef();
            NodeRef child = ClassPathRepoTemplateLoader.this.nodeService.getChildByName(parentRef, ContentModel.ASSOC_CONTAINS, name);
            if (child != null && (contentReader = ClassPathRepoTemplateLoader.this.contentService.getReader(child, ContentModel.PROP_CONTENT)).exists()) {
                stream = contentReader.getContentInputStream();
            }
            return stream;
        }
    }
}

