/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.io.LineNumberReader;
import org.springframework.core.io.support.EncodedResource;

public abstract class DBScriptUtil {
    private static final String DEFAULT_SCRIPT_COMMENT_PREFIX = "--";

    public static String readScript(EncodedResource resource) throws IOException {
        return DBScriptUtil.readScript(resource, DEFAULT_SCRIPT_COMMENT_PREFIX);
    }

    private static String readScript(EncodedResource resource, String lineCommentPrefix) throws IOException {
        try (LineNumberReader lineNumberReader = new LineNumberReader(resource.getReader());){
            String string = DBScriptUtil.readScript(lineNumberReader, lineCommentPrefix);
            return string;
        }
    }

    private static String readScript(LineNumberReader lineNumberReader, String lineCommentPrefix) throws IOException {
        String statement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (statement != null) {
            if (lineCommentPrefix != null && !statement.startsWith(lineCommentPrefix)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(statement);
            }
            statement = lineNumberReader.readLine();
        }
        return scriptBuilder.toString();
    }
}

