/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.PostgreSQLDialect;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.search.DocumentNavigator;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.NodeServiceXPath;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.search.SearcherComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.ISO9075;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SearcherComponentTest
extends BaseSpringTest {
    private static String COMPLEX_LOCAL_NAME = " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_";
    private static String COMPLEX_LOCAL_NAME_NO_U0000 = " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\[]{};'#:@~,./<>?\\u007c_xT65A_";
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private SearcherComponent searcher;
    private NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    private NodeRef rootNodeRef;
    private UserTransaction txn;
    private Dialect dialect;

    @Before
    public void setUp() throws Exception {
        this.dialect = (Dialect)this.applicationContext.getBean("dialect");
        if (this.dialect instanceof PostgreSQLDialect) {
            COMPLEX_LOCAL_NAME = COMPLEX_LOCAL_NAME_NO_U0000;
        }
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.dictionaryService = BaseNodeServiceTest.loadModel(this.applicationContext);
        this.nodeService = this.serviceRegistry.getNodeService();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        IndexerAndSearcher indexerAndSearcher = (IndexerAndSearcher)this.applicationContext.getBean("indexerAndSearcherFactory");
        this.searcher = new SearcherComponent();
        this.searcher.setIndexerAndSearcherFactory(indexerAndSearcher);
        StoreRef storeRef = this.nodeService.createStore("workspace", String.valueOf(this.getName()) + "_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    @After
    public void tearDown() throws Exception {
        if (this.txn.getStatus() == 0) {
            this.txn.rollback();
        }
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    @Test
    public void testNodeXPath() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)COMPLEX_LOCAL_NAME), "monkey");
        QName qnamerequiringescaping = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)COMPLEX_LOCAL_NAME);
        this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, qnamerequiringescaping, ContentModel.TYPE_CONTAINER);
        QName qname = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n2_p_n4");
        DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver(null);
        namespacePrefixResolver.registerNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        DocumentNavigator documentNavigator = new DocumentNavigator(this.dictionaryService, this.nodeService, (SearchService)this.searcher, (NamespacePrefixResolver)namespacePrefixResolver, false, false);
        NodeServiceXPath xpath = new NodeServiceXPath("//.[@test:animal='monkey']", documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        List list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpath = new NodeServiceXPath("*", documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)3, (int)list.size());
        xpath = new NodeServiceXPath("*/*", documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)5, (int)list.size());
        xpath = new NodeServiceXPath("*/*/*", documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)3, (int)list.size());
        xpath = new NodeServiceXPath("*/*/*/*", documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)2, (int)list.size());
        xpath = new NodeServiceXPath("*/*/*/*/..", documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)2, (int)list.size());
        xpath = new NodeServiceXPath("*//.", documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)13, (int)list.size());
        String xpathStr = "test:root_p_n1";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpathStr = "*//.[@test:animal]";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpathStr = "*//.[@test:animal='monkey']";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpathStr = "//.[@test:animal='monkey']";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        QueryParameterDefImpl paramDef = new QueryParameterDefImpl(QName.createQName((String)"test:test", (NamespacePrefixResolver)namespacePrefixResolver), this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, "monkey");
        xpathStr = "//.[@test:animal=$test:test]";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, new QueryParameterDefinition[]{paramDef});
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpath = new NodeServiceXPath(".", documentNavigator, null);
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpath = new NodeServiceXPath("/test:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME), documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpath = new NodeServiceXPath("//test:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME), documentNavigator, null);
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpath = new NodeServiceXPath("..", documentNavigator, null);
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        documentNavigator.setFollowAllParentLinks(true);
        xpath = new NodeServiceXPath("..", documentNavigator, null);
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)2, (int)list.size());
        xpathStr = "//@test:animal";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        SearcherComponentTest.assertTrue((boolean)(list.get(0) instanceof DocumentNavigator.Property));
        xpathStr = "//@test:reference";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        documentNavigator.setFollowAllParentLinks(false);
        xpathStr = "deref(/test:root_p_n1/test:n1_p_n3/@test:reference, '*')";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpathStr = "deref(/test:root_p_n1/test:n1_p_n3/@test:reference, 'test:root_p_n1')";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)0, (int)list.size());
        xpathStr = "deref(/test:root_p_n1/test:n1_p_n3/@test:reference, 'test:root_p_n2')";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        paramDef = new QueryParameterDefImpl(QName.createQName((String)"test:type", (NamespacePrefixResolver)namespacePrefixResolver), this.dictionaryService.getDataType(DataTypeDefinition.QNAME), true, BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT.toPrefixString((NamespacePrefixResolver)namespacePrefixResolver));
        xpathStr = "//.[subtypeOf($test:type)]";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, new QueryParameterDefinition[]{paramDef});
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)3, (int)list.size());
        xpath = new NodeServiceXPath("/", documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)assocRefs.get(qname));
        SearcherComponentTest.assertEquals((int)1, (int)list.size());
        xpathStr = "test:root_p_n1 | test:root_p_n2";
        xpath = new NodeServiceXPath(xpathStr, documentNavigator, null);
        xpath.addNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        list = xpath.selectNodes((Object)new ChildAssociationRef(null, null, null, this.rootNodeRef));
        SearcherComponentTest.assertEquals((int)2, (int)list.size());
    }

    @Test
    public void testSelectAPI() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        NodeRef n6Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n3_p_n6")).getChildRef();
        DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver(null);
        namespacePrefixResolver.registerNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        List answer = this.searcher.selectNodes(this.rootNodeRef, "/test:root_p_n1/test:n1_p_n3/*", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n6Ref));
        answer = this.searcher.selectNodes(this.rootNodeRef, "*", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)2, (int)answer.size());
        List attributes = this.searcher.selectProperties(this.rootNodeRef, "//@test:animal", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)attributes.size());
        NodeRef n1 = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n1")).getChildRef();
        NodeRef n2 = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n2")).getChildRef();
        answer = this.searcher.selectNodes(this.rootNodeRef, "test:root_p_n1 | test:root_p_n2", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)2, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n1));
        SearcherComponentTest.assertTrue((boolean)answer.contains(n2));
        NodeRef n3 = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n1_p_n3")).getChildRef();
        answer = this.searcher.selectNodes(this.rootNodeRef, "//@test:animal", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n3));
        answer = this.searcher.selectNodes(this.rootNodeRef, "*//.[@test:animal]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n3));
        answer = this.searcher.selectNodes(this.rootNodeRef, "*//.[@test:animal='monkey']", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n3));
        answer = this.searcher.selectNodes(this.rootNodeRef, "//.[@test:animal='monkey']", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n3));
        answer = this.searcher.selectNodes(this.rootNodeRef, "*//.[@test:animal='monkey']", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n3));
        answer = this.searcher.selectNodes(this.rootNodeRef, "//@*", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)9, (int)answer.size());
        QName qname = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"my@test_with_at_sign");
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mytest"), "my@test_value_with_at_sign");
        ChildAssociationRef assoc = this.nodeService.createNode(n1, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, qname, ContentModel.TYPE_CONTAINER, properties);
        NodeRef n4 = assoc.getChildRef();
        StringBuffer path = new StringBuffer().append("test:root_p_n1/").append(ISO9075.getXPathName((QName)qname, (NamespacePrefixResolver)namespacePrefixResolver));
        answer = this.searcher.selectNodes(this.rootNodeRef, path.toString(), null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n4));
        String xpathQuery = "//*[@test:mytest='my@test_value_with_at_sign']";
        answer = this.searcher.selectNodes(this.rootNodeRef, xpathQuery, null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertTrue((boolean)answer.contains(n4));
    }

    public void xtestLikeAndContains() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)COMPLEX_LOCAL_NAME), "monkey");
        QName qnamerequiringescaping = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)COMPLEX_LOCAL_NAME);
        this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, qnamerequiringescaping, ContentModel.TYPE_CONTAINER, properties);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver(null);
        namespacePrefixResolver.registerNamespace("test", "http://www.alfresco.org/test/BaseNodeServiceTest");
        List answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'm__k%', false)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        System.out.println("Encoded = " + ISO9075.encode((String)COMPLEX_LOCAL_NAME));
        String roundTrip = ISO9075.decode((String)ISO9075.encode((String)COMPLEX_LOCAL_NAME));
        int i = 0;
        while (i < COMPLEX_LOCAL_NAME.length() && 1 < roundTrip.length()) {
            System.out.println("Char at " + i + " = " + Integer.toHexString(COMPLEX_LOCAL_NAME.charAt(i)) + "   ...    " + Integer.toHexString(roundTrip.charAt(i)));
            ++i;
        }
        SearcherComponentTest.assertEquals((String)COMPLEX_LOCAL_NAME, (String)roundTrip);
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME) + ", 'm__k%', false)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:animal, 'M__K%', false)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME) + ", 'M__K%', false)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:UPPERANIMAL, 'm__k%', false)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:UPPERANIMAL, 'M__K%', false)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[like(@test:UPPERANIMAL, 'M__K%', true)]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[contains('monkey')]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)2, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[contains('MONKEY')]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)2, (int)answer.size());
        answer = this.searcher.selectNodes(this.rootNodeRef, "//*[contains(lower-case('MONKEY'))]", null, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)2, (int)answer.size());
        QueryParameterDefinition[] paramDefs = new QueryParameterDefinition[]{new QueryParameterDefImpl(QName.createQName((String)"test:animal", (NamespacePrefixResolver)namespacePrefixResolver), this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, "monkey%"), new QueryParameterDefImpl(QName.createQName((String)"test:type", (NamespacePrefixResolver)namespacePrefixResolver), this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, BaseNodeServiceTest.TYPE_QNAME_TEST_CONTENT.toString())};
        answer = this.searcher.selectNodes(this.rootNodeRef, "./*/*[like(@test:animal, $test:animal, false) or subtypeOf($test:type)]", paramDefs, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        NodeRef n1Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n1")).getChildRef();
        NodeRef n3Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n1_p_n3")).getChildRef();
        answer = this.searcher.selectNodes(n1Ref, "./*/*[like(@test:animal, $test:animal, false) or subtypeOf($test:type)]", paramDefs, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)0, (int)answer.size());
        answer = this.searcher.selectNodes(n1Ref, "./*[like(@test:animal, $test:animal, false) or subtypeOf($test:type)]", paramDefs, (NamespacePrefixResolver)namespacePrefixResolver, false);
        SearcherComponentTest.assertEquals((int)1, (int)answer.size());
        SearcherComponentTest.assertFalse((String)"Incorrect result: search root node pulled back", (boolean)answer.contains(n1Ref));
        SearcherComponentTest.assertTrue((String)"Incorrect result: incorrect node retrieved", (boolean)answer.contains(n3Ref));
    }

    public static void main(String[] args) {
        String escape = "\\\t\n\"";
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        int i = 0;
        while (i < COMPLEX_LOCAL_NAME.length()) {
            if (escape.indexOf(COMPLEX_LOCAL_NAME.charAt(i)) != -1) {
                builder.append(COMPLEX_LOCAL_NAME.charAt(i));
            } else {
                String part = Integer.toHexString(COMPLEX_LOCAL_NAME.charAt(i));
                builder.append("\\u");
                if (part.length() == 0) {
                    builder.append("000");
                }
                if (part.length() == 1) {
                    builder.append("000");
                }
                if (part.length() == 2) {
                    builder.append("00");
                }
                if (part.length() == 3) {
                    builder.append("0");
                }
                builder.append(part);
                System.out.println(String.valueOf(COMPLEX_LOCAL_NAME.charAt(i)) + " = " + part);
            }
            ++i;
        }
        builder.append("\"");
        System.out.println(builder.toString());
    }
}

