/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.PerformanceTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.JUnitCore;
import org.springframework.context.ApplicationContext;

@Category(value={PerformanceTests.class})
public class SiteServiceTestHuge {
    private static final int NUM_USERS = 100;
    private static final int NUM_GROUPS = 60;
    private static int NUM_SITES = 60000;
    private static final String ADMIN_USER = "admin";
    private static final long SECOND = 1000L;
    private static final long FIVE_SECONDS = 5000L;
    private static final long MAX_CREATE_USER_MS = 5000L;
    private static final long MAX_CREATE_GROUP_MS = 5000L;
    private static final long MAX_CREATE_SITE_MS = 5000L;
    private static final long MAX_DELETE_USER_MS = 5000L;
    private static final long MAX_DELETE_GROUP_MS = 5000L;
    private static final long MAX_DELETE_SITE_MS = 5000L;
    private static final long MAX_USER_TO_GROUP_MS = 5000L;
    private static final long MAX_USER_TO_SITE_MS = 5000L;
    private static final long MAX_GROUP_TO_SITE_MS = 5000L;
    private static int usersCreated = 0;
    private static int groupsCreated = 0;
    private static int sitesCreated = 0;
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static TransactionService transactionService = (TransactionService)ctx.getBean("TransactionService");
    private static AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
    private static MutableAuthenticationService authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
    private static PersonService personService = (PersonService)ctx.getBean("PersonService");
    private static AuthorityService authorityService = (AuthorityService)ctx.getBean("AuthorityService");
    private static SiteService siteService = (SiteService)ctx.getBean("SiteService");
    private static String logFilename;
    private static PrintStream log;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logFilename = "sites.log";
    }

    @AfterClass
    public static void tearDownClass() {
        if (log != null) {
            log.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
    }

    @After
    public void tearDown() throws Exception {
        authenticationComponent.clearCurrentSecurityContext();
    }

    private void log(String msg) throws Exception {
        System.out.println(msg);
        if (logFilename != null) {
            if (log == null) {
                log = new PrintStream(new File(logFilename));
            }
            log.println(msg);
        }
    }

    private void createAndAllocate(int userCount, int groupCount, int siteCount, Allocation usersToGroups, Allocation usersToSites, Allocation groupsToSites) throws Exception {
        this.createUsersGroupsAndSites(userCount, groupCount, siteCount);
        this.allocateUsersToGroupsAndSites(userCount, groupCount, siteCount, usersToGroups, usersToSites, groupsToSites);
    }

    private void createUsersGroupsAndSites(int userCount, int groupCount, int siteCount) throws Exception {
        this.createUsers(userCount);
        this.createGroups(groupCount);
        this.createSites(siteCount, userCount, 0, OnFailure.GIVE_UP);
    }

    private void allocateUsersToGroupsAndSites(int userCount, int groupCount, int siteCount, Allocation usersToGroups, Allocation usersToSites, Allocation groupsToSites) throws Exception {
        if (usersToGroups == Allocation.ALL_TO_EACH && usersToSites == Allocation.NONE && groupsToSites == Allocation.ROUND_ROBIN_TO_TARGET || usersToGroups == Allocation.NONE && usersToSites == Allocation.ALL_TO_EACH && groupsToSites == Allocation.NONE) {
            this.allocateUsersToGroups(userCount, groupCount, usersToGroups);
            this.allocateUsersToSites(userCount, siteCount, usersToSites);
            this.allocateGroupsToSites(groupCount, siteCount, groupsToSites, userCount, 0, OnFailure.GIVE_UP);
        } else {
            Assert.fail((String)"Users are not able to see all sites or can see a site directly and via a group");
        }
    }

    private void addMoreSites(int sitesToAdd, OnFailure onFailureAction) throws Exception {
        this.log("\n\n ADD " + sitesToAdd + " MORE SITES AND ADD A GROUP TO EACH");
        Allocation groupsToSites = Allocation.ROUND_ROBIN_TO_TARGET;
        int sitesAlreadyCreated = sitesCreated;
        int siteCount = sitesAlreadyCreated + sitesToAdd;
        long ms = System.currentTimeMillis();
        this.createSites(siteCount, 100, sitesAlreadyCreated, OnFailure.GIVE_UP);
        this.allocateGroupsToSites(60, siteCount, groupsToSites, 100, sitesAlreadyCreated, OnFailure.KEEP_GOING);
        this.assertTime("Add more sites", sitesAlreadyCreated + 1, sitesToAdd, ms, 10000L, onFailureAction, sitesToAdd);
    }

    private void assertTime(String what, int id1, int id2, long start, long max) throws Exception {
        this.assertTime(what, id1, id2, start, max, OnFailure.GIVE_UP, 1);
    }

    private void assertTime(String what, int id1, int id2, long start, long max, OnFailure onFailureAction, int blockSize) throws Exception {
        long ms = (System.currentTimeMillis() - start) / (long)blockSize;
        String msg = String.valueOf(what) + "," + id1 + (id2 > 0 ? "," + id2 : "") + "," + ms + ",ms" + (blockSize == 1 ? "" : " average for," + blockSize);
        this.log(msg);
        if (ms > max && onFailureAction == OnFailure.GIVE_UP) {
            Assert.fail((String)(String.valueOf(msg) + " is longer than " + max));
        }
    }

    private void createUsers(int userCount) throws Exception {
        int userId = 1;
        while (true) {
            long ms;
            boolean exists;
            String userName = this.getUserName(userId);
            boolean bl = exists = userId <= usersCreated || personService.personExists(userName);
            if (userId <= userCount) {
                if (!exists) {
                    ms = System.currentTimeMillis();
                    this.createUser(userName);
                    this.assertTime("Create user", userId, -1, ms, 5000L);
                }
            } else {
                if (!exists) break;
                ms = System.currentTimeMillis();
                this.deleteUser(userName);
                this.assertTime("Delete user", userId, -1, ms, 5000L);
            }
            ++userId;
        }
        usersCreated = userCount;
    }

    private void createGroups(int groupCount) throws Exception {
        int groupId = 1;
        while (true) {
            long ms;
            boolean exists;
            String groupName = this.getGroupName(groupId);
            String groupAuthorityName = authorityService.getName(AuthorityType.GROUP, groupName);
            boolean bl = exists = groupId <= groupsCreated || authorityService.authorityExists(groupAuthorityName);
            if (groupId <= groupCount) {
                if (!exists) {
                    ms = System.currentTimeMillis();
                    this.createGroup(groupName);
                    this.assertTime("Create group", groupId, -1, ms, 5000L);
                }
            } else {
                if (!exists) break;
                ms = System.currentTimeMillis();
                this.deleteGroup(groupName);
                this.assertTime("Delete group", groupId, -1, ms, 5000L);
            }
            ++groupId;
        }
        groupsCreated = groupCount;
    }

    private void createSites(int siteCount, int userCount, int sitesAlreadyCreated, OnFailure onFailureAction) throws Exception {
        int siteId = sitesAlreadyCreated + 1;
        while (true) {
            boolean exists;
            String siteName = this.getSiteName(siteId);
            boolean bl = exists = siteId <= sitesCreated || siteService.getSite(siteName) != null;
            if (siteId <= siteCount) {
                if (!exists) {
                    String siteOwnerUserName = this.getSiteOwnerUserName(siteId, userCount);
                    this.creatSite(siteId, siteOwnerUserName, onFailureAction);
                }
            } else if (!exists) {
                if (siteId >= siteCount + 1) {
                    break;
                }
            } else {
                long ms = System.currentTimeMillis();
                this.deleteSite(siteName, null);
                this.assertTime("Delete site", siteId, -1, ms, 5000L);
            }
            ++siteId;
        }
        sitesCreated = siteCount;
    }

    private void deleteSites(int fromSiteId, int toSiteId, OnFailure onFailureAction) throws Exception {
        this.log("\n\n TIDY UP: DELETE SITES " + fromSiteId + " TO " + toSiteId);
        int siteId = fromSiteId;
        while (siteId <= toSiteId) {
            try {
                this.deleteSite(siteId, null, onFailureAction);
            }
            catch (Exception exception) {}
            ++siteId;
        }
        sitesCreated = fromSiteId - 1;
    }

    private void createUser(String userName) throws Exception {
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            authenticationService.createAuthentication(userName, userName.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userName.substring(0, userName.length() - 4));
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"user");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(userName) + "@email.com"));
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            personService.createPerson((Map)ppOne);
            txn.commit();
        }
        catch (Exception e) {
            txn.rollback();
            throw e;
        }
    }

    private void createGroup(String groupName) throws Exception {
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            authorityService.createAuthority(AuthorityType.GROUP, groupName);
            txn.commit();
        }
        catch (Exception e) {
            txn.rollback();
            throw e;
        }
    }

    private void creatSite(int siteId, String doAsUser, OnFailure onFailureAction) throws Exception {
        String siteName = this.getSiteName(siteId);
        long ms = System.currentTimeMillis();
        this.creatSite(siteName, doAsUser);
        this.assertTime("Create site", siteId, -1, ms, 5000L, onFailureAction, 1);
    }

    private void creatSite(String siteName, String doAsUser) throws Exception {
        String currentUser = authenticationComponent.getCurrentUserName();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            try {
                if (doAsUser != null) {
                    authenticationComponent.setCurrentUser(doAsUser);
                }
                txn.begin();
                if (siteService.getSite(siteName) == null) {
                    String sitePreset = "site-dashboard";
                    siteService.createSite(sitePreset, siteName, "Title for " + siteName, "Description for " + siteName, SiteVisibility.PUBLIC);
                    siteService.createContainer(siteName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                    siteService.createContainer(siteName, "links", ContentModel.TYPE_FOLDER, null);
                }
                txn.commit();
            }
            catch (Exception e) {
                try {
                    txn.rollback();
                }
                catch (Exception exception) {}
                throw e;
            }
        }
        finally {
            authenticationComponent.setCurrentUser(currentUser);
        }
    }

    private void deleteUser(String userName) throws Exception {
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            personService.deletePerson(userName);
            txn.commit();
        }
        catch (Exception e) {
            txn.rollback();
            throw e;
        }
    }

    private void deleteGroup(String groupName) throws Exception {
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            String groupAuthorityName = authorityService.getName(AuthorityType.GROUP, groupName);
            authorityService.deleteAuthority(groupAuthorityName, true);
            txn.commit();
        }
        catch (Exception e) {
            txn.rollback();
            throw e;
        }
    }

    private void deleteSite(int siteId, String doAsUser, OnFailure onFailureAction) throws Exception {
        String siteName = this.getSiteName(siteId);
        long ms = System.currentTimeMillis();
        this.deleteSite(siteName, doAsUser);
        this.assertTime("Delete site", siteId, -1, ms, 5000L, onFailureAction, 1);
    }

    private void deleteSite(String siteName, String doAsUser) throws Exception {
        String currentUser = authenticationComponent.getCurrentUserName();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            try {
                if (doAsUser != null) {
                    authenticationComponent.setCurrentUser(doAsUser);
                }
                txn.begin();
                siteService.deleteSite(siteName);
                txn.commit();
            }
            catch (Exception e) {
                try {
                    txn.rollback();
                }
                catch (Exception exception) {}
                throw e;
            }
        }
        finally {
            authenticationComponent.setCurrentUser(currentUser);
        }
    }

    private void allocateUsersToGroups(int userCount, int groupCount, Allocation allocation) throws Exception {
        block16: {
            if (allocation == Allocation.ALL_TO_EACH) {
                int userId = 1;
                while (userId <= userCount) {
                    UserTransaction txn = transactionService.getUserTransaction();
                    try {
                        txn.begin();
                        Set existingAuthorities = authorityService.getContainingAuthoritiesInZone(AuthorityType.GROUP, this.getUserName(userId), "APP.DEFAULT", null, -1);
                        int groupId = 1;
                        while (groupId <= groupCount) {
                            if (!existingAuthorities.contains(authorityService.getName(AuthorityType.GROUP, this.getGroupName(groupId)))) {
                                this.allocateUserToGroup(userId, groupId);
                            }
                            ++groupId;
                        }
                        txn.commit();
                    }
                    catch (Exception e) {
                        txn.rollback();
                        throw e;
                    }
                    ++userId;
                }
            } else {
                int groupIncrement;
                int iterations;
                if (allocation == Allocation.ROUND_ROBIN_FROM_SOURCE) {
                    iterations = userCount;
                    groupIncrement = 1;
                } else {
                    iterations = groupCount;
                    groupIncrement = userCount;
                }
                int i = 0;
                while (i < iterations) {
                    int userId = 1;
                    while (userId <= userCount) {
                        UserTransaction txn = transactionService.getUserTransaction();
                        try {
                            txn.begin();
                            Set existingAuthorities = authorityService.getContainingAuthoritiesInZone(AuthorityType.GROUP, this.getUserName(userId), "APP.DEFAULT", null, -1);
                            int groupId = userId;
                            while (groupId <= groupCount) {
                                if (!existingAuthorities.contains(authorityService.getName(AuthorityType.GROUP, this.getGroupName(groupId)))) {
                                    this.allocateUserToGroup(userId, groupId);
                                }
                                if (++i >= iterations) {
                                    txn.commit();
                                    break block16;
                                }
                                groupId += groupIncrement;
                            }
                            txn.commit();
                        }
                        catch (Exception e) {
                            txn.rollback();
                            throw e;
                        }
                        ++userId;
                    }
                }
            }
        }
    }

    private void allocateUsersToSites(int userCount, int siteCount, Allocation allocation) throws Exception {
        if (allocation == Allocation.ALL_TO_EACH) {
            int userId = 1;
            while (userId <= userCount) {
                int siteId = 1;
                while (siteId <= siteCount) {
                    this.allocateUserToSite(userId, siteId, userCount);
                    ++siteId;
                }
                ++userId;
            }
        } else if (allocation == Allocation.ROUND_ROBIN_TO_TARGET) {
            boolean sourceEnd = allocation == Allocation.ROUND_ROBIN_TO_TARGET;
            boolean targetEnd = allocation == Allocation.ROUND_ROBIN_FROM_SOURCE;
            int siteId = 1;
            int userId = 1;
            while (true) {
                if (userId > userCount) {
                    if (targetEnd) break;
                    sourceEnd = true;
                    userId = 1;
                }
                if (siteId > siteCount) {
                    if (sourceEnd) break;
                    targetEnd = true;
                    siteId = 1;
                }
                this.allocateUserToSite(userId, siteId, userCount);
                ++siteId;
                ++userId;
            }
        }
    }

    private void allocateGroupsToSites(int groupCount, int siteCount, Allocation allocation, int userCount, int sitesAlreadyCreated, OnFailure onFailureAction) throws Exception {
        if (allocation == Allocation.ALL_TO_EACH) {
            int groupId = 1;
            while (groupId <= groupCount) {
                int siteId = sitesAlreadyCreated + 1;
                while (siteId <= siteCount) {
                    String doAsUser = this.getSiteOwnerUserName(siteId, userCount);
                    this.allocateGroupToSite(groupId, siteId, userCount, doAsUser, onFailureAction);
                    ++siteId;
                }
                ++groupId;
            }
        } else if (allocation == Allocation.ROUND_ROBIN_TO_TARGET) {
            boolean sourceEnd = allocation == Allocation.ROUND_ROBIN_TO_TARGET;
            boolean targetEnd = allocation == Allocation.ROUND_ROBIN_FROM_SOURCE;
            int startGroupId = sitesAlreadyCreated % groupCount + 1;
            int siteId = sitesAlreadyCreated + 1;
            int groupId = startGroupId;
            while (true) {
                if (groupId > groupCount) {
                    if (targetEnd) break;
                    sourceEnd = true;
                    groupId = 1;
                }
                if (siteId > siteCount) {
                    if (sourceEnd) break;
                    targetEnd = true;
                    siteId = 1;
                }
                String doAsUser = this.getSiteOwnerUserName(siteId, userCount);
                this.allocateGroupToSite(groupId, siteId, userCount, doAsUser, onFailureAction);
                ++siteId;
                ++groupId;
            }
        }
    }

    private void allocateUserToGroup(int userId, int groupId) throws Exception {
        String userName = this.getUserName(userId);
        String groupName = this.getGroupName(groupId);
        long ms = System.currentTimeMillis();
        this.allocateUserToGroup(userName, groupName);
        this.assertTime("Adding a user to a group", userId, groupId, ms, 5000L);
    }

    private void allocateUserToSite(int userId, int siteId, int userCount) throws Exception {
        try {
            String userName = this.getUserName(userId);
            String siteName = this.getSiteName(siteId);
            String siteOwnerUserName = this.getSiteOwnerUserName(siteId, userCount);
            long ms = System.currentTimeMillis();
            this.allocateUserToSite(userName, siteName, siteOwnerUserName);
            this.assertTime("Adding a user to a site", userId, siteId, ms, 5000L);
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
    }

    private int getNextSiteToAddGroupTo(int firstSiteIdToCheck) throws Exception {
        String userName = this.getUserName(1);
        Set existingAuthorities = authorityService.getAuthoritiesForUser(userName);
        int siteId = firstSiteIdToCheck;
        while (siteId <= NUM_SITES) {
            String siteName = this.getSiteName(siteId);
            String groupName = "GROUP_site_" + siteName;
            if (!existingAuthorities.contains(groupName)) break;
            ++siteId;
        }
        this.log("Next site to add group to is " + siteId);
        return siteId;
    }

    private void allocateGroupToSite(int firstSiteId, int userCount, String doAsUser, OnFailure onFailureAction, int blockSize) throws Exception {
        String currentUser = authenticationComponent.getCurrentUserName();
        UserTransaction txn = transactionService.getUserTransaction();
        long ms1 = System.currentTimeMillis();
        try {
            try {
                if (doAsUser != null) {
                    authenticationComponent.setCurrentUser(doAsUser);
                }
                txn.begin();
                int siteId = firstSiteId;
                while (siteId < firstSiteId + blockSize) {
                    try {
                        int groupId = (siteId - 1) % 60 + 1;
                        String groupName = this.getGroupName(groupId);
                        String siteName = this.getSiteName(siteId);
                        long ms2 = System.currentTimeMillis();
                        String groupAuthorityName = authorityService.getName(AuthorityType.GROUP, groupName);
                        siteService.setMembership(siteName, groupAuthorityName, "SiteCollaborator");
                        this.assertTime("Adding a group to a site", groupId, siteId, ms2, 5000L, onFailureAction, 1);
                    }
                    catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
                    ++siteId;
                }
                txn.commit();
                this.assertTime("    Block Add", firstSiteId, 0, ms1, 5000L, onFailureAction, blockSize);
            }
            catch (Exception e) {
                txn.rollback();
                throw e;
            }
        }
        finally {
            authenticationComponent.setCurrentUser(currentUser);
        }
    }

    private void allocateGroupToSite(int siteId, int userCount, String doAsUser, OnFailure onFailureAction) throws Exception {
        int groupId = (siteId - 1) % 60 + 1;
        this.allocateGroupToSite(groupId, siteId, userCount, doAsUser, onFailureAction);
    }

    private void allocateGroupToSite(int groupId, int siteId, int userCount, String doAsUser, OnFailure onFailureAction) throws Exception {
        try {
            String groupName = this.getGroupName(groupId);
            String siteName = this.getSiteName(siteId);
            long ms = System.currentTimeMillis();
            this.allocateGroupToSite(groupName, siteName, doAsUser);
            this.assertTime("Adding a group to a site", groupId, siteId, ms, 5000L, onFailureAction, 1);
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
    }

    private void allocateUserToGroup(String userName, String groupName) throws Exception {
        String groupAuthorityName = authorityService.getName(AuthorityType.GROUP, groupName);
        authorityService.addAuthority(groupAuthorityName, userName);
    }

    private void allocateUserToSite(String userName, String siteName, String doAsUser) throws Exception {
        this.setSiteMembership(userName, siteName, doAsUser);
    }

    private void allocateGroupToSite(String groupName, String siteName, String doAsUser) throws Exception {
        String groupAuthorityName = authorityService.getName(AuthorityType.GROUP, groupName);
        this.setSiteMembership(groupAuthorityName, siteName, doAsUser);
    }

    private void setSiteMembership(String authority, String siteName, String doAsUser) throws SystemException, Exception {
        String currentUser = authenticationComponent.getCurrentUserName();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            try {
                if (doAsUser != null) {
                    authenticationComponent.setCurrentUser(doAsUser);
                }
                txn.begin();
                siteService.setMembership(siteName, authority, "SiteCollaborator");
                txn.commit();
            }
            catch (Exception e) {
                txn.rollback();
                throw e;
            }
        }
        finally {
            authenticationComponent.setCurrentUser(currentUser);
        }
    }

    private String getUserName(int userId) {
        return this.getName("user", userId);
    }

    private String getGroupName(int groupId) {
        return this.getName("group", groupId);
    }

    private String getSiteName(int siteId) {
        return this.getName("site", siteId);
    }

    private String getName(String prefix, int id) {
        return prefix + id;
    }

    private String getSiteOwnerUserName(int siteId, int userCount) {
        int ownerId = (siteId - 1) % userCount + 1;
        return this.getUserName(ownerId);
    }

    @Test
    public void testInit() throws Exception {
        this.createUsers(100);
        this.createGroups(60);
        this.allocateUsersToGroups(100, 60, Allocation.ALL_TO_EACH);
        this.createSites(NUM_SITES, 100, 0, OnFailure.KEEP_GOING);
        int blockSize = 10;
        int siteId = this.getNextSiteToAddGroupTo(1);
        while (siteId <= NUM_SITES) {
            this.allocateGroupToSite(siteId, 100, ADMIN_USER, OnFailure.KEEP_GOING, blockSize);
            siteId += blockSize;
        }
    }

    @Test
    public void commandLine() throws Exception {
        String from = System.getProperty("from");
        String to = System.getProperty("to");
        String restart = System.getProperty("restart");
        String action = System.getProperty("action");
        logFilename = System.getProperty("log", "sites.log");
        boolean usersOnly = "usersOnly".equalsIgnoreCase(action);
        boolean sites = "sites".equalsIgnoreCase(action);
        boolean groups = "groups".equalsIgnoreCase(action);
        boolean test = "test".equalsIgnoreCase(action);
        if (usersOnly && (from != null || to != null || restart != null) || !usersOnly && (from == null || to == null || action != null && !sites && !groups && !test)) {
            System.err.println("Usage: -Dfrom=<fromSiteId> -Dto=<toSiteId>                     [ -Dlog=<logFilename> ]\n       -Daction=usersOnly                                      [ -Dlog=<logFilename> ]\n       -Daction=sites      -Dfrom=<fromSiteId> -Dto=<toSiteId> [ -Dlog=<logFilename> ] [ -Drestart=<restartAtSiteId> ]\n       -Daction=groups     -Dfrom=<fromSiteId> -Dto=<toSiteId> [ -Dlog=<logFilename> ] [ -Drestart=<restartAtSiteId> ]       -Daction=test       -Dfrom=<fromSiteId> -Dto=<toSiteId> [ -Dlog=<logFilename> ] ");
        } else {
            try {
                try {
                    int restartFromId;
                    int fromId = from == null ? 0 : Integer.parseInt(from);
                    NUM_SITES = to == null ? 0 : Integer.parseInt(to);
                    int n = restartFromId = restart == null ? fromId : Integer.parseInt(restart);
                    if (test) {
                        this.testAddingSitesAndDelete(fromId, NUM_SITES);
                    } else {
                        if (action == null || usersOnly) {
                            this.createUsers(100);
                            this.createGroups(60);
                            this.allocateUsersToGroups(100, 60, Allocation.ALL_TO_EACH);
                            if (action == null) {
                                sites = true;
                            }
                        }
                        if (sites) {
                            this.createSites(NUM_SITES, 100, restartFromId - 1, OnFailure.KEEP_GOING);
                            restartFromId = fromId;
                            groups = true;
                        }
                        if (groups) {
                            int blockSize = 10;
                            int siteId = this.getNextSiteToAddGroupTo(restartFromId);
                            while (siteId <= NUM_SITES) {
                                int size = Math.min(blockSize, NUM_SITES - siteId + 1);
                                this.allocateGroupToSite(siteId, 100, ADMIN_USER, OnFailure.KEEP_GOING, size);
                                siteId += blockSize;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log("\n\n DONE");
                }
            }
            finally {
                this.log("\n\n DONE");
            }
        }
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{SiteServiceTestHuge.class.getName()});
    }

    public void testAddingSitesAndDelete(int fromSiteId, int toSiteId) throws Exception {
        String siteCreatorUser;
        usersCreated = 100;
        groupsCreated = 60;
        sitesCreated = fromSiteId - 1;
        this.deleteSites(fromSiteId, toSiteId, OnFailure.KEEP_GOING);
        this.log("\n\n CREATE SITES");
        int siteId = fromSiteId;
        while (siteId <= toSiteId) {
            siteCreatorUser = this.getSiteOwnerUserName(siteId, 100);
            this.creatSite(siteId, siteCreatorUser, OnFailure.KEEP_GOING);
            ++siteId;
        }
        this.log("\n\n ADD GROUPS");
        siteId = fromSiteId;
        while (siteId <= toSiteId) {
            siteCreatorUser = this.getSiteOwnerUserName(siteId, 100);
            this.allocateGroupToSite(siteId, 100, siteCreatorUser, OnFailure.KEEP_GOING);
            ++siteId;
        }
        this.log("\n\n DELETE");
        siteId = fromSiteId;
        while (siteId <= toSiteId) {
            siteCreatorUser = this.getSiteOwnerUserName(siteId, 100);
            this.deleteSite(siteId, siteCreatorUser, OnFailure.KEEP_GOING);
            ++siteId;
        }
    }

    private static enum Allocation {
        ROUND_ROBIN_TO_TARGET,
        ROUND_ROBIN_FROM_SOURCE,
        ROUND_ROBIN_BOTH,
        ALL_TO_EACH,
        NONE;

    }

    private static enum OnFailure {
        GIVE_UP,
        KEEP_GOING;

    }
}

