/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.alfresco.ibatis.AlfrescoSqlSessionFactoryBuilder;
import org.alfresco.ibatis.HierarchicalXMLConfigBuilder;
import org.alfresco.metrics.db.DBMetricsReporter;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.resource.HierarchicalResourceLoader;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class HierarchicalSqlSessionFactoryBean
extends SqlSessionFactoryBean {
    private HierarchicalResourceLoader resourceLoader;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Resource configLocation;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private TransactionFactory transactionFactory;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new AlfrescoSqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();
    private boolean failFast;
    private Interceptor[] plugins;
    private TypeHandler<?>[] typeHandlers;
    private String typeHandlersPackage;
    private Class<?>[] typeAliases;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private DatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
    private ObjectFactory objectFactory;
    private ObjectWrapperFactory objectWrapperFactory;
    private DBMetricsReporter dbMetricsReporter;

    public DBMetricsReporter getDbMetricsReporter() {
        return this.dbMetricsReporter;
    }

    public void setDbMetricsReporter(DBMetricsReporter dbMetricsReporter) {
        this.dbMetricsReporter = dbMetricsReporter;
    }

    public void setResourceLoader(HierarchicalResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setObjectWrapperFactory(ObjectWrapperFactory objectWrapperFactory) {
        this.objectWrapperFactory = objectWrapperFactory;
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        return this.databaseIdProvider;
    }

    public void setDatabaseIdProvider(DatabaseIdProvider databaseIdProvider) {
        this.databaseIdProvider = databaseIdProvider;
    }

    public void setPlugins(Interceptor[] plugins) {
        this.plugins = plugins;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setTypeHandlers(TypeHandler<?>[] typeHandlers) {
        this.typeHandlers = typeHandlers;
    }

    public void setTypeAliases(Class<?>[] typeAliases) {
        this.typeAliases = typeAliases;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfigurationProperties(Properties sqlSessionFactoryProperties) {
        this.configurationProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)((Object)this), (String)"resourceLoader", (Object)((Object)this.resourceLoader));
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        if (this.sqlSessionFactoryBuilder instanceof AlfrescoSqlSessionFactoryBuilder) {
            ((AlfrescoSqlSessionFactoryBuilder)this.sqlSessionFactoryBuilder).setDbMetricsReporter(this.dbMetricsReporter);
        }
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        int n;
        int n2;
        String[] stringArray;
        Configuration configuration;
        HierarchicalXMLConfigBuilder xmlConfigBuilder;
        block43: {
            xmlConfigBuilder = null;
            if (this.configLocation != null) {
                try {
                    try {
                        xmlConfigBuilder = new HierarchicalXMLConfigBuilder(this.resourceLoader, this.configLocation.getInputStream(), null, this.configurationProperties);
                        configuration = xmlConfigBuilder.getConfiguration();
                        break block43;
                    }
                    catch (Exception ex) {
                        throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
                    }
                }
                finally {
                    ErrorContext.instance().reset();
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Property 'configLocation' not specified, using default MyBatis Configuration");
            }
            configuration = new Configuration();
            configuration.setVariables(this.configurationProperties);
        }
        if (this.objectFactory != null) {
            configuration.setObjectFactory(this.objectFactory);
        }
        if (this.objectWrapperFactory != null) {
            configuration.setObjectWrapperFactory(this.objectWrapperFactory);
        }
        if (StringUtils.hasLength((String)this.typeAliasesPackage)) {
            String[] typeAliasPackageArray;
            stringArray = typeAliasPackageArray = StringUtils.tokenizeToStringArray((String)this.typeAliasesPackage, (String)",; \t\n");
            n2 = typeAliasPackageArray.length;
            n = 0;
            while (n < n2) {
                String packageToScan = stringArray[n];
                configuration.getTypeAliasRegistry().registerAliases(packageToScan, this.typeAliasesSuperType == null ? Object.class : this.typeAliasesSuperType);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Scanned package: '" + packageToScan + "' for aliases");
                }
                ++n;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeAliases)) {
            Class<?>[] classArray = this.typeAliases;
            n = this.typeAliases.length;
            int packageToScan = 0;
            while (packageToScan < n) {
                Class<?> typeAlias = classArray[packageToScan];
                configuration.getTypeAliasRegistry().registerAlias(typeAlias);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Registered type alias: '" + typeAlias + "'");
                }
                ++packageToScan;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.plugins)) {
            Interceptor[] interceptorArray = this.plugins;
            n = this.plugins.length;
            int packageToScan = 0;
            while (packageToScan < n) {
                Interceptor plugin = interceptorArray[packageToScan];
                configuration.addInterceptor(plugin);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Registered plugin: '" + plugin + "'");
                }
                ++packageToScan;
            }
        }
        if (StringUtils.hasLength((String)this.typeHandlersPackage)) {
            String[] typeHandlersPackageArray;
            stringArray = typeHandlersPackageArray = StringUtils.tokenizeToStringArray((String)this.typeHandlersPackage, (String)",; \t\n");
            n2 = typeHandlersPackageArray.length;
            n = 0;
            while (n < n2) {
                String packageToScan = stringArray[n];
                configuration.getTypeHandlerRegistry().register(packageToScan);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Scanned package: '" + packageToScan + "' for type handlers");
                }
                ++n;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
            TypeHandler<?>[] typeHandlerArray = this.typeHandlers;
            n = this.typeHandlers.length;
            int packageToScan = 0;
            while (packageToScan < n) {
                TypeHandler<?> typeHandler = typeHandlerArray[packageToScan];
                configuration.getTypeHandlerRegistry().register(typeHandler);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Registered type handler: '" + typeHandler + "'");
                }
                ++packageToScan;
            }
        }
        if (xmlConfigBuilder != null) {
            try {
                try {
                    xmlConfigBuilder.parse();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Parsed configuration file: '" + this.configLocation + "'");
                    }
                }
                catch (Exception ex) {
                    throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
                }
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        if (this.transactionFactory == null) {
            this.transactionFactory = new SpringManagedTransactionFactory();
        }
        Environment environment = new Environment(this.environment, this.transactionFactory, this.dataSource);
        configuration.setEnvironment(environment);
        if (!ObjectUtils.isEmpty((Object[])this.mapperLocations)) {
            stringArray = this.mapperLocations;
            int n3 = this.mapperLocations.length;
            n = 0;
            while (n < n3) {
                String mapperLocation = stringArray[n];
                if (mapperLocation != null) {
                    try {
                        try {
                            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), configuration, mapperLocation.toString(), configuration.getSqlFragments());
                            xmlMapperBuilder.parse();
                        }
                        catch (Exception e) {
                            throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                        }
                    }
                    finally {
                        ErrorContext.instance().reset();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Parsed mapper file: '" + mapperLocation + "'");
                    }
                }
                ++n;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Property 'mapperLocations' was not specified, only MyBatis mapper files specified in the config xml were loaded");
        }
        return this.sqlSessionFactoryBuilder.build(configuration);
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.failFast && event instanceof ContextRefreshedEvent) {
            this.sqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }
}

