/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.client.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.transform.client.registry.AbstractTransformRegistry;
import org.alfresco.transform.client.registry.SupportedTransform;
import org.alfresco.transform.client.registry.TransformCache;
import org.alfresco.transform.client.registry.TransformRegistryHelper;
import org.alfresco.util.ConfigScheduler;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ShutdownIndicator;
import org.apache.commons.logging.Log;
import org.quartz.CronExpression;
import org.springframework.beans.factory.InitializingBean;

public abstract class TransformServiceRegistryImpl
extends AbstractTransformRegistry
implements InitializingBean {
    protected boolean enabled = true;
    private ObjectMapper jsonObjectMapper;
    private CronExpression cronExpression;
    private CronExpression initialAndOnErrorCronExpression;
    private ConfigScheduler<Data> configScheduler = new ConfigScheduler<Data>((Object)this){

        public boolean readConfig() throws IOException {
            return TransformServiceRegistryImpl.this.readConfig();
        }

        public Data createData() {
            return TransformServiceRegistryImpl.this.createData();
        }
    };

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronExpression = cronExpression;
    }

    public CronExpression getInitialAndOnErrorCronExpression() {
        return this.initialAndOnErrorCronExpression;
    }

    public void setInitialAndOnErrorCronExpression(CronExpression initialAndOnErrorCronExpression) {
        this.initialAndOnErrorCronExpression = initialAndOnErrorCronExpression;
    }

    public void setShutdownIndicator(ShutdownIndicator shutdownIndicator) {
        this.configScheduler.setShutdownIndicator(shutdownIndicator);
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)((Object)this), (String)"jsonObjectMapper", (Object)this.jsonObjectMapper);
        if (this.cronExpression != null) {
            PropertyCheck.mandatory((Object)((Object)this), (String)"initialAndOnErrorCronExpression", (Object)this.initialAndOnErrorCronExpression);
        }
        Log log = this.getLog();
        this.configScheduler.run(this.enabled, log, this.cronExpression, this.initialAndOnErrorCronExpression);
    }

    public Data createData() {
        return new Data();
    }

    public Data getData() {
        return (Data)((Object)this.configScheduler.getData());
    }

    public abstract boolean readConfig() throws IOException;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setFirstTime(true);
    }

    protected void setFirstTime(boolean firstTime) {
        this.getData().firstTime = firstTime;
    }

    protected boolean getFirstTime() {
        return this.getData().firstTime;
    }

    protected abstract Log getLog();

    protected void logError(String msg) {
        this.getLog().error((Object)msg);
    }

    protected void logWarn(String msg) {
        this.getLog().warn((Object)msg);
    }

    public String findTransformerName(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        return this.enabled ? super.findTransformerName(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName) : null;
    }

    public long findMaxSize(String sourceMimetype, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        return this.enabled ? super.findMaxSize(sourceMimetype, targetMimetype, actualOptions, renditionName) : 0L;
    }

    public List<SupportedTransform> findTransformers(String sourceMimetype, String targetMimetype, Map<String, String> actualOptions, String renditionName) {
        return this.enabled ? TransformRegistryHelper.retrieveTransformListBySize((TransformCache)this.getData(), (String)sourceMimetype, (String)targetMimetype, actualOptions, (String)renditionName) : Collections.emptyList();
    }

    public static class Data
    extends TransformCache {
        private int tEngineCount = 0;
        private int fileCount;
        boolean firstTime = true;

        public String toString() {
            return this.transformerCount == 0 && this.transformCount == 0 && this.tEngineCount == 0 && this.fileCount == 0 ? "" : "(transformers: " + this.transformerCount + " transforms: " + this.transformCount + " t-engines: " + this.tEngineCount + " files: " + this.fileCount + ")";
        }

        public void setTEngineCount(int tEngineCount) {
            this.tEngineCount = tEngineCount;
        }

        public void setFileCount(int fileCount) {
            this.fileCount = fileCount;
        }
    }
}

