/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.UserInfo;
import org.alfresco.repo.event2.filter.EventFilterRegistry;
import org.alfresco.repo.event2.filter.NodeAspectFilter;
import org.alfresco.repo.event2.filter.NodePropertyFilter;
import org.alfresco.repo.event2.mapper.PropertyMapper;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PathUtil;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class NodeResourceHelper
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getLog(NodeResourceHelper.class);
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PersonService personService;
    protected EventFilterRegistry eventFilterRegistry;
    protected NamespaceService namespaceService;
    protected PermissionService permissionService;
    protected PropertyMapper propertyMapper;
    private NodeAspectFilter nodeAspectFilter;
    private NodePropertyFilter nodePropertyFilter;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"eventFilterRegistry", (Object)this.eventFilterRegistry);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"propertyMapper", (Object)this.propertyMapper);
        this.nodeAspectFilter = this.eventFilterRegistry.getNodeAspectFilter();
        this.nodePropertyFilter = this.eventFilterRegistry.getNodePropertyFilter();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setEventFilterRegistry(EventFilterRegistry eventFilterRegistry) {
        this.eventFilterRegistry = eventFilterRegistry;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPropertyMapper(PropertyMapper propertyMapper) {
        this.propertyMapper = propertyMapper;
    }

    public NodeResource.Builder createNodeResourceBuilder(NodeRef nodeRef) {
        QName type = this.nodeService.getType(nodeRef);
        Path path = this.nodeService.getPath(nodeRef);
        Map<QName, Serializable> properties = this.getProperties(nodeRef);
        HashMap<String, UserInfo> mapUserCache = new HashMap<String, UserInfo>(2);
        return NodeResource.builder().setId(nodeRef.getId()).setName((String)((Object)properties.get(ContentModel.PROP_NAME))).setNodeType(this.getQNamePrefixString(type)).setIsFile(Boolean.valueOf(this.isSubClass(type, ContentModel.TYPE_CONTENT))).setIsFolder(Boolean.valueOf(this.isSubClass(type, ContentModel.TYPE_FOLDER))).setCreatedByUser(this.getUserInfo((String)((Object)properties.get(ContentModel.PROP_CREATOR)), mapUserCache)).setCreatedAt(this.getZonedDateTime((Date)properties.get(ContentModel.PROP_CREATED))).setModifiedByUser(this.getUserInfo((String)((Object)properties.get(ContentModel.PROP_MODIFIER)), mapUserCache)).setModifiedAt(this.getZonedDateTime((Date)properties.get(ContentModel.PROP_MODIFIED))).setContent(this.getContentInfo(properties)).setPrimaryAssocQName(this.getPrimaryAssocQName(nodeRef)).setPrimaryHierarchy(PathUtil.getNodeIdsInReverse(path, false)).setProperties(this.mapToNodeProperties(properties)).setLocalizedProperties(this.mapToNodeLocalizedProperties(properties)).setAspectNames(this.getMappedAspects(nodeRef));
    }

    private boolean isSubClass(QName className, QName ofClassQName) {
        return this.dictionaryService.isSubClass(className, ofClassQName);
    }

    private String getPrimaryAssocQName(NodeRef nodeRef) {
        String result = null;
        try {
            ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(nodeRef);
            if (primaryParent != null && primaryParent.getQName() != null) {
                result = primaryParent.getQName().getPrefixedQName((NamespacePrefixResolver)this.namespaceService).getPrefixString();
            }
        }
        catch (NamespaceException namespaceException) {
            LOGGER.error((Object)("Cannot return a valid primary association QName: " + namespaceException.getMessage()));
        }
        return result;
    }

    private UserInfo getUserInfo(String userName, Map<String, UserInfo> mapUserCache) {
        UserInfo userInfo = mapUserCache.get(userName);
        if (userInfo == null) {
            userInfo = this.getUserInfo(userName);
            mapUserCache.put(userName, userInfo);
        }
        return userInfo;
    }

    public boolean nodeExists(NodeRef nodeRef) {
        return this.nodeService.exists(nodeRef);
    }

    public Map<String, Serializable> mapToNodeProperties(Map<QName, Serializable> props) {
        HashMap<String, Serializable> filteredProps = new HashMap<String, Serializable>(props.size());
        props.forEach((k, v) -> {
            if (!this.nodePropertyFilter.isExcluded((QName)k)) {
                if (v instanceof MLText) {
                    v = ((MLText)v).getDefaultValue();
                }
                Serializable mappedValue = this.propertyMapper.map((QName)k, (Serializable)v);
                filteredProps.put(this.getQNamePrefixString((QName)k), mappedValue);
            }
        });
        return filteredProps;
    }

    public Map<String, Map<String, String>> mapToNodeLocalizedProperties(Map<QName, Serializable> props) {
        HashMap<String, Map<String, String>> filteredProps = new HashMap<String, Map<String, String>>(props.size());
        props.forEach((k, v) -> {
            if (!this.nodePropertyFilter.isExcluded((QName)k) && v instanceof MLText) {
                MLText mlTextValue = (MLText)v;
                HashMap localizedValues = new HashMap(mlTextValue.size());
                mlTextValue.forEach((locale, text) -> {
                    Serializable mappedValue = this.propertyMapper.map((QName)k, (Serializable)((Object)text));
                    localizedValues.put(locale.toString(), (String)((Object)mappedValue));
                });
                filteredProps.put(this.getQNamePrefixString((QName)k), localizedValues);
            }
        });
        return filteredProps.isEmpty() ? null : filteredProps;
    }

    public ContentInfo getContentInfo(Map<QName, Serializable> props) {
        Serializable content = props.get(ContentModel.PROP_CONTENT);
        ContentInfo contentInfo = null;
        if (content instanceof ContentData) {
            ContentData cd = (ContentData)content;
            contentInfo = new ContentInfo(cd.getMimetype(), Long.valueOf(cd.getSize()), cd.getEncoding());
        }
        return contentInfo;
    }

    public UserInfo getUserInfo(String userName) {
        UserInfo userInfo = null;
        if (userName != null) {
            String sysUserName = AuthenticationUtil.getSystemUserName();
            if (userName.equals(sysUserName) || AuthenticationUtil.isMtEnabled() && userName.startsWith(String.valueOf(sysUserName) + "@")) {
                userInfo = new UserInfo(userName, userName, "");
            } else {
                PersonService.PersonInfo pInfo = null;
                try {
                    NodeRef pNodeRef = this.personService.getPersonOrNull(userName);
                    if (pNodeRef != null) {
                        pInfo = this.personService.getPerson(pNodeRef);
                    }
                }
                catch (AccessDeniedException | NoSuchPersonException alfrescoRuntimeException) {}
                if (pInfo != null) {
                    userInfo = new UserInfo(userName, pInfo.getFirstName(), pInfo.getLastName());
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Unknown person: " + userName));
                    }
                    userInfo = new UserInfo(userName, userName, "");
                }
            }
        }
        return userInfo;
    }

    public ZonedDateTime getZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public String getQNamePrefixString(QName k) {
        String key;
        try {
            key = k.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException namespaceException) {
            key = k.toString();
        }
        return key;
    }

    public Set<String> mapToNodeAspects(Collection<QName> aspects) {
        HashSet<String> filteredAspects = new HashSet<String>(aspects.size());
        aspects.forEach(q -> {
            if (!this.nodeAspectFilter.isExcluded((QName)q)) {
                filteredAspects.add(this.getQNamePrefixString((QName)q));
            }
        });
        return filteredAspects;
    }

    public QName getNodeType(NodeRef nodeRef) {
        return this.nodeService.getType(nodeRef);
    }

    public Serializable getProperty(NodeRef nodeRef, QName qName) {
        return this.nodeService.getProperty(nodeRef, qName);
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) {
        boolean toRestore = MLPropertyInterceptor.isMLAware();
        MLPropertyInterceptor.setMLAware(true);
        try {
            Map map = this.nodeService.getProperties(nodeRef);
            return map;
        }
        finally {
            MLPropertyInterceptor.setMLAware(toRestore);
        }
    }

    public Map<String, Map<String, String>> getLocalizedPropertiesBefore(Map<QName, Serializable> propsBefore, NodeResource nodeAfter) {
        Map locPropsBefore = Optional.ofNullable(propsBefore).map(this::mapToNodeLocalizedProperties).orElseGet(Map::of);
        Map locPropsAfter = Optional.ofNullable(nodeAfter).map(NodeResource::getLocalizedProperties).orElseGet(Map::of);
        return NodeResourceHelper.getLocalizedPropertiesBefore(locPropsBefore, locPropsAfter);
    }

    static Map<String, Map<String, String>> getLocalizedPropertiesBefore(Map<String, Map<String, String>> locPropsBefore, Map<String, Map<String, String>> locPropsAfter) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(locPropsBefore.size());
        Sets.union(locPropsBefore.keySet(), locPropsAfter.keySet()).forEach(propertyName -> {
            Map valuesBefore = Optional.ofNullable((Map)locPropsBefore.get(propertyName)).orElseGet(Map::of);
            Map valuesAfter = Optional.ofNullable((Map)locPropsAfter.get(propertyName)).orElseGet(Map::of);
            if (!valuesAfter.isEmpty() || !valuesBefore.isEmpty()) {
                HashMap diff = new HashMap(valuesBefore.size());
                Sets.union(valuesBefore.keySet(), valuesAfter.keySet()).forEach(lang -> {
                    String valueAfter;
                    String valueBefore = (String)valuesBefore.get(lang);
                    if (!Objects.equals(valueBefore, valueAfter = (String)valuesAfter.get(lang))) {
                        diff.put(lang, valueBefore);
                    }
                });
                if (!diff.isEmpty()) {
                    result.put((String)propertyName, diff);
                }
            }
        });
        return result;
    }

    public Set<String> getMappedAspects(NodeRef nodeRef) {
        return this.mapToNodeAspects(this.nodeService.getAspects(nodeRef));
    }

    public List<String> getPrimaryHierarchy(NodeRef nodeRef, boolean showLeaf) {
        Path path = this.nodeService.getPath(nodeRef);
        return PathUtil.getNodeIdsInReverse(path, showLeaf);
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }
}

