/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.activiti;

import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.alfresco.repo.client.config.ClientAppConfig;
import org.alfresco.repo.invitation.activiti.AbstractInvitationDelegate;
import org.alfresco.util.EmailHelper;

public class SendModeratedInviteDelegate
extends AbstractInvitationDelegate {
    private String emailTemplatePath;
    private ClientAppConfig clientAppConfig;
    private EmailHelper emailHelper;
    public static final String ENTERPRISE_EMAIL_TEMPLATE_PATH = "app:company_home/app:dictionary/app:email_templates/cm:invite/cm:invite-email-moderated.html.ftl";
    public static final String EMAIL_SUBJECT_KEY = "invitation.moderated.email.subject";
    private static final String EMAIL_TEMPLATE_REF = "alfresco/templates/workspace/invite-email-moderated.html.ftl";

    public void setEmailTemplatePath(String emailTemplatePath) {
        this.emailTemplatePath = emailTemplatePath;
    }

    public void setClientAppConfig(ClientAppConfig clientAppConfig) {
        this.clientAppConfig = clientAppConfig;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }

    public void execute(DelegateExecution execution) throws Exception {
        String invitationId = "activiti$" + execution.getProcessInstanceId();
        Map variables = execution.getVariables();
        String clientName = (String)variables.get("imwf_clientName");
        if (clientName != null && this.clientAppConfig.getClient(clientName) != null) {
            ClientAppConfig.ClientApp clientApp = this.clientAppConfig.getClient(clientName);
            String path = clientApp.getProperty("inviteModeratedTemplatePath");
            String templatePath = this.emailHelper.getEmailTemplate(clientApp.getName(), path, EMAIL_TEMPLATE_REF);
            this.invitationService.sendModeratedInvitation(invitationId, templatePath, EMAIL_SUBJECT_KEY, variables);
        } else {
            this.invitationService.sendModeratedInvitation(invitationId, this.emailTemplatePath, EMAIL_SUBJECT_KEY, variables);
        }
    }
}

