/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentityServiceAuthenticationComponent
extends AbstractAuthenticationComponent
implements ActivateableBean {
    private final Log LOGGER = LogFactory.getLog(IdentityServiceAuthenticationComponent.class);
    private IdentityServiceFacade identityServiceFacade;
    private boolean active;
    private boolean allowGuestLogin;

    public void setIdentityServiceFacade(IdentityServiceFacade identityServiceFacade) {
        this.identityServiceFacade = identityServiceFacade;
    }

    public void setAllowGuestLogin(boolean allowGuestLogin) {
        this.allowGuestLogin = allowGuestLogin;
    }

    @Override
    public void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        if (this.identityServiceFacade == null) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)"IdentityServiceFacade was not set, possibly due to the 'identity-service.authentication.enable-username-password-authentication=false' property.");
            }
            throw new AuthenticationException("User not authenticated because IdentityServiceFacade was not set.");
        }
        try {
            this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.password(userName, new String(password)));
            this.setCurrentUser(userName);
        }
        catch (IdentityServiceFacade.IdentityServiceFacadeException e) {
            throw new AuthenticationException("Failed to verify user credentials against the OAuth2 Authorization Server.", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new AuthenticationException("Failed to verify user credentials.", (Throwable)e);
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return this.allowGuestLogin;
    }
}

