/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.BaseInterpreter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.FailedWorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.I18NUtil;

public class WorkflowInterpreter
extends BaseInterpreter {
    private WorkflowService workflowService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private AuthorityDAO authorityDAO;
    private PersonService personService;
    private FileFolderService fileFolderService;
    private TenantService tenantService;
    private DictionaryService dictionaryService;
    private WorkflowDefinition currentWorkflowDef = null;
    private WorkflowPath currentPath = null;
    private String currentDeployResource = null;
    private String currentDeployEngine = null;
    private Map<QName, Serializable> vars = new HashMap<QName, Serializable>();

    @Override
    protected void onBootstrap(ApplicationEvent event) {
    }

    @Override
    protected void onShutdown(ApplicationEvent event) {
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public static void main(String[] args) {
        WorkflowInterpreter.runMain("workflowInterpreter");
    }

    @Override
    protected boolean hasAuthority(String username) {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String executeCommand(String line) throws IOException {
        String[] command = line.split(" ");
        if (command.length == 0) {
            command = new String[]{line};
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        if (command[0].equals("r")) {
            if (this.lastCommand != null) return "repeating command " + this.lastCommand + "\n\n" + this.executeCommand(this.lastCommand);
            return "No command entered yet.";
        }
        this.lastCommand = line;
        if (command[0].equals("help")) {
            String helpFile = I18NUtil.getMessage((String)"workflow_console.help");
            ClassPathResource helpResource = new ClassPathResource(helpFile);
            byte[] helpBytes = new byte[500];
            try (InputStream inputStream = helpResource.getInputStream();){
                int read = inputStream.read(helpBytes);
                while (read != -1) {
                    bout.write(helpBytes, 0, read);
                    read = inputStream.read(helpBytes);
                }
            }
        }
        if (command[0].equals("show")) {
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("file")) {
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                ClassPathResource file = new ClassPathResource(command[2]);
                byte[] fileBytes = new byte[500];
                try (InputStream fileStream = file.getInputStream();){
                    int n;
                    int n2 = fileStream.read(fileBytes);
                    while (n != -1) {
                        bout.write(fileBytes, 0, n);
                        n = fileStream.read(fileBytes);
                    }
                }
                out.println();
            } else if (command[1].equals("definitions")) {
                List<WorkflowDefinition> defs = null;
                if (command.length == 3) {
                    if (!command[2].equals("all")) return "Syntax Error.\n";
                    defs = this.workflowService.getAllDefinitions();
                } else {
                    defs = this.workflowService.getDefinitions();
                }
                for (WorkflowDefinition def : defs) {
                    out.println("id: " + def.getId() + " , name: " + def.getName() + " , title: " + def.getTitle() + " , version: " + def.getVersion());
                }
            } else if (command[1].equals("workflows")) {
                String id;
                String string = id = this.currentWorkflowDef != null ? this.currentWorkflowDef.getId() : null;
                if (id == null && command.length == 2) {
                    return "workflow definition not in use.  Enter command 'show workflows all' or 'use <workflowDefId>'.\n";
                }
                if (command.length == 3) {
                    if (!command[2].equals("all")) return "Syntax Error.\n";
                    id = "all";
                }
                if ("all".equals(id)) {
                    for (WorkflowDefinition def : this.workflowService.getAllDefinitions()) {
                        List<WorkflowInstance> list = this.workflowService.getActiveWorkflows(def.getId());
                        for (WorkflowInstance workflow : list) {
                            out.println("id: " + workflow.getId() + " , desc: " + workflow.getDescription() + " , start date: " + workflow.getStartDate() + " , def: " + workflow.getDefinition().getName() + " v" + workflow.getDefinition().getVersion());
                        }
                    }
                } else {
                    List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(id);
                    for (WorkflowInstance workflow : workflows) {
                        out.println("id: " + workflow.getId() + " , desc: " + workflow.getDescription() + " , start date: " + workflow.getStartDate() + " , def: " + workflow.getDefinition().getName());
                    }
                }
            } else if (command[1].equals("paths")) {
                String workflowId;
                String string;
                if (command.length == 3) {
                    string = command[2];
                } else {
                    if (this.currentPath == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    string = workflowId = this.currentPath.getInstance().getId();
                }
                if (workflowId == null) {
                    return "Syntax Error.  Workflow Id not specified.\n";
                }
                List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowId);
                for (WorkflowPath path : paths) {
                    out.println("path id: " + path.getId() + " , node: " + path.getNode().getName());
                }
            } else if (command[1].equals("tasks")) {
                String pathId;
                String string;
                if (command.length == 3) {
                    string = command[2];
                } else {
                    if (this.currentPath == null) {
                        return "Syntax Error.  Path Id not specified.\n";
                    }
                    string = pathId = this.currentPath.getId();
                }
                if (pathId == null) {
                    return "Syntax Error.  Path Id not specified.\n";
                }
                List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(pathId);
                for (WorkflowTask task : tasks) {
                    out.println("task id: " + task.getId() + " , name: " + task.getName() + " , properties: " + task.getProperties().size());
                }
            } else if (command[1].equals("transitions")) {
                String workflowId;
                String string;
                if (command.length == 3) {
                    string = command[2];
                } else {
                    if (this.currentPath == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    string = workflowId = this.currentPath.getInstance().getId();
                }
                if (workflowId == null) {
                    return "Syntax Error.  Workflow Id not specified.\n";
                }
                List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(workflowId);
                if (paths.size() == 0) {
                    out.println("no further transitions");
                }
                for (WorkflowPath path : paths) {
                    out.println("path: " + path.getId() + " , node: " + path.getNode().getName() + " , active: " + path.isActive());
                    List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
                    for (WorkflowTask task : tasks) {
                        out.println(" task id: " + task.getId() + " , name: " + task.getName() + ", title: " + task.getTitle() + " , desc: " + task.getDescription() + " , properties: " + task.getProperties().size());
                    }
                    WorkflowTransition[] workflowTransitionArray = path.getNode().getTransitions();
                    int n = workflowTransitionArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        WorkflowTransition transition = workflowTransitionArray[n3];
                        out.println(" transition id: " + (transition.getId() == null || transition.getId().equals("") ? "[default]" : transition.getId()) + " , title: " + transition.getTitle());
                        ++n3;
                    }
                }
            } else if (command[1].equals("timers")) {
                String id;
                String string = id = this.currentWorkflowDef != null ? this.currentWorkflowDef.getId() : null;
                if (id == null && command.length == 2) {
                    return "workflow definition not in use.  Enter command 'show timers all' or 'use <workflowDefId>'.\n";
                }
                if (command.length == 3) {
                    if (!command[2].equals("all")) return "Syntax Error.\n";
                    id = "all";
                }
                ArrayList<WorkflowTimer> timers = new ArrayList<WorkflowTimer>();
                if ("all".equals(id)) {
                    for (WorkflowDefinition def : this.workflowService.getAllDefinitions()) {
                        List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(def.getId());
                        Iterator iterator = workflows.iterator();
                        while (iterator.hasNext()) {
                            WorkflowInstance workflow = (WorkflowInstance)iterator.next();
                            timers.addAll(this.workflowService.getTimers(workflow.getId()));
                        }
                    }
                } else {
                    List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(id);
                    for (WorkflowInstance workflowInstance : workflows) {
                        timers.addAll(this.workflowService.getTimers(workflowInstance.getId()));
                    }
                }
                for (WorkflowTimer timer : timers) {
                    out.print("id: " + timer.getId() + " , name: " + timer.getName() + " , due date: " + timer.getDueDate() + " , path: " + timer.getPath().getId() + " , node: " + timer.getPath().getNode().getName() + " , process: " + timer.getPath().getInstance().getId());
                    if (timer.getTask() != null) {
                        out.print(" , task: " + timer.getTask().getName() + "(" + timer.getTask().getId() + ")");
                    }
                    out.println();
                    if (timer.getError() == null) continue;
                    out.println("error executing timer id " + timer.getId());
                    out.println(timer.getError());
                }
            } else {
                if (!command[1].equals("my")) return "Syntax Error.\n";
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                if (command[2].equals("tasks")) {
                    out.println(String.valueOf(AuthenticationUtil.getRunAsUser()) + ":");
                    List<WorkflowTask> tasks = this.workflowService.getAssignedTasks(AuthenticationUtil.getRunAsUser(), WorkflowTaskState.IN_PROGRESS);
                    for (WorkflowTask task : tasks) {
                        out.println("id: " + task.getId() + " , name: " + task.getName() + " , properties: " + task.getProperties().size() + " , workflow: " + task.getPath().getInstance().getId() + " , path: " + task.getPath().getId());
                    }
                } else if (command[2].equals("completed")) {
                    out.println(String.valueOf(AuthenticationUtil.getRunAsUser()) + ":");
                    List<WorkflowTask> tasks = this.workflowService.getAssignedTasks(AuthenticationUtil.getRunAsUser(), WorkflowTaskState.COMPLETED);
                    for (WorkflowTask task : tasks) {
                        out.println("id: " + task.getId() + " , name " + task.getName() + " , properties: " + task.getProperties().size() + " , workflow: " + task.getPath().getInstance().getId() + " , path: " + task.getPath().getId());
                    }
                } else {
                    if (!command[2].equals("pooled")) return "Syntax Error.\n";
                    out.println(String.valueOf(AuthenticationUtil.getRunAsUser()) + ":");
                    List<WorkflowTask> tasks = this.workflowService.getPooledTasks(AuthenticationUtil.getRunAsUser());
                    for (WorkflowTask task : tasks) {
                        out.println("id: " + task.getId() + " , name " + task.getName() + " , properties: " + task.getProperties().size() + " , workflow: " + task.getPath().getInstance().getId() + " , path: " + task.getPath().getId());
                    }
                }
            }
        } else if (command[0].equals("desc")) {
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("task")) {
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                WorkflowTask task = this.workflowService.getTaskById(command[2]);
                out.println("id: " + task.getId());
                out.println("name: " + task.getName());
                out.println("title: " + task.getTitle());
                out.println("description: " + task.getDescription());
                out.println("state: " + (Object)((Object)task.getState()));
                out.println("path: " + task.getPath().getId());
                out.println("transitions: " + task.getDefinition().getNode().getTransitions().length);
                WorkflowTransition[] workflows = task.getDefinition().getNode().getTransitions();
                int n = workflows.length;
                int timer = 0;
                while (timer < n) {
                    WorkflowTransition transition = workflows[timer];
                    out.println(" transition: " + (transition.getId() == null || transition.getId().equals("") ? "[default]" : transition.getId()) + " , title: " + transition.getTitle() + " , desc: " + transition.getDescription());
                    ++timer;
                }
                out.println("properties: " + task.getProperties().size());
                for (Map.Entry<QName, Serializable> prop : task.getProperties().entrySet()) {
                    out.println(" " + prop.getKey() + " = " + prop.getValue());
                }
            } else if (command[1].equals("workflow")) {
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                WorkflowInstance workflow = this.workflowService.getWorkflowById(command[2]);
                out.println("definition: " + workflow.getDefinition().getName());
                out.println("id: " + workflow.getId());
                out.println("description: " + workflow.getDescription());
                out.println("active: " + workflow.isActive());
                out.println("start date: " + workflow.getStartDate());
                out.println("end date: " + workflow.getEndDate());
                out.println("initiator: " + workflow.getInitiator());
                out.println("context: " + workflow.getContext());
                out.println("package: " + workflow.getWorkflowPackage());
            } else {
                if (!command[1].equals("path")) return "Syntax Error.\n";
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                Map<QName, Serializable> properties = this.workflowService.getPathProperties(command[2]);
                out.println("path: " + command[1]);
                out.println("properties: " + properties.size());
                for (Map.Entry<QName, Serializable> prop : properties.entrySet()) {
                    out.println(" " + prop.getKey() + " = " + prop.getValue());
                }
            }
        } else if (command[0].equals("query")) {
            void var8_108;
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            if (!command[1].equals("task")) return "Syntax Error.\n";
            WorkflowTaskQuery query = new WorkflowTaskQuery();
            HashMap<QName, Object> taskProps = new HashMap<QName, Object>();
            HashMap<QName, Object> procProps = new HashMap<QName, Object>();
            int n = 2;
            while (var8_108 < command.length) {
                String[] predicate = command[var8_108].split("=");
                if (predicate.length == 1) {
                    return "Syntax Error.\n";
                }
                String[] predicateName = predicate[0].split("\\.");
                if (predicateName.length == 1) {
                    if (predicate[0].equals("taskId")) {
                        query.setTaskId(predicate[1]);
                    } else if (predicate[0].equals("taskState")) {
                        WorkflowTaskState state = WorkflowTaskState.valueOf(predicate[1]);
                        if (state == null) {
                            return "Syntax Error.  Unknown task state\n";
                        }
                        query.setTaskState(state);
                    } else if (predicate[0].equals("taskName")) {
                        query.setTaskName(QName.createQName((String)predicate[1], (NamespacePrefixResolver)this.namespaceService));
                    } else if (predicate[0].equals("taskActor")) {
                        query.setActorId(predicate[1]);
                    } else if (predicate[0].equals("processId")) {
                        query.setProcessId(predicate[1]);
                    } else if (predicate[0].equals("processName")) {
                        query.setProcessName(QName.createQName((String)predicate[1], (NamespacePrefixResolver)this.namespaceService));
                    } else if (predicate[0].equals("workflowDefinitionName")) {
                        query.setWorkflowDefinitionName(predicate[1]);
                    } else if (predicate[0].equals("processActive")) {
                        Boolean active = Boolean.valueOf(predicate[1]);
                        query.setActive(active);
                    } else {
                        if (!predicate[0].equals("orderBy")) return "Syntax Error.  Unknown query predicate.\n";
                        String[] orderBy = predicate[1].split(",");
                        WorkflowTaskQuery.OrderBy[] queryOrderBy = new WorkflowTaskQuery.OrderBy[orderBy.length];
                        int iOrderBy = 0;
                        while (iOrderBy < orderBy.length) {
                            queryOrderBy[iOrderBy] = WorkflowTaskQuery.OrderBy.valueOf(orderBy[iOrderBy]);
                            if (queryOrderBy[iOrderBy] == null) {
                                return "Syntax Error.  Unknown orderBy.\n";
                            }
                            ++iOrderBy;
                        }
                        query.setOrderBy(queryOrderBy);
                    }
                } else {
                    if (predicateName.length != 2) return "Syntax Error.\n";
                    if (predicateName[0].equals("task")) {
                        taskProps.put(QName.createQName((String)predicateName[1], (NamespacePrefixResolver)this.namespaceService), predicate[1]);
                    } else {
                        if (!((String)predicateName[0]).equals("process")) return "Syntax Error.  Unknown query predicate.\n";
                        procProps.put(QName.createQName((String)predicateName[1], (NamespacePrefixResolver)this.namespaceService), predicate[1]);
                    }
                }
                ++var8_108;
            }
            if (taskProps.size() > 0) {
                query.setTaskCustomProps(taskProps);
            }
            if (procProps.size() > 0) {
                query.setProcessCustomProps(procProps);
            }
            List<WorkflowTask> list = this.workflowService.queryTasks(query);
            out.println("found " + list.size() + " tasks.");
            for (WorkflowTask task : list) {
                out.println("task id: " + task.getId() + " , name: " + task.getName() + " , properties: " + task.getProperties().size() + ", process id: " + task.getPath().getInstance());
            }
        } else if (command[0].equals("deploy")) {
            if (command.length != 3) {
                return "Syntax Error.\n";
            }
            ClassPathResource workflowDef = new ClassPathResource(command[2]);
            WorkflowDeployment deployment = this.workflowService.deployDefinition(command[1], workflowDef.getInputStream(), "text/xml");
            WorkflowDefinition def = deployment.getDefinition();
            String[] stringArray = deployment.getProblems();
            int predicateName = stringArray.length;
            int task = 0;
            while (task < predicateName) {
                String string = stringArray[task];
                out.println(string);
                ++task;
            }
            Optional<String> optional = FailedWorkflowDeployment.getFailure(deployment);
            if (optional.isPresent()) {
                out.println("Failed to deploy the workflow definition.");
            } else {
                out.println("deployed definition id: " + def.getId() + " , name: " + def.getName() + " , title: " + def.getTitle() + " , version: " + def.getVersion());
                this.currentDeployEngine = command[1];
                this.currentDeployResource = command[2];
                out.print(this.executeCommand("use definition " + def.getId()));
            }
        } else if (command[0].equals("redeploy")) {
            if (this.currentDeployResource == null) {
                return "nothing to redeploy\n";
            }
            out.print(this.executeCommand("deploy " + this.currentDeployEngine + " " + this.currentDeployResource));
        } else if (command[0].equals("undeploy")) {
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            if (!command[1].equals("definition")) return "Syntax Error.\n";
            if (command.length == 3) {
                this.workflowService.undeployDefinition(command[2]);
                this.currentWorkflowDef = null;
                this.currentPath = null;
                out.print(this.executeCommand("show definitions"));
            } else {
                if (command.length != 4) return "Syntax Error.\n";
                if (!command[2].equals("name")) return "Syntax Error.\n";
                out.print("undeploying...");
                List<WorkflowDefinition> defs = this.workflowService.getAllDefinitionsByName(command[3]);
                for (WorkflowDefinition def : defs) {
                    this.workflowService.undeployDefinition(def.getId());
                    out.print(" v" + def.getVersion());
                }
                out.println("");
                this.currentWorkflowDef = null;
                this.currentPath = null;
                out.print(this.executeCommand("show definitions all"));
            }
        } else if (command[0].equals("use")) {
            if (command.length == 1) {
                out.println("definition: " + (this.currentWorkflowDef == null ? "None" : String.valueOf(this.currentWorkflowDef.getId()) + " , name: " + this.currentWorkflowDef.getTitle() + " , version: " + this.currentWorkflowDef.getVersion()));
                out.println("workflow: " + (this.currentPath == null ? "None" : String.valueOf(this.currentPath.getInstance().getId()) + " , active: " + this.currentPath.getInstance().isActive()));
                out.println("path: " + (this.currentPath == null ? "None" : String.valueOf(this.currentPath.getId()) + " , node: " + this.currentPath.getNode().getTitle()));
            } else if (command.length > 1) {
                if (command[1].equals("definition")) {
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    WorkflowDefinition def = this.workflowService.getDefinitionById(command[2]);
                    if (def == null) {
                        return "Not found.\n";
                    }
                    this.currentWorkflowDef = def;
                    this.currentPath = null;
                    out.print(this.executeCommand("use"));
                } else {
                    if (!command[1].equals("workflow")) return "Syntax Error.\n";
                    if (command.length != 3) {
                        return "Syntax Error.\n";
                    }
                    WorkflowInstance instance = this.workflowService.getWorkflowById(command[2]);
                    this.currentWorkflowDef = instance.getDefinition();
                    this.currentPath = this.workflowService.getWorkflowPaths(instance.getId()).get(0);
                    out.print(this.executeCommand("use"));
                }
            }
        } else if (command[0].equals("user")) {
            if (command.length == 2) {
                NodeRef personRef;
                if (this.tenantService.isEnabled()) {
                    this.tenantService.checkDomainUser(command[1]);
                }
                if ((personRef = this.personService.getPerson(command[1])) == null) {
                    throw new WorkflowException("User " + command[1] + " does not exist.");
                }
                PersonService.PersonInfo info = this.personService.getPerson(personRef);
                String userName = info.getUserName();
                this.setCurrentUserName(userName);
            }
            out.println("using user " + this.getCurrentUserName());
        } else if (command[0].equals("start")) {
            HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
            int i = 1;
            while (i < command.length) {
                String[] param = command[i].split("=");
                QName qName = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                if (param.length == 1) {
                    if (!this.vars.containsKey(qName)) {
                        return "var " + qName + " not found.\n";
                    }
                    params.put(qName, this.vars.get(qName));
                } else {
                    if (param.length != 2) return "Syntax Error.\n";
                    params.put(qName, (Serializable)((Object)param[1]));
                }
                ++i;
            }
            if (this.currentWorkflowDef == null) {
                return "Workflow definition not selected.\n";
            }
            this.setupStartTaskParameters(this.currentWorkflowDef.getStartTaskDefinition().metadata, params);
            WorkflowPath path = this.workflowService.startWorkflow(this.currentWorkflowDef.getId(), params);
            this.endStartTaskForPath(path);
            out.println("started workflow id: " + path.getInstance().getId() + " , def: " + path.getInstance().getDefinition().getTitle());
            this.currentPath = path;
            out.print(this.interpretCommand("show transitions"));
        } else if (command[0].equals("update")) {
            if (command.length < 3) {
                return "Syntax Error.\n";
            }
            if (!command[1].equals("task")) return "Syntax Error.\n";
            if (command.length < 4) {
                return "Syntax Error.\n";
            }
            HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
            int i = 3;
            while (i < command.length) {
                String[] param = command[i].split("=");
                QName qName = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                if (param.length == 1) {
                    if (!this.vars.containsKey(qName)) {
                        return "var " + qName + " not found.\n";
                    }
                    params.put(qName, this.vars.get(qName));
                } else {
                    if (param.length != 2) return "Syntax Error.\n";
                    params.put(qName, (Serializable)((Object)param[1]));
                }
                ++i;
            }
            WorkflowTask task = this.workflowService.updateTask(command[2], params, null, null);
            out.println("updated task id: " + command[2] + ", properties: " + task.getProperties().size());
        } else if (command[0].equals("signal")) {
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            WorkflowPath path = this.workflowService.signal(command[1], this.getTransition(command));
            out.println("signal sent - path id: " + path.getId());
            out.print(this.interpretCommand("show transitions"));
        } else if (command[0].equals("event")) {
            if (command.length < 3) {
                return "Syntax Error.\n";
            }
            WorkflowPath path = this.workflowService.fireEvent(command[1], command[2]);
            out.println("event " + command[2] + " fired - path id: " + path.getId());
            out.print(this.interpretCommand("show transitions"));
        } else if (command[0].equals("end")) {
            if (command.length < 3) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("task")) {
                WorkflowTask task = this.workflowService.endTask(command[2], command.length == 4 ? command[3] : null);
                out.println("signal sent - path id: " + task.getPath().getId());
                this.currentPath = task.getPath();
                out.print(this.interpretCommand("show transitions"));
            } else {
                String workflowId;
                String string;
                if (!command[1].equals("workflow")) return "Syntax Error.\n";
                if (command.length == 3) {
                    string = command[2];
                } else {
                    if (this.currentPath == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    string = workflowId = this.currentPath.getInstance().getId();
                }
                if (workflowId == null) {
                    return "Syntax Error.  Workflow Id not specified.\n";
                }
                this.workflowService.cancelWorkflow(workflowId);
                out.println("workflow " + workflowId + " cancelled.");
            }
        } else if (command[0].equals("delete")) {
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("workflow")) {
                String workflowId;
                String string;
                if (command.length == 3) {
                    string = command[2];
                } else {
                    if (this.currentPath == null) {
                        return "Syntax Error.  Workflow Id not specified.\n";
                    }
                    string = workflowId = this.currentPath.getInstance().getId();
                }
                if (workflowId == null) {
                    return "Syntax Error.  Workflow Id not specified.\n";
                }
                this.workflowService.deleteWorkflow(workflowId);
                out.println("workflow " + workflowId + " deleted.");
            } else {
                if (!command[1].equals("all")) return "Syntax Error.\n";
                if (command.length < 3) {
                    return "Syntax Error.\n";
                }
                if (!command[2].equals("workflows")) return "Syntax Error.\n";
                if (command.length < 4) {
                    return "Enter the command 'delete all workflows imeanit' to really delete all workflows\n";
                }
                if (!command[3].equals("imeanit")) return "Syntax Error.\n";
                for (WorkflowDefinition def : this.workflowService.getAllDefinitions()) {
                    List<WorkflowInstance> workflows = this.workflowService.getActiveWorkflows(def.getId());
                    for (WorkflowInstance workflowInstance : workflows) {
                        this.workflowService.deleteWorkflow(workflowInstance.getId());
                        out.println("workflow " + workflowInstance.getId() + " deleted.");
                    }
                }
            }
        } else {
            if (!command[0].equals("var")) return "Syntax Error.\n";
            if (command.length == 1) {
                for (Map.Entry<QName, Serializable> entry : this.vars.entrySet()) {
                    out.println(entry.getKey() + " = " + entry.getValue());
                }
            } else if (command.length == 2) {
                String[] param = command[1].split("=");
                if (param.length == 0) {
                    return "Syntax Error.\n";
                }
                if (param.length == 1) {
                    QName qname = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                    this.vars.remove(qname);
                    out.println("deleted var " + qname);
                } else {
                    if (param.length != 2) return "Syntax Error.\n";
                    boolean multi = false;
                    if (param[0].endsWith("*")) {
                        param[0] = param[0].substring(0, param[0].length() - 1);
                        multi = true;
                    }
                    QName qname = QName.createQName((String)param[0], (NamespacePrefixResolver)this.namespaceService);
                    String[] stringArray = param[1].split(",");
                    if (!multi && stringArray.length > 1) {
                        return "Syntax Error.\n";
                    }
                    if (!multi) {
                        this.vars.put(qname, (Serializable)((Object)stringArray[0]));
                    } else {
                        ArrayList<String> values = new ArrayList<String>();
                        String[] iOrderBy = stringArray;
                        int n = stringArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            String strValue = iOrderBy[n4];
                            values.add(strValue);
                            ++n4;
                        }
                        this.vars.put(qname, values);
                    }
                    out.println("set var " + qname + " = " + this.vars.get(qname));
                }
            } else {
                if (command.length != 4) return "Syntax Error.\n";
                if (command[2].equals("person")) {
                    boolean multi = false;
                    if (command[1].endsWith("*")) {
                        command[1] = command[1].substring(0, command[1].length() - 1);
                        multi = true;
                    }
                    QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                    String[] strValues = command[3].split(",");
                    if (!multi && strValues.length > 1) {
                        return "Syntax Error.\n";
                    }
                    if (!multi) {
                        NodeRef nodeRef = this.personService.getPerson(strValues[0]);
                        this.vars.put(qname, (Serializable)nodeRef);
                    } else {
                        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
                        String[] stringArray = strValues;
                        int n = strValues.length;
                        int strValue = 0;
                        while (strValue < n) {
                            String strValue2 = stringArray[strValue];
                            NodeRef auth = this.personService.getPerson(strValue2);
                            arrayList.add(auth);
                            ++strValue;
                        }
                        this.vars.put(qname, arrayList);
                    }
                    out.println("set var " + qname + " = " + this.vars.get(qname));
                } else if (command[2].equals("group")) {
                    boolean multi = false;
                    if (command[1].endsWith("*")) {
                        command[1] = command[1].substring(0, command[1].length() - 1);
                        multi = true;
                    }
                    QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                    String[] strValues = command[3].split(",");
                    if (!multi && strValues.length > 1) {
                        return "Syntax Error.\n";
                    }
                    if (!multi) {
                        NodeRef nodeRef = this.authorityDAO.getAuthorityNodeRefOrNull(strValues[0]);
                        if (nodeRef == null) {
                            throw new WorkflowException("Group " + strValues[0] + " does not exist.");
                        }
                        this.vars.put(qname, (Serializable)nodeRef);
                    } else {
                        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
                        String[] stringArray = strValues;
                        int n = strValues.length;
                        int strValue = 0;
                        while (strValue < n) {
                            String strValue3 = stringArray[strValue];
                            NodeRef auth = this.authorityDAO.getAuthorityNodeRefOrNull(strValue3);
                            if (auth == null) {
                                throw new WorkflowException("Group " + strValue3 + " does not exist.");
                            }
                            arrayList.add(auth);
                            ++strValue;
                        }
                        this.vars.put(qname, arrayList);
                    }
                    out.println("set var " + qname + " = " + this.vars.get(qname));
                } else {
                    void var8_121;
                    if (!command[2].equals("package")) return "Syntax Error.\n";
                    QName qname = QName.createQName((String)command[1], (NamespacePrefixResolver)this.namespaceService);
                    int number = new Integer(command[3]);
                    NodeRef packageNodeRef = this.workflowService.createPackage(null);
                    boolean bl = false;
                    while (var8_121 < number) {
                        FileInfo fileInfo = this.fileFolderService.create(packageNodeRef, "Content" + (int)var8_121, ContentModel.TYPE_CONTENT);
                        ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
                        writer.putContent("Content" + (int)var8_121);
                        ++var8_121;
                    }
                    this.vars.put(qname, (Serializable)packageNodeRef);
                    out.println("set var " + qname + " = " + this.vars.get(qname));
                }
            }
        }
        out.flush();
        String retVal = new String(bout.toByteArray());
        out.close();
        return retVal;
    }

    private String getTransition(String[] command) {
        int length = command.length;
        if (length < 3) {
            return null;
        }
        StringBuilder builder = new StringBuilder(command[2]);
        int i = 3;
        while (i < length) {
            builder.append(" ").append(command[i++]);
        }
        return builder.toString();
    }

    public WorkflowDefinition getCurrentWorkflowDef() {
        return this.currentWorkflowDef;
    }

    private void setupStartTaskParameters(TypeDefinition typeDef, Map<QName, Serializable> params) {
        List aspects = typeDef.getDefaultAspects();
        ArrayList<QName> aspectNames = new ArrayList<QName>(aspects.size());
        this.getMandatoryAspects((ClassDefinition)typeDef, aspectNames);
        TypeDefinition startTaskDef = this.dictionaryService.getAnonymousType(typeDef.getName(), aspectNames);
        Map propertyDefs = startTaskDef.getProperties();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            String defaultValue = ((PropertyDefinition)entry.getValue()).getDefaultValue();
            if (params.get(entry.getKey()) == null) {
                if (defaultValue == null) continue;
                params.put((QName)entry.getKey(), (Serializable)DefaultTypeConverter.INSTANCE.convert(((PropertyDefinition)entry.getValue()).getDataType(), (Object)defaultValue));
                continue;
            }
            params.put((QName)entry.getKey(), (Serializable)DefaultTypeConverter.INSTANCE.convert(((PropertyDefinition)entry.getValue()).getDataType(), (Object)params.get(entry.getKey())));
        }
        if (params.containsKey(WorkflowModel.ASSOC_ASSIGNEE)) {
            String value = (String)((Object)params.get(WorkflowModel.ASSOC_ASSIGNEE));
            ArrayList<NodeRef> assignees = new ArrayList<NodeRef>();
            assignees.add(this.personService.getPerson(value));
            params.put(WorkflowModel.ASSOC_ASSIGNEE, assignees);
        }
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)this.workflowService.createPackage(null));
    }

    private void getMandatoryAspects(ClassDefinition classDef, List<QName> aspects) {
        for (AspectDefinition aspect : classDef.getDefaultAspects()) {
            QName aspectName = aspect.getName();
            if (aspects.contains(aspectName)) continue;
            aspects.add(aspect.getName());
            this.getMandatoryAspects((ClassDefinition)aspect, aspects);
        }
    }

    private void endStartTaskForPath(WorkflowPath path) {
        List<WorkflowTask> tasks;
        if (path != null && (tasks = this.workflowService.getTasksForWorkflowPath(path.id)).size() == 1) {
            WorkflowTask startTask = tasks.get(0);
            if (startTask.state == WorkflowTaskState.IN_PROGRESS) {
                this.workflowService.endTask(startTask.id, null);
            }
        }
    }
}

