/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;

public class AuthenticatedAsyncJobHandler
implements JobHandler {
    private JobHandler wrappedHandler;

    public AuthenticatedAsyncJobHandler(JobHandler jobHandler) {
        if (jobHandler == null) {
            throw new IllegalArgumentException("JobHandler to delegate to is required");
        }
        this.wrappedHandler = jobHandler;
    }

    public void execute(final JobEntity job, final String configuration, final ExecutionEntity execution, final CommandContext commandContext) {
        String userName = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                ActivitiScriptNode ownerNode = (ActivitiScriptNode)execution.getVariable("initiator");
                if (ownerNode != null && ownerNode.exists()) {
                    return (String)ownerNode.getProperties().get(ContentModel.PROP_USERNAME);
                }
                return null;
            }
        });
        if (userName == null) {
            userName = AuthenticationUtil.getSystemUserName();
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuthenticatedAsyncJobHandler.this.wrappedHandler.execute(job, configuration, execution, commandContext);
                return null;
            }
        }, (String)userName);
    }

    public String getType() {
        return this.wrappedHandler.getType();
    }
}

