/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterLimits;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataExtracterLimitsTest {
    private MockDelayedMetadataExtracter extracter;

    @Before
    public void setUp() throws Exception {
        this.extracter = new MockDelayedMetadataExtracter(1500L);
        this.extracter.init();
    }

    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    protected Map<QName, Serializable> extractFromFile(File sourceFile, String mimetype) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        FileContentReader sourceReader = new FileContentReader(sourceFile);
        sourceReader.setMimetype(mimetype);
        this.getExtracter().extract((ContentReader)sourceReader, properties);
        return properties;
    }

    @Test
    public void testNoTimeout() throws Exception {
        File file = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.txt");
        Map<QName, Serializable> properties = this.extractFromFile(file, "text/plain");
        Assert.assertEquals((Object)"value1", (Object)properties.get(QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"a1")));
    }

    @Test
    public void testWildcardTimeout() throws Exception {
        long timeoutMs = 1000L;
        MetadataExtracterLimits limits = new MetadataExtracterLimits();
        limits.setTimeoutMs(timeoutMs);
        HashMap<String, MetadataExtracterLimits> mimetypeLimits = new HashMap<String, MetadataExtracterLimits>(1);
        mimetypeLimits.put("*", limits);
        ((MockDelayedMetadataExtracter)this.getExtracter()).setMimetypeLimits(mimetypeLimits);
        File file = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.txt");
        long startTime = new Date().getTime();
        this.extractFromFile(file, "text/plain");
        long extractionTime = new Date().getTime() - startTime;
        Assert.assertTrue((String)("Metadata extraction took (" + extractionTime + "ms) " + "but should have failed with a timeout at " + timeoutMs + "ms"), (extractionTime < timeoutMs + 50L ? 1 : 0) != 0);
    }

    @Test
    public void testMimetypeSpecificTimeout() throws Exception {
        long timeoutMs = 1000L;
        MetadataExtracterLimits limits = new MetadataExtracterLimits();
        limits.setTimeoutMs(timeoutMs);
        HashMap<String, MetadataExtracterLimits> mimetypeLimits = new HashMap<String, MetadataExtracterLimits>(1);
        mimetypeLimits.put("text/plain", limits);
        ((MockDelayedMetadataExtracter)this.getExtracter()).setMimetypeLimits(mimetypeLimits);
        File file = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.txt");
        long startTime = new Date().getTime();
        this.extractFromFile(file, "text/plain");
        long extractionTime = new Date().getTime() - startTime;
        Assert.assertTrue((String)("Metadata extraction took (" + extractionTime + "ms) " + "but should have failed with a timeout at " + timeoutMs + "ms"), (extractionTime < timeoutMs + 50L ? 1 : 0) != 0);
    }

    @Test
    public void testInterrupted() throws Exception {
        long timeoutMs = 5000L;
        long interruptMs = 500L;
        MetadataExtracterLimits limits = new MetadataExtracterLimits();
        limits.setTimeoutMs(timeoutMs);
        HashMap<String, MetadataExtracterLimits> mimetypeLimits = new HashMap<String, MetadataExtracterLimits>(1);
        mimetypeLimits.put("text/plain", limits);
        ((MockDelayedMetadataExtracter)this.getExtracter()).setMimetypeLimits(mimetypeLimits);
        final File file = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.txt");
        long startTime = new Date().getTime();
        Thread extractThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MetadataExtracterLimitsTest.this.extractFromFile(file, "text/plain");
            }
        });
        extractThread.start();
        Thread.sleep(interruptMs);
        extractThread.interrupt();
        long extractionTime = new Date().getTime() - startTime;
        Assert.assertTrue((String)("Metadata extraction took (" + extractionTime + "ms) " + "but should have been interrupted at " + interruptMs + "ms"), (extractionTime < interruptMs + 500L ? 1 : 0) != 0);
    }

    @Test
    public void testUnmatchedMimetypeSpecificTimeout() throws Exception {
        long timeoutMs = 1000L;
        MetadataExtracterLimits limits = new MetadataExtracterLimits();
        limits.setTimeoutMs(timeoutMs);
        HashMap<String, MetadataExtracterLimits> mimetypeLimits = new HashMap<String, MetadataExtracterLimits>(1);
        mimetypeLimits.put("image/jpeg", limits);
        ((MockDelayedMetadataExtracter)this.getExtracter()).setMimetypeLimits(mimetypeLimits);
        File file = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.txt");
        Map<QName, Serializable> properties = this.extractFromFile(file, "text/plain");
        Assert.assertEquals((Object)"value1", (Object)properties.get(QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"a1")));
    }

    @Test
    public void testUnlimitedTimeout() throws Exception {
        File file = AbstractContentTransformerTest.loadNamedQuickTestFile("quick.txt");
        Map<QName, Serializable> properties = this.extractFromFile(file, "text/plain");
        Assert.assertEquals((Object)"value1", (Object)properties.get(QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"a1")));
    }

    private class MockDelayedMetadataExtracter
    extends AbstractMappingMetadataExtracter {
        private long delay;

        public MockDelayedMetadataExtracter(long delay) {
            this.delay = delay;
        }

        public boolean isSupported(String sourceMimetype) {
            return true;
        }

        protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>(10);
            long startTime = new Date().getTime();
            boolean done = false;
            int i = 0;
            try {
                while (!done) {
                    Thread.sleep(50L);
                    long extractTime = new Date().getTime() - startTime;
                    properties.put("key" + i, Long.valueOf(extractTime));
                    ++i;
                    boolean bl = done = extractTime > this.delay;
                }
                properties.put("a", (Serializable)((Object)"value1"));
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            return properties;
        }
    }
}

