/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.ADMAccessControlListDAO;
import org.alfresco.repo.domain.permissions.ADMPermissionsDaoComponentImpl;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.FixedAclUpdater;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.PermissionsDaoComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.test.junitrules.RetryAtMostRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.ConcurrencyFailureException;

public class FixedAclUpdaterTest {
    private static final Logger LOG = LoggerFactory.getLogger(FixedAclUpdaterTest.class);
    private ApplicationContext ctx;
    private RetryingTransactionHelper txnHelper;
    private FileFolderService fileFolderService;
    private Repository repository;
    private FixedAclUpdater fixedAclUpdater;
    private PermissionsDaoComponent permissionsDaoComponent;
    private PermissionService permissionService;
    private NodeDAO nodeDAO;
    private NodeRef homeFolderNodeRef;
    private LockService lockService;
    private CheckOutCheckInService checkOutCheckInService;
    private ContentService contentService;
    private AuthorityService authorityService;
    private static final long MAX_TRANSACTION_TIME_DEFAULT = 10L;
    private static final int[] filesPerLevelMoreFolders = new int[]{5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] filesPerLevelMoreFiles = new int[]{5, 100};
    private long maxTransactionTime;
    private static HashMap<Integer, Class<?>> errors;
    private static String TEST_GROUP_NAME;
    private static String TEST_GROUP_NAME_FULL;
    private static String DEFAULT_PERMISSION;
    @Rule
    public RetryAtMostRule retryAtMostRule = new RetryAtMostRule();

    static {
        TEST_GROUP_NAME = "FixedACLUpdaterTest";
        TEST_GROUP_NAME_FULL = "GROUP_" + TEST_GROUP_NAME;
        DEFAULT_PERMISSION = "Contributor";
    }

    @Before
    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.txnHelper = serviceRegistry.getTransactionService().getRetryingTransactionHelper();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.repository = (Repository)this.ctx.getBean("repositoryHelper");
        this.fixedAclUpdater = (FixedAclUpdater)this.ctx.getBean("fixedAclUpdater");
        this.permissionsDaoComponent = (PermissionsDaoComponent)this.ctx.getBean("admPermissionsDaoComponent");
        this.permissionService = (PermissionService)this.ctx.getBean("permissionService");
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        this.lockService = (LockService)this.ctx.getBean("lockService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.ctx.getBean("checkOutCheckInService");
        this.contentService = (ContentService)this.ctx.getBean("contentService");
        this.authorityService = (AuthorityService)this.ctx.getBean("authorityService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.homeFolderNodeRef = this.repository.getCompanyHome();
        this.maxTransactionTime = 10L;
        FixedAclUpdaterTest.setFixedAclMaxTransactionTime(this.permissionsDaoComponent, this.homeFolderNodeRef, this.maxTransactionTime);
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testSyncNoTimeOut() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testSyncNoTimeOutFolder");
        ACLComparator aclComparator = new ACLComparator(folderRef);
        try {
            this.maxTransactionTime = 86400000L;
            FixedAclUpdaterTest.setFixedAclMaxTransactionTime(this.permissionsDaoComponent, this.homeFolderNodeRef, this.maxTransactionTime);
            this.setPermissionsOnTree(folderRef, false, false);
            aclComparator.compareACLs();
            Assert.assertEquals((String)"There are nodes pending", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    public void testSyncTimeOut() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testSyncTimeOutFolder");
        ACLComparator aclComparator = new ACLComparator(folderRef);
        try {
            long timestampBeforePermissions = System.currentTimeMillis();
            this.setPermissionsOnTree(folderRef, false, true);
            aclComparator.updateCurrentACLs();
            Assert.assertTrue((String)"Permissions not applied", (boolean)aclComparator.parentHasOriginalPermission());
            NodeRef folderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            long folderWithPendingAclNodeId = (Long)this.nodeDAO.getNodePair(folderWithPendingAcl).getFirst();
            Date modificationDate = (Date)this.nodeDAO.getNodeProperty(Long.valueOf(folderWithPendingAclNodeId), ContentModel.PROP_MODIFIED);
            Assert.assertTrue((String)"Changing permissions updated cm:modified", (modificationDate.getTime() < timestampBeforePermissions ? 1 : 0) != 0);
            ACLComparator aclComparatorForPending = new ACLComparator(folderWithPendingAcl);
            Assert.assertEquals((String)"Pending inheritFrom value should be the parent ACL id", (Object)aclComparator.getParentAcl(), (Object)aclComparatorForPending.getPendingInheritFromAcl());
            Assert.assertFalse((String)"Permissions not expected to be applied on a pending node before job", (boolean)aclComparatorForPending.firstChildHasOriginalPermission());
            this.triggerFixedACLJob();
            aclComparator.updateCurrentACLs();
            aclComparatorForPending.updateCurrentACLs();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertEquals((String)"Processed Pending ACL children doesn't have correct ACL", (Object)aclComparator.getChildAcl(), (Object)aclComparatorForPending.getChildAcl());
            Assert.assertTrue((String)"Permissions not applied on pending nodes", (boolean)aclComparatorForPending.firstChildHasOriginalPermission());
            Date modificationDateAfterJob = (Date)this.nodeDAO.getNodeProperty(Long.valueOf(folderWithPendingAclNodeId), ContentModel.PROP_MODIFIED);
            Assert.assertEquals((String)"Running the job updated cm:modified", (long)modificationDate.getTime(), (long)modificationDateAfterJob.getTime());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsync() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncFolder");
        ACLComparator aclComparator = new ACLComparator(folderRef);
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            aclComparator.updateCurrentACLs();
            Assert.assertTrue((String)"Permissions not applied", (boolean)aclComparator.parentHasOriginalPermission());
            NodeRef folderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)folderWithPendingAcl);
            ACLComparator aclComparatorForPending = new ACLComparator(folderWithPendingAcl);
            Assert.assertEquals((String)"Pending inheritFrom value should be the parent ACL id", (Object)aclComparator.getParentAcl(), (Object)aclComparatorForPending.getPendingInheritFromAcl());
            Assert.assertFalse((String)"Permissions not expected to be applied on a pending node before job", (boolean)aclComparatorForPending.firstChildHasOriginalPermission());
            this.triggerFixedACLJob();
            aclComparator.updateCurrentACLs();
            aclComparatorForPending.updateCurrentACLs();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertEquals((String)"Processed Pending ACL children doesn't have correct ACL", (Object)aclComparator.getChildAcl(), (Object)aclComparatorForPending.getChildAcl());
            Assert.assertTrue((String)"Pending nodes doesn't have same permission as parent", (boolean)aclComparatorForPending.parentHasOriginalPermission());
            Assert.assertTrue((String)"Children of Pending nodes doesn't have same permission as parent", (boolean)aclComparatorForPending.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeCreation() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCreationFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef folderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)folderWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                FixedAclUpdaterTest.createFile(this.fileFolderService, folderWithPendingAcl, "NewFile", ContentModel.TYPE_CONTENT);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeDeletion() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeDeletionFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef folderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)folderWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.delete(folderWithPendingAcl);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    public void testSyncCopyNoTimeOut() throws FileExistsException, FileNotFoundException {
        NodeRef originalRef = this.createFolderHierarchyInRootForFolderTests("originFolder");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("targetFolder");
        ACLComparator aclComparatorOrigin = new ACLComparator(originalRef);
        try {
            this.maxTransactionTime = 86400000L;
            FixedAclUpdaterTest.setFixedAclMaxTransactionTime(this.permissionsDaoComponent, this.homeFolderNodeRef, this.maxTransactionTime);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            this.permissionService.setInheritParentPermissions(originalRef, true, false);
            this.permissionService.setPermission(originalRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
            aclComparatorOrigin.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
            this.permissionService.setInheritParentPermissions(targetRef, true, false);
            this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
            NodeRef copiedNode = this.fileFolderService.copy(originalRef, targetRef, null).getNodeRef();
            ACLComparator aclComparatorCopied = new ACLComparator(copiedNode);
            aclComparatorOrigin.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
            Assert.assertEquals((String)"There are nodes pending", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Copied node did not inherit permissions from target", (boolean)aclComparatorCopied.hasPermission(TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION));
            Assert.assertTrue((String)"Child of Copied node did not inherit permissions from target", (boolean)aclComparatorCopied.firstChildHasPermission(TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION));
            Assert.assertTrue((String)"Copied node did not keep original permissions", (boolean)aclComparatorCopied.parentHasOriginalPermission());
            Assert.assertTrue((String)"Child of Copied node did not keep original permissions", (boolean)aclComparatorCopied.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(originalRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeCopy() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCopyOriginFolder");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCopyTargetFolder");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            ACLComparator aclComparatorTarget = new ACLComparator(targetRef);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRef, false, false);
                this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                aclComparatorTarget.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
                return null;
            }, false, true);
            Assert.assertTrue((String)"Target Folder does not have correct permission", (boolean)aclComparatorTarget.parentHasOriginalPermission());
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
                return null;
            }, false, true);
            NodeRef folderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)folderWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.copy(folderWithPendingAcl, targetRef, "copyOfFolder");
                return null;
            }, false, true);
            NodeRef copiedChild = this.fileFolderService.searchSimple(targetRef, "copyOfFolder");
            ACLComparator aclComparatorCopiedPendingChild = new ACLComparator(copiedChild);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Pending Copied node did not inherit permissions from target", (boolean)aclComparatorCopiedPendingChild.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending Copied node did not inherit permissions from target", (boolean)aclComparatorCopiedPendingChild.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertFalse((String)"Pending Copied node kept original permissions", (boolean)aclComparatorCopiedPendingChild.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Pending Copied node kept original permissions", (boolean)aclComparatorCopiedPendingChild.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeCopyToPendingFolder() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCopyOriginFolder");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCopyTargetFolder");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            ACLComparator aclComparatorTarget = new ACLComparator(targetRef);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRef, false, false);
                this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                aclComparatorTarget.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
                return null;
            }, false, true);
            Assert.assertTrue((String)"Target Folder does not have correct permission", (boolean)aclComparatorTarget.parentHasOriginalPermission());
            NodeRef targetFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, targetRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)targetFolderWithPendingAcl);
            ACLComparator aclComparatorTargetPendingChild = new ACLComparator(targetFolderWithPendingAcl);
            aclComparatorTargetPendingChild.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
                return null;
            }, false, true);
            NodeRef originFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)originFolderWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.copy(originFolderWithPendingAcl, targetFolderWithPendingAcl, "copyOfFolder");
                return null;
            }, false, true);
            NodeRef copiedChild = this.fileFolderService.searchSimple(targetFolderWithPendingAcl, "copyOfFolder");
            ACLComparator aclComparatorCopiedPendingChild = new ACLComparator(copiedChild);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Pending Copied node did not inherit permissions from target", (boolean)aclComparatorCopiedPendingChild.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of PendingCopied node did not inherit permissions from target", (boolean)aclComparatorCopiedPendingChild.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertFalse((String)"Pending Copied kept original permissions", (boolean)aclComparatorCopiedPendingChild.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Pending Copied node kept original permissions", (boolean)aclComparatorCopiedPendingChild.firstChildHasOriginalPermission());
            Assert.assertTrue((String)"Pending target node does not have parent's permissions", (boolean)aclComparatorTargetPendingChild.parentHasOriginalPermission());
            Assert.assertTrue((String)"Child of Pending target node does not have parent's permissions", (boolean)aclComparatorTargetPendingChild.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeCopyParentToChildPendingFolder() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCopyOriginFolder");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeCopyTargetFolder");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            ACLComparator aclComparatorTarget = new ACLComparator(targetRef);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRef, false, false);
                this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                aclComparatorTarget.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
                return null;
            }, false, true);
            Assert.assertTrue((String)"Target Folder does not have correct permission", (boolean)aclComparatorTarget.parentHasOriginalPermission());
            NodeRef targetFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, targetRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)targetFolderWithPendingAcl);
            NodeRef targetFolderWithPendingAclChild = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetFolderWithPendingAcl).getFirst())).getSecond();
            ACLComparator aclComparatorTargetPendingChild = new ACLComparator(targetFolderWithPendingAclChild);
            aclComparatorTargetPendingChild.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
                return null;
            }, false, true);
            NodeRef originFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)originFolderWithPendingAcl);
            NodeRef originFolderWithPendingAclParent = ((ChildAssociationRef)this.nodeDAO.getPrimaryParentAssoc((Long)this.nodeDAO.getNodePair(originFolderWithPendingAcl).getFirst()).getSecond()).getParentRef();
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.copy(originFolderWithPendingAclParent, targetFolderWithPendingAcl, "copyOfFolder");
                return null;
            }, false, true);
            NodeRef copiedChild = this.fileFolderService.searchSimple(targetFolderWithPendingAcl, "copyOfFolder");
            ACLComparator aclComparatorCopiedPendingParent = new ACLComparator(copiedChild);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Copied Parent node did not inherit permissions from target", (boolean)aclComparatorCopiedPendingParent.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Pending Node copied with parent node did not inherit permissions from target", (boolean)aclComparatorCopiedPendingParent.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            if (originFolderWithPendingAclParent.equals((Object)folderRef)) {
                Assert.assertTrue((String)"Copied Parent (from original node where permissions were set) did not keep original permissions", (boolean)aclComparatorCopiedPendingParent.parentHasOriginalPermission());
                Assert.assertTrue((String)"Pending Node copied with parent node did not keep original permissions", (boolean)aclComparatorCopiedPendingParent.firstChildHasOriginalPermission());
            } else {
                Assert.assertFalse((String)"Copied Parent kept original permissions", (boolean)aclComparatorCopiedPendingParent.parentHasOriginalPermission());
                Assert.assertFalse((String)"Pending Node copied with parent node kept original permissions", (boolean)aclComparatorCopiedPendingParent.firstChildHasOriginalPermission());
            }
            Assert.assertTrue((String)"Pending target node does not have parent's permissions", (boolean)aclComparatorTargetPendingChild.parentHasOriginalPermission());
            Assert.assertTrue((String)"Child of Pending target node does not have parent's permissions", (boolean)aclComparatorTargetPendingChild.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeMoveChildToChildPendingFolder() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeMoveChildToChildPendingFolderOrigin");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeMoveChildToChildPendingFolderTarget");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRef, true, false);
                this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                return null;
            }, false, true);
            NodeRef targetFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, targetRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)targetFolderWithPendingAcl);
            NodeRef targetFolderWithPendingAclChild = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetFolderWithPendingAcl).getFirst())).getSecond();
            ACLComparator aclComparatorTarget = new ACLComparator(targetFolderWithPendingAcl);
            aclComparatorTarget.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
                return null;
            }, false, true);
            NodeRef originFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)originFolderWithPendingAcl);
            NodeRef originFolderWithPendingAclChild = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(originFolderWithPendingAcl).getFirst())).getSecond();
            ACLComparator aclComparatorMovedNode = new ACLComparator(originFolderWithPendingAclChild);
            aclComparatorMovedNode.setOriginalPermission(TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION);
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.move(originFolderWithPendingAclChild, targetFolderWithPendingAclChild, "movedFolder");
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Moved node did not inherit permissions from target", (boolean)aclComparatorMovedNode.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending Moved node did not inherit permissions from target", (boolean)aclComparatorMovedNode.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertFalse((String)"Moved node kept original permissions", (boolean)aclComparatorMovedNode.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Moved node kept original permissions", (boolean)aclComparatorMovedNode.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithErrorsForceSharedACL() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithErrorsForceSharedACL");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                return null;
            }, false, true);
            NodeRef originFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)originFolderWithPendingAcl);
            NodeRef originFolderWithPendingAclChild = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(originFolderWithPendingAcl).getFirst())).getSecond();
            this.txnHelper.doInTransaction(() -> {
                NodeRef tempNode = FixedAclUpdaterTest.createFile(this.fileFolderService, folderRef, "testAsyncWithErrorsForceSharedACLTemp", ContentModel.TYPE_FOLDER);
                this.permissionService.setInheritParentPermissions(tempNode, false, false);
                this.permissionService.setPermission(tempNode, TEST_GROUP_NAME_FULL, "Consumer", true);
                NodeRef tempNodeChild = FixedAclUpdaterTest.createFile(this.fileFolderService, tempNode, "testAsyncWithErrorsForceSharedACLTempChild", ContentModel.TYPE_FOLDER);
                FixedAclUpdaterTest.setACL(this.permissionsDaoComponent, originFolderWithPendingAclChild, this.nodeDAO.getNodeAclId((Long)this.nodeDAO.getNodePair(tempNodeChild).getFirst()));
                return null;
            }, false, true);
            ACLComparator aclComparator = new ACLComparator(originFolderWithPendingAclChild);
            this.triggerFixedACLJob(false);
            Assert.assertEquals((String)"Unexpected number of errors", (long)1L, (long)this.getNodesCountWithPendingFixedAclAspect());
            this.triggerFixedACLJob(true);
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Child of node with conflict does not have correct permissions", (boolean)aclComparator.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Node with conflict does not have correct permissions", (boolean)aclComparator.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeMove() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeMoveOriginFolder");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeMoveTargetFolder");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            ACLComparator aclComparatorTarget = new ACLComparator(targetRef);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRef, false, false);
                this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                aclComparatorTarget.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
                return null;
            }, false, true);
            Assert.assertTrue((String)"Target Folder does not have correct permission", (boolean)aclComparatorTarget.parentHasOriginalPermission());
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
                return null;
            }, false, true);
            NodeRef folderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            ACLComparator aclComparatorOriginPendingChild = new ACLComparator(folderWithPendingAcl);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)folderWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.move(folderWithPendingAcl, targetRef, "moveOfFolder");
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Pending Moved node did not inherit permissions from target", (boolean)aclComparatorOriginPendingChild.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending Moved node did not inherit permissions from target", (boolean)aclComparatorOriginPendingChild.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertFalse((String)"Pending Moved node kept original permissions", (boolean)aclComparatorOriginPendingChild.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Pending Moved node kept original permissions", (boolean)aclComparatorOriginPendingChild.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeMoveToPendingFolder() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeMoveOriginFolder");
        NodeRef targetRefBase = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeMoveTargetFolder");
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRefBase, true, false);
                this.permissionService.setPermission(targetRefBase, TEST_GROUP_NAME_FULL, "Consumer", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            NodeRef targetRef = (NodeRef)this.nodeDAO.getNodePair(this.getChild((Long)this.nodeDAO.getNodePair(targetRefBase).getFirst())).getSecond();
            ACLComparator aclComparatorTarget = new ACLComparator(targetRef);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(targetRef, false, false);
                this.permissionService.setPermission(targetRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                aclComparatorTarget.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
                return null;
            }, false, true);
            Assert.assertTrue((String)"Target Folder does not have correct permission", (boolean)aclComparatorTarget.parentHasOriginalPermission());
            NodeRef targetFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, targetRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)targetFolderWithPendingAcl);
            ACLComparator aclComparatorTargetPendingChild = new ACLComparator(targetFolderWithPendingAcl);
            aclComparatorTargetPendingChild.setOriginalPermission(TEST_GROUP_NAME_FULL, "Coordinator");
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, true, false);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
                return null;
            }, false, true);
            NodeRef originFolderWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER, folderRef);
            Assert.assertNotNull((String)"No children folders were found with pendingFixACl aspect", (Object)originFolderWithPendingAcl);
            ACLComparator aclComparatorOriginPendingChild = new ACLComparator(originFolderWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.fileFolderService.move(originFolderWithPendingAcl, targetFolderWithPendingAcl, "movedFolder");
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Pending Moved node did not inherit permissions from target", (boolean)aclComparatorOriginPendingChild.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of PendingMoved node did not inherit permissions from target", (boolean)aclComparatorOriginPendingChild.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertFalse((String)"Pending Moved kept original permissions", (boolean)aclComparatorOriginPendingChild.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Pending Moved node kept original permissions", (boolean)aclComparatorOriginPendingChild.firstChildHasOriginalPermission());
            Assert.assertTrue((String)"Pending target node does not have parent's permissions", (boolean)aclComparatorTargetPendingChild.parentHasOriginalPermission());
            Assert.assertTrue((String)"Child of Pending target node does not have parent's permissions", (boolean)aclComparatorTargetPendingChild.firstChildHasOriginalPermission());
        }
        finally {
            this.deleteNodes(folderRef);
            this.deleteNodes(targetRefBase);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeLock() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFileTests("testAsyncWithNodeLockFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_CONTENT);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.lockService.lock(nodeWithPendingAcl, LockType.READ_ONLY_LOCK);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeCheckout() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFileTests("testAsyncWithNodeCheckoutFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_CONTENT);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                NodeRef workingCopy = this.checkOutCheckInService.checkout(nodeWithPendingAcl);
                Assert.assertNotNull((String)"Working copy is null", (Object)workingCopy);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeUpdatePermissionsFixed() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeUpdatePermissionsFixedFolder");
        ACLComparator aclComparatorTop = new ACLComparator(folderRef);
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            aclComparatorTop.updateCurrentACLs();
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            ACLComparator aclComparator = new ACLComparator(nodeWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(nodeWithPendingAcl, false, false);
                this.permissionService.setPermission(nodeWithPendingAcl, TEST_GROUP_NAME_FULL, "Coordinator", true);
                return null;
            }, false, true);
            aclComparator.updateCurrentACLs();
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertFalse((String)"Pending node is not expected to have old permission", (boolean)aclComparator.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Pending node is not expected to have old permission", (boolean)aclComparator.firstChildHasOriginalPermission());
            Assert.assertTrue((String)"Pending node is expected to have new permission", (boolean)aclComparator.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending node is expected to have new permission", (boolean)aclComparator.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeUpdatePermissionsShared() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithNodeUpdatePermissionsSharedFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            ACLComparator aclComparator = new ACLComparator(nodeWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(nodeWithPendingAcl, true, false);
                this.permissionService.setPermission(nodeWithPendingAcl, TEST_GROUP_NAME_FULL, "Coordinator", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Pending node is expected to have old permission", (boolean)aclComparator.parentHasOriginalPermission());
            Assert.assertTrue((String)"Child of Pending node is expected to have old permission", (boolean)aclComparator.firstChildHasOriginalPermission());
            Assert.assertTrue((String)"Pending node is expected to have new permission", (boolean)aclComparator.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending node is expected to have new permission", (boolean)aclComparator.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithParentUpdatePermissionsFixed() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithParentUpdatePermissionsFixedFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            ACLComparator aclComparator = new ACLComparator(nodeWithPendingAcl);
            NodeRef parentRef = ((ChildAssociationRef)this.nodeDAO.getPrimaryParentAssoc((Long)this.nodeDAO.getNodePair(nodeWithPendingAcl).getFirst()).getSecond()).getParentRef();
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(parentRef, false, false);
                this.permissionService.setPermission(parentRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertFalse((String)"Pending node is not expected to have old permission", (boolean)aclComparator.parentHasOriginalPermission());
            Assert.assertFalse((String)"Child of Pending node is not expected to have old permission", (boolean)aclComparator.firstChildHasOriginalPermission());
            Assert.assertTrue((String)"Pending node is expected to have new permission", (boolean)aclComparator.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending node is expected to have new permission", (boolean)aclComparator.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithParentUpdatePermissionsShared() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncWithParentUpdatePermissionsSharedFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_FOLDER);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            ACLComparator aclComparator = new ACLComparator(nodeWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                NodeRef parentRef = ((ChildAssociationRef)this.nodeDAO.getPrimaryParentAssoc((Long)this.nodeDAO.getNodePair(nodeWithPendingAcl).getFirst()).getSecond()).getParentRef();
                this.permissionService.setInheritParentPermissions(parentRef, true, false);
                this.permissionService.setPermission(parentRef, TEST_GROUP_NAME_FULL, "Coordinator", true);
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Pending node is expected to have old permission", (boolean)aclComparator.parentHasOriginalPermission());
            Assert.assertTrue((String)"Child of Pending node is expected to have old permission", (boolean)aclComparator.firstChildHasOriginalPermission());
            Assert.assertTrue((String)"Pending node is expected to have new permission", (boolean)aclComparator.hasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
            Assert.assertTrue((String)"Child of Pending node is expected to have new permission", (boolean)aclComparator.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Coordinator"));
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncCascadeUpdatePermissions() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncCascadeUpdatePermissionsFolder");
        List subFolders = this.fileFolderService.listFolders(folderRef);
        NodeRef subFolder1 = ((FileInfo)subFolders.get(0)).getNodeRef();
        ACLComparator aclComparatorBase = new ACLComparator(folderRef);
        ACLComparator aclComparatorSubfolder1 = new ACLComparator(subFolder1);
        try {
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(subFolder1, false, true);
                this.permissionService.setPermission(subFolder1, TEST_GROUP_NAME_FULL, "Contributor", true);
                aclComparatorSubfolder1.setOriginalPermission(TEST_GROUP_NAME_FULL, "Contributor");
                return null;
            }, false, true);
            this.txnHelper.doInTransaction(() -> {
                this.permissionService.setInheritParentPermissions(folderRef, false, true);
                this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, "Consumer", true);
                aclComparatorBase.setOriginalPermission(TEST_GROUP_NAME_FULL, "Consumer");
                return null;
            }, false, true);
            Assert.assertTrue((String)"There are no nodes to process", (this.getNodesCountWithPendingFixedAclAspect() > 0 ? 1 : 0) != 0);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
            Assert.assertTrue((String)"Base Folder permissions are incorrect", (boolean)aclComparatorBase.hasPermission(TEST_GROUP_NAME_FULL, "Consumer"));
            Assert.assertTrue((String)"First Sub-Folder permissions are incorrect", (boolean)aclComparatorSubfolder1.hasPermission(TEST_GROUP_NAME_FULL, "Contributor"));
            Assert.assertTrue((String)"Child of First Sub-Folder permissions are incorrect", (boolean)aclComparatorSubfolder1.firstChildHasPermission(TEST_GROUP_NAME_FULL, "Contributor"));
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncWithNodeContentUpdate() {
        NodeRef folderRef = this.createFolderHierarchyInRootForFileTests("testAsyncWithNodeContentUpdateFolder");
        try {
            this.setPermissionsOnTree(folderRef, true, true);
            NodeRef nodeWithPendingAcl = this.getFirstNodeWithAclPending(ContentModel.TYPE_CONTENT);
            Assert.assertNotNull((String)"No children files were found with pendingFixACl aspect", (Object)nodeWithPendingAcl);
            this.txnHelper.doInTransaction(() -> {
                ContentWriter contentWriter = this.contentService.getWriter(nodeWithPendingAcl, ContentModel.PROP_CONTENT, true);
                contentWriter.setEncoding("UTF-8");
                contentWriter.setMimetype("text/plain");
                contentWriter.putContent("Updated content for file");
                return null;
            }, false, true);
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncConcurrentPermissionsUpdate() throws Throwable {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncConcurrentPermissionsUpdateFolder");
        List subFolders = this.fileFolderService.listFolders(folderRef);
        String group_prefix = "TEST_";
        int concurrentUpdates = 5;
        try {
            void var8_9;
            this.txnHelper.doInTransaction(() -> {
                HashSet<String> zones = new HashSet<String>(2, 1.0f);
                zones.add("APP.DEFAULT");
                int i = 0;
                while (i < concurrentUpdates) {
                    if (!this.authorityService.authorityExists("GROUP_" + group_prefix + i)) {
                        this.authorityService.createAuthority(AuthorityType.GROUP, String.valueOf(group_prefix) + i, String.valueOf(group_prefix) + i, zones);
                    }
                    ++i;
                }
                return null;
            }, false, true);
            Runnable[] runnables = new Runnable[concurrentUpdates];
            ArrayList<Thread> threads = new ArrayList<Thread>();
            errors = new HashMap();
            runnables[0] = this.createRunnableToSetPermissions(folderRef, String.valueOf(group_prefix) + 0, 0);
            Thread threadBase = new Thread(runnables[0]);
            threads.add(threadBase);
            threadBase.start();
            boolean bl = true;
            while (var8_9 < runnables.length) {
                NodeRef nodeRef = ((FileInfo)subFolders.get((int)(var8_9 - true))).getNodeRef();
                runnables[var8_9] = this.createRunnableToSetPermissions(nodeRef, String.valueOf(group_prefix) + (int)var8_9, (int)var8_9);
                Thread thread = new Thread(runnables[var8_9]);
                threads.add(thread);
                thread.start();
                ++var8_9;
            }
            for (Thread thread : threads) {
                thread.join();
            }
            for (Map.Entry entry : errors.entrySet()) {
                Assert.assertEquals((String)"Unexpected error on Concurrent Update", ConcurrencyFailureException.class, entry.getValue());
            }
            this.triggerFixedACLJob();
            Assert.assertTrue((String)"There were no concurrency errors", (errors.entrySet().size() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @RetryAtMostRule.RetryAtMost(value=3)
    public void testAsyncConcurrentUpdateAndJob() throws Throwable {
        NodeRef folderRef = this.createFolderHierarchyInRootForFolderTests("testAsyncConcurrentUpdateAndJobFolder");
        List subFolders = this.fileFolderService.listFolders(folderRef);
        String group_prefix = "TEST_";
        int concurrentUpdates = 5;
        try {
            void var8_9;
            this.txnHelper.doInTransaction(() -> {
                HashSet<String> zones = new HashSet<String>(2, 1.0f);
                zones.add("APP.DEFAULT");
                int i = 0;
                while (i < concurrentUpdates) {
                    if (!this.authorityService.authorityExists("GROUP_" + group_prefix + i)) {
                        this.authorityService.createAuthority(AuthorityType.GROUP, String.valueOf(group_prefix) + i, String.valueOf(group_prefix) + i, zones);
                    }
                    ++i;
                }
                return null;
            }, false, true);
            Runnable[] runnables = new Runnable[concurrentUpdates];
            ArrayList<Thread> threads = new ArrayList<Thread>();
            errors = new HashMap();
            this.setPermissionsOnTree(folderRef, true, true);
            runnables[0] = this.createRunnableToRunJob();
            Thread threadBase = new Thread(runnables[0]);
            threads.add(threadBase);
            threadBase.start();
            boolean bl = true;
            while (var8_9 < runnables.length) {
                NodeRef nodeRef = ((FileInfo)subFolders.get((int)(var8_9 - true))).getNodeRef();
                runnables[var8_9] = this.createRunnableToSetPermissions(nodeRef, String.valueOf(group_prefix) + (int)var8_9, (int)var8_9);
                Thread thread = new Thread(runnables[var8_9]);
                threads.add(thread);
                thread.start();
                ++var8_9;
            }
            for (Thread thread : threads) {
                thread.join();
            }
            for (Map.Entry entry : errors.entrySet()) {
                Assert.assertEquals((String)"Unexpected error on Concurrent Update", ConcurrencyFailureException.class, entry.getValue());
            }
            this.triggerFixedACLJob();
            Assert.assertEquals((String)"Not all nodes were processed", (long)0L, (long)this.getNodesCountWithPendingFixedAclAspect());
        }
        finally {
            this.deleteNodes(folderRef);
        }
    }

    private Long getChild(Long parentId) {
        List children = this.fileFolderService.list((NodeRef)this.nodeDAO.getNodePair(parentId).getSecond());
        if (children.size() > 0) {
            NodeRef childRef = ((FileInfo)children.get(0)).getNodeRef();
            return (Long)this.nodeDAO.getNodePair(childRef).getFirst();
        }
        return null;
    }

    private Long getAclOfFirstChild(Long nodeId) {
        Long firstChild = this.getChild(nodeId);
        if (firstChild != null) {
            return this.nodeDAO.getNodeAclId(firstChild);
        }
        return null;
    }

    private void setFixedPermissionsForTestGroup(NodeRef folderRef, String authName, int thread) {
        this.txnHelper.doInTransaction(() -> {
            try {
                Thread.sleep(200L);
                this.permissionService.setInheritParentPermissions(folderRef, false, true);
                this.permissionService.setPermission(folderRef, authName, "Coordinator", true);
            }
            catch (Exception e) {
                errors.put(thread, e.getClass());
                throw e;
            }
            return null;
        }, false, true);
    }

    private Runnable createRunnableToSetPermissions(final NodeRef folderRef, final String authName, final int thread) throws Throwable {
        return new Runnable(){

            @Override
            public synchronized void run() {
                FixedAclUpdaterTest.this.setFixedPermissionsForTestGroup(folderRef, authName, thread);
            }
        };
    }

    private Runnable createRunnableToRunJob() throws Throwable {
        return new Runnable(){

            @Override
            public synchronized void run() {
                FixedAclUpdaterTest.this.triggerFixedACLJob();
            }
        };
    }

    private static void setFixedAclMaxTransactionTime(PermissionsDaoComponent permissionsDaoComponent, NodeRef folderNodeRef, long fixedAclMaxTransactionTime) {
        AccessControlListDAO acldao;
        if (permissionsDaoComponent instanceof ADMPermissionsDaoComponentImpl && (acldao = ((ADMPermissionsDaoComponentImpl)permissionsDaoComponent).getACLDAO(folderNodeRef)) instanceof ADMAccessControlListDAO) {
            ADMAccessControlListDAO admAcLDao = (ADMAccessControlListDAO)acldao;
            admAcLDao.setFixedAclMaxTransactionTime(fixedAclMaxTransactionTime);
        }
    }

    private static void setACL(PermissionsDaoComponent permissionsDaoComponent, NodeRef nodeRef, long aclId) {
        AccessControlListDAO acldao;
        if (permissionsDaoComponent instanceof ADMPermissionsDaoComponentImpl && (acldao = ((ADMPermissionsDaoComponentImpl)permissionsDaoComponent).getACLDAO(nodeRef)) instanceof ADMAccessControlListDAO) {
            ADMAccessControlListDAO admAcLDao = (ADMAccessControlListDAO)acldao;
            admAcLDao.setAccessControlList(nodeRef, Long.valueOf(aclId));
        }
    }

    private NodeRef createFolderHierarchyInRoot(String folderName, int[] filesPerLevel) {
        return (NodeRef)this.txnHelper.doInTransaction(() -> {
            NodeRef parent = FixedAclUpdaterTest.createFile(this.fileFolderService, this.homeFolderNodeRef, folderName, ContentModel.TYPE_FOLDER);
            FixedAclUpdaterTest.createFolderHierchy(this.fileFolderService, parent, 0, filesPerLevel);
            return parent;
        }, false, true);
    }

    private NodeRef createFolderHierarchyInRootForFolderTests(String folderName) {
        return this.createFolderHierarchyInRoot(folderName, filesPerLevelMoreFolders);
    }

    private NodeRef createFolderHierarchyInRootForFileTests(String folderName) {
        return this.createFolderHierarchyInRoot(folderName, filesPerLevelMoreFiles);
    }

    private static NodeRef createFile(FileFolderService fileFolderService, NodeRef parent, String name, QName type) {
        return fileFolderService.create(parent, String.valueOf(name) + "_" + System.currentTimeMillis(), type).getNodeRef();
    }

    private int getNodesCountWithPendingFixedAclAspect() {
        return (Integer)this.txnHelper.doInTransaction(() -> {
            HashSet<QName> aspects = new HashSet<QName>(1);
            aspects.add(ContentModel.ASPECT_PENDING_FIX_ACL);
            GetNodesCountWithAspectCallback callback = new GetNodesCountWithAspectCallback();
            this.nodeDAO.getNodesWithAspects(aspects, Long.valueOf(1L), null, (NodeDAO.NodeRefQueryCallback)callback);
            return callback.getNodesNumber();
        }, true, true);
    }

    private void setPermissionsOnTree(NodeRef folderRef, boolean asyncCall, boolean shouldHaveNodesPending) {
        this.txnHelper.doInTransaction(() -> {
            HashSet<String> zones = new HashSet<String>(2, 1.0f);
            zones.add("APP.DEFAULT");
            if (!this.authorityService.authorityExists(TEST_GROUP_NAME_FULL)) {
                this.authorityService.createAuthority(AuthorityType.GROUP, TEST_GROUP_NAME, TEST_GROUP_NAME, zones);
            }
            this.permissionService.setInheritParentPermissions(folderRef, false, asyncCall);
            this.permissionService.setPermission(folderRef, TEST_GROUP_NAME_FULL, DEFAULT_PERMISSION, true);
            return null;
        }, false, true);
        int pendingNodes = this.getNodesCountWithPendingFixedAclAspect();
        if (shouldHaveNodesPending) {
            Assert.assertTrue((String)"There are no nodes to process", (pendingNodes > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)"There are nodes to process", (long)pendingNodes, (long)0L);
        }
    }

    private void triggerFixedACLJob() {
        this.triggerFixedACLJob(false);
    }

    private void triggerFixedACLJob(boolean forceSharedACL) {
        LOG.debug("Fixing ACL");
        int numberOfConsecutiveZeros = 0;
        int round = 0;
        while (round < 30) {
            int count = (Integer)this.txnHelper.doInTransaction(() -> {
                this.fixedAclUpdater.setForceSharedACL(forceSharedACL);
                return this.fixedAclUpdater.execute();
            }, false, true);
            int n = numberOfConsecutiveZeros = count == 0 ? numberOfConsecutiveZeros + 1 : 0;
            if (numberOfConsecutiveZeros == 3) {
                LOG.info("ACL has been fixed in {} rounds", (Object)round);
                return;
            }
            ++round;
        }
        LOG.warn("Haven't fixed ACL in {} rounds.", (Object)30);
    }

    private NodeRef getFirstNodeWithAclPending(QName nodeType, NodeRef parentRef) {
        return (NodeRef)this.txnHelper.doInTransaction(() -> {
            GetNodesWithAspectCallback getNodesCallback = new GetNodesWithAspectCallback();
            this.nodeDAO.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_PENDING_FIX_ACL), Long.valueOf(0L), null, (NodeDAO.NodeRefQueryCallback)getNodesCallback);
            List<NodeRef> nodesWithAclPendingAspect = getNodesCallback.getNodes();
            int i = 0;
            while (i < nodesWithAclPendingAspect.size()) {
                NodeRef nodeRef2 = nodesWithAclPendingAspect.get(i);
                boolean isDescendent = false;
                List path = this.fileFolderService.getNamePath(this.homeFolderNodeRef, nodeRef2);
                for (FileInfo element : path) {
                    if (!element.getNodeRef().equals((Object)parentRef)) continue;
                    isDescendent = true;
                }
                if (isDescendent && this.nodeDAO.getNodeType((Long)this.nodeDAO.getNodePair(nodeRef2).getFirst()).equals((Object)nodeType) && (!nodeType.equals((Object)ContentModel.TYPE_FOLDER) || this.hasGrandChilden(nodeRef2))) {
                    return nodeRef2;
                }
                ++i;
            }
            return null;
        }, false, true);
    }

    private NodeRef getFirstNodeWithAclPending(QName nodeType) {
        return (NodeRef)this.txnHelper.doInTransaction(() -> {
            GetNodesWithAspectCallback getNodesCallback = new GetNodesWithAspectCallback();
            this.nodeDAO.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_PENDING_FIX_ACL), Long.valueOf(0L), null, (NodeDAO.NodeRefQueryCallback)getNodesCallback);
            List<NodeRef> nodesWithAclPendingAspect = getNodesCallback.getNodes();
            int i = 0;
            while (i < nodesWithAclPendingAspect.size()) {
                NodeRef nodeRef = nodesWithAclPendingAspect.get(i);
                if (this.nodeDAO.getNodeType((Long)this.nodeDAO.getNodePair(nodeRef).getFirst()).equals((Object)nodeType) && (!nodeType.equals((Object)ContentModel.TYPE_FOLDER) || this.hasGrandChilden(nodeRef))) {
                    return nodeRef;
                }
                ++i;
            }
            return null;
        }, false, true);
    }

    private boolean hasGrandChilden(NodeRef nodeRef) {
        Long nodeId = (Long)this.nodeDAO.getNodePair(nodeRef).getFirst();
        Long childId = this.getChild(nodeId);
        Long grandChild = null;
        if (childId != null) {
            grandChild = this.getChild(childId);
        }
        return grandChild != null;
    }

    private void deleteNodes(NodeRef folder) {
        this.txnHelper.doInTransaction(() -> {
            if (this.nodeDAO.exists(folder)) {
                HashSet<QName> aspect = new HashSet<QName>();
                aspect.add(ContentModel.ASPECT_TEMPORARY);
                this.nodeDAO.addNodeAspects((Long)this.nodeDAO.getNodePair(folder).getFirst(), aspect);
                this.fileFolderService.delete(folder);
            }
            return null;
        }, false, true);
    }

    private static void createFolderHierchy(FileFolderService fileFolderService, NodeRef parent, int level, int[] filesPerLevel) {
        block3: {
            int levels;
            block2: {
                levels = filesPerLevel.length;
                if (level >= levels - 1) break block2;
                int numFiles = filesPerLevel[level];
                int i = 0;
                while (i < numFiles) {
                    NodeRef node = FixedAclUpdaterTest.createFile(fileFolderService, parent, "-LVL" + level + i, ContentModel.TYPE_FOLDER);
                    FixedAclUpdaterTest.createFolderHierchy(fileFolderService, node, level + 1, filesPerLevel);
                    ++i;
                }
                break block3;
            }
            if (level != levels - 1) break block3;
            int numFiles = filesPerLevel[level];
            int i = 0;
            while (i < numFiles) {
                FixedAclUpdaterTest.createFile(fileFolderService, parent, "-File" + i, ContentModel.TYPE_CONTENT);
                ++i;
            }
        }
    }

    static /* synthetic */ String access$0() {
        return DEFAULT_PERMISSION;
    }

    static /* synthetic */ String access$1() {
        return TEST_GROUP_NAME_FULL;
    }

    private class ACLComparator {
        Long parentId;
        Long oParentACL;
        Long oFirstChildACL;
        Long tParentACL;
        Long tFirstChildACL;
        String originalPermission = FixedAclUpdaterTest.access$0();
        String originalAuthority = FixedAclUpdaterTest.access$1();
        Long pendingInheritFrom = 0L;

        public ACLComparator(NodeRef nodeRef) {
            Long parentId;
            this.parentId = parentId = (Long)FixedAclUpdaterTest.this.nodeDAO.getNodePair(nodeRef).getFirst();
            this.oParentACL = FixedAclUpdaterTest.this.nodeDAO.getNodeAclId(parentId);
            this.oFirstChildACL = FixedAclUpdaterTest.this.getAclOfFirstChild(parentId);
            this.updateCurrentACLs();
        }

        public void updateCurrentACLs() {
            this.tParentACL = FixedAclUpdaterTest.this.nodeDAO.getNodeAclId(this.parentId);
            this.tFirstChildACL = FixedAclUpdaterTest.this.getAclOfFirstChild(this.parentId);
            this.pendingInheritFrom = FixedAclUpdaterTest.this.nodeDAO.hasNodeAspect(this.parentId, ContentModel.ASPECT_PENDING_FIX_ACL) ? (Long)FixedAclUpdaterTest.this.nodeDAO.getNodeProperty(this.parentId, ContentModel.PROP_INHERIT_FROM_ACL) : Long.valueOf(0L);
        }

        public void compareACLs() {
            this.updateCurrentACLs();
            Assert.assertTrue((String)"Permissions were not changed on top folder", (!this.oParentACL.equals(this.tParentACL) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Permissions were not changed on child", (!this.oFirstChildACL.equals(this.tFirstChildACL) ? 1 : 0) != 0);
        }

        public void setOriginalPermission(String originalAuthority, String originalPermission) {
            this.originalPermission = originalPermission;
            this.originalAuthority = originalAuthority;
        }

        public boolean hasPermission(String authority, String permission) {
            return this.hasPermission(this.parentId, authority, permission);
        }

        public boolean hasPermission(Long nodeId, String authority, String permission) {
            boolean hasExpectedPermission = false;
            Set permissions = FixedAclUpdaterTest.this.permissionService.getAllSetPermissions((NodeRef)FixedAclUpdaterTest.this.nodeDAO.getNodePair(nodeId).getSecond());
            for (AccessPermission accessPermission : permissions) {
                if (!accessPermission.getPermission().equalsIgnoreCase(permission) || !accessPermission.getAuthority().equalsIgnoreCase(authority)) continue;
                hasExpectedPermission = true;
                break;
            }
            return hasExpectedPermission;
        }

        public boolean firstChildHasPermission(String authority, String permission) {
            return this.hasPermission(FixedAclUpdaterTest.this.getChild(this.parentId), authority, permission);
        }

        public boolean firstChildHasOriginalPermission() {
            return this.hasPermission(FixedAclUpdaterTest.this.getChild(this.parentId), this.originalAuthority, this.originalPermission);
        }

        public boolean parentHasOriginalPermission() {
            return this.hasPermission(this.originalAuthority, this.originalPermission);
        }

        private Long getParentAcl() {
            return this.tParentACL;
        }

        private Long getChildAcl() {
            return this.tFirstChildACL;
        }

        private Long getPendingInheritFromAcl() {
            return this.pendingInheritFrom;
        }
    }

    private static class GetNodesCountWithAspectCallback
    implements NodeDAO.NodeRefQueryCallback {
        int nodesNumber = 0;

        private GetNodesCountWithAspectCallback() {
        }

        public boolean handle(Pair<Long, NodeRef> nodePair) {
            ++this.nodesNumber;
            return true;
        }

        public int getNodesNumber() {
            return this.nodesNumber;
        }
    }

    private static class GetNodesWithAspectCallback
    implements NodeDAO.NodeRefQueryCallback {
        private List<NodeRef> nodes = new ArrayList<NodeRef>();

        private GetNodesWithAspectCallback() {
        }

        public boolean handle(Pair<Long, NodeRef> nodePair) {
            this.nodes.add((NodeRef)nodePair.getSecond());
            return true;
        }

        public List<NodeRef> getNodes() {
            return this.nodes;
        }
    }
}

