/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.OnPropertyUpdateRuleTrigger;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleAssocRefPolicyRuleTrigger
extends RuleTriggerAbstractBase {
    private static Log logger = LogFactory.getLog(OnPropertyUpdateRuleTrigger.class);
    private String policyNamespace = "http://www.alfresco.org";
    private String policyName;
    private Set<QName> excludedAssocTypes = Collections.emptySet();

    public void setPolicyNamespace(String policyNamespace) {
        this.policyNamespace = policyNamespace;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public void setExcludedAssociationTypes(Set<QName> assocTypes) {
        this.excludedAssocTypes = assocTypes;
    }

    @Override
    public void registerRuleTrigger() {
        PropertyCheck.mandatory((Object)this, (String)"policyNamespace", (Object)this.policyNamespace);
        PropertyCheck.mandatory((Object)this, (String)"policyName", (Object)this.policyName);
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)this.policyNamespace, (String)this.policyName), this, (Behaviour)new JavaBehaviour(this, "policyBehaviour"));
    }

    public void policyBehaviour(AssociationRef assocRef) {
        NodeRef nodeRef;
        QName assocTypeQName = assocRef.getTypeQName();
        if (!this.excludedAssocTypes.contains(assocTypeQName) && this.nodeService.exists(nodeRef = assocRef.getSourceRef())) {
            List parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
            for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("OnUpdateAssoc rule triggered (parent); nodeRef=" + parentAssocRef.getParentRef()));
            }
        }
    }
}

