/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.repo.event2.filter.EventFilter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeEventFilter
implements EventFilter<QName> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNodeEventFilter.class);
    private static final String MARKER_INCLUDE_SUBTYPES = "include_subtypes";
    private static final String WILDCARD = "*";
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    private Set<QName> excludedTypes = new HashSet<QName>();
    private Set<String> excludedNamespaceURI = new HashSet<String>();

    public final void init() {
        this.preprocessExcludedTypes(this.getExcludedTypes());
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @Override
    public boolean isExcluded(QName qName) {
        if (qName != null) {
            return this.excludedTypes.contains(qName) || this.excludedNamespaceURI.contains(qName.getNamespaceURI());
        }
        return false;
    }

    protected abstract Set<QName> getExcludedTypes();

    protected List<String> parseFilterList(String unparsedFilterList) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(unparsedFilterList, ",");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken().trim();
            if (entry.isEmpty() || entry.equals("none") || entry.contains("${")) continue;
            list.add(entry);
        }
        return list;
    }

    private void preprocessExcludedTypes(Set<QName> excluded) {
        excluded.forEach(qName -> {
            if (WILDCARD.equals(qName.getLocalName())) {
                this.excludedNamespaceURI.add(qName.getNamespaceURI());
            } else {
                this.excludedTypes.add((QName)qName);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excluded namespace URIs:" + this.excludedNamespaceURI);
            LOGGER.debug("Excluded types:" + this.excludedTypes);
        }
    }

    private QName getQName(String type) {
        return QName.createQName((String)type, (NamespacePrefixResolver)this.namespaceService);
    }

    protected Collection<QName> expandTypeDef(String typeDef) {
        if (typeDef == null || typeDef.isEmpty() || typeDef.equals("none") || typeDef.contains("${")) {
            return Collections.emptyList();
        }
        if (typeDef.indexOf(32) < 0) {
            return Collections.singleton(this.getQName(typeDef));
        }
        String[] typeDefParts = typeDef.split(" ");
        if (typeDefParts.length != 2) {
            LOGGER.warn("Ignoring invalid blacklist type pattern: " + typeDef);
            return Collections.emptyList();
        }
        if (typeDefParts[1].equals(MARKER_INCLUDE_SUBTYPES)) {
            QName baseType;
            if (typeDefParts[0].indexOf(42) >= 0) {
                LOGGER.warn("Ignoring invalid blacklist type pattern: " + typeDef);
                return Collections.emptyList();
            }
            try {
                baseType = this.getQName(typeDefParts[0]);
            }
            catch (NamespaceException namespaceException) {
                return Collections.emptyList();
            }
            return this.dictionaryService.getSubTypes(baseType, true);
        }
        LOGGER.warn("Ignoring invalid blacklist type pattern: " + typeDef);
        return Collections.emptyList();
    }
}

