/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.Set;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnCreateChildAssociationRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnCreateChildAssociationPolicy {
    private static Log logger = LogFactory.getLog(OnCreateChildAssociationRuleTrigger.class);
    private static final String POLICY_NAME = "onCreateChildAssociation";
    private boolean isClassBehaviour = false;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    @Override
    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY_NAME), this, (Behaviour)new JavaBehaviour(this, POLICY_NAME));
        }
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        if (!this.areRulesEnabled()) {
            return;
        }
        if (isNewNode) {
            return;
        }
        NodeRef childNodeRef = childAssocRef.getChildRef();
        Set renamedNodeRefSet = TransactionalResourceHelper.getSet("RuleTrigger.RenamedNodes");
        if (renamedNodeRefSet.contains(childNodeRef)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Single child assoc trigger (policy = onCreateChildAssociation) fired for parent node " + childAssocRef.getParentRef() + " and child node " + childAssocRef.getChildRef()));
        }
        this.triggerRules(childAssocRef.getParentRef(), childNodeRef);
    }
}

