/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.repo.event2.EventJSONSchema;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateRepoEventIT
extends AbstractContextAwareRepoEvent {
    @Autowired
    private NodeDAO nodeDAO;

    @Test
    public void testCreateEvent() {
        String name = "TestFile-" + System.currentTimeMillis() + ".txt";
        String localName = GUID.generate();
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.put((Object)ContentModel.PROP_TITLE, (Object)"test title");
        propertyMap.put((Object)ContentModel.PROP_NAME, (Object)name);
        MLText localizedDescription = new MLText(this.germanLocale, "german description");
        localizedDescription.addValue(this.defaultLocale, "default description");
        propertyMap.put((Object)ContentModel.PROP_DESCRIPTION, (Object)localizedDescription);
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT, localName, propertyMap);
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        CreateRepoEventIT.assertEquals((String)"Repo event type", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        CreateRepoEventIT.assertNotNull((String)"Repo event ID is not available. ", (Object)resultRepoEvent.getId());
        CreateRepoEventIT.assertNotNull((Object)resultRepoEvent.getSource());
        CreateRepoEventIT.assertEquals((String)"Repo event source is not available. ", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)resultRepoEvent.getSource().toString());
        CreateRepoEventIT.assertNotNull((String)"Repo event creation time is not available. ", (Object)resultRepoEvent.getTime());
        CreateRepoEventIT.assertEquals((String)"Repo event datacontenttype", (String)"application/json", (String)resultRepoEvent.getDatacontenttype());
        CreateRepoEventIT.assertNotNull((Object)resultRepoEvent.getDataschema());
        CreateRepoEventIT.assertEquals((Object)EventJSONSchema.NODE_CREATED_V1.getSchema(), (Object)resultRepoEvent.getDataschema());
        EventData nodeResourceEventData = (EventData)this.getEventData(resultRepoEvent);
        CreateRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)nodeResourceEventData.getEventGroupId());
        CreateRepoEventIT.assertNull((String)"resourceBefore property is not available", (Object)nodeResourceEventData.getResourceBefore());
        NodeResource nodeResource = this.getNodeResource(resultRepoEvent);
        CreateRepoEventIT.assertEquals((String)nodeRef.getId(), (String)nodeResource.getId());
        CreateRepoEventIT.assertEquals((String)name, (String)nodeResource.getName());
        CreateRepoEventIT.assertEquals((String)"cm:content", (String)nodeResource.getNodeType());
        CreateRepoEventIT.assertNotNull((Object)nodeResource.getPrimaryHierarchy());
        CreateRepoEventIT.assertNotNull((String)"Default aspects were not added. ", (Object)nodeResource.getAspectNames());
        CreateRepoEventIT.assertEquals((String)"test title", (String)((String)this.getProperty(nodeResource, "cm:title")));
        CreateRepoEventIT.assertEquals((String)"test title", (String)this.getLocalizedProperty(nodeResource, "cm:title", this.defaultLocale));
        CreateRepoEventIT.assertEquals((String)"default description", (String)((String)this.getProperty(nodeResource, "cm:description")));
        CreateRepoEventIT.assertEquals((String)"default description", (String)this.getLocalizedProperty(nodeResource, "cm:description", this.defaultLocale));
        CreateRepoEventIT.assertEquals((String)"german description", (String)this.getLocalizedProperty(nodeResource, "cm:description", this.germanLocale));
        CreateRepoEventIT.assertNull((String)"There is no content.", (Object)nodeResource.getContent());
        CreateRepoEventIT.assertNotNull((String)"Missing createdByUser property.", (Object)nodeResource.getCreatedByUser());
        CreateRepoEventIT.assertEquals((String)"Wrong node creator id.", (String)"admin", (String)nodeResource.getCreatedByUser().getId());
        CreateRepoEventIT.assertEquals((String)"Wrong node creator display name.", (String)"Administrator", (String)nodeResource.getCreatedByUser().getDisplayName());
        CreateRepoEventIT.assertNotNull((String)"Missing createdAt property.", (Object)nodeResource.getCreatedAt());
        CreateRepoEventIT.assertNotNull((String)"Missing modifiedByUser property.", (Object)nodeResource.getModifiedByUser());
        CreateRepoEventIT.assertEquals((String)"Wrong node modifier id.", (String)"admin", (String)nodeResource.getModifiedByUser().getId());
        CreateRepoEventIT.assertEquals((String)"Wrong node modifier display name.", (String)"Administrator", (String)nodeResource.getModifiedByUser().getDisplayName());
        CreateRepoEventIT.assertNotNull((String)"Missing modifiedAt property.", (Object)nodeResource.getModifiedAt());
        CreateRepoEventIT.assertEquals((String)"Wrong primaryAssocQName prefix.", (String)("ce:" + localName), (String)nodeResource.getPrimaryAssocQName());
    }

    @Test
    public void testCreateContentInFolderStructure() {
        NodeRef grandParent = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent = this.createNode(ContentModel.TYPE_FOLDER, grandParent);
        this.createNode(ContentModel.TYPE_CONTENT, parent);
        NodeResource resource = this.getNodeResource(3);
        List primaryHierarchy = resource.getPrimaryHierarchy();
        CreateRepoEventIT.assertNotNull((Object)primaryHierarchy);
        CreateRepoEventIT.assertEquals((String)"Wrong hierarchy", (int)3, (int)primaryHierarchy.size());
        CreateRepoEventIT.assertEquals((String)"Wrong parent", (String)parent.getId(), (String)((String)primaryHierarchy.get(0)));
    }

    @Test
    public void testCreateNodeWithId() {
        String uuid = GUID.generate();
        PropertyMap properties = new PropertyMap();
        properties.put((Object)ContentModel.PROP_NODE_UUID, (Object)uuid);
        this.createNode(ContentModel.TYPE_CONTENT, properties);
        NodeResource resource = this.getNodeResource(1);
        CreateRepoEventIT.assertEquals((String)"Failed to create node with a chosen ID", (String)uuid, (String)resource.getId());
    }

    @Test
    public void testFolderNodeType() {
        this.createNode(ContentModel.TYPE_FOLDER);
        NodeResource resource = this.getNodeResource(1);
        CreateRepoEventIT.assertEquals((String)"cm:content node type was not found", (String)"cm:folder", (String)resource.getNodeType());
        CreateRepoEventIT.assertFalse((String)"isFile flag should be FALSE for nodeType=cm:folder. ", (boolean)resource.isFile());
        CreateRepoEventIT.assertTrue((String)"isFolder flag should be TRUE for nodeType=cm:folder. ", (boolean)resource.isFolder());
    }

    @Test
    public void testFileNodeType() {
        this.createNode(ContentModel.TYPE_CONTENT);
        NodeResource resource = this.getNodeResource(1);
        CreateRepoEventIT.assertEquals((String)"cm:content node type was not found", (String)"cm:content", (String)resource.getNodeType());
        CreateRepoEventIT.assertTrue((String)"isFile flag should be TRUE for nodeType=cm:content. ", (boolean)resource.isFile());
        CreateRepoEventIT.assertFalse((String)"isFolder flag should be FALSE for nodeType=cm:content. ", (boolean)resource.isFolder());
    }

    @Test
    public void testEventTimestampEqualsToTransactionCommitTime() {
        String name = "TestFile-" + System.currentTimeMillis() + ".txt";
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.put((Object)ContentModel.PROP_NAME, (Object)name);
        Long transactionId = (Long)this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()), ContentModel.TYPE_CONTENT, (Map)propertyMap).getChildRef();
            return this.nodeDAO.getCurrentTransactionId(false);
        });
        RepoEvent resultRepoEvent = this.getRepoEvent(1);
        Transaction transaction = this.nodeDAO.getTxnById(transactionId);
        Instant commitTimeMs = Instant.ofEpochMilli(transaction.getCommitTimeMs());
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(commitTimeMs, ZoneOffset.UTC);
        CreateRepoEventIT.assertEquals((Object)timestamp, (Object)resultRepoEvent.getTime());
    }

    @Test
    public void testCreateMultipleNodesInTheSameTransaction() {
        this.retryingTransactionHelper.doInTransaction(() -> {
            int i = 0;
            while (i < 3) {
                this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()), ContentModel.TYPE_CONTENT);
                ++i;
            }
            return null;
        });
        this.checkNumOfEvents(3);
        AbstractContextAwareRepoEvent.RepoEventContainer repoEventsContainer = this.getRepoEventsContainer();
        String eventGroupId1 = ((DataAttributes)this.getEventData(repoEventsContainer.getEvent(1))).getEventGroupId();
        String eventGroupId2 = ((DataAttributes)this.getEventData(repoEventsContainer.getEvent(2))).getEventGroupId();
        String eventGroupId3 = ((DataAttributes)this.getEventData(repoEventsContainer.getEvent(3))).getEventGroupId();
        CreateRepoEventIT.assertTrue((eventGroupId1.equals(eventGroupId2) && eventGroupId2.equals(eventGroupId3) ? 1 : 0) != 0);
    }
}

