/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.audit.ibatis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.repo.domain.audit.AbstractAuditDAOImpl;
import org.alfresco.repo.domain.audit.AuditApplicationEntity;
import org.alfresco.repo.domain.audit.AuditDeleteParameters;
import org.alfresco.repo.domain.audit.AuditEntryEntity;
import org.alfresco.repo.domain.audit.AuditModelEntity;
import org.alfresco.repo.domain.audit.AuditQueryParameters;
import org.alfresco.repo.domain.audit.AuditQueryResult;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.util.Pair;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.ConcurrencyFailureException;

public class AuditDAOImpl
extends AbstractAuditDAOImpl {
    private static final String SELECT_MODEL_BY_CRC = "alfresco.audit.select_AuditModelByCrc";
    private static final String INSERT_MODEL = "alfresco.audit.insert.insert_AuditModel";
    private static final String SELECT_APPLICATION_BY_ID = "alfresco.audit.select_AuditApplicationById";
    private static final String SELECT_APPLICATION_BY_NAME_ID = "alfresco.audit.select_AuditApplicationByNameId";
    private static final String INSERT_APPLICATION = "alfresco.audit.insert.insert_AuditApplication";
    private static final String UPDATE_APPLICATION = "alfresco.audit.update_AuditApplication";
    private static final String DELETE_ENTRIES = "alfresco.audit.delete_AuditEntries";
    private static final String DELETE_ENTRIES_BY_ID = "alfresco.audit.delete_AuditEntriesById";
    private static final String INSERT_ENTRY = "alfresco.audit.insert.insert_AuditEntry";
    private static final String SELECT_MINMAX_ENTRY_FOR_APP = "alfresco.audit.select_MinMaxAuditEntryId";
    private static final String SELECT_COUNT_ENTRIES_FOR_APP = "alfresco.audit.select_CountAuditEntryId";
    private static final String SELECT_COUNT_ENTRIES_FOR_APP_WITH_PROPERTIES = "select_CountAuditEntryIdWithWhereClause";
    private static final String SELECT_ENTRIES_SIMPLE = "alfresco.audit.select_AuditEntriesSimple";
    private static final String SELECT_ENTRIES_WITH_VALUES = "alfresco.audit.select_AuditEntriesWithValues";
    private static final String SELECT_ENTRIES_WITHOUT_VALUES = "alfresco.audit.select_AuditEntriesWithoutValues";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    protected AuditModelEntity getAuditModelByCrc(long crc) {
        AuditModelEntity entity = new AuditModelEntity();
        entity.setContentCrc(crc);
        entity = (AuditModelEntity)this.template.selectOne(SELECT_MODEL_BY_CRC, (Object)entity);
        return entity;
    }

    @Override
    protected AuditModelEntity createAuditModel(Long contentDataId, long crc) {
        AuditModelEntity entity = new AuditModelEntity();
        entity.setContentDataId(contentDataId);
        entity.setContentCrc(crc);
        this.template.insert(INSERT_MODEL, (Object)entity);
        return entity;
    }

    @Override
    protected AuditApplicationEntity getAuditApplicationById(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("id", id);
        AuditApplicationEntity entity = (AuditApplicationEntity)this.template.selectOne(SELECT_APPLICATION_BY_ID, params);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searched for audit application ID " + id + " and found: " + entity));
        }
        return entity;
    }

    @Override
    protected AuditApplicationEntity getAuditApplicationByName(String appName) {
        Pair<Long, Serializable> appNamePair = this.propertyValueDAO.getPropertyValue((Serializable)((Object)appName));
        if (appNamePair == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(11);
        params.put("id", appNamePair.getFirst());
        AuditApplicationEntity entity = (AuditApplicationEntity)this.template.selectOne(SELECT_APPLICATION_BY_NAME_ID, params);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searched for audit application '" + appName + "' and found: " + entity));
        }
        return entity;
    }

    @Override
    protected AuditApplicationEntity createAuditApplication(Long appNameId, Long modelId, Long disabledPathsId) {
        AuditApplicationEntity entity = new AuditApplicationEntity();
        entity.setVersion((short)0);
        entity.setApplicationNameId(appNameId);
        entity.setAuditModelId(modelId);
        entity.setDisabledPathsId(disabledPathsId);
        this.template.insert(INSERT_APPLICATION, (Object)entity);
        return entity;
    }

    @Override
    protected AuditApplicationEntity updateAuditApplication(AuditApplicationEntity entity) {
        AuditApplicationEntity updateEntity = new AuditApplicationEntity();
        updateEntity.setId(entity.getId());
        updateEntity.setVersion(entity.getVersion());
        updateEntity.incrementVersion();
        updateEntity.setApplicationNameId(entity.getApplicationNameId());
        updateEntity.setAuditModelId(entity.getAuditModelId());
        updateEntity.setDisabledPathsId(entity.getDisabledPathsId());
        int updated = this.template.update(UPDATE_APPLICATION, (Object)updateEntity);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Incorrect number of rows affected for updateAuditApplication: " + updateEntity + ": expected 1, actual " + updated);
        }
        return updateEntity;
    }

    @Override
    public int deleteAuditEntries(Long applicationId, Long from, Long to) {
        AuditDeleteParameters params = new AuditDeleteParameters();
        params.setAuditApplicationId(applicationId);
        params.setAuditFromTime(from);
        params.setAuditToTime(to);
        return this.template.delete(DELETE_ENTRIES, (Object)params);
    }

    @Override
    public int deleteAuditEntriesByIdRange(Long applicationId, Long fromId, Long toId) {
        AuditDeleteParameters params = new AuditDeleteParameters();
        params.setAuditApplicationId(applicationId);
        params.setAuditFromId(fromId);
        params.setAuditToId(toId);
        return this.template.delete(DELETE_ENTRIES, (Object)params);
    }

    @Override
    protected int deleteAuditEntriesImpl(List<Long> auditEntryIds) {
        AuditDeleteParameters params = new AuditDeleteParameters();
        params.setAuditEntryIds(auditEntryIds);
        return this.template.delete(DELETE_ENTRIES_BY_ID, (Object)params);
    }

    @Override
    protected AuditEntryEntity createAuditEntry(Long applicationId, long time, Long usernameId, Long valuesId) {
        AuditEntryEntity entity = new AuditEntryEntity();
        entity.setAuditApplicationId(applicationId);
        entity.setAuditTime(time);
        entity.setAuditUserId(usernameId);
        entity.setAuditValuesId(valuesId);
        this.template.insert(INSERT_ENTRY, (Object)entity);
        return entity;
    }

    @Override
    public HashMap<String, Long> getAuditMinMaxByApp(long appId, List<String> extremes) {
        Map<String, Object> params = extremes.stream().collect(Collectors.toMap(s -> s, s -> Boolean.TRUE, (s1, s2) -> s1));
        params.put("auditAppId", appId);
        HashMap result = (HashMap)this.template.selectOne(SELECT_MINMAX_ENTRY_FOR_APP, params);
        return result;
    }

    @Override
    public int getAuditEntriesCountByApp(long applicationId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("auditAppId", applicationId);
        int result = (Integer)this.template.selectOne(SELECT_COUNT_ENTRIES_FOR_APP, params);
        return result;
    }

    @Override
    public int getAuditEntriesCountByAppAndProperties(String applicationName, org.alfresco.service.cmr.audit.AuditQueryParameters parameters) {
        AuditQueryParameters dbParameters = this.convertFromRestAuditQueryParameters(parameters);
        int result = (Integer)this.template.selectOne(SELECT_COUNT_ENTRIES_FOR_APP_WITH_PROPERTIES, (Object)dbParameters);
        return result;
    }

    @Override
    protected void findAuditEntries(AbstractAuditDAOImpl.AuditQueryRowHandler rowHandler, int maxResults, org.alfresco.service.cmr.audit.AuditQueryParameters restParameters) {
        AuditQueryParameters params = this.convertFromRestAuditQueryParameters(restParameters);
        if (params == null) {
            return;
        }
        if (maxResults > 0) {
            final HashMap<Long, AuditQueryResult> resultsByValueId = new HashMap<Long, AuditQueryResult>(173);
            PropertyValueDAO.PropertyFinderCallback propertyFinderCallback = new PropertyValueDAO.PropertyFinderCallback(){

                @Override
                public void handleProperty(Long id, Serializable value) {
                    AuditQueryResult row = (AuditQueryResult)resultsByValueId.get(id);
                    try {
                        row.setAuditValue((Map)((Object)value));
                    }
                    catch (ClassCastException classCastException) {}
                }
            };
            List rows = this.template.selectList(SELECT_ENTRIES_WITHOUT_VALUES, (Object)params, new RowBounds(0, maxResults));
            for (AuditQueryResult row : rows) {
                resultsByValueId.put(row.getAuditValuesId(), row);
                if (resultsByValueId.size() < 100) continue;
                ArrayList<Long> valueIds = new ArrayList<Long>(resultsByValueId.keySet());
                this.propertyValueDAO.getPropertiesByIds(valueIds, propertyFinderCallback);
                resultsByValueId.clear();
            }
            if (resultsByValueId.size() > 0) {
                ArrayList<Long> valueIds = new ArrayList<Long>(resultsByValueId.keySet());
                this.propertyValueDAO.getPropertiesByIds(valueIds, propertyFinderCallback);
            }
            for (AuditQueryResult row : rows) {
                rowHandler.processResult(row);
            }
        } else {
            throw new IllegalArgumentException("maxResults must be greater than 0");
        }
    }
}

