/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.FixedAclUpdaterListener;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionServicePolicies;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PolicyIgnoreUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

public class FixedAclUpdater
extends TransactionListenerAdapter
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(FixedAclUpdater.class);
    private static final Set<QName> PENDING_FIX_ACL_ASPECT_PROPS = FixedAclUpdater.pendingFixAclAspectProps();
    public static final String FIXED_ACL_ASYNC_REQUIRED_KEY = "FIXED_ACL_ASYNC_REQUIRED";
    public static final String FIXED_ACL_ASYNC_CALL_KEY = "FIXED_ACL_ASYNC_CALL";
    protected static final QName LOCK_Q_NAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"FixedAclUpdater");
    private static Set<FixedAclUpdaterListener> listeners = Sets.newConcurrentHashSet();
    private ApplicationContext applicationContext;
    private JobLockService jobLockService;
    private TransactionService transactionService;
    private AccessControlListDAO accessControlListDAO;
    private NodeDAO nodeDAO;
    private long lockTimeToLive = 10000L;
    private long lockRefreshTime = this.lockTimeToLive / 2L;
    private int maxItemBatchSize = 100;
    private int numThreads = 4;
    private boolean forceSharedACL = false;
    private ClassPolicyDelegate<PermissionServicePolicies.OnInheritPermissionsDisabled> onInheritPermissionsDisabledDelegate;
    private PolicyComponent policyComponent;
    private PolicyIgnoreUtil policyIgnoreUtil;

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAccessControlListDAO(AccessControlListDAO accessControlListDAO) {
        this.accessControlListDAO = accessControlListDAO;
    }

    public void setMaxItemBatchSize(int maxItemBatchSize) {
        this.maxItemBatchSize = maxItemBatchSize;
    }

    public void setForceSharedACL(boolean forceSharedACL) {
        this.forceSharedACL = forceSharedACL;
    }

    public void setLockTimeToLive(long lockTimeToLive) {
        this.lockTimeToLive = lockTimeToLive;
        this.lockRefreshTime = lockTimeToLive / 2L;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setPolicyIgnoreUtil(PolicyIgnoreUtil policyIgnoreUtil) {
        this.policyIgnoreUtil = policyIgnoreUtil;
    }

    public static void registerListener(FixedAclUpdaterListener listener) {
        listeners.add(listener);
    }

    public static void unregisterListener(FixedAclUpdaterListener listener) {
        listeners.remove(listener);
    }

    public void init() {
        this.onInheritPermissionsDisabledDelegate = this.policyComponent.registerClassPolicy(PermissionServicePolicies.OnInheritPermissionsDisabled.class);
    }

    protected AclWorker createAclWorker() {
        return new AclWorker();
    }

    private static Set<QName> pendingFixAclAspectProps() {
        HashSet<QName> props = new HashSet<QName>();
        props.add(ContentModel.PROP_SHARED_ACL_TO_REPLACE);
        props.add(ContentModel.PROP_INHERIT_FROM_ACL);
        return props;
    }

    public int execute() {
        String lockToken = null;
        FixedAclUpdaterJobLockRefreshCallback jobLockRefreshCallback = new FixedAclUpdaterJobLockRefreshCallback();
        try {
            int count;
            lockToken = this.jobLockService.getLock(LOCK_Q_NAME, this.lockTimeToLive, 0L, 1);
            this.jobLockService.refreshLock(lockToken, LOCK_Q_NAME, this.lockRefreshTime, jobLockRefreshCallback);
            AclWorkProvider provider = new AclWorkProvider();
            AclWorker worker = this.createAclWorker();
            BatchProcessor<NodeRef> bp = new BatchProcessor<NodeRef>("FixedAclUpdater", this.transactionService.getRetryingTransactionHelper(), provider, this.numThreads, this.maxItemBatchSize, (ApplicationEventPublisher)this.applicationContext, log, 100);
            int n = count = bp.process(worker, true);
            return n;
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            return 0;
        }
        finally {
            jobLockRefreshCallback.isActive.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_Q_NAME);
            }
        }
    }

    @Override
    public void afterCommit() {
        this.execute();
    }

    private class AclWorkProvider
    implements BatchProcessWorkProvider<NodeRef> {
        private GetNodesWithAspects getNodesWithAspects;

        AclWorkProvider() {
            this.getNodesWithAspects = new GetNodesWithAspects(Collections.singleton(ContentModel.ASPECT_PENDING_FIX_ACL));
        }

        @Override
        public int getTotalEstimatedWorkSize() {
            return (int)this.getTotalEstimatedWorkSizeLong();
        }

        @Override
        public long getTotalEstimatedWorkSizeLong() {
            return this.getNodesWithAspects.getWorkSize();
        }

        @Override
        public Collection<NodeRef> getNextWork() {
            return this.getNodesWithAspects.getNodesWithAspects();
        }
    }

    protected class AclWorker
    implements BatchProcessor.BatchProcessWorker<NodeRef> {
        private Set<QName> aspects = new HashSet<QName>(1);

        AclWorker() {
            this.aspects.add(ContentModel.ASPECT_PENDING_FIX_ACL);
        }

        @Override
        public String getIdentifier(NodeRef nodeRef) {
            return String.valueOf(nodeRef.toString());
        }

        @Override
        public void beforeProcess() throws Throwable {
        }

        @Override
        public void afterProcess() throws Throwable {
        }

        @Override
        public void process(final NodeRef nodeRef) {
            AuthenticationUtil.RunAsWork<Void> findAndUpdateAclRunAsWork = new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    Long nodeId;
                    block6: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Processing node %s", nodeRef));
                        }
                        nodeId = (Long)FixedAclUpdater.this.nodeDAO.getNodePair(nodeRef).getFirst();
                        if (!nodeRef.getStoreRef().equals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE)) break block6;
                        FixedAclUpdater.this.accessControlListDAO.removePendingAclAspect(nodeId);
                        return null;
                    }
                    try {
                        Long inheritFrom = (Long)FixedAclUpdater.this.nodeDAO.getNodeProperty(nodeId, ContentModel.PROP_INHERIT_FROM_ACL);
                        Long sharedAclToReplace = (Long)FixedAclUpdater.this.nodeDAO.getNodeProperty(nodeId, ContentModel.PROP_SHARED_ACL_TO_REPLACE);
                        FixedAclUpdater.this.accessControlListDAO.setInheritanceForChildren(nodeRef, inheritFrom, sharedAclToReplace, true, FixedAclUpdater.this.forceSharedACL);
                        FixedAclUpdater.this.accessControlListDAO.removePendingAclAspect(nodeId);
                        if (!FixedAclUpdater.this.policyIgnoreUtil.ignorePolicy(nodeRef)) {
                            boolean transformedToAsyncOperation = BooleanUtils.toBoolean((Boolean)((Boolean)AlfrescoTransactionSupport.getResource((Object)FixedAclUpdater.FIXED_ACL_ASYNC_REQUIRED_KEY)));
                            PermissionServicePolicies.OnInheritPermissionsDisabled onInheritPermissionsDisabledPolicy = (PermissionServicePolicies.OnInheritPermissionsDisabled)FixedAclUpdater.this.onInheritPermissionsDisabledDelegate.get(ContentModel.TYPE_BASE);
                            onInheritPermissionsDisabledPolicy.onInheritPermissionsDisabled(nodeRef, transformedToAsyncOperation);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Job could not process pending ACL node " + nodeRef + ": " + e));
                        e.printStackTrace();
                    }
                    listeners.forEach(listener -> listener.permissionsUpdatedAsynchronously(nodeRef));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Node processed %s", nodeRef));
                    }
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)findAndUpdateAclRunAsWork, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private class CountNodesWithAspectCallback
    implements NodeDAO.NodeRefQueryCallback {
        private int count = 0;

        private CountNodesWithAspectCallback() {
        }

        @Override
        public boolean handle(Pair<Long, NodeRef> nodePair) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class FixedAclUpdaterJobLockRefreshCallback
    implements JobLockService.JobLockRefreshCallback {
        public AtomicBoolean isActive = new AtomicBoolean(true);

        private FixedAclUpdaterJobLockRefreshCallback() {
        }

        @Override
        public boolean isActive() {
            return this.isActive.get();
        }

        @Override
        public void lockReleased() {
            this.isActive.set(false);
        }
    }

    class GetNodesWithAspectCallback
    implements NodeDAO.NodeRefQueryCallback {
        private List<NodeRef> nodes = new ArrayList<NodeRef>();
        private long minNodeId;
        private long maxNodeId;

        GetNodesWithAspectCallback() {
        }

        void init() {
            this.nodes.clear();
        }

        void done() {
            this.minNodeId = this.maxNodeId + 1L;
        }

        @Override
        public boolean handle(Pair<Long, NodeRef> nodePair) {
            if (this.nodes.size() < FixedAclUpdater.this.maxItemBatchSize) {
                this.nodes.add((NodeRef)nodePair.getSecond());
                if ((Long)nodePair.getFirst() > this.maxNodeId) {
                    this.maxNodeId = (Long)nodePair.getFirst();
                }
                return true;
            }
            return false;
        }

        long getMinNodeId() {
            return this.minNodeId;
        }

        public List<NodeRef> getNodes() {
            return this.nodes;
        }
    }

    private class GetNodesWithAspects {
        private Set<QName> aspects;
        private int workSize;
        private GetNodesWithAspectCallback getNodesCallback;

        GetNodesWithAspects(Set<QName> aspects) {
            this.aspects = aspects;
            this.getNodesCallback = new GetNodesWithAspectCallback();
            this.workSize = this.countNodesWithAspects();
        }

        int getWorkSize() {
            return this.workSize;
        }

        List<NodeRef> getNodesWithAspects() {
            List<NodeRef> nodes = FixedAclUpdater.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

                @Override
                public List<NodeRef> execute() throws Throwable {
                    GetNodesWithAspects.this.getNodesCallback.init();
                    FixedAclUpdater.this.nodeDAO.getNodesWithAspects(GetNodesWithAspects.this.aspects, GetNodesWithAspects.this.getNodesCallback.getMinNodeId(), null, true, GetNodesWithAspects.this.getNodesCallback);
                    GetNodesWithAspects.this.getNodesCallback.done();
                    return GetNodesWithAspects.this.getNodesCallback.getNodes();
                }
            }, false, true);
            return nodes;
        }

        int countNodesWithAspects() {
            final CountNodesWithAspectCallback countNodesCallback = new CountNodesWithAspectCallback();
            int count = FixedAclUpdater.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                @Override
                public Integer execute() throws Throwable {
                    FixedAclUpdater.this.nodeDAO.getNodesWithAspects(GetNodesWithAspects.this.aspects, 0L, null, countNodesCallback);
                    return countNodesCallback.getCount();
                }
            }, false, true);
            return count;
        }
    }
}

