/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.DirectEventSender;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnqueuingEventSender
extends DirectEventSender {
    protected static final Log LOGGER = LogFactory.getLog(EnqueuingEventSender.class);
    protected Executor enqueueThreadPoolExecutor;
    protected Executor dequeueThreadPoolExecutor;
    protected BlockingQueue<EventInMaking> queue = new LinkedBlockingQueue<EventInMaking>();
    protected Runnable listener = this.createListener();

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)this, (String)"enqueueThreadPoolExecutor", (Object)this.enqueueThreadPoolExecutor);
        PropertyCheck.mandatory((Object)this, (String)"dequeueThreadPoolExecutor", (Object)this.dequeueThreadPoolExecutor);
    }

    public void setEnqueueThreadPoolExecutor(Executor enqueueThreadPoolExecutor) {
        this.enqueueThreadPoolExecutor = enqueueThreadPoolExecutor;
    }

    public void setDequeueThreadPoolExecutor(Executor dequeueThreadPoolExecutor) {
        this.dequeueThreadPoolExecutor = dequeueThreadPoolExecutor;
        dequeueThreadPoolExecutor.execute(this.listener);
    }

    @Override
    public void accept(Callable<Optional<RepoEvent<?>>> eventProducer) {
        EventInMaking eventInMaking = new EventInMaking(eventProducer);
        this.queue.offer(eventInMaking);
        this.enqueueThreadPoolExecutor.execute(() -> {
            try {
                eventInMaking.make();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unexpected error while enqueuing maker function for repository event" + e));
            }
        });
    }

    private Runnable createListener() {
        return () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
    }

    private /* synthetic */ void lambda$2(RepoEvent event) {
        this.event2MessageProducer.send(event);
    }

    private static class EventInMaking {
        private final Callable<Optional<RepoEvent<?>>> maker;
        private volatile RepoEvent<?> event;
        private final CountDownLatch latch;

        public EventInMaking(Callable<Optional<RepoEvent<?>>> maker) {
            this.maker = maker;
            this.latch = new CountDownLatch(1);
        }

        public void make() throws Exception {
            try {
                this.event = this.maker.call().orElse(null);
            }
            finally {
                this.latch.countDown();
            }
        }

        public Optional<RepoEvent<?>> getEventWhenReady() throws InterruptedException {
            this.latch.await(30L, TimeUnit.SECONDS);
            return Optional.ofNullable(this.event);
        }

        public String toString() {
            return this.maker.toString();
        }
    }
}

