/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.PatternFilter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilenameFilteringInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(FilenameFilteringInterceptor.class);
    private static final String XLSX_MIMETYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final String MACOS_TEMPORARY_FILE_NAME_PREFIX = "._";
    private static final Pattern XSL_MACOS_TEMPORARY_FILENAME_FITLER = Pattern.compile("^(\\._)?[0-9,a-f]{8}$", 66);
    private NodeService nodeService;
    private PermissionService permissionService;
    private ContentService contentService;
    private PatternFilter temporaryFiles;
    private PatternFilter systemPaths;
    private HiddenAspect hiddenAspect;
    private boolean enabled = true;

    public void setTemporaryFiles(PatternFilter temporaryFiles) {
        this.temporaryFiles = temporaryFiles;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSystemPaths(PatternFilter systemPaths) {
        this.systemPaths = systemPaths;
    }

    public FileFilterMode.Mode getMode() {
        return FileFilterMode.getMode();
    }

    public FileFilterMode.Client getClient() {
        return FileFilterMode.getClient();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    private void checkTemporaryAspect(boolean isTemporary, FileInfo fileInfo) {
        this.checkTemporaryAspect(isTemporary, fileInfo.getNodeRef());
    }

    private void checkTemporaryAspect(boolean isTemporary, NodeRef nodeRef) {
        if (isTemporary) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applied temporary marker: " + nodeRef));
            }
        } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY)) {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TEMPORARY);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed temporary marker: " + nodeRef));
            }
        }
    }

    private Object runAsSystem(MethodInvocation invocation) throws Throwable {
        Object ret = null;
        AuthenticationUtil.pushAuthentication();
        try {
            AuthenticationUtil.setRunAsUserSystem();
            ret = invocation.proceed();
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        return ret;
    }

    private boolean isSystemPath(NodeRef parentNodeRef, String filename) {
        boolean ret = false;
        Path path = this.nodeService.getPath(parentNodeRef);
        for (Path.ChildAssocElement elem : path) {
            QName qname = elem.getRef().getQName();
            if (qname == null || !this.systemPaths.isFiltered(qname.getLocalName())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private int getSystemFileVisibilityMask() {
        int mask = 0;
        mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.cifs, HiddenAspect.Visibility.HiddenAttribute);
        mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.webdav, HiddenAspect.Visibility.Visible);
        mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.nfs, HiddenAspect.Visibility.Visible);
        return mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.ftp, HiddenAspect.Visibility.Visible);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.enabled) {
            return invocation.proceed();
        }
        String methodName = invocation.getMethod().getName();
        Object ret = null;
        if (methodName.startsWith("create")) {
            NodeRef nodeRef = (NodeRef)invocation.getArguments()[0];
            String filename = (String)invocation.getArguments()[1];
            if (this.getMode() == FileFilterMode.Mode.ENHANCED) {
                if (this.systemPaths.isFiltered(filename)) {
                    ret = this.runAsSystem(invocation);
                    FileInfoImpl fileInfo = (FileInfoImpl)ret;
                    this.permissionService.setPermission(fileInfo.getNodeRef(), "GROUP_EVERYONE", "FullControl", true);
                    this.checkTemporaryAspect(true, fileInfo);
                    this.hiddenAspect.hideNode(fileInfo, this.getSystemFileVisibilityMask(), false, false, false);
                } else {
                    ret = invocation.proceed();
                    FileInfoImpl fileInfo = (FileInfoImpl)ret;
                    if (this.isSystemPath(nodeRef, filename)) {
                        this.checkTemporaryAspect(true, fileInfo);
                        this.hiddenAspect.hideNode(fileInfo, this.getSystemFileVisibilityMask(), false, false, false);
                    } else {
                        FileInfo sourceInfo = (FileInfo)ret;
                        boolean isTmp = this.isTemporaryObject(filename, sourceInfo.getNodeRef());
                        this.checkTemporaryAspect(isTmp, sourceInfo);
                        boolean isHidden = this.hiddenAspect.checkHidden(fileInfo, false, false);
                        if (isHidden && fileInfo instanceof FileInfoImpl) {
                            fileInfo.setHidden(true);
                        }
                    }
                }
            } else {
                ret = invocation.proceed();
                FileInfoImpl fileInfo = (FileInfoImpl)ret;
                boolean isTmp = this.isTemporaryObject(filename, fileInfo.getNodeRef());
                this.checkTemporaryAspect(isTmp, fileInfo);
            }
        } else if (methodName.startsWith("move")) {
            Object[] args = invocation.getArguments();
            NodeRef sourceNodeRef = (NodeRef)args[0];
            String newName = (String)args[args.length - 1];
            if (newName != null) {
                boolean isTmp = this.isTemporaryObject(newName, sourceNodeRef);
                this.checkTemporaryAspect(isTmp, sourceNodeRef);
            }
            ret = invocation.proceed();
            if (this.getMode() == FileFilterMode.Mode.ENHANCED) {
                this.hiddenAspect.checkHidden(sourceNodeRef, true, true);
            }
        } else if (methodName.startsWith("copy")) {
            boolean isHidden;
            ret = invocation.proceed();
            FileInfoImpl fileInfo = (FileInfoImpl)ret;
            String filename = fileInfo.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking filename returned by " + methodName + ": " + filename));
            }
            boolean isTmp = this.isTemporaryObject(filename, fileInfo.getNodeRef());
            this.checkTemporaryAspect(isTmp, fileInfo);
            if (this.getMode() == FileFilterMode.Mode.ENHANCED && (isHidden = this.hiddenAspect.checkHidden(fileInfo, true, true)) && fileInfo instanceof FileInfoImpl) {
                fileInfo.setHidden(true);
            }
        } else {
            if (methodName.startsWith("rename")) {
                Object[] args = invocation.getArguments();
                if (args != null && args.length == 2) {
                    boolean isHidden;
                    String newName = (String)args[1];
                    NodeRef sourceNodeRef = (NodeRef)args[0];
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Checking filename returned by " + methodName + ": " + newName));
                    }
                    boolean isTmp = this.isTemporaryObject(newName, sourceNodeRef);
                    this.checkTemporaryAspect(isTmp, sourceNodeRef);
                    ret = invocation.proceed();
                    if (this.getMode() == FileFilterMode.Mode.ENHANCED && (isHidden = this.hiddenAspect.checkHidden(sourceNodeRef, true, true)) && ret instanceof FileInfoImpl) {
                        ((FileInfoImpl)ret).setHidden(true);
                    }
                    return ret;
                }
                throw new AlfrescoRuntimeException("FilenameFilteringInterceptor: unknown rename method");
            }
            ret = invocation.proceed();
        }
        return ret;
    }

    private boolean isTemporaryObject(String name, NodeRef nodeRef) {
        boolean isFiltered = this.temporaryFiles.isFiltered(name);
        if (isFiltered) {
            return true;
        }
        boolean result = XSL_MACOS_TEMPORARY_FILENAME_FITLER.matcher(name).matches();
        if (result && !name.startsWith(MACOS_TEMPORARY_FILE_NAME_PREFIX)) {
            ContentReader contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
            result = contentReader != null ? XLSX_MIMETYPE.equals(contentReader.getMimetype()) : false;
        }
        return result;
    }
}

