/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import org.alfresco.util.ParameterCheck;

public class Authorization {
    public static String TICKET_USERID = "ROLE_TICKET";
    private String username;
    private String password;
    private String ticket;

    public Authorization(String authorization) {
        ParameterCheck.mandatoryString((String)"authorization", (String)authorization);
        if (authorization.length() == 0) {
            throw new IllegalArgumentException("authorization does not consist of username and password");
        }
        int idx = authorization.indexOf(58);
        if (idx == -1) {
            this.setUser(null, authorization);
        } else {
            this.setUser(authorization.substring(0, idx), authorization.substring(idx + 1));
        }
    }

    public Authorization(String username, String password) {
        this.setUser(username, password);
    }

    private void setUser(String username, String password) {
        this.username = username;
        this.password = password;
        if (username == null || username.length() == 0 || username.equalsIgnoreCase(TICKET_USERID)) {
            this.ticket = password;
        }
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public char[] getPasswordCharArray() {
        return this.password == null ? null : this.password.toCharArray();
    }

    public boolean isTicket() {
        return this.ticket != null;
    }

    public String getTicket() {
        return this.ticket;
    }
}

