/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.OIDCUserInfo;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

public interface IdentityServiceFacade {
    public AccessTokenAuthorization authorize(AuthorizationGrant var1) throws AuthorizationException;

    public DecodedAccessToken decodeToken(String var1) throws TokenDecodingException;

    public Optional<OIDCUserInfo> getUserInfo(String var1, String var2);

    public ClientRegistration getClientRegistration();

    public static interface AccessToken {
        public String getTokenValue();

        public Instant getExpiresAt();
    }

    public static interface AccessTokenAuthorization {
        public AccessToken getAccessToken();

        public String getRefreshTokenValue();
    }

    public static class AuthorizationException
    extends IdentityServiceFacadeException {
        AuthorizationException(String message) {
            super(message);
        }

        AuthorizationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AuthorizationGrant {
        private final String username;
        private final String password;
        private final String refreshToken;
        private final String authorizationCode;
        private final String redirectUri;

        private AuthorizationGrant(String username, String password, String refreshToken, String authorizationCode, String redirectUri) {
            this.username = username;
            this.password = password;
            this.refreshToken = refreshToken;
            this.authorizationCode = authorizationCode;
            this.redirectUri = redirectUri;
        }

        public static AuthorizationGrant password(String username, String password) {
            return new AuthorizationGrant(Objects.requireNonNull(username), Objects.requireNonNull(password), null, null, null);
        }

        public static AuthorizationGrant refreshToken(String refreshToken) {
            return new AuthorizationGrant(null, null, Objects.requireNonNull(refreshToken), null, null);
        }

        public static AuthorizationGrant authorizationCode(String authorizationCode, String redirectUri) {
            return new AuthorizationGrant(null, null, null, Objects.requireNonNull(authorizationCode), Objects.requireNonNull(redirectUri));
        }

        boolean isPassword() {
            return Objects.nonNull(this.username);
        }

        boolean isRefreshToken() {
            return Objects.nonNull(this.refreshToken);
        }

        boolean isAuthorizationCode() {
            return Objects.nonNull(this.authorizationCode);
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }

        String getRefreshToken() {
            return this.refreshToken;
        }

        String getAuthorizationCode() {
            return this.authorizationCode;
        }

        String getRedirectUri() {
            return this.redirectUri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthorizationGrant that = (AuthorizationGrant)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.authorizationCode, that.authorizationCode) && Objects.equals(this.redirectUri, that.redirectUri);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password, this.refreshToken, this.authorizationCode, this.redirectUri);
        }
    }

    public static interface DecodedAccessToken
    extends AccessToken {
        public Object getClaim(String var1);
    }

    public static class IdentityServiceFacadeException
    extends RuntimeException {
        public IdentityServiceFacadeException(String message) {
            super(message);
        }

        IdentityServiceFacadeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class TokenDecodingException
    extends IdentityServiceFacadeException {
        TokenDecodingException(String message) {
            super(message);
        }

        TokenDecodingException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UserInfoException
    extends IdentityServiceFacadeException {
        UserInfoException(String message) {
            super(message);
        }

        UserInfoException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

