/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.repo.usage.UserUsageTrackingComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Category(value={BaseSpringTestsCategory.class})
public class FTPServerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTPServerTest.class);
    private ApplicationContext applicationContext;
    private static final String USER_ADMIN = "admin";
    private static final String PASSWORD_ADMIN = "admin";
    private static final String USER_ONE = "FTPServerTestOne";
    private static final String USER_TWO = "FTPServerTestTwo";
    private static final String USER_THREE = "FTPServerTestThree";
    private static final String PASSWORD_ONE = "Password01";
    private static final String PASSWORD_TWO = "Password02";
    private static final String PASSWORD_THREE = "Password03";
    private static final String HOSTNAME = "localhost";
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private Repository repositoryHelper;
    private PermissionService permissionService;
    private FTPConfigSection ftpConfigSection;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        NodeService nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        TransactionService transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        ServerConfigurationAccessor fileServerConfiguration = (ServerConfigurationAccessor)this.applicationContext.getBean("fileServerConfiguration");
        this.ftpConfigSection = (FTPConfigSection)fileServerConfiguration.getConfigSection("FTP");
        Assert.assertNotNull((String)"nodeService is null", (Object)nodeService);
        Assert.assertNotNull((String)"repositoryHelper is null", (Object)this.repositoryHelper);
        Assert.assertNotNull((String)"personService is null", (Object)this.personService);
        Assert.assertNotNull((String)"authenticationService is null", (Object)this.authenticationService);
        Assert.assertNotNull((String)"authenticationComponent is null", (Object)authenticationComponent);
        authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper tran = transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback createUsersCB = () -> {
            this.createUser(USER_ONE, PASSWORD_ONE, -1L);
            this.createUser(USER_TWO, PASSWORD_TWO, -1L);
            this.createUser(USER_THREE, PASSWORD_THREE, 30L);
            return null;
        };
        tran.doInTransaction(createUsersCB);
        RetryingTransactionHelper.RetryingTransactionCallback createTestDirCB = () -> {
            NodeRef userOneHome = this.repositoryHelper.getUserHome(this.personService.getPerson(USER_ONE));
            this.permissionService.setPermission(userOneHome, USER_TWO, "Contributor", true);
            this.permissionService.setPermission(userOneHome, USER_TWO, "Write", true);
            return null;
        };
        tran.doInTransaction(createTestDirCB, false, true);
    }

    @Test
    public void testFTPConnect() throws Exception {
        LOGGER.debug("Start testFTPConnect");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "admin");
            Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testFTPConnectNegative() throws Exception {
        LOGGER.debug("Start testFTPConnectNegative");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "garbage");
            Assert.assertFalse((String)"admin login should not be successful", (boolean)isLoggedIn);
            FTPFile[] files = ftp.listFiles();
            Assert.assertNotNull((String)"files should not be null", (Object)files);
            Assert.assertEquals((String)"there should be no files", (long)0L, (long)files.length);
            reply = ftp.getReplyCode();
            Assert.assertTrue((String)"FTP server should respond negatively", (boolean)FTPReply.isNegativePermanent((int)reply));
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testCWD() throws Exception {
        LOGGER.debug("Start testCWD");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "admin");
            Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
            FTPFile[] files = ftp.listFiles();
            reply = ftp.getReplyCode();
            Assert.assertTrue((String)"FTP server refused connection", (boolean)FTPReply.isPositiveCompletion((int)reply));
            Assert.assertEquals((String)"there should be only 1 file", (long)1L, (long)files.length);
            boolean isFileFound = false;
            FTPFile[] fTPFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                String fileName = file.getName();
                LOGGER.debug("File name = {}", (Object)fileName);
                Assert.assertTrue((String)"file is not a directory", (boolean)file.isDirectory());
                if (fileName.equalsIgnoreCase("Alfresco")) {
                    isFileFound = true;
                }
                ++n2;
            }
            Assert.assertTrue((String)"file should be found", (boolean)isFileFound);
            reply = ftp.cwd("/Alfresco");
            Assert.assertTrue((String)"unable to change to /Alfresco", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("Data Dictionary");
            Assert.assertTrue((String)"unable to change to Data Dictionary", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("/Garbage");
            Assert.assertTrue((String)"able to change to nonexistent /Garbage", (boolean)FTPReply.isNegativePermanent((int)reply));
            reply = ftp.cwd("/Alfresco/User Homes");
            Assert.assertTrue((String)"unable to change to /Alfresco/User Homes", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("/Alfresco/User*Homes");
            Assert.assertTrue((String)"unable to change to /Alfresco User*Homes/", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("/Alfresco/Data Dictionary");
            Assert.assertTrue((String)"unable to change to /Alfresco/Data Dictionary", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("..");
            Assert.assertTrue((String)"unable to change to ..", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.pwd();
            ftp.getStatus();
            Assert.assertTrue((String)"unable to get status", (boolean)FTPReply.isPositiveCompletion((int)reply));
            reply = ftp.cwd("Data Dictionary");
            Assert.assertTrue((String)"test should end in being in the tree of Data Dictionary", (boolean)FTPReply.isPositiveCompletion((int)reply));
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testCRUD() throws Exception {
        LOGGER.debug("Start testFTPCRUD");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "admin");
            Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
            reply = ftp.cwd("/Alfresco/User Homes");
            Assert.assertTrue((String)"unable to change to /Alfresco/User Homes", (boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory("FTPServerTest");
            }
            catch (IOException iOException) {}
            ftp.makeDirectory("FTPServerTest");
            ftp.cwd("FTPServerTest");
            ftp.makeDirectory("Second part");
            ftp.cwd("Second part");
            FTPFile[] files = ftp.listFiles();
            Assert.assertEquals((String)"there should be no files", (long)0L, (long)files.length);
            String file1Content1 = "test file 1 content";
            String file1Name = "testFile1.txt";
            ftp.appendFile(file1Name, (InputStream)new ByteArrayInputStream(file1Content1.getBytes(StandardCharsets.UTF_8)));
            FTPFile[] files2 = ftp.listFiles();
            Assert.assertEquals((String)"there should be only 1 file", (long)1L, (long)files2.length);
            InputStream is = ftp.retrieveFileStream(file1Name);
            String content = this.inputStreamToString(is);
            Assert.assertEquals((String)"Content is not as expected", (Object)content, (Object)file1Content1);
            ftp.completePendingCommand();
            String file1Content2 = "That's how it is says Pooh!";
            ftp.storeFile(file1Name, (InputStream)new ByteArrayInputStream(file1Content2.getBytes(StandardCharsets.UTF_8)));
            InputStream is2 = ftp.retrieveFileStream(file1Name);
            String content2 = this.inputStreamToString(is2);
            Assert.assertEquals((String)"Content is not as expected", (Object)file1Content2, (Object)content2);
            ftp.completePendingCommand();
            Assert.assertTrue((String)"unsuccessful delete", (boolean)ftp.deleteFile(file1Name));
            Assert.assertFalse((String)"file exists after deletion", (boolean)ftp.deleteFile(file1Name));
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testPathNames() throws Exception {
        LOGGER.debug("Start testPathNames");
        FTPClient ftp = this.connectClient();
        String path1 = "testPathNames";
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "admin");
            Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
            reply = ftp.cwd("/Alfresco/User*Homes");
            Assert.assertTrue((String)"unable to change to /Alfresco/User*Homes", (boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory(path1);
            }
            catch (IOException iOException) {}
            boolean isDirectoryMade = ftp.makeDirectory(path1);
            Assert.assertTrue((String)("unable to make directory:" + path1), (boolean)isDirectoryMade);
            boolean isDirectoryChanged = ftp.changeWorkingDirectory(path1);
            Assert.assertTrue((String)("unable to change to working directory:" + path1), (boolean)isDirectoryChanged);
            Assert.assertTrue((String)"with a space", (boolean)ftp.makeDirectory("test space"));
            Assert.assertTrue((String)"with exclamation", (boolean)ftp.makeDirectory("space!"));
            Assert.assertTrue((String)"with dollar", (boolean)ftp.makeDirectory("space$"));
            Assert.assertTrue((String)"with brackets", (boolean)ftp.makeDirectory("space()"));
            Assert.assertTrue((String)"with hash curley  brackets", (boolean)ftp.makeDirectory("space{}"));
            Assert.assertTrue((String)"with pound sign", (boolean)ftp.makeDirectory("pound \u00a3.world"));
            Assert.assertTrue((String)"with yen sign", (boolean)ftp.makeDirectory("yen \u00a5.world"));
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testRenameCase() throws Exception {
        LOGGER.debug("Start testRenameCase");
        FTPClient ftp = this.connectClient();
        String path1 = "testRenameCase";
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "admin");
            Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
            reply = ftp.cwd("/Alfresco/User*Homes");
            Assert.assertTrue((String)"unable to change to /Alfresco/User*Homes", (boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory(path1);
            }
            catch (IOException iOException) {}
            boolean isDirectoryMade = ftp.makeDirectory(path1);
            Assert.assertTrue((String)("unable to make directory:" + path1), (boolean)isDirectoryMade);
            ftp.cwd(path1);
            String file1Content2 = "That's how it is says Pooh!";
            ftp.storeFile("FileA.txt", (InputStream)new ByteArrayInputStream(file1Content2.getBytes(StandardCharsets.UTF_8)));
            Assert.assertTrue((String)"unable to rename", (boolean)ftp.rename("FileA.txt", "FILEA.TXT"));
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testTwoUserUpdate() throws Exception {
        LOGGER.debug("Start testFTPConnect");
        FTPClient ftpOne = this.connectClient();
        FTPClient ftpTwo = this.connectClient();
        try {
            int reply = ftpOne.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = ftpTwo.getReplyCode()))) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftpOne.login(USER_ONE, PASSWORD_ONE);
            Assert.assertTrue((String)"user one login should be successful", (boolean)isLoggedIn);
            isLoggedIn = ftpTwo.login(USER_TWO, PASSWORD_TWO);
            Assert.assertTrue((String)"user two login should be successful", (boolean)isLoggedIn);
            boolean isDirectoryChanged = ftpOne.changeWorkingDirectory("Alfresco");
            Assert.assertTrue((String)"user one unable to cd to Alfresco", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpOne.changeWorkingDirectory("User*Homes");
            Assert.assertTrue((String)"user one unable to cd to User*Homes", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpOne.changeWorkingDirectory(USER_ONE);
            Assert.assertTrue((String)"user one unable to cd to FTPServerTestOne", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpTwo.changeWorkingDirectory("Alfresco");
            Assert.assertTrue((String)"user two unable to cd to Alfresco", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpTwo.changeWorkingDirectory("User*Homes");
            Assert.assertTrue((String)"user two unable to cd to User*Homes", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpTwo.changeWorkingDirectory(USER_ONE);
            Assert.assertTrue((String)"user two unable to cd FTPServerTestOne", (boolean)isDirectoryChanged);
            String file1Content1 = "test file 1 content";
            String file1Name = "test.docx";
            boolean isAppend = ftpOne.appendFile(file1Name, (InputStream)new ByteArrayInputStream(file1Content1.getBytes(StandardCharsets.UTF_8)));
            Assert.assertTrue((String)"user one should be able to append file", (boolean)isAppend);
            String file1Content2 = "test file content updated";
            boolean isStored = ftpTwo.storeFile(file1Name, (InputStream)new ByteArrayInputStream(file1Content2.getBytes(StandardCharsets.UTF_8)));
            Assert.assertTrue((String)"user two should be able to store file", (boolean)isStored);
            InputStream is1 = ftpOne.retrieveFileStream(file1Name);
            Assert.assertNotNull((String)"is1 is null", (Object)is1);
            String content1 = this.inputStreamToString(is1);
            Assert.assertEquals((String)"Content is not as expected", (Object)file1Content2, (Object)content1);
            ftpOne.completePendingCommand();
            InputStream is2 = ftpTwo.retrieveFileStream(file1Name);
            Assert.assertNotNull((String)"is2 is null", (Object)is2);
            String content2 = this.inputStreamToString(is2);
            Assert.assertEquals((String)"Content is not as expected", (Object)file1Content2, (Object)content2);
            ftpTwo.completePendingCommand();
            LOGGER.debug("Test finished");
        }
        finally {
            ftpOne.dele("/Alfresco/User Homes/FTPServerTestOne");
            ftpOne.disconnect();
            ftpTwo.disconnect();
        }
    }

    @Test
    public void testFtpQuotaAndFtp() throws Exception {
        ContentUsageImpl contentUsage = (ContentUsageImpl)this.applicationContext.getBean("contentUsageImpl");
        contentUsage.setEnabled(true);
        contentUsage.init();
        UserUsageTrackingComponent userUsageTrackingComponent = (UserUsageTrackingComponent)this.applicationContext.getBean("userUsageTrackingComponent");
        userUsageTrackingComponent.setEnabled(true);
        userUsageTrackingComponent.bootstrapInternal();
        FTPClient ftpOne = this.connectClient();
        try {
            int reply = ftpOne.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftpOne.login(USER_THREE, PASSWORD_THREE);
            Assert.assertTrue((String)"user three login should be successful", (boolean)isLoggedIn);
            boolean isDirectoryChanged = ftpOne.changeWorkingDirectory("Alfresco");
            Assert.assertTrue((String)"user three unable to cd to Alfresco", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpOne.changeWorkingDirectory("User*Homes");
            Assert.assertTrue((String)"user one unable to cd to User*Homes", (boolean)isDirectoryChanged);
            isDirectoryChanged = ftpOne.changeWorkingDirectory(USER_THREE);
            Assert.assertTrue((String)"user one unable to cd to FTPServerTestThree", (boolean)isDirectoryChanged);
            String file3Content3 = "test file 3 content that needs to be greater than 100 bytes to result in a quota exception being thrown";
            String file1Name = "test.docx";
            boolean isAppend = ftpOne.appendFile(file1Name, (InputStream)new ByteArrayInputStream(file3Content3.getBytes(StandardCharsets.UTF_8)));
            Assert.assertFalse((String)"user one can ignore quota", (boolean)isAppend);
            boolean isDeleted = ftpOne.deleteFile(file1Name);
            Assert.assertFalse((String)"quota exception expected", (boolean)isDeleted);
            LOGGER.debug("test done");
        }
        finally {
            contentUsage.setEnabled(false);
            contentUsage.init();
            userUsageTrackingComponent.setEnabled(false);
            userUsageTrackingComponent.bootstrapInternal();
            ftpOne.dele("/Alfresco/User Homes/FTPServerTestThree");
            ftpOne.disconnect();
        }
    }

    @Test
    public void testModificationTime() throws Exception {
        LOGGER.debug("Start testModificationTime");
        FTPClient ftp = this.connectClient();
        try {
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                Assert.fail((String)"FTP server refused connection.");
            }
            boolean isLoggedIn = ftp.login("admin", "admin");
            Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
            reply = ftp.cwd("/Alfresco/User Homes");
            Assert.assertTrue((String)"unable to change to /Alfresco/User Homes", (boolean)FTPReply.isPositiveCompletion((int)reply));
            try {
                ftp.removeDirectory("FTPServerTest");
            }
            catch (IOException iOException) {}
            ftp.makeDirectory("FTPServerTest");
            ftp.cwd("FTPServerTest");
            ftp.makeDirectory("ModificationTime");
            ftp.cwd("ModificationTime");
            FTPFile[] files = ftp.listFiles();
            Assert.assertEquals((String)"there should be no files", (long)0L, (long)files.length);
            String file1Content1 = "test file 1 content";
            String file1Name = "testFile1.txt";
            ftp.appendFile(file1Name, (InputStream)new ByteArrayInputStream(file1Content1.getBytes(StandardCharsets.UTF_8)));
            String pathname = "/Alfresco/User Homes/FTPServerTest/ModificationTime/" + file1Name;
            LOGGER.debug("set modification time");
            String olympicTime = "20120830123905";
            ftp.setModificationTime(pathname, olympicTime);
            String extractedTime = ftp.getModificationTime(pathname);
            Assert.assertTrue((String)"time not set correctly by explicit set time", (boolean)extractedTime.contains(olympicTime));
            FTPFile[] files2 = ftp.listFiles();
            Assert.assertEquals((String)"there should be only 1 file", (long)1L, (long)files2.length);
            InputStream is = ftp.retrieveFileStream(file1Name);
            String content = this.inputStreamToString(is);
            Assert.assertEquals((String)"Content is not as expected", (Object)content, (Object)file1Content1);
            ftp.completePendingCommand();
            String file1Content2 = "That's how it is says Pooh!";
            ftp.storeFile(file1Name, (InputStream)new ByteArrayInputStream(file1Content2.getBytes(StandardCharsets.UTF_8)));
            InputStream is2 = ftp.retrieveFileStream(file1Name);
            String content2 = this.inputStreamToString(is2);
            Assert.assertEquals((String)"Content is not as expected", (Object)file1Content2, (Object)content2);
            ftp.completePendingCommand();
            extractedTime = ftp.getModificationTime(pathname);
            Assert.assertFalse((String)"time not moved on if time not explicitly set", (boolean)extractedTime.contains(olympicTime));
            Assert.assertTrue((String)"unsuccessful delete", (boolean)ftp.deleteFile(file1Name));
            Assert.assertFalse((String)"file exists after deletion", (boolean)ftp.deleteFile(file1Name));
        }
        finally {
            ftp.disconnect();
        }
    }

    @Test
    public void testFTPConnectExternalAddressSet() throws Exception {
        LOGGER.debug("Start testFTPConnectExternalAddressSet");
        try {
            String improbableIPAddress = "127.255.255.42";
            this.ftpConfigSection.setFTPExternalAddress(improbableIPAddress);
            FTPClient ftp = this.connectClient();
            try {
                int reply = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    Assert.fail((String)"FTP server refused connection.");
                }
                boolean isLoggedIn = ftp.login("admin", "admin");
                Assert.assertTrue((String)"admin login should be successful", (boolean)isLoggedIn);
                boolean isPassiveMode = ftp.enterRemotePassiveMode();
                Assert.assertTrue((String)"failed activating passive mode", (boolean)isPassiveMode);
                Assert.assertEquals((String)"Client should be in passive mode now", (long)3L, (long)ftp.getDataConnectionMode());
                reply = ftp.getReplyCode();
                Assert.assertEquals((String)"reply code should be 227", (long)227L, (long)reply);
                String replyLine = ftp.getReplyString();
                Assert.assertNotNull((String)"replyLine should not be null", (Object)replyLine);
                String encodedImprobableIPAddress = improbableIPAddress.replaceAll("\\.", ",");
                Assert.assertTrue((String)"Pasv command should contain the set external address encoded", (boolean)replyLine.contains(encodedImprobableIPAddress));
                FTPFile[] files = ftp.listFiles();
                Assert.assertNotNull((String)"files should not be null", (Object)files);
                Assert.assertEquals((String)"list command should not succeed", (long)0L, (long)files.length);
                Assert.assertEquals((String)"The passive host should be the one set earlier.", (Object)improbableIPAddress, (Object)ftp.getPassiveHost());
            }
            finally {
                this.safeDisconnect(ftp);
            }
        }
        finally {
            this.ftpConfigSection.setFTPExternalAddress(null);
        }
    }

    private void safeDisconnect(FTPClient ftp) {
        try {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not gracefully disconnect the ftp client.", (Throwable)e);
        }
    }

    private FTPClient connectClient() throws IOException {
        FTPClient ftp = new FTPClient();
        ftp.setIpAddressFromPasvResponse(true);
        if (LOGGER.isDebugEnabled()) {
            ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        }
        ftp.connect(HOSTNAME, this.ftpConfigSection.getFTPPort());
        return ftp;
    }

    private String inputStreamToString(InputStream is) throws IOException {
        if (is != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (StringWriter writer = new StringWriter();){
                char[] buffer = new char[1024];
                try {
                    int n;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    while ((n = reader.read(buffer)) != -1) {
                        writer.write(buffer, 0, n);
                    }
                }
                finally {
                    is.close();
                }
                return writer.getBuffer().toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return "";
    }

    private void createUser(String userName, String password, long quota) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            if (quota > 0L) {
                ppOne.put((Object)ContentModel.PROP_SIZE_QUOTA, (Object)quota);
            }
            this.personService.createPerson((Map)ppOne);
        }
    }
}

