/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.SpringBasedIdentityServiceFacade;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.RestOperations;

public class SpringBasedIdentityServiceFacadeUnitTest {
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private static final String TOKEN = "tEsT-tOkEn";

    @Test
    public void shouldThrowVerificationExceptionOnFailure() {
        RestOperations restOperations = (RestOperations)Mockito.mock(RestOperations.class);
        JwtDecoder jwtDecoder = (JwtDecoder)Mockito.mock(JwtDecoder.class);
        Mockito.when((Object)restOperations.exchange((RequestEntity)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenThrow(new Throwable[]{new RuntimeException("Expected")});
        SpringBasedIdentityServiceFacade facade = new SpringBasedIdentityServiceFacade(restOperations, this.testRegistration(), jwtDecoder);
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.AuthorizationException.class).isThrownBy(() -> {
            IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = facade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        }).havingCause().withNoCause().withMessage("Expected");
    }

    @Test
    public void shouldThrowTokenExceptionOnFailure() {
        RestOperations restOperations = (RestOperations)Mockito.mock(RestOperations.class);
        JwtDecoder jwtDecoder = (JwtDecoder)Mockito.mock(JwtDecoder.class);
        Mockito.when((Object)jwtDecoder.decode(TOKEN)).thenThrow(new Throwable[]{new RuntimeException("Expected")});
        SpringBasedIdentityServiceFacade facade = new SpringBasedIdentityServiceFacade(restOperations, this.testRegistration(), jwtDecoder);
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.TokenDecodingException.class).isThrownBy(() -> {
            IdentityServiceFacade.DecodedAccessToken decodedAccessToken = facade.decodeToken(TOKEN);
        }).havingCause().withNoCause().withMessage("Expected");
    }

    @Test
    public void shouldReturnEmptyOptionalOnFailure() {
        RestOperations restOperations = (RestOperations)Mockito.mock(RestOperations.class);
        JwtDecoder jwtDecoder = (JwtDecoder)Mockito.mock(JwtDecoder.class);
        SpringBasedIdentityServiceFacade facade = new SpringBasedIdentityServiceFacade(restOperations, this.testRegistration(), jwtDecoder);
        Assertions.assertThat((boolean)facade.getUserInfo(TOKEN, "preferred_username").isEmpty()).isTrue();
    }

    private ClientRegistration testRegistration() {
        return ClientRegistration.withRegistrationId((String)"test").tokenUri("http://localhost").clientId("test").userInfoUri("http://localhost/userinfo").authorizationGrantType(AuthorizationGrantType.PASSWORD).build();
    }
}

